/*
 * exploiter.h
 *
 * basic typedefs and #defines
 */

#ifndef EXPLOITER_H
#define EXPLOITER_H

#include "types.h"

/*
 * Q layout
 */

typedef u32 lisp_q;

#define Q_BITS_CDRCODE 0xc0000000
#define Q_BITS_DTP     0x3e000000
#define Q_BITS_ADDRESS 0x01ffffff

#define CDR_NORMAL 0x00000000
#define CDR_ERROR  0x40000000
#define CDR_NIL    0x80000000
#define CDR_NEXT   0xc0000000

#define     DTP(q)     ((q) &  Q_BITS_DTP    )
#define NOT_DTP(q)     ((q) & ~Q_BITS_DTP    )
#define     CDRCODE(q) ((q) &  Q_BITS_CDRCODE)
#define NOT_CDRCODE(q) ((q) & ~Q_BITS_CDRCODE)
#define     ADDRESS(q) ((q) &  Q_BITS_ADDRESS)
#define NOT_ADDRESS(q) ((q) & ~Q_BITS_ADDRESS)


/*
 * known constants
 */

#define C_NIL 0x06000000
#define C_T   0x06000005


/*
 * M-Memory locations
 */

#define VM_M_BASE 0x01fffc00

#define M_MODE_FLAGS                   020
#define M_SEQUENCE_BREAK_SOURCE_ENABLE 021
#define M_METER_MICRO_ENABLES          022
#define M_SELF                         023
#define M_SELF_MAPPING_TABLE           024

#define M_LOCATIVE(foo) ((foo) | DTP_LOCATIVE | VM_M_BASE)


/*
 * A-Memory locations
 */

#define A_DEFAULT_CONS_AREA 0x42
#define A_NUMBER_CONS_AREA  0x43


/*
 * type tag codes
 */

#define DTP_TRAP_CODE              0
#define DTP_LIST_CODE              1
#define DTP_STACK_LIST_CODE        2
#define DTP_SYMBOL_CODE            3
#define DTP_ARRAY_CODE             4
#define DTP_FIX_CODE               5
#define DTP_CHARACTER_CODE         6
#define DTP_SINGLE_FLOAT_CODE      7
#define DTP_SHORT_FLOAT_CODE       8
#define DTP_INSTANCE_CODE          9
#define DTP_EXTENDED_NUMBER_CODE  10
#define DTP_LOCATIVE_CODE         11
#define DTP_FUNCTION_CODE         12
#define DTP_CLOSURE_CODE          13
#define DTP_LEXICAL_CLOSURE_CODE  14
#define DTP_U_ENTRY_CODE          15
#define DTP_STACK_GROUP_CODE      16
#define DTP_GC_FORWARD_CODE       17
#define DTP_EVCP_CODE             18
#define DTP_ONE_Q_FORWARD_CODE    19
#define DTP_HEADER_FORWARD_CODE   20
#define DTP_BODY_FORWARD_CODE     21
#define DTP_SYMBOL_HEADER_CODE    22
#define DTP_HEADER_CODE           23 /* Not in SSDN2 */
#define DTP_ARRAY_HEADER_CODE     24
#define DTP_INSTANCE_HEADER_CODE  25
#define DTP_FEF_HEADER_CODE       26
#define DTP_SELF_REF_POINTER_CODE 27
#define DTP_GCYP_CODE             28
#define DTP_FREE_CODE             29
#define DTP_NULL_CODE             30
#define DTP_ONES_TRAP_CODE        31

#define DTP_TRAP             (DTP_TRAP_CODE             << 25)
#define DTP_LIST             (DTP_LIST_CODE             << 25)
#define DTP_STACK_LIST       (DTP_STACK_LIST_CODE       << 25)
#define DTP_SYMBOL           (DTP_SYMBOL_CODE           << 25)
#define DTP_ARRAY            (DTP_ARRAY_CODE            << 25)
#define DTP_FIX              (DTP_FIX_CODE              << 25)
#define DTP_CHARACTER        (DTP_CHARACTER_CODE        << 25)
#define DTP_SINGLE_FLOAT     (DTP_SINGLE_FLOAT_CODE     << 25)
#define DTP_SHORT_FLOAT      (DTP_SHORT_FLOAT_CODE      << 25)
#define DTP_INSTANCE         (DTP_INSTANCE_CODE         << 25)
#define DTP_EXTENDED_NUMBER  (DTP_EXTENDED_NUMBER_CODE  << 25)
#define DTP_LOCATIVE         (DTP_LOCATIVE_CODE         << 25)
#define DTP_FUNCTION         (DTP_FUNCTION_CODE         << 25)
#define DTP_CLOSURE          (DTP_CLOSURE_CODE          << 25)
#define DTP_LEXICAL_CLOSURE  (DTP_LEXICAL_CLOSURE_CODE  << 25)
#define DTP_U_ENTRY          (DTP_U_ENTRY_CODE          << 25)
#define DTP_STACK_GROUP      (DTP_STACK_GROUP_CODE      << 25)
#define DTP_GC_FORWARD       (DTP_GC_FORWARD_CODE       << 25)
#define DTP_EVCP             (DTP_EVCP_CODE             << 25)
#define DTP_ONE_Q_FORWARD    (DTP_ONE_Q_FORWARD_CODE    << 25)
#define DTP_HEADER_FORWARD   (DTP_HEADER_FORWARD_CODE   << 25)
#define DTP_BODY_FORWARD     (DTP_BODY_FORWARD_CODE     << 25)
#define DTP_SYMBOL_HEADER    (DTP_SYMBOL_HEADER_CODE    << 25)
#define DTP_HEADER           (DTP_HEADER_CODE           << 25)
#define DTP_ARRAY_HEADER     (DTP_ARRAY_HEADER_CODE     << 25)
#define DTP_INSTANCE_HEADER  (DTP_INSTANCE_HEADER_CODE  << 25)
#define DTP_FEF_HEADER       (DTP_FEF_HEADER_CODE       << 25)
#define DTP_SELF_REF_POINTER (DTP_SELF_REF_POINTER_CODE << 25)
#define DTP_GCYP             (DTP_GCYP_CODE             << 25)
#define DTP_FREE             (DTP_FREE_CODE             << 25)
#define DTP_NULL             (DTP_NULL_CODE             << 25)
#define DTP_ONES_TRAP        (DTP_ONES_TRAP_CODE        << 25)


/*
 * symbol structure layout
 */

#define SYM_PRINTNAME 0
#define SYM_VALUE     1
#define SYM_FUNCTION  2
#define SYM_PROPERTY  3
#define SYM_PACKAGE   4


/*
 * scratch pad init area layout
 */

#define SPIA_INITIAL_FUNCTION 0
#define SPIA_ERROR_HANDLER_SG 1
#define SPIA_CURRENT_SG 2
#define SPIA_INITIAL_SG 3
#define SPIA_LAST_ARRAY_ELEMENT 4 /* ??? */


/*
 * call-info word layout
 */

#define CI_NUMARGS          0x0000003f
#define CI_LEXPRFUNCALL     0x00000040
#define CI_SELFMAPPINGTABLE 0x00000080
#define CI_LEXICALCLOSURE   0x00000100
#define CI_RETURNDEST       0x00000e00
#define CI_RETURNTYPE       0x00003000
#define CI_NUMRESULTS       0x000fc000
#define CI_BINDINGBLOCK     0x00100000
#define CI_MICROSTACK       0x00200000
#define CI_TRAPONEXIT       0x00400000
#define CI_ENVIRONMENT      0x00800000

#define CI_RETURNFIELDS     (CI_RETURNTYPE | CI_NUMRESULTS)

#define D_INDS     0x00000000
#define D_PUSH     0x00000200
#define D_RETURN   0x00000400
#define D_TAIL_REC 0x00000600


/*
 * FEF layout
 */

#define FEF_HEADER    0
#define FEF_LENGTH    1
#define FEF_DEBUGINFO 2
#define FEF_LONGARGS  3
#define FEF_OPTION_1  3 /* longargs or flavorname */
#define FEF_OPTION_2  4 /* flavorname */

#define FEFLA_LOCALS       0x00007f
#define FEFLA_MAXARGS      0x001f80
#define FEFLA_MINARGS      0x07e000
#define FEFLA_HASREST      0x080000
#define FEFLA_HASLOCALS    0x100000
#define FEFLA_HASOPTIONALS 0x200000

#define FEFLA_MAXARGS_SHIFT 7
#define FEFLA_MINARGS_SHIFT 13


/*
 * array header layout
 */

#define ARY_BITS_TYPE        0x00f80000
#define ARY_BITS_PHYSICAL    0x00040000
#define ARY_BITS_LEADER	     0x00020000
#define ARY_BITS_DISPLACED   0x00010000
#define ARY_BITS_SIMPLE	     0x00008000
#define ARY_BITS_DIMS        0x00007000
#define ARY_BITS_LONG_LENGTH 0x00000800
#define ARY_BITS_NS          0x00000400
#define ARY_BITS_INDEX       0x000003ff

#define ARY_TYPE(q)       ((q) & ARY_BITS_TYPE       )
#define ARY_PHYSICAL(q)   ((q) & ARY_BITS_PHYSICAL   )
#define ARY_LEADER(q)     ((q) & ARY_BITS_LEADER     )
#define ARY_DISPLACED(q)  ((q) & ARY_BITS_DISPLACED  )
#define ARY_SIMPLE(q)     ((q) & ARY_BITS_SIMPLE     )
#define ARY_DIMS(q)      (((q) & ARY_BITS_DIMS       ) >> 12)
#define ARY_LL(q)         ((q) & ARY_BITS_LONG_LENGTH)
#define ARY_NS(q)         ((q) & ARY_BITS_NS         )
#define ARY_INDEX(q)      ((q) & ARY_BITS_INDEX      )

#define ART_ERROR_CODE			0
#define ART_1B_CODE			1
#define ART_2B_CODE			2
#define ART_4B_CODE			3
#define ART_8B_CODE			4
#define ART_16B_CODE			5
#define ART_32B_CODE			6
#define ART_Q_CODE			7
#define ART_Q_LIST_CODE			8
#define ART_STRING_CODE			9
#define ART_STACK_GROUP_HEAD_CODE	10
#define ART_SPECIAL_PDL_CODE		11
#define ART_HALF_FIX_CODE		12
#define ART_REG_PDL_CODE		13
#define ART_DOUBLE_FLOAT_CODE		14
#define ART_SINGLE_FLOAT_CODE		15
#define ART_FAT_STRING_CODE		16
#define ART_COMPLEX_DOUBLE_FLOAT_CODE	17
#define ART_COMPLEX_CODE		18
#define ART_COMPLEX_SINGLE_FLOAT_CODE	19
#define ART_FIX_CODE			20

#define ART_ERROR			(ART_ERROR_CODE			<< 19)
#define ART_1B				(ART_1B_CODE			<< 19)
#define ART_2B				(ART_2B_CODE			<< 19)
#define ART_4B				(ART_4B_CODE			<< 19)
#define ART_8B				(ART_8B_CODE			<< 19)
#define ART_16B				(ART_16B_CODE			<< 19)
#define ART_32B				(ART_32B_CODE			<< 19)
#define ART_Q				(ART_Q_CODE			<< 19)
#define ART_Q_LIST			(ART_Q_LIST_CODE		<< 19)
#define ART_STRING			(ART_STRING_CODE		<< 19)
#define ART_STACK_GROUP_HEAD		(ART_STACK_GROUP_HEAD_CODE	<< 19)
#define ART_SPECIAL_PDL			(ART_SPECIAL_PDL_CODE		<< 19)
#define ART_HALF_FIX			(ART_HALF_FIX_CODE		<< 19)
#define ART_REG_PDL			(ART_REG_PDL_CODE		<< 19)
#define ART_DOUBLE_FLOAT		(ART_DOUBLE_FLOAT_CODE		<< 19)
#define ART_SINGLE_FLOAT		(ART_SINGLE_FLOAT_CODE		<< 19)
#define ART_FAT_STRING			(ART_FAT_STRING_CODE		<< 19)
#define ART_COMPLEX_DOUBLE_FLOAT	(ART_COMPLEX_DOUBLE_FLOAT_CODE	<< 19)
#define ART_COMPLEX			(ART_COMPLEX_CODE		<< 19)
#define ART_COMPLEX_SINGLE_FLOAT	(ART_COMPLEX_SINGLE_FLOAT_CODE	<< 19)
#define ART_FIX				(ART_FIX_CODE			<< 19)


/*
 * Stack Group layout
 *
 * These are all in the leader area, so are accessed as negative offsets and
 * begin at 2 (0 is the header, -1 is the leader length).
 */

/* static section */

#define SG_NAME                    2
#define SG_REGULAR_PDL             3
#define SG_REGULAR_PDL_LIMIT       4
#define SG_SPECIAL_PDL             5
#define SG_SPECIAL_PDL_LIMIT       6
#define SG_INITIAL_FUNCTION_INDEX  7

/* debugging section */

#define SG_TRAP_TAG                8
#define SG_RECOVERY_HISTORY        9
#define SG_FOOTHOLD_DATA          10

/* high-level section */

#define SG_STATE                  11
#define SG_PREVIOUS_STACK_GROUP   12
#define SG_CALLING_ARGS_POINTER   13
#define SG_CALLING_ARGS_NUMBER    14
#define SG_TRAP_AP_LEVEL          15

/* dynamic section */

#define SG_REGULAR_PDL_POINTER    16
#define SG_SPECIAL_PDL_POINTER    17
#define SG_TRAP_MICRO_PC          18
#define SG_SAVED_M_FLAGS          19
#define SG_PDL_PHASE              20
#define SG_SAVED_VMA              21
#define SG_VMA_M1_M2_TAGS         22
#define SG_M3_M4_TAGS             23
#define SG_AC_1                   24
#define SG_AC_2                   25
#define SG_AC_3                   26
#define SG_AC_4                   27
#define SG_AC_A                   28
#define SG_AC_B                   29
#define SG_AC_C                   30
#define SG_AC_D                   31
#define SG_AC_E                   32
#define SG_AC_F                   33
#define SG_AC_G                   34
#define SG_AC_H                   35
#define SG_AC_I                   36
#define SG_AC_J                   37
#define SG_AC_K                   38
#define SG_AC_L                   39
#define SG_AC_Q                   40
#define SG_AC_R                   41
#define SG_AC_S                   42
#define SG_AC_ZR                  43
#define SG_AC_T                   44
#define SG_CATCH_POINTER          45


/*
 * SpecPDL flags
 */

#define SPECPDL_CLOSURE_BINDING  0x80000000
#define SPECPDL_BLOCK_START_FLAG 0x40000000


#endif /* EXPLOITER_H */

/* EOF */
