/*
 * interp.h
 *
 * macroinstruction interpreter interface
 */

#ifndef INTERP_H
#define INTERP_H

int step_miscop(u16 opcode);
u32 ppss_mask(int ppss);
int ppss_position(int ppss);
u16 get_opcode(void);
int step_auxop(u16 opcode);
int step(void);
void do_branch(u16 opcode);

lisp_q load_target(u16 opcode);
void store_target(u16 opcode, lisp_q value);
lisp_q locative_target(u16 opcode);

/* FIXME: These next three probably belong in a separate header */
int math_plus(lisp_q src1, lisp_q src2);
int math_minus(lisp_q src1, lisp_q src2);
int math_times(lisp_q src1, lisp_q src2);


#endif /* INTERP_H */

/* EOF */
