;;;  -*- Mode:LISP; Package:Compiler; Base:8; Fonts:medfnt,tr10i -*-

#|

The following function can be used to convert .XFASL files into .XLD files.
Font files fall into this category.  Be  sure to check the size of  the two
files via dired to make sure that they are the same size.

The steps to follow when converting a font file to an XLD are quite simple:

	Compile this file.
	(COMPILER2:FASD-FONT 'FONTS:font-symbol-name)
	(COMPILER:CONVERT-FASD-FILES "SYS:FONTS;font-file-name.XFASL")
	(COPY-FILE * "LM:FONTS;")

Where  `font-symbol-name'  is   the  name   of  the   font,  e.g.    MOUSE.
`Font-file-name' is the filename that FASD-FONT used to write out the font,
e.g.  MOUSE.  Generally these two names will be the same.

|#

(DEFUN CONVERT-FASD-FILES (INFILE1)
  (LET* ((FILE1 (FS:PARSE-PATHNAME INFILE1))
	 (OFILE (SEND (FS:MERGE-PATHNAME-DEFAULTS FILE1 FS:LOAD-PATHNAME-DEFAULTS)
		      :NEW-PATHNAME :TYPE "XLD")))
    (WITH-OPEN-FILE (OSTREAM OFILE '(:WRITE :FIXNUM))
      (SEND OSTREAM :TYO #o70001 )
      (SEND OSTREAM :TYO #o70002)
      (WITH-OPEN-FILE (STR2 FILE1 '(:READ :FIXNUM))
	(SI:VALIDATE-BINARY-FILE STR2 NIL)
	(DO ((NIBBLE (SEND STR2 ':TYI))
             (NEXT1 (SEND STR2 ':TYI))
             (NEXT2))
            ((NULL NIBBLE))
          (SETQ NEXT2 (SEND STR2 ':TYI))
          (AND (OR NEXT2
                   (AND NEXT1 (NOT (ZEROP NEXT1)))
		   (NOT (ZEROP NIBBLE)))
               (SEND OSTREAM ':TYO NIBBLE))
          (SETQ NIBBLE NEXT1
                NEXT1 NEXT2))))
    OFILE))


(DEFUN VALIDATE-CONVERTED-FASD (FILE)
  (WITH-OPEN-FILE (STR FILE '(:READ :FIXNUM))
    (SI:VALIDATE-BINARY-FILE STR :YFASL)))