;;; -*- Mode:Common-Lisp; Package:USER; Fonts:(MEDFNT HL12BI); Base:10 -*-


(DEFUN execute-menu (option-list &rest more-option-lists)
  "2Merge option-lists then call MULTIPLE-CHOICE-EVAL*"
  ;;1Combine all arguments into one list*
  (WHEN more-option-lists
    (SETQ option-list (COPY-LIST option-list))
    (DOLIST (opt more-option-lists)
      (SETQ option-list (NCONC option-list (COPY-LIST opt))))
    ;1;Merge lists with the same names*
    (DO ((options option-list (CDR options)) temp) ((NULL (CDR options)))
      (WHEN (SETQ temp
                  (MEMBER (CAAR OPTIONS) (CDR OPTIONS) :TEST
			       #'(LAMBDA (ITEM ELEMENT)
				   (STRING-EQUAL ITEM (CAR ELEMENT)))))
	(RPLACA options (APPEND (CAR options) (CDAR temp)))
	(RPLACA temp nil))))
  ;1;Call another function to do all the work*
  (multiple-choice-eval option-list))

(DEFUN multiple-choice-eval (option-list &optional (label "Init options")
			     &aux item-list column-list form)
  "2Pop up a MULTIPLE-CHOOSE menu then execute the options the user selected.
   OPTION-LIST is a list of items. Each item is a list 
   (label action-list) *
      2LABEL  is a string to appear in the menu as item name.*
      2ACTION-LIST is a list of actions*
      2(column forms-to-eval)*
         2The first element of the list is a symbol to appear as*
            2a column heading for a multiple-choice window.*
	 2The rest of the list are lisp forms to be evaluated*
	    2if the option is selected. *"
  (SETQ option-list (COPY-LIST option-list))
  ;;1Create item-list for choose window*
  (DO ((options option-list (CDR options)) option) ((NULL options))
    (WHEN (CAR options)
      (SETQ option (CONS (GENSYM) (CAR options)))
      (RPLACA options option)
      (SETQ form (MAPLIST #'CAAR (CDDR option)))
      (PUSH (LIST (FIRST option) (SECOND option) form) item-list)
      ;1;Collect column headings*
      (DOLIST (column form)
	(WHEN (NOT (ASSQ column column-list))
	  (PUSH (LIST column (STRING column) nil) column-list)))))
  ;1; Get options from user*
  (DOLIST (option (tv:multiple-choose label (nreverse item-list) (nreverse column-list)))
    (LET ((system (CDDR (ASSQ (CAR option) option-list))))
      ;;1Execute options selected by the user*
      (DOLIST (action (NREVERSE (CDR option)))
	(SETQ FORM (CDR (ASSQ ACTION SYSTEM)))
	(CATCH-ERROR-RESTART ((ERROR sys:abort)
			      "Load next file" nil)
	  (DOLIST (f form) (EVAL f)))))))

#| Load-file-list doesn't work on symbolics system 4.5 (its buggy)
(DEFUN loadf (&rest files)
  "2Load files that aren't loaded or have changed.*"
  (LOAD-FILE-LIST (LOOP for file in files collect (LIST file)) ':noconfirm))
|#

;
;1 Some macros to make loading files easier*
;
(DEFMACRO defaulting-queries (defaults &body body)
  "1Provide defaults to Fquery within BODY.
When an Fquery is executed within BODY, force Fquery to return
the first item in DEFAULTS that is a legal choice. If none of the
DEFAULTS is a legal Fquery choice, Fquery will ask the user.
DEFAULTS may be a character, string or something that FQUERY might
return (like T or NIL).  It can also be a list of 2these*.*"
  (UNLESS body (FERROR "Default list missing from DEFAULTING-QUERIES form"))
  `(CONDITION-BIND ((:FQUERY 'default-query-handler ,defaults))
     . ,body))

(DEFUN default-query-handler (condition defaults)
  "2FQUERY Condition handler returns the first default thats a legal choice*"
  (FLET ((first-atom (LIST)
           "2Return the first Atom in LIST*"
	   (IF (ATOM LIST) LIST (first-atom (CAR LIST)))))
    (WHEN (ATOM defaults) (SETQ defaults (LIST defaults)))
    (LOOP named top
	  with options = (SEND condition :options)
	  with choices = (OR (GETF options :choices)
			     FORMAT:Y-OR-N-P-CHOICES)
	  for default in defaults
	  DO (LOOP for (choice . items) in choices
		   with item 
		   DO (WHEN (IF (ATOM choice)
				(OR (EQUAL (SETQ item choice) default)
				    (AND (OR (STRINGP default) (SYMBOLP default))
					 (MEMBER default items :test #'STRING-EQUAL)))
			      (OR (EQUAL (SETQ item (CAR choice)) default)
				  (AND (OR (STRINGP default) (SYMBOLP default))
				       (MEMBER default (CDR choice) :test #'STRING-EQUAL))
				  (AND (OR (CHARACTERP default) (FIXNUMP default))
				       (MEMBER default items :test #'CHAR-EQUAL))))
			(RETURN-FROM top ':new-value item))))))

(comment DEFMACRO without-connect-errors (&body body)
  "If a connect error occurs while executing BODY, retry the connection without asking."
  `(CONDITION-BIND (((sys:host-not-responding sys:connection-refused chaos:bad-chaos-connection-state)
		     #'(lambda (condition)
			 (FORMAT t "~&~a  ---  Retrying connection~%" condition)
			 (dbg:invoke-restart-handlers condition))))
     (PROGN 'COMPILE . ,body)))

(DEFMACRO WITHOUT-MORE-PROCESSING (STREAM &BODY BODY)
  "Execute body with more-processing turned off on stream"
  ;1; It should be sufficient to bind tv:more-processing-global-enable to nil*
  (UNLESS body (FERROR "STREAM missing from WITHOUT-MORE-PROCESSING form"))
  `(LET ((MORE (SEND ,STREAM ':MORE-P)))
    (SEND ,STREAM ':SET-MORE-P NIL)
    (UNWIND-PROTECT
      (PROGN . ,BODY)
      (SEND ,STREAM ':SET-MORE-P MORE))))

(DEFUN Med (thing)
  "2Like ED except it doesn't wait for terminal-io to be re-exposed
This allows a program to load several files into the editor at once.*"
  (LET ((*standard-output* *terminal-io*)
	(*standard-input* *terminal-io*)
	(*debug-io* *terminal-io*)
	(*query-io* *terminal-io*)
	(*terminal-io* nil))
    (ED thing)))

(DEFUN med1 (thing)
  (PROCESS-RUN-FUNCTION "Med1" #'ED thing))