;;; -*- Mode: LISP; Package: USER; Fonts: cptfont, HL12B, hl12bi; Base:10 -*-

(DEFCONST load-options
          '(
            ("Common Lisp"
             (patch (LOAD-PATCHES 'common-lisp ':noconfirm)))
            ("GED"
             (patch (LOAD-PATCHES 'ged ':noconfirm)))
            ("GWIN"
             (patch (LOAD-PATCHES 'gwin ':noconfirm)))
            ("UCL"
             (patch (LOAD-PATCHES 'ucl ':noconfirm)))
            ("Zmacs"
             (patch (LOAD-PATCHES 'zmacs ':noconfirm)))
            ("All Patches"
             (patch (LOAD-PATCHES ':noselective)))))

(DEFUN load-menu (&optional (option-list load-options) &rest more-option-lists)
  "2Merge option-lists then cal MULTIPLE-CHOICE-EVAL*"
  1;;Combine all arguments into one list*
  (WHEN more-option-lists
    (SETQ option-list (COPYLIST option-list))
    (DOLIST (opt more-option-lists)
      (SETQ option-list (NCONC option-list (COPYLIST opt))))
    1;;Merge lists with the same names*
    (DO ((options option-list (CDR options)) temp) ((NULL (CDR options)))
      (WHEN (SETQ temp (MEM #'(lambda (item element)
                                (STRING-EQUAL item (CAR element)))
                            (CAAR options) (CDR options)))
        (RPLACA options (APPEND (CAR options) (CDAR temp)))
        (RPLACA temp nil))))
  1;;Call another function to do all the work*
  (multiple-choice-eval option-list))

(DEFUN multiple-choice-eval (option-list &optional (label "Init Options")
                             &aux item-list column-list form)
  "2Pop up a MULTIPLE-CHOOSE menu then execute the options the user selected.
   OPTION-LIST il a list of items. Each item is a list (label action-list)
     LABEL is a string to appear in the menu as item name.
     ACTION-LIST is a list of actions
     (column forms-to-eval)
       The first element of the list is a symbol to appear as
          a column heading for a multiple-choice window.
       The rest of the list are lisp forms to be evaluated
          if the option is selected.*"
  (SETQ option-list (COPYLIST option-list))
  1;;Create item-list for choose window*
  (DO ((options option-list (CDR options)) option) ((NULL options))
    (WHEN (CAR options)
      (SETQ option (CONS (GENSYM) (CAR options)))
      (RPLACA options option)
      (SETQ form (MAPLIST #'CAAR (CDDR option)))
      (GED:PUSH-END (LIST (FIRST option) (SECOND option) form) item-list)
      1;;Collect column headings*
      (DOLIST (column form)
        (WHEN (NOT (ASSQ column column-list))
          (GED:PUSH-END (LIST column (STRING column) nil) column-list)))))
  1;;Get options from user*
  (DOLIST (option (tv:multiple-choose label item-list column-list))
    (LET ((system (CDDR (ASSQ (CAR option) option-list))))
      1;;Execute options selected by the user*
      (DOLIST (action (NREVERSE (CDR option)))
        (SETQ form (CDR (ASSQ action system)))
        (CATCH-ERROR-RESTART ((ERROR sys:abort)
                              "Load next file" nil)
          (DOLIST (f form) (EVAL f)))))))

(DEFUN loadf (&rest files)
  "2Load files that aren't loaded or have changed.*"
  (LOAD-FILE-LIST (LOOP for file in files collect (LIST file)) ':noconfirm))

(DEFMACRO without-more-processing (STREAM &body body)
  "2Execute body with more-processing turned off on stream.*"
  (UNLESS body (ERROR "STREAM missing from WITHOUT-MORE-PROCESSING form"))
  `(LET ((more (SEND ,STREAM ':more-p)))
     (SEND ,STREAM ':set-more-p nil)
     (UNWIND-PROTECT
         (PROGN . ,body)
       (SEND ,STREAM ':set-more-p more))))

;
;1 Some macros to make loading files easier*
;
(DEFVAR fquery-defaults nil)

(DEFUN default-query-handler (condition &aux (defaults fquery-defaults))
  "2FQUERY Condition handler returns the first default thats a legal choice*"
  (WHEN (NLISTP defaults) (SETQ defaults (LIST defaults)))
  (LOOP named top
	with options = (SEND condition 'options)
	with choices = (OR (GET (CONS nil options) 'choices)
			   FORMAT:Y-OR-N-P-CHOICES)
	for default in defaults
	DO (LOOP for choice in choices
		 for item = (first-atom choice)
		 DO (WHEN (EQ item default)
		      (RETURN-FROM top ':new-value default)))))

(DEFUN first-atom (LIST)
  "2Return the first Atom in LIST*"
  (IF (ATOM LIST) LIST (first-atom (CAR LIST))))

(DEFMACRO defaulting-queries (defaults &body body)
  "2Provide defaults to Fquery within BODY.
When an Fquery is executed within BODY, force Fquery to return
the first item in DEFAULTS that is a legal choice. If none of the
DEFAULTS is a legal Fquery choice, Fquery will ask the user*"
  (UNLESS defaults (SETQ defaults ''(proceed t)))
  (UNLESS body (FERROR "Default list missing from DEFAULTING-QUERIES form"))
  `(LET ((fquery-defaults ,defaults)
	 (*fquery-signal-condition* t))
     (CONDITION-BIND ((FQUERY 'default-query-handler))
     . ,body)))

;(DEFMACRO without-connect-errors (&body body)
;  "If a connect error occurs while executing BODY, retry the connection without asking."
;  `(CONDITION-BIND (((sys:host-not-responding sys:connection-refused chaos:bad-chaos-connection-state)
;		     #'(lambda (condition)
;			 (FORMAT t "~&~a  ---  Retrying connection~%" condition)
;			 (dbg:invoke-restart-handlers condition))))
;     (PROGN 'COMPILE . ,body)))

(DEFUN Med (thing)
  "2Like ED except it doesn't wait for terminal-io to be re-exposed
This allows a program to load several files into the editor at once.*"
  (LET ((standard-output terminal-io)
	(standard-input terminal-io)
	(debug-io terminal-io)
	(query-io terminal-io)
	(terminal-io nil))
    (ED thing)))

