;;; -*- Mode:Common-Lisp; Package:USER; Base:10; Fonts:(CPTFONT HL12B HL12BI) -*-

;(FS:ADD-LOGICAL-PATHNAME-HOST "Dan" "CEREBUS"
;                                 '(("Nichols" "Nichols;")
;                                   ("CELL" "Nichols.Toys.Cellular-automata;")
;                                   ("FONTS" "FONTS;")
;                                   ("FRACTAL" "Graphics.Fractal;")
;                                   ("GAMES" "Nichols.Toys.Games;")
;                                   ("GRAPHICS" "GRAPHICS;") ("HACKS" "nichols.HACKS;")
;                                   ("MISC" "Nichols.Misc;") ("MUSIC" "Sound.music;")
;                                   ("NOISE" "Sound.noise;") ("OH" "Graphics.Oh;")
;                                   ("PUBLIC" "PUBLIC;") ("SLIME" "HOLLAND;") ("SOUND" "SOUND;")
;                                   ("TOUR" "Nichols.Toys.Tour;") ("TOYS" "Nichols.Toys;")
;                                   ("UTILS" "nichols.UTILITIES;") ("WINDOW" "WINDOW;")
;                                   ("ZMACS" "nichols.ZMACS;")))

;(ADD-LOGICAL-PATHNAME-HOST "2s4*" "2tan*" '(("xsrc" "/tilde/lagoon.u1/XV11R2/")
;                                          ("dix" "/tilde/lagoon.u1/XV11R2/server/dix/")))
;(ADD-LOGICAL-PATHNAME-HOST "2s3*" "2lagoon*" '(("xsrc" "/abuser/XV11R2/")
;                                          ("dix" "/abuser/XV11R2/server/dix/")))
(ADD-LOGICAL-PATHNAME-HOST "2cross*" "2m2*" '(("dress" "/epoch/misc/u2/dnichols/Misc/stuff/cdf/")))
(ADD-LOGICAL-PATHNAME-HOST "2dn*" "2m2*" '(("tex-stuff" "/epoch/misc/u2/dnichols/TeX/Stuff/")
                                          ("letters" "/epoch/misc/u2/dnichols/TeX/Letters/")))
(loop for (system source-file) in
       '(
;         (speller               "si:public.speller;defsystem.lisp")
;	 (CUBE                  "DAN:CUBE;defsystem")
;	 (I-CHING               "DAN:TOYS;i-ching-defsystem")
         (ISKR-PROLOG           "cerebus:risk.prolog;defsystem")
         (KBOTS                 "cerebus:risk.k-bots;intro-grid-game-system")
;	 (MOVIE                 "lam1:demo.movie;movie-demo-system")
         (PUBLIC                "lm:public;defsystem")
	 (MIN-PUBLIC            "lm:public;defsystem")
	 (MY-PUBLIC             "lm:public;defsystem")
;	 (3D-DISPLAY            "BEF0:BRUCEF;3dd-system")
;	 (4D-DISPLAY            "BEF0:BRUCEF;4dd-system")
	 )
      do (si:set-system-source-file system source-file))

(WHEN (NULL (FIND-PACKAGE "DEMO")) (MAKE-PACKAGE "DEMO"))
(IF (NULL (FIND-PACKAGE 'i-ching)) (si:set-system-source-file 'i-ching "lm:hacks;i-ching-defsystem"))

;;; Make sure that the godzilla mouse is set up for the right image.  On the
;;; REL3P build it got screwed up again.  It had something to do with it
;;; coming from the Ausome Vax as a character file instead of a binary file.
(DEFPARAMETER GODZILLA-BITMAP-MOUSE-MAX-WIDTH NIL)
(DEFPARAMETER GODZILLA-BITMAP-MOUSE-MAX-HEIGHT NIL)
(DEFPARAMETER GODZILLA-BITMAP-MOUSE NIL)
(DEFPARAMETER HEATHER-BITMAP-MOUSE-MAX-WIDTH NIL)
(DEFPARAMETER HEATHER-BITMAP-MOUSE-MAX-HEIGHT NIL)
(DEFPARAMETER HEATHER-BITMAP-MOUSE NIL)
(DEFPARAMETER FAST-BITMAP-MOUSE-MAX-WIDTH NIL)
(DEFPARAMETER FAST-BITMAP-MOUSE-MAX-HEIGHT NIL)
(DEFPARAMETER FAST-BITMAP-MOUSE NIL)
(DEFPARAMETER SUSIE-BITMAP-MOUSE-MAX-WIDTH NIL)
(DEFPARAMETER SUSIE-BITMAP-MOUSE-MAX-HEIGHT NIL)
(DEFPARAMETER SUSIE-BITMAP-MOUSE NIL)
(DEFPARAMETER CHERRY-BITMAP-MOUSE-MAX-WIDTH NIL)
(DEFPARAMETER CHERRY-BITMAP-MOUSE-MAX-HEIGHT NIL)
(DEFPARAMETER CHERRY-BITMAP-MOUSE NIL)
(DEFPARAMETER CHERRYT-BITMAP-MOUSE-MAX-WIDTH NIL)
(DEFPARAMETER CHERRYT-BITMAP-MOUSE-MAX-HEIGHT NIL)
(DEFPARAMETER CHERRYT-BITMAP-MOUSE NIL)
(DEFPARAMETER JESSICA-BITMAP-MOUSE-MAX-WIDTH NIL)
(DEFPARAMETER JESSICA-BITMAP-MOUSE-MAX-HEIGHT NIL)
(DEFPARAMETER JESSICA-BITMAP-MOUSE NIL)
(DEFPARAMETER CUTEY-BITMAP-MOUSE-MAX-WIDTH NIL)
(DEFPARAMETER CUTEY-BITMAP-MOUSE-MAX-HEIGHT NIL)
(DEFPARAMETER CUTEY-BITMAP-MOUSE NIL)
(DEFPARAMETER *mouse-toggle-state* 0
  "2Start with Godzilla-mouse*")



;;; This function toggles between the two mouse bitmaps by setting up the
;;; appropriate mouse variables.
;(DEFUN MOUSE-TOGGLE (&REST IGNORE)
;  "2Toggle the current mode of the bitmap mouse.*"
;  (IF (NOT (EQ TV:BITMAP-MOUSE GODZILLA-BITMAP-MOUSE))
;      (SETQ TV:BITMAP-MOUSE-MAX-WIDTH  GODZILLA-BITMAP-MOUSE-MAX-WIDTH
;	    TV:BITMAP-MOUSE-MAX-HEIGHT GODZILLA-BITMAP-MOUSE-MAX-HEIGHT
;	    TV:BITMAP-MOUSE            GODZILLA-BITMAP-MOUSE)
;      (SETQ TV:BITMAP-MOUSE-MAX-WIDTH  HEATHER-BITMAP-MOUSE-MAX-WIDTH
;	    TV:BITMAP-MOUSE-MAX-HEIGHT HEATHER-BITMAP-MOUSE-MAX-HEIGHT
;	    TV:BITMAP-MOUSE            HEATHER-BITMAP-MOUSE)
;      (SETQ TV:BITMAP-MOUSE-MAX-WIDTH  SUSIE-BITMAP-MOUSE-MAX-WIDTH
;	    TV:BITMAP-MOUSE-MAX-HEIGHT SUSIE-BITMAP-MOUSE-MAX-HEIGHT
;	    TV:BITMAP-MOUSE            SUSIE-BITMAP-MOUSE)
;      (SETQ TV:BITMAP-MOUSE-MAX-WIDTH  CHERRY-BITMAP-MOUSE-MAX-WIDTH
;            TV:BITMAP-MOUSE-MAX-HEIGHT CHERRY-BITMAP-MOUSE-MAX-HEIGHT
;            TV:BITMAP-MOUSE            CHERRY-BITMAP-MOUSE)
;      (SETQ TV:BITMAP-MOUSE-MAX-WIDTH  CUTEY-BITMAP-MOUSE-MAX-WIDTH
;            TV:BITMAP-MOUSE-MAX-HEIGHT CUTEY-BITMAP-MOUSE-MAX-HEIGHT
;            TV:BITMAP-MOUSE            CUTEY-BITMAP-MOUSE)
;      ))

(DEFUN MOUSE-TOGGLE (&REST IGNORE)
  "2Toggle the current mode of the bitmap mouse.*"
  (CASE *mouse-toggle-state*
    (0 (SETQ TV:BITMAP-MOUSE-MAX-WIDTH  HEATHER-BITMAP-MOUSE-MAX-WIDTH
             TV:BITMAP-MOUSE-MAX-HEIGHT HEATHER-BITMAP-MOUSE-MAX-HEIGHT
             TV:BITMAP-MOUSE            HEATHER-BITMAP-MOUSE))
    (1 (SETQ TV:BITMAP-MOUSE-MAX-WIDTH  SUSIE-BITMAP-MOUSE-MAX-WIDTH
             TV:BITMAP-MOUSE-MAX-HEIGHT SUSIE-BITMAP-MOUSE-MAX-HEIGHT
             TV:BITMAP-MOUSE            SUSIE-BITMAP-MOUSE))
    (2 (SETQ TV:BITMAP-MOUSE-MAX-WIDTH  GODZILLA-BITMAP-MOUSE-MAX-WIDTH
             TV:BITMAP-MOUSE-MAX-HEIGHT GODZILLA-BITMAP-MOUSE-MAX-HEIGHT
             TV:BITMAP-MOUSE            GODZILLA-BITMAP-MOUSE))
    (3 (SETQ TV:BITMAP-MOUSE-MAX-WIDTH  CHERRY-BITMAP-MOUSE-MAX-WIDTH
             TV:BITMAP-MOUSE-MAX-HEIGHT CHERRY-BITMAP-MOUSE-MAX-HEIGHT
             TV:BITMAP-MOUSE            CHERRY-BITMAP-MOUSE))
    (4 (SETQ TV:BITMAP-MOUSE-MAX-WIDTH  CHERRYT-BITMAP-MOUSE-MAX-WIDTH
             TV:BITMAP-MOUSE-MAX-HEIGHT CHERRYT-BITMAP-MOUSE-MAX-HEIGHT
             TV:BITMAP-MOUSE            CHERRYT-BITMAP-MOUSE))
    (5 (SETQ TV:BITMAP-MOUSE-MAX-WIDTH  JESSICA-BITMAP-MOUSE-MAX-WIDTH
             TV:BITMAP-MOUSE-MAX-HEIGHT JESSICA-BITMAP-MOUSE-MAX-HEIGHT
             TV:BITMAP-MOUSE            JESSICA-BITMAP-MOUSE))
    (6 (SETQ TV:BITMAP-MOUSE-MAX-WIDTH  CUTEY-BITMAP-MOUSE-MAX-WIDTH
             TV:BITMAP-MOUSE-MAX-HEIGHT CUTEY-BITMAP-MOUSE-MAX-HEIGHT
             TV:BITMAP-MOUSE            CUTEY-BITMAP-MOUSE))
    )
    (SETQ *mouse-toggle-state* (MOD (INCF *mouse-toggle-state*) 7))
      )

(DEFUN fast-mouse (bitmap-name)
  "2Setup a new fast-tracking mouse*"
1   *;;1Define the new mouse bitmap.*
  (LET ((PATHNAME (CONCATENATE 'STRING "cerebus:bitmaps;"
                               (string-downcase (STRING bitmap-name))
                                ".bitmap")))
    (MULTIPLE-VALUE-BIND (ARRAY WIDTH HEIGHT)
        (W:READ-BIT-ARRAY-FILE pathname)
      (SETQ fast-BITMAP-MOUSE-MAX-WIDTH  WIDTH
            fast-BITMAP-MOUSE-MAX-HEIGHT HEIGHT
            fast-BITMAP-MOUSE ARRAY)))
  ;1;Now turn it on.*
  (SETQ TV:BITMAP-MOUSE-MAX-WIDTH  fast-BITMAP-MOUSE-MAX-WIDTH
	    TV:BITMAP-MOUSE-MAX-HEIGHT fast-BITMAP-MOUSE-MAX-HEIGHT
	    TV:BITMAP-MOUSE            fast-BITMAP-MOUSE))

(DEFPARAMETER posk-bitmaps '(BENGAL_TIGER BETYBOOP BILL BLOOM BROOKE CBRINKLY CHEESECAKE DRAGON DRKRIDER EYE1
                     EYE1 EYE2 EYES FULLMOON GEISHA HORROR HUNTRESS KEI1 KEI2 KINSKI KRISTEN LUM1 LUM2
                     MARILYN3 MAZE2 MOEB MSTREEP NAUSICCA1 NAUSICCA2 NERD NO NOBOZOS NOSMOKING PANTHER
                     PEIDMONT RHINE SCROOGE SHIN STARS STEINHEIM THING TIFFANY TVC15 VANNA VANNA2
                     WATERFALL YIN_YANG2 YODA YURI1 YURI2 ZEBRAGRL))

(DEFPARAMETER anime-bitmaps '(ALIEN_MAILCARRIER ASUKA ATARU BENTEN CHERRY ESMERALDUS EVE FANDORA IZU JUSTY
                      KEI2 KITSUNE KURAMA KUTATSU_NEKO LAN LUM MAKO MARI MARISU MENDO MORE_PINK_NINJA_SUITS
                      NAYUTA OYUKI PINK_NINJA_SUIT QUEEN ROY RYOKO RYUNOSKE SAKURA SHINOBU TAXI_DRIVER TOBIMARO
                      TOMOMI YURI ZMAIL))

(DEFUN LOAD-bitmaps ()
  (DOLIST (name posk-bitmaps) (SET name (tv:read-bit-array-file
                                          (CONCATENATE 'STRING "cerebus:bitmaps.posk;" (STRING name) ".bitmap"))))
  (DOLIST (name anime-bitmaps) (SET name (tv:read-bit-array-file
                                           (CONCATENATE 'STRING "cerebus:bitmaps;" (STRING name) ".bitmap")))))

(DEFUN read-and-load-bitmap (name &optional (posk t))
  (IF posk
   (SET name (tv:read-bit-array-file (CONCATENATE 'STRING "cerebus:bitmaps.posk;" (STRING name) ".bitmap")))
   (SET name (tv:read-bit-array-file (CONCATENATE 'STRING "cerebus:bitmaps;" (STRING name) ".bitmap")))))

(DEFUN show-image (image-name)
  (tv:show-bit-array image-name))

(DEFUN show-posk ()
  (dolist (image posk-bitmaps) (show-image (symbol-value image))))

(DEFUN show-anime ()
  (dolist (image anime-bitmaps) (show-image (symbol-value image))))

(DEFUN show-icon (bitmap-name)
  (tv:show-bit-array (tv:read-bit-array-file bitmap-name)))

(DEFUN my-profile ()
  (DECLARE (SPECIAL printer:*rotate-page-image*))

  (SETQ FS:USER-PERSONAL-NAME-FIRST-NAME-FIRST "Daniel A. Nichols"
	fs:user-personal-name "Nichols, Dan")
 
  ;; 1fix pathnames so VMS files with "-" are accessable*
  (UNLESS (POSITION #\- (THE STRING (STRING FS::VMS4-FILENAME-CHARSET)) :TEST #'CHAR-EQUAL)  
    (setq fs:vms4-filename-charset (string-append fs:vms4-filename-charset "-")))
  
  (SETQ-GLOBALLY *PRINT-BASE* 10. *READ-BASE* 10.)	   ;1This is supppsed to be the default, but it keeps changing...*
  (SETQ *print-length* 100.)		   ;1So circular lists don't screw too bad*
  (SETQ *print-level* 50.)

  ;1Ensure CPTFONT is the default font*
  (UNLESS (EQ (send tv:main-screen :parse-font-descriptor :default) fonts:cptfont)
    (tv:set-default-font fonts:cptfont))

  (SETQ fonts:code-font    fonts:cptfont
        fonts:comment-font fonts:hl12b
        fonts:string-font  fonts:hl12bi)
;1; Setting this to T has many bad side-effects in parts of the system that print to files...*
;1;*  (SETQ *print-pretty* t)		   ;1Grind on output*

  (WHEN (FIND-PACKAGE 'TELNET)
    (EVAL (READ-FROM-STRING "(LOGIN-SETQ TELNET:*NUMBER-OF-VT100-LINES* 52.)")))

  (PROFILE::PROFILE-SETQ profile:arrest-character #\f4)
;  (SETQ si:gc-flip-ratio 0.75)
   
;1; Setup default compiler optimizations*
;1; Don't optimize while working on performance benchmarks...*
;1;*  (proclaim '(optimize (compilation-speed 0) (safety 1) (space 2) (speed 3)))
;1;*  (setq-globally compiler:optimize-switch compiler:optimize-switch)
  
;  (tv:black-on-white)			   ;1Ensure black on white display*

  (SETQ inhibit-fdefine-warnings 		:just-warn         1; Don't ask about function redefinition*
	fs:host-unit-lifetime			(* 60. 3600.)	   ;1 Keep a connection 60 minutes*
;	profile:p-lisp-mode			:common-lisp
	tv:*enable-wholine-help-documentation-p* t
	tv:black-screen-time-delay		600	   ;1Black screen after 1 hour*
;1;*	tv:initial-repeat-delay			#o1777777  ;1Don't repeat keys*
	)
  (PROGN :PROFILE-OPTIONS
	 (PROFILE::PROFILE-SETQ *READ-BASE* '10.)
	 (PROFILE::PROFILE-SETQ *PRINT-BASE* '10.)
	 (PROFILE::PROFILE-SETQ UCL::*TYPEIN-CONFIGURATION* 'NIL)
         (PROFILE::PROFILE-SETQ ZWEI::*DEFAULT-BASE* '10.)
         (PROFILE::PROFILE-SETQ ZWEI::*FIND-FILE-EARLY-SELECT* T)
         (PROFILE:PROFILE-SETQ TV:EXPLODING-MOMENTARY-WINDOWS 'T)
	 (PROFILE::PROFILE-SETQ UCL::*DEFAULT-MAX-COMMAND-HISTORY* '32.))

  ;; Fix up the godzilla mouse.
  (MULTIPLE-VALUE-BIND (ARRAY WIDTH HEIGHT)
      (W:READ-BIT-ARRAY-FILE "cerebus:bitmaps;GODZILLA-MOUSE.BITMAP")
    (SETQ GODZILLA-BITMAP-MOUSE-MAX-WIDTH  WIDTH
          GODZILLA-BITMAP-MOUSE-MAX-HEIGHT HEIGHT
          GODZILLA-BITMAP-MOUSE ARRAY))

  ;; Define 1the Heather* bitmap.
  (MULTIPLE-VALUE-BIND (ARRAY WIDTH HEIGHT)
      (W:READ-BIT-ARRAY-FILE "CEREBUS:BITMAPS;HEATHER-SMALL-6.BITMAP")
    (SETQ HEATHER-BITMAP-MOUSE-MAX-WIDTH  WIDTH
          HEATHER-BITMAP-MOUSE-MAX-HEIGHT HEIGHT
          HEATHER-BITMAP-MOUSE ARRAY))

  ;; Define 1the Susie* bitmap.
  (MULTIPLE-VALUE-BIND (ARRAY WIDTH HEIGHT)
      (W:READ-BIT-ARRAY-FILE "CEREBUS:BITMAPS;SUSIE.BITMAP")
    (SETQ SUSIE-BITMAP-MOUSE-MAX-WIDTH  WIDTH
          SUSIE-BITMAP-MOUSE-MAX-HEIGHT HEIGHT
          SUSIE-BITMAP-MOUSE ARRAY))
  
  ;; Define 1the Cherry* bitmap.
  (MULTIPLE-VALUE-BIND (ARRAY WIDTH HEIGHT)
      (W:READ-BIT-ARRAY-FILE "CEREBUS:BITMAPS;CHERRYP-SMALL.BITMAP")
    (SETQ CHERRY-BITMAP-MOUSE-MAX-WIDTH  WIDTH
          CHERRY-BITMAP-MOUSE-MAX-HEIGHT HEIGHT
          CHERRY-BITMAP-MOUSE ARRAY))

  ;; Define 1the Cherry-Tart* bitmap.
  (MULTIPLE-VALUE-BIND (ARRAY WIDTH HEIGHT)
      (W:READ-BIT-ARRAY-FILE "CEREBUS:BITMAPS;CHERRY-TART8.BITMAP")
    (SETQ CHERRYT-BITMAP-MOUSE-MAX-WIDTH  WIDTH
          CHERRYT-BITMAP-MOUSE-MAX-HEIGHT HEIGHT
          CHERRYT-BITMAP-MOUSE ARRAY))

  ;; Define 1the Jessica* bitmap.
  (MULTIPLE-VALUE-BIND (ARRAY WIDTH HEIGHT)
      (W:READ-BIT-ARRAY-FILE "CEREBUS:BITMAPS;jessica-rabbit8.BITMAP")
    (SETQ JESSICA-BITMAP-MOUSE-MAX-WIDTH  WIDTH
          JESSICA-BITMAP-MOUSE-MAX-HEIGHT HEIGHT
          JESSICA-BITMAP-MOUSE ARRAY))

  ;; Define 1the Cutey* bitmap.
  (MULTIPLE-VALUE-BIND (ARRAY WIDTH HEIGHT)
      (W:READ-BIT-ARRAY-FILE "CEREBUS:BITMAPS;CUTEY-SMALL.BITMAP")
    (SETQ CUTEY-BITMAP-MOUSE-MAX-WIDTH  WIDTH
          CUTEY-BITMAP-MOUSE-MAX-HEIGHT HEIGHT
          CUTEY-BITMAP-MOUSE ARRAY))

  ;; Make sure that the godzilla mouse comes up first.
  (SETQ TV:BITMAP-MOUSE NIL)
  (MOUSE-TOGGLE)

  ;; Tie the mouse toggling to the F2 key.
  (LOGIN-SETQ TV:KBD-GLOBAL-ASYNCHRONOUS-CHARACTERS (CONS (LIST (CHAR-CODE #\F3) 'MOUSE-TOGGLE)
                                                          TV:KBD-GLOBAL-ASYNCHRONOUS-CHARACTERS))

  ;; Turn on the Gozdilla mouse.
  (LOGIN-SETQ W:MOUSE-FAST-TRACK-BITMAP-MOUSE-P T
              W:MOUSE-FAST-MOTION-SPEED 3)


  )

(my-profile)


(DEFUN my-options ()
  (WHEN (FBOUNDP 'vaxps) (vaxps))
;  (WHEN (FBOUNDP 'set-process) (set-process :process si:initial-process :background))
  
  ;1; Set printer defaults*
  (SETQ printer:*rotate-page-image* t)	   ;1Landscape mode is the default*
;  (setq *vax-laser-device* :talaris-1200)		;1can be :talaris-2400 :talaris-1200 or :ln01*
  (SET-DEFAULT-PRINTER "TALARIS-2400")                ;1Can be "talaris-2400" "talaris-1200" or "ln01"*
  (SET-DEFAULT-IMAGE-PRINTER "TALARIS-2400")          ;1Can be "talaris-2400" "talaris-1200" or "ln01"*
;  (unless (member si:*default-printer* si:*printer-devices* :test #'EQUAL)
;    (add-printer-device si:*default-printer* 'printer::talaris "v4"))

  (SETQ beep :beep)			   ;1Get rid of beep flash*
  (setq zwei:*converse-receive-mode* :simple	   ; 1For the pop-up mode.*
	zwei:*converse-beep-count*   1)	   ; 1Telephone bell should only ring once.*
  
  ;1;Put the flavor-inspector back on a system key.*
  (tv:ADD-SYSTEM-KEY #\o 'tv:flavor-inspector "Flavor Inspector -- A utility for examining the structure of flavors.")

  ;; 1Set some reminders*
  (WHEN (FBOUNDP 'demo:set-alarm)
    (DEMO::DEACTIVATE-ALARM-PROCESS T)
    (demo:set-alarm "8:58am" "Good Morning!!  -  Don't forget timesheet" "24 hours")
    (demo:set-alarm "8:59am" "Almost 9am - any meetings today?" "24 hours")
    (demo:set-alarm "9:58am" "Almost 10am - any meetings today?" "24 hours")
    (demo:set-alarm "11:28am" "Lunch Time!" "24 hours")
    (demo:set-alarm "12:58pm" "Almost 1pm - any meetings today?" "24 hours")
    (demo:set-alarm "1:58pm" "Almost 2pm - any meetings today?" "24 hours")
    (demo:set-alarm "2:58pm" "Almost 3pm - any meetings today?" "24 hours")
    (demo:set-alarm "5:25pm" "Its been a long day... Why don't you go home?" "24 hours")
    (demo:set-alarm "6:00pm" "You really DO need to go home now..." "24 hours" nil t 'BEEP :races)
    (demo:set-alarm "6:30pm" "If you're still here, you shouldn't be!!" "24 hours" nil t 'BEEP :flying-saucer)
    (setq chaos:time-server-hosts '("v4"))
    ;1; Reset the timebase every hour on the hour*
    (demo:set-alarm (format nil "~d:00:00" (1+ (nth-value 2 (time:get-time))))
		    "Reset timebase" "1 hour" nil nil 'PROCESS-RUN-FUNCTION
		 "Reset TimeBase" 'time:initialize-timebase)
    ;1; GC at 3:00AM*
    (demo:set-alarm "5:00am" "Garbage Collect" "24 hours" nil nil 'PROCESS-RUN-FUNCTION
		    "Start-GC" 'EVAL '(tv:notify
					nil "~a"
					(WITH-OUTPUT-TO-STRING (*trace-output*)
					  (LET ((si:gc-flip-ratio 0.01))
					    (TIME (GC-IMMEDIATELY))
					    ;1; Force a rehash of the Pathname Hash Table*
					    (gethash 'foo fs:*pathname-hash-table*)))))
    )

    ;1;;CSNET mail*
    ;(LOGIN-SETQ zwei:*user-from-field* "Col. Muammar Qadhafi <Qadhafi@TI-CSL>")
    (LOGIN-SETQ zwei::*user-default-mail-file*
          (MAKE-PATHNAME :defaults "cerebus:mail;mail.text")
;                         :raw-name "RMAIL"
;                         :raw-type :unspecific)
	    mail:*user-mail-address* "Dan Nichols <dnichols@csc.ti.com>" ;preload the FROM field
            zwei:*mail-summary-mode* :filtered
	    zwei:*mail-file-versions-kept* 2		 ;only keep 2 mail file versions
	    zwei:*yank-message-prefix* "   > "		 ;new prefix on yanked mail in replies
	    zwei:*two-window-reply* nil			 ;don't use two window mode in reply
	    zwei:*delete-message-after-copy* T           ;delete copied messages
	    zwei:*mail-summary-template*		 ;change to full date and longer subject
	    '(:length :lines :from 30. :subject 40. :date :date :keywords 20.)
          )
    )

(defun mail:DEFAULT-SENDER-ADDRESS (&optional errorp)

  (fs:force-user-to-login)
  (let ((sender (mail:xstring-append nil user-id "@"
                                (IF (OR (STRING= user-id "Denise") (STRING= user-id "Dcj")) "Killer.dallas.tx.us"
                                    (send si:local-host :name)))))
    (prog1 (mail:parse-address sender 0 nil errorp :mailbox)
	   (mail:deallocate-xstring sender))))

(DEFUN dan ()
  (COND ((NOT (EQUAL USER-id "NICHOLS"))
         (SETQ user-id "NICHOLS")
         (SETF nse:*value* "Dan Nichols")))
  (SETQ FS:USER-PERSONAL-NAME-FIRST-NAME-FIRST "Daniel A. Nichols"
        mail:*mail-user-personal-name* "Daniel A. Nichols"
	fs:user-personal-name "Nichols, Dan")
  (LOGIN-SETQ mail:*user-mail-address* "Dan Nichols <dnichols@csc.ti.com>"))
(DEFUN denise ()
  (SETQ user-id "DENISE")
  (SETF nse:*value* "Denise Jacob")
  (SETQ FS:USER-PERSONAL-NAME-FIRST-NAME-FIRST "Denise C. Jacob"
        mail:*mail-user-personal-name* "Denise C. Jacob"
	fs:user-personal-name "Jacob, Denise")
  (LOGIN-SETQ mail:*user-mail-address* "Denise Jacob <dcj@killer.uucp>"))
;  (LOGIN-SETQ mail:*user-mail-address* "Denise Jacob <dcj@cerebus.ti.com>"))
(DEFUN dcj ()
  (SETQ user-id "DCJ")
  (SETF nse:*value* "Denise Jacob")
  (SETQ FS:USER-PERSONAL-NAME-FIRST-NAME-FIRST "Denise C. Jacob"
        mail:*mail-user-personal-name* "Denise C. Jacob"
	fs:user-personal-name "Jacob, Denise")
  (LOGIN-SETQ mail:*user-mail-address* "Denise Jacob <dcj@killer.uucp>"))
;  (LOGIN-SETQ mail:*user-mail-address* "Denise Jacob <dcj@cerebus.ti.com>"))
(DEFUN wendy ()
  (SETQ user-id "WENDY")
  (SETF nse:*value* "Wendy Storm")
  (SETQ FS:USER-PERSONAL-NAME-FIRST-NAME-FIRST "Wendy J. Storm"
	fs:user-personal-name "Storm, Wendy")
  (LOGIN-SETQ mail:*user-mail-address* "Wendy Storm <wendy@killer.uucp>"))

(DEFUN login-options (&optional reload)
  ;1;make this stuff a function so I can call it after*
  ;1;a warm boot or in case I forgot to load something*
  (DECLARE (SPECIAL my-environment))
  (WHEN reload (LOAD "Lm:nichols;login-options"))
  (UNLESS (FBOUNDP 'execute-menu) (LOAD "Lm:nichols;execute-menu"))
  (SEND *terminal-io* :set-deexposed-typeout-action :permit)
  (let ((tv:more-processing-global-enable nil))
      (execute-menu my-environment my-projects))
  (my-options))


(DEFSYSTEM DAN
  (:Name "Dan Nichols")
  (:short-name "Dan")
  (:component-systems i-ching)
  (:pathname-default "Lm:nichols;")
  (:patchable "cerebus:nichols.patch;" PATCH)
  (:module zmacs ("lm:nichols.Zmacs;bind-key" "lm:nichols.ZMACS;zmacs-init" 
		  "lm:nichols.ZMACS;zmacs-commands" "lm:nichols.zmacs;zmacs-mouse" "lm:nichols.zmacs;insert-debug-code"))
  (:module util ("lm:nichols.UTILITIES;new-utils" "lm:nichols;execute-menu" "lm:nichols.utilities;super-point"
                 "lm:public;alarm")) ;"lm:hacks.misc;screen-saver")); "lm:public;black-screen" "lm:public;idle-qix"))
  (:module mouse-font ("lm:Fonts;hs-mouse"))
  (:fasload mouse-font)
  (:compile-load zmacs)
  (:compile-load util)
  )

(DEFCONSTANT my-environment
          '(
            ("My Environment"
             (LOAD (MAKE-SYSTEM 'Dan :noconfirm  :no-reload-system-declaration :no-load-patches))
             (patch (MAKE-SYSTEM 'Dan :nowarn :compile :no-increment-patch :noconfirm
				  :no-reload-system-declaration))
	     (edit (ed "Lm:Nichols;login-options")))
	    ("Patches"
	     (load (LOAD-PATCHES :noselective)))
	    ("My Patches"
	     (load (LOAD-PATCHES 'Dan :noselective)))
	    ("CLX"
	     (load (make-system 'clx :noconfirm))
	     (patch (make-system 'clx :recompile :noconfirm)))
	    ("X-SERVER"
	     (load (make-system 'x11 :noconfirm))
	     (patch (make-system 'x11 :recompile :noconfirm)))
            ("Super-. X11"
             (LOAD (scan-tag-file "stroke:/u1/XV11R2/tags/servertags")
                   (scan-tag-file "stroke:/u1/XV11R2/tags/dix-tags")
                   ))
            ("Graphics Window"
             (LOAD (MAKE-SYSTEM 'gwin ':noconfirm)))
            ("Graphics Editor"
             (LOAD (MAKE-SYSTEM 'ged ':noconfirm)))
            ("Grasper"
             (LOAD (MAKE-SYSTEM 'grasper ':noconfirm)))
            ("Prolog"
             (LOAD (MAKE-SYSTEM 'prolog ':noconfirm)))
;	    ("Tree Editor"
;	     (load (make-system 'tree ':noconfirm)))
            ("Public"
             (LOAD (LOAD "lm:public;defsystem")
                   (MAKE-SYSTEM 'my-public :noconfirm)
                   (MAKE-SYSTEM 'csc-printer-changes :noconfirm))
;                   (LOAD "yours:buehring;filter-summary"))
             (edit (ed "lm:public;defsystem.lisp")))
            ("Rogue"
             (LOAD (MAKE-SYSTEM 'mpr :noconfirm)))
            ("ZGraph"
             (LOAD (MAKE-SYSTEM 'zgraph :noconfirm)))
;            ("NFS"
;             (LOAD (MAKE-SYSTEM 'rpc :noconfirm)
;                   (MAKE-SYSTEM 'nfs :noconfirm)
;                   (nfs:start-nfs-server :udp t t)))
	    ("Demo"
	     (load (make-system 'demo ':noconfirm)))
	    ("Sounds"
	     (load (LOAD "sys:public.music-demo;defsystem")
                   (MAKE-SYSTEM 'music :noconfirm)
                   (LOAD "sys:public.speech;speech")
                   (LOAD "lm:sound;new-beeps")))
            ("Login"
             (edit (med1 "cerebus:nichols;login-logicals.lisp")
                   (med1 "cerebus:nichols;login-init.lisp")))
            ("Movies"
             (edit (med1 "m2:/epoch/misc/u2/dnichols/TeX/Stuff/movies.tex")
                   (med1 "m2:/epoch/misc/u2/dnichols/TeX/Stuff/movie-tape.index")
                   (med1 "m2:/epoch/misc/u2/dnichols/TeX/Stuff/mn.tex")))
            ("CDF"
             (LOAD (zwei:read-mail "m2:/epoch/misc/u2/dnichols/Misc/stuff/cdf/mail.text"))
             (edit (med1 "m2:/epoch/misc/u2/dnichols/Misc/stuff/cdf/pending-mail"))
             (patch (med1 "m2:/epoch/misc/u2/dnichols/.mailrc")
                    (med1 "m2:/epoch/misc/u2/dnichols/Misc/stuff/cdf/MailingList")
                    (med1 "m2:/epoch/misc/u2/dnichols/Misc/stuff/cdf/cdf.info")))
            ))
            
(DEFPARAMETER my-projects
          '(
	    ))

#+comment
(DEFPARAMETER Sound-options
              `(("Beep"
                 (DEMO:read-sound 'beep "cerebus:sound;BEEP.SOUND")
                 (push  '(:beep (demo:play beep "cerebus:sound;beep.sound:"))
                        tv:BEEPING-FUNCTIONS)
                 (tv:DEF-BEEP-TYPE TV:DEFAULT-BEEP  :beep))
                ("Don't do that!"
                 (DEMO:read-sound 'dont_do_that "CEREBUS:SOUND;DONT_DO_THAT.SOUND")
                 (push  '(:dont_do_that (demo:play dont_do_that "cerebus:sound;dont_do_that.sound:"))
                        tv:BEEPING-FUNCTIONS)
                 (tv:DEF-BEEP-TYPE TV:DEFAULT-BEEP  :dont_do_that))
                ("Don't touch!"
                 (DEMO:read-sound 'dont_touch "CEREBUS:SOUND;DONT_TOUCH.SOUND")
                 (push  '(:dont_touch (demo:play dont_touch "cerebus:sound;dont_touch.sound:"))
                        tv:BEEPING-FUNCTIONS)
                 (tv:DEF-BEEP-TYPE TV:DEFAULT-BEEP  :dont_touch))
                ("Go Away!."
                 (DEMO:read-sound 'goaway1 "CEREBUS:SOUND;goaway1.SOUND")
                 (push  '(:goaway1 (demo:play goaway1 "cerebus:sound;goaway1.sound:"))
                        tv:BEEPING-FUNCTIONS)
                 (tv:DEF-BEEP-TYPE TV:DEFAULT-BEEP  :goaway1))
                ("Hey! Stop that."
                 (DEMO:read-sound 'hey_stop_that "CEREBUS:SOUND;HEY_STOP_THAT.SOUND")
                 (push  '(:hey_stop_that (demo:play hey_stop_that "cerebus:sound;hey_stop_that.sound:"))
                        tv:BEEPING-FUNCTIONS)
                 (tv:DEF-BEEP-TYPE TV:DEFAULT-BEEP  :hey_stop_that))
                ("Keep your hands off!"
                 (DEMO:read-sound 'keep_your_hands_off "CEREBUS:SOUND;KEEP_YOUR_HANDS_OFF.SOUND")
                 (push  '(:keep_your_hands_off (demo:play keep_your_hands_off "cerebus:sound;keep_your_hands_off.sound:"))
                        tv:BEEPING-FUNCTIONS)
                 (tv:DEF-BEEP-TYPE TV:DEFAULT-BEEP  :keep_your_hands_off))
                ("Phone ringing"
                 (DEMO:read-sound 'phone_ringing "CEREBUS:SOUND;PHONE_RINGING.SOUND")
                 (push  '(:phone_ringing (demo:play phone_ringing "cerebus:sound;phone_ringing.sound:"))
                        tv:BEEPING-FUNCTIONS)
                 (tv:DEF-BEEP-TYPE TV:DEFAULT-BEEP  :phone_ringing))
                ("Ribbit"
                 (DEMO:read-sound 'ribbit "CEREBUS:SOUND;RIBBIT.SOUND")
                 (push  '(:ribbit (demo:play ribbit "cerebus:sound;ribbit.sound:"))
                        tv:BEEPING-FUNCTIONS)
                 (tv:DEF-BEEP-TYPE TV:DEFAULT-BEEP  :ribbit))))

#+comment
(DEFUN play-time ()
  (execute-menu hacking-options graphics-options))

#+comment
(DEFPARAMETER Hacking-options
              `(("APL"
                 (LOAD (LOAD "DAN:HACKS;apl"))
                 (edit (ED "DAN:HACKS;apl")))
                ("Baseball"
                 (edit (ED "DAN:toys;baseball")))
                ("Fractals"
                 (edit (ED "dan:nichols.graphics.fractal;fractal")))
                ("Games-and-Toys"
                 (LOAD (execute-menu games-and-toys)))
                ("GKS"
                 (edit (ED "DAN:NICHOLS;gks")))
                ("Slime"
                 (LOAD (LOAD "DAN:SLIME;slime-utils")
                       (LOAD "DAN:SLIME;slime-mute")
                       (LOAD "DAN:SLIME;slime-color")
                       (LOAD "DAN:SLIME;slime-graph")
                       (LOAD "DAN:SLIME;slime-palindrome"))
                 (edit (MED "DAN:SLIME;slime-utils")
                       (MED "DAN:SLIME;slime-mute")
                       (MED "DAN:SLIME;slime-color")
                       (MED "DAN:SLIME;slime-graph")
                       (MED "DAN:SLIME;slime-palindrome")))
                ("Turtle"
                 (edit (ED "DAN:TURTLE;turtles")))))

#+comment
(Defparameter graphics-options
              '(("Hacks"
                 (load (make-system 'hacks ':noconfirm)))
                ("My-Hacks"
                 (LOAD (LOADf "DAN:DEMO;hacksys")
                       (MAKE-SYSTEM 'hacks ':noconfirm)))
                ("Movies"
                 (LOAD (MAKE-SYSTEM 'movie ':noconfirm)))
                ("3dd"
                 (LOAD (MAKE-SYSTEM '3d-display ':noconfirm)
                       (LOADf "BEF0:BRUCEF;3dd-demo")))
                ("4dd"
                 (LOAD (MAKE-SYSTEM '4d-display ':noconfirm)))
                ("Turtle"
                 (LOAD (LOAD "dan:turtle;turtles")))
                ("Fractals"
                 (LOAD (LOAD "dan:nichols.fractal;fractal")))
                ("GKS"
                 (LOAD (FORMAT t "~%GKS not available, yet!")))))

#+comment
(DEFPARAMETER Games-and-Toys
              `(("Backgammon"
                 (edit (ED "DAN:TOYS;backgammon"))
                 (LOAD (LOAD "DAN:TOYS;backgammon")))
                ("Cannon"
                 (LOAD (LOAD "DAN:toys;boom"))
                 (edit (ED "DAN:toys;boom")))
                ("Life"
                 (LOAD (LOAD "DAN:cell;life-ut"))
                 (edit (ED "DAN:cell;life-ut")))
                ("Moire"
                 (LOAD (LOAD "DAN:graphics;moire"))
                 (edit (ED "DAN:graphics;moire")))
                ("Planets"
                 (LOAD (LOAD "DAN:TOYS;newton"))
                 (edit (ED "DAN:TOYS;newton")))
                ("Solar System"
                 (LOAD (LOAD "Dan:toys;solar-system")))
                ("Spacewar"
                 (LOAD (LOAD "DAN:TOYS;spacewar"))
                 (edit (ED "DAN:TOYS;spacewar")))
                ("Turtles"
                 (LOAD (LOAD "DAN:turtle;turtles"))
                 (edit (ED "DAN:turtle;turtles")))))

#+comment
(DEFUN hacker ()
  (without-more-processing *terminal-io*
    (execute-menu hacking-options graphics-options)))


