;;-*-LISP-*-
;; Some functions to test the arithmetic routines.
;; Taken from Macsyma.

#+MACLISP (DECLARE (MUZZLED T))

(DEFMACRO DEFMFUN (&REST L) `(DEFUN ,@L))
(DEFMACRO DEFMVAR (&REST L) `(DEFVAR ,@L))

(DECLARE (SPECIAL MODULUS))

(DEFUN FERMAT (MODULUS)
  (CEXPT 2 (1- MODULUS)))

;; SI:NEXT-PRIME is in the NIL Virtual Machine, used by hash-table code.
(DEFVAR MY-NEXT-PRIME #+NIL #'NEXT-PRIME #+MACLISP 'MY-NEXT-PRIME)

(DEFUN MY-NEXT-PRIME (N)
  ;; if PRIMEP works we can use this function.
  (PROG (P)
    (SETQ P (IF (ODDP N)
		(+ 2 N)
		(1+ N)))
   LOOP
    (IF (PRIMEP P) (RETURN P))
    (SETQ P (+ 2 P))
    (GO LOOP)))

(DEFVAR FERMAT-TEST T)

(DEFUN FERMAT-TEST ()
  (DO ((P 3 (FUNCALL MY-NEXT-PRIME P))
       (LINESIZE 50.))
      ((OR (MINUSP P)
	   (>= P (LSH -1 -1))))
    (IF FERMAT-TEST
	(LET ((S (1+ (FLATSIZE P))))
	  (COND ((> (+ S LINESIZE) 50.)
		 (SETQ LINESIZE 0)
		 (TERPRI)))
	  (SETQ LINESIZE (+ S LINESIZE))
	  (PRIN1 P) (PRINC " ")))
    (OR (EQUAL (FERMAT P) 1)
	(ERROR "fails fermat little theorem" P))))

(DEFUN FNEWPRIME (P)	; Finds biggest prime less than fixnum P.
  (DO PP (IF (ODDP P) (- P 2) (- P 1)) (- PP 2) (< PP 0)
      (IF (PRIMEP PP) (RETURN PP))))


(DEFUN PRIMEP (P)
  (AND (OR (LESSP P 14.)
	   (LET ((MODULUS P))
		(AND (EQUAL 1 (CEXPT 13. (SUB1 P))) (EQUAL 1 (CEXPT 3 (SUB1 P))))))
       (NULL (CDDR (SETQ P (CFACTORW P))))
       (= 1 (CADR P))))

(DEFUN CEXPT (N E)
  (COND	((NULL MODULUS) (EXPT N E))
	(T (CMOD (CBEXPT N E)))))

(DEFMACRO BCTIMES (&REST L)
  `(REMAINDER (TIMES . ,L) MODULUS))

(DEFUN CBEXPT (P N)
       (DO ((N (QUOTIENT N 2) (QUOTIENT N 2))
	    (S (COND ((ODDP N) P) (T 1))))
	   ((ZEROP N) S)
	   (SETQ P (BCTIMES P P))
	   (AND (ODDP N) (SETQ S (BCTIMES S P)))))

(DEFUN CMOD (N)
  (COND ((NULL MODULUS) N)
	((BIGP MODULUS)
	 (SETQ N (REMAINDER N MODULUS))
	 (COND ((LESSP N 0)
		(IF (LESSP (TIMES 2 N) (MINUS MODULUS))
		    (SETQ N (PLUS N MODULUS))))
	       ((GREATERP (TIMES 2 N) MODULUS) (SETQ N (DIFFERENCE N MODULUS)))) 
	 N)
	((BIGP N)
	 (SETQ N (REMAINDER N MODULUS))
	 (COND ((< N 0)
		(IF (< N (- (LSH MODULUS -1))) (SETQ N (+ N MODULUS))))
	       ((> N (LSH MODULUS -1)) (SETQ N (- N MODULUS))))
	 N)
	((= MODULUS 2) (LOGAND N 1))
	(T (LET ((NN (\ N MODULUS)))
	     (DECLARE (FIXNUM NN))
	     (COND ((< NN 0)
		    (AND (< NN (- (LSH MODULUS -1))) (SETQ NN (+ NN MODULUS))))
		   ((> NN (LSH MODULUS -1)) (SETQ NN (- NN MODULUS))))
	     NN))))

(DECLARE (SPECIAL $FACTORFLAG))

(DEFMFUN CFACTORW (N) (LET (($FACTORFLAG T)) (CFACTOR N)))

(DEFMACRO EQN (&REST L) `(EQUAL . ,L))
(DEFMACRO PZEROP (X) `(SIGNP E ,X))			;TRUE FOR 0 OR 0.0
(DEFMACRO PZERO () 0)
(DEFMACRO ERRRJF (X) `(ERROR ,X))

(DEFMVAR $INTFACLIM 1000.)

(DEFMFUN CFACTOR (X)
  (PROG (DIVISOR TT ANS K)
	(COND ((NULL $FACTORFLAG) (RETURN (LIST X 1)))
	      ((FLOATP X)
	       (ERRRJF "FACTOR given floating arg"))
	      ((PZEROP X) (RETURN (LIST (PZERO) 1)))
	      ((EQN X -1) (RETURN (LIST -1 1)))
	      ((MINUSP X)
	       (RETURN (CONS -1 (CONS 1 (CFACTOR (MINUS X))))))
	      ((LESSP X 2) (RETURN (LIST X 1))))
	(SETQ K 2)
	(SETQ DIVISOR 2)
	SETT (SETQ TT 0)
	LOOP (COND ((ZEROP (REMAINDER X DIVISOR))
		    (SETQ TT (ADD1 TT))
		    (SETQ X (QUOTIENT X DIVISOR))
		    (GO LOOP)))
	(COND ((GREATERP TT 0)
	       (SETQ ANS (CONS DIVISOR (CONS TT ANS)))))
	(COND ((EQUAL DIVISOR 2) (SETQ DIVISOR 3))
	      ((EQUAL DIVISOR 3) (SETQ DIVISOR 5))
	      (T (SETQ DIVISOR (PLUS DIVISOR K))
		 (COND ((EQ K 2) (SETQ K 4)) (T (SETQ K 2)))))
	(COND ((OR (AND $INTFACLIM (GREATERP DIVISOR $INTFACLIM))
		   (GREATERP (TIMES DIVISOR DIVISOR) X))
	       (RETURN (COND ((GREATERP X 1)
			      (CONS X (CONS 1 ANS)))
			     (T ANS)))))
	(GO SETT)))
  