;;; -*- Mode:LISP; Package:USER; Base:8; Fonts:(MEDFNT MEDFNB HL12B) -*-

(DEFVAR altered-key-list nil "2List of keys altered by the ALTER-KEY-MAP function*")

(DEFUN alter-key (old-key new-key &optional shift-key &aux shift key)
  "2alter the key map 'si:kbd-new-table replacing OLD-KEY with NEW-KEY.  OLD-KEY is always
the origional key code.  This prevents things from getting confusing after calling this function
several times.  This works by searching for OLD-KEY in the key table.  If SHIFT-KEY is non-nil,
it is used to restrict the search to that part of the array where SHIFT-KEY applys.  This can
be used to restrict the search for cases where the same key-code appears on more than one
key.*"
  ;1;Infer shift from bucky bits*
  (SETQ shift (SELECTQ (LDB %%kbd-control-meta old-key)
		(0 nil) (1 1) (2 2) (4 3) (10 4)
		(otherwise (FERROR 'bad-character
				   "ALTER-KEY-MAP given a character with too many ~
                                    shift keys specified - ~C" old-key))))
  ;1;Check for shift-key specified separately*
  (WHEN shift-key
    (WHEN (OR (NOT (SETQ key (SECOND (ASSQ shift-key '((shift 1) (top 2) (greek 3)
						       (shift-greek 4))))))
	      (AND shift (NEQ shift key)))
      (FERROR 'bad-shift-specifier "bad parameter to ALTER-KEY-MAP ~s" shift-key))
    (SETQ shift key))
  ;1;Check for key already altered*
  (COND ((DOLIST (change altered-key-list)
	   (WHEN (AND (EQ old-key (FIRST change))
		      (OR (NULL shift) (EQ shift (SECOND change))))
	     (ASET new-key si:kbd-new-table (SECOND change) (THIRD change))
	     (RETURN (SETF (FOURTH change) new-key)))))
	;1;Search for key in key table*
	((DO-NAMED outer
		   ((i 0 (1+ i))
		    ii)
		   ((OR (>= i 4)
			(AND shift (NEQ i 0))))
	   (SETQ ii (OR shift i))
	   (DOTIMES (j 200)
	     (WHEN (AND (EQ old-key (AREF si:kbd-new-table i j))
			(NOT (DOLIST (changed altered-key-list)
			       (AND (EQ old-key (FOURTH changed))
				    (NEQ old-key (FIRST changed))
				    (EQ ii (SECOND changed))
				    (EQ j (THIRD changed))
				    (RETURN t)))))
	       (PUSH (LIST (AREF si:kbd-new-table ii j) ii j new-key)
		     altered-key-list)
	       (ASET new-key si:kbd-new-table ii j)
	       (RETURN-FROM outer t)))))
	;1;Report error if key not found*
	(t (FERROR 'char-not-found "Could not find ~C in the key table" old-key))))

(DEFUN set-key-map (keycode shift-key new-key &aux shift)
  "2Set the key-map for the character at KEYCODE shifted one of (NIL SHIFT TOP GREEK SHIFT-GREEK)
to the NEW-KEY character.*"
  (SETQ shift (IF (NULL shift-key) 0
		(SECOND (ASSQ shift-key '((shift 1) (top 2) (greek 3)
					  (shift-greek 4))))))
  (PUSH (LIST (AREF si:kbd-new-table shift keycode) shift new-key)
	altered-key-list)
  (ASET keycode si:kbd-new-table shift new-key))

(DEFUN reset-key-map ()
  "2Undo any changes made by ALTER-KEY-MAP*"
  (DOLIST (key altered-key-list)
    (ASET (FIRST key) si:kbd-new-table (SECOND key) (THIRD key)))
  (SETQ altered-key-list nil))

#| Test forms
(PROGN
  (reset-key-map)
  (Alter-key #/9 #/[ 'shift)
  (alter-key #/0 #/] 'shift)
  (alter-key #/[ #/()
  (alter-key #/] #/))
  )

|#