;;; -*- Mode:LISP; Package:USER; Base:10; Fonts:(MEDFNT HL12B Hl12BI) -*-

;;; This sets values globally for your lispm session. If you don't want the
;;; bases set to 10, remove those items or insert the base you want. The
;;; global var *login-time* is used to determine which files are new.

(login-forms
  (setq-globally base 10.
		 ibase  10.                                ;decimal
		 *login-time* (time:get-universal-time)))

;;; This is the list of items to be eval'd on invocation of LOGOUT. If
;;; you want other things going on at logout time, feel free to add
;;; them to the list before LOGOUT-CHOOSE.

;(setq LOGOUT-LIST '((bye-bye)(disk-restore)))
(setq LOGOUT-LIST '((logout-choose)))


;;; This is the first of two choice menus offered to the user.
;;; LOGOUT-CHOOSE offers to user the option of not automatically backing
;;; up all new files and/or not returning to the FEP.  Backing up and
;;; rebooting are the default options, selected by simply moving the mouse
;;; away from the menu. Abort gets you neither, you're just logged out - RCS - 9 Dec 83.
;;; If you want other actions going on here, add them to items and write
;;; the supporting code.

(defun LOGOUT-CHOOSE ()
  (let* ((items '(("Backup all new files on other Lambda" :value '(Lam-Backup))
		  ("Disk Restore" :value '(disk-restore))))
         (your-choices
	   (logout-menu-choose "             Logout Options             " items items)))
    (if your-choices
	(mapcar
	  (function (lambda (x) (eval (cadar (cddr x))))) your-choices)))
  (format terminal-io "~2%Logout completed successfully"))


;;; LOGOUT-MENU-CHOOSE is a direct ripoff of Multiple-Menu-Choose from
;;; the explib file of NLMenu. This creates the menu used by LOGOUT-CHOOSE.
;;; There shouldn't be any reason to mess with this code unless you don't
;;; like the menu.

(defun LOGOUT-MENU-CHOOSE (label item-list
			     &optional (initially-highlighted-items nil)
			     &aux *menu* choices)
  (setq *menu*
	(tv:make-window 'tv:multiple-menu
	  ':special-choices '(("Abort" :value nil)
			      ("Do It" :eval
			       (send *menu* ':highlighted-items))
			      ("" :no-select nil))
	  ':item-list item-list
	  ':highlighted-items (reverse initially-highlighted-items)
	  ':label label))
  (funcall *menu* ':expose-near '(:mouse))
  (setq choices (reverse (funcall *menu* ':choose)))
  (funcall *menu* ':set-highlighted-items nil)
  (funcall *menu* ':deactivate)
  choices)

(DEFUN Lam-Backup ()
  (fs:balance-directories "lam2:nichols;*.lisp" "lam5:nichols;*.lisp"
                                 ':direction ':1->2 ':query-mode nil)
  (fs:balance-directories "lam2:nichols.hack;*.lisp" "lam5:nichols.hack;*.lisp"
                                 ':direction ':1->2 ':query-mode nil))

(DEFUN bye-bye ()
  2"This executes my logout stuff."*
  (FUNCALL terminal-io ':clear-screen)
  (COND ((tv:mouse-confirm "Do you want to back up your files?")
         (Lam-Backup))))

(DEFUN bye (&optional (backup? nil))
  "2This will logout and disk-restore. With an argument of t, it will do a backup first.*"
  (SEND terminal-io ':clear-screen)
  (COND (backup? (lam-backup)))
  (LOGOUT)
  (DISK-RESTORE))

;(DEFUN marine-disk-backup ()
  
;  "2DISK BACKUP ( LISP FILES ONLY )*"
  
;  (zwei:copy-file "lam4:marine;*.lisp"
;                  "lam3:marine;*.lisp"
;                  ':error nil
;                  ':report-stream terminal-io)

;  (zwei:copy-file "lam4:marine.patch;*.lisp"
;                  "lam3:marine.patch;*.lisp"
;                  ':error nil
;                  ':report-stream terminal-io)
  
;  (zwei:copy-file "lam4:marine.siw;*.lisp"
;                  "lam3:marine.siw;*.lisp"
;                  ':error nil
;                  ':report-stream terminal-io)
  
;  (zwei:copy-file "lam4:marine.utilities;*.lisp"
;                  "lam3:marine.utilities;*.lisp"
;                  ':error nil
;                  ':report-stream terminal-io)
  
;  (zwei:copy-file "lam4:marine.wisp;*.lisp"
;                  "lam3:marine.wisp;*.lisp"
;                  ':error nil
;                  ':report-stream terminal-io)

;  (FORMAT t "~% MARINE DISK BACKUP COMPLETED"))