;;; -*- mode:lisp; base:10.; package:aux   -*-
;
;===============================================================================
;
;   This data and information is proprietary to, and a valuable trade secret of
;   Texas Instruments, Incorporated, a Delaware corporation.  It is given in
;   confidence by Texas Instruments, and may not be used as the basis of
;   manufacture, or be reproduced or copied, or be distributed to any other
;   party, in whole or in part, without the prior written consent of Texas
;   Instruments.
;
;===============================================================================
;
;   (c) Unpublished Copyright 1984 by Texas Instruments.  All rights reserved.
;
;===============================================================================
;



;;;This is a file of functions to do the things available in CLISP that do not
;;;exist or have different names in ZETALISP. It can be used as a general library
;;;of lisp functions in addition to support for such systems as GRASPER, CEG and CSG.

;;;---------------------------------------------------------------

;;; REPEAT MACRO
; for compatibility with CLISP

(defmacro repeat (varlist &body body)
   `(prog ,varlist ,@(process-repeat-body body)))


;;;---------------------------------------------------------------


;;; PROCESS-REPEAT-BODY

(eval-when (compile load eval)
(defun process-repeat-body (body)
  (do ((repeat-body body (cdr repeat-body))
       (new-body nil)
       (begin-flag nil))
      ((null repeat-body)
       (push '(go begin) new-body)
       (if begin-flag
	   (nreverse new-body)
	   (cons 'begin (nreverse new-body))))
    (selectq (car repeat-body)
      (begin (if begin-flag (ferror T "Too many begins in REPEAT"))
	     (push 'begin new-body)
	     (setq begin-flag t))
      (while (push `(let ((test ,(cadr repeat-body)))
		      (if (not test) (return test)))
		   new-body)
	     (setq repeat-body (cdr repeat-body)))
      
      (until (push `(let ((test ,(cadr repeat-body)))
		      (if test (return test)))
		   new-body)
	     (setq repeat-body (cdr repeat-body)))
      (t (push (car repeat-body) new-body)))))
)

;;;-------------------------------------------------------------


;;;  ALPHA-COMPARE
;;Compatibility

(defun alpha-compare (x1 x2)
  (cond
   ((and (null x1) (null x2)) 0)
   ((null x1) -1)
   ((null x2) 1)
   ((string-lessp (make-string x1) (make-string x2)) -1);maclisp
   ((string-lessp (make-string x2) (make-string x1)) 1);maclisp
   (t 0)
   )
  )

;;;------------------------------------------------------------

;;; MAKE-STRING


(Defun make-string (x)
	(format nil "~A" x))

;;;------------------------------------------------------------

;;; USER-TEXT
;Compatibility

(defmacro user-text (&body body)
  `(format standard-output ,(user-text-mac-cntrl-str body)
	   ,@(user-text-mac-args body)))

;;;-------------------------------------------------------------

;;; USER-TEXT-MAC-CNTRL-STR

(eval-when (compile load eval)
  (defun user-text-mac-cntrl-str (body)
    (cond ((null body) "") ;null string
	  ((and (stringp (car body))  ;% = new line
		(string-equal (car body) "%"))
	   (string-append " ~% " (user-text-mac-cntrl-str (cdr body))))
	  ((and (stringp (car body))
		(string-equal (car body) "@"))
	   (string-append "~A" (user-text-mac-cntrl-str (cdr body))))
	  ((stringp (car body))(string-append " " (car body)
					      (user-text-mac-cntrl-str
					       (cdr body))))
	  (t (string-append " ~A" (user-text-mac-cntrl-str (cdr
							    body)))))))

;;;----------------------------------------------------------------

;;; USER-TEXT-MAC-ARGS

(eval-when (compile load eval)
  (defun user-text-mac-args (body)
    (cond ((null body) nil)
	  ((stringp (car body))
	   (user-text-mac-args (cdr body)))
	  (t (cons (car body)(user-text-mac-args (cdr body)))))))

;;;----------------------------------------------------------------

;;; USER-ERROR
;Compatibility - Use ferror
(defmacro user-error (errtype msg &body args)
  `(ferror ,errtype ,(string-append msg " " (user-text-mac-cntrl-str
					     args))
				    ,@(user-text-mac-args args)))

;;;-----------------------------------------------------------------

;;; USER-WARNING
;Compatibility - Use format
(defmacro user-warning (errtype msg &body args)
  `(format standard-output ,(string-append (eval errtype) "WARNING: ~% " msg
			       (user-text-mac-cntrl-str args))
	   ,@(user-text-mac-args args)))

;;;-----------------------------------------------------------------

;;; INSERT-ENTRIES
;Compatibility - Use subdirectories
(defun insert-entries (file itemlist)
  (cond ((null itemlist) nil)
	(t (sys:dump-forms-to-file (format nil  "~A-CLISP.~A" file (car itemlist))
				       (car itemlist))
	   (insert-entries file (cdr itemlist)))))

;;;------------------------------------------------------------------

;;; REPLACE-ENTRIES
;Compatibility - Use subdirectories
(defmacro replace-entries (file itemlist)
  `(insert-entries ,file ,itemlist))

;;;-------------------------------------------------------------------

;;; LOAD-ENTRIES
;compatibility - use subdirectories
(defun load-entries (file &optional (itemlist nil))
  (cond ((null itemlist)
	 (mapcar #'load (mapcar #'car
				(cdr (fs:directory-list (format nil "~A-CLISP.*" file))))))
	(t (load-entries1 file itemlist))))

(defun load-entries1 (file itemlist)
  (cond ((null itemlist)nil)
	(t (load (format nil  "~A-CLISP.~A" file (car itemlist)))
	   (load-entries file (cdr itemlist)))))

;;;---------------------------------------------------------------

;;; DELETE-ENTRIES
;Compatibility - Use subdirectories
(defun delete-entries (file itemlist)
  (cond ((null itemlist) nil)
	(t (deletef (format nil  "~A-CLISP.~A" file (car itemlist)))
	   (delete-entries file (cdr itemlist)))))

;;;----------------------------------------------------------------


;;; ADD-ELEMENT
;;Compatibility
(defun add-element (element set)
  "Add ELEMENT to the beginning of SET"
  (cons element (remove element set)))


;;;-----------------------------------------------------------------

;;; ORDERED-INTERSECTION

(defun ordered-intersection (lst1 lst2)(intersection lst1 lst2))

;;;----------------------------------------------------------------------

;;; ATTRIBUTE/?

(defun attribute/? (item alst)(assq item alst))

;;;----------------------------------------------------------------------


;;; SELECT-ATTRIBUTE

(defun select-attribute (alst x)
  (cdr (assq x alst)))

;;;-----------------------------------------------------------------------

;;; CONSTRUCT-ATTIRBUTE-LIST

(defun construct-attribute-list (alst x1 x2)
  (append alst (pairlis (list x1) (list x2))))

;;;-----------------------------------------------------------------------

;;; UPDATE-ATTRIBUTE-LIST

(defun update-attribute-list (alst x &functional fun)
  (let ((glub (assq x alst)))
    (cond (glub (rplacd (assq x alst) (funcall fun (cdr glub))) alst)
	  (t (append alst (pairlis (list x)(funcall fun nil)))))))

;;;----------------------------------------------------------------------
 

;;;REMOVE-ATTRIBUTE

(defun remove-attribute (alst x)
  (cond ((null alst) nil)
	((eq (caar alst) x) (cdr alst))
	(t (cons (car alst) (remove-attribute (cdr alst) x)))))

;;;--------------------------------------------------------------------

;;;PRINB
;;Compatibility
(defun prinb (&optional (num 0) (stream standard-output))
  "Print optional NUM number of blanks to STREAM (default Standard-Output)"
  (if (= num 0)nil
    (format stream "~VX" num)))



;;;--------------------------------------------------------------------------


;;; GRAPHICS MACROS & ROUTINES for Compatibility with Grinnell routines

;;;------------------------------------------------------

;;;GRVECTCLIP

(defmacro grvectclip (x y dx dy red green blue)
  `(send *world* ':insert-line ,x ,y ,(+ x dx) ,(+ y dy) 1 ,(// (+ ,red ,green ,blue) 8)))

;;;------------------------------------------------------

;;GRRECTOV

(defmacro grrectov (x y width height red green blue)
  `(send *graphics-window* ':draw-rectangle ,x ,y ,width ,height 1 ,(// (+ ,red ,green ,blue) 8)))

;;;------------------------------------------------------

;;;GRTEXTOV

(defmacro grtextov (x y string foo bar baz bux red green blue font)
  `(send *graphics-window* ':draw-string font ,string ,x ,y
	 ,(// (+ ,red ,green ,blue) 8)))

;;;------------------------------------------------------

;;;GRCIRCLEOV

(defmacro grcircleov (x y radius red green blue)
  `(send *graphics-window* ':draw-circle ,x ,y ,radius 1 ,(// (+ ,red ,green ,blue) 8)))
