;;; -*- Package: USER; Mode: LISP; Base: 10.; Fonts:(CPTFONT HL12B HL12BI) -*-

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;*		1               UTIL-MISC
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;

#|Documentation:

2     This file contains miscellaneous useful functions.*

End documentation|# 

;;;Functions contained in this file:
;;;       alpha-compare
;;;       insert-value
;;;       nreversef
;;;       ordered-element/?
;;;       ordered-add-element
;;;       random-initialize
;;;       restore-object
;;;       roll
;;;       rotate
;;;       save-object
;;;       shake
;;;       snoc
;;;       swap*

(DEFMACRO snoc (x xlist)
 2 "Appends x onto the right end of xlist after popping off the leftmost element."*
  `(SETQ ,xlist (NCONC (CDR ,xlist) (LIST ,x))))

(DEFUN SNOC (X1 X2)
  "2Cons X1 onto the back of X2.*"
  (APPEND X2 (LIST X1))) 

(DEFUN ROLL (DIE)
  "2Roll a DIE sided die. Returns a number between 0 and DIE minus one.*"
   (IF (> die 0.)(RANDOM (FIX DIE)) 0.))

(DEFUN shake (num die)
  "2Roll NUM number of DIE sided dice.*"
  (COND ((ZEROP num)(roll die))
	((< num 0) 0)
	(t (+ (roll die) (shake (1- num) die)))))

(DEFUN random-initialize ()
  "2Set the random number generator to a random value.*"
  (shake (\ (TIME:get-universal-time) 1000) 10))

(DEFUN rotate (lst n)
 2 "Rotate lst by n to the left.  0 means no change. negative is to the right."*
  (take (LENGTH lst) (NTHCDR (LET ((ROTe (\ (FIX n) (LENGTH lst))))
			       (IF (MINUSP n) (+ rote (LENGTH lst)) rote)) 
			     `(,@lst ,@lst))))

(defun alpha-compare (x1 x2)
  (cond
   ((and (null x1) (null x2)) 0)
   ((null x1) -1)
   ((null x2) 1)
   ((string-lessp (make-string x1) (make-string x2)) -1);maclisp
   ((string-lessp (make-string x2) (make-string x1)) 1);maclisp
   (t 0)
   )
  )

(defun ordered-add-element (x olist)
  "2Add X to the ordered Set OLIST.*"
  (cond ((ordered-element/? x olist) olist)
	(t (sort (cons x olist) #'string-lessp))))


(defun ordered-element/? (x oset)
  "2Add X to the Ordered Set OSET in its correct position.*"
  (cond ((null oset) nil)
	((equal x (car oset)) oset)
	((string-lessp x (car oset)) nil)
	(t (ordered-element/? x (cdr oset)))))

(defmacro swap (x y) `(setq ,y (prog1 ,x (setq ,x ,y))))

(declare (special :object :array))

(defun save-object (:object file)
  (compiler:fasd-symbol-value file ':object)
  :object)

(defun restore-object (file)
  (pkg-bind 'user
    (let (:object :array)
      (fasload file)
      (or :object :array))))

(declare (unspecial :object :array))

(defmacro nreversef (list)
  `(setf ,list (nreverse ,list)))

(DEFUN insert-value (data loc val)
  "2This function is intended to splice val into data at loc where 1 is the car of data, the
    updated data is returned*"
  (APPEND
    (FIRSTN (1- loc) data)
    (LIST val)
    (WHEN (> (- (LENGTH data) loc) (MINUS 1))
      (NLEFT (- (1+ (LENGTH data)) loc) data))))

