;;; -*- Mode:Common-Lisp; Package:USER; Base:10; Fonts:(CPTFONT HL12B HL12BI) -*-

1;;;
;;; This is a collection of generally useful utility functions which can be shared by lots of
;;; different systems.
;;;
;;;Functions in this file:
;;;      accept
;;;      acceptf
;;;      bye
;;;      c
;;;      c
;;;      c
;;;      cat
;;;      compare
;;;      compare-internal
;;;      default-query-handler
;;;      defaulting-queries  - macro
;;;      dir
;;;      document-all-functions
;;;      document-all-variables
;;;      e
;;;      edit-output
;;;      eval-while-possible
;;;      first-atom
;;;      flavor-method-function-specs
;;;      get-string-length
;;;      grep
;;;      ll
;;;      loadf
;;;      logout-choose
;;;      logout-menu-choose
;;;      ls
;;;      pause
;;;      print-array
;;;      push-end - defsubst
;;;      pv
;;;      save-symbol
;;;      string-trim-all
;;;      td
;;;      universal-string
;;;      unroll
;;;      with-font - macro
;;;      with-real-time - macro
;;;      without-more-processing - macro
;;;      write-string-in-font
;;;      write-centered-text
;;;      type
;;;      *

(DEFUN bye ()
  "2This will logout, giving the choice of backing up new files and disk-restoring.*"
  (SEND *terminal-io* :clear-screen)
  (LOGOUT-CHOOSE))

(DEFUN CAT (&OPTIONAL (FILENAME *TYPE-FILENAME*))
  "2View contents of a file. Doesn't allow forward and bacward scrolling.*"
  (DECLARE)
  (BLOCK ()
    (RETURN
     (COND
       ((PROBE-FILE
	 (SETQ *TYPE-FILENAME*
	       (FS:MERGE-AND-SET-PATHNAME-DEFAULTS FILENAME *DEFAULT-PATHNAME-DEFAULTS* "lisp")))
	(WITH-OPEN-FILE (IN-STREAM *TYPE-FILENAME* :CHARACTERS T :DIRECTION :INPUT)
	  (TERPRI *STANDARD-OUTPUT*)
	  (STREAM-COPY-UNTIL-EOF IN-STREAM *STANDARD-OUTPUT*)
	  (SEND IN-STREAM :TRUENAME)))
       (T (FORMAT () "File ~A not found" *TYPE-FILENAME*))))
    ()))  

;(DEFUN default-query-handler (condition defaults)
;  "2FQUERY Condition handler returns the first default that's a legal choice.*"
;  (WHEN (NLISTP defaults) (SETQ defaults (LIST defaults)))
;  (LOOP named top
;        with options = (SEND condition 'options)
;        with choices = (OR (GET (CONS nil options) 'choices)
;                           FORMAT:y-or-n-p-choices)
;        for default in defaults
;        DO (LOOP for choice in choices
;                 for item = (first-atom choice)
;                 DO (WHEN (EQ item default)
;                      (RETURN-FROM top :new-value default)))))

;(DEFMACRO defaulting-queries (defaults &body body)
;  "2Provides defaults to Fquery within BODY.*
;2When a Fquery is executed within BODY, force Fquery to return*
;2the first item in DEFAULTS that is a legal choice. If none of the*
;2DEFAULTS is a legal Fquery choice, Fquery will ask the user.*"
;  (UNLESS defaults (SETQ defaults ''(proceed t)))
;  (UNLESS body (ERROR "Default list missing from DEFAULTING-QUERIES form"))
;  `(CONDITION-BIND ((FQUERY 'default-query-handler ,defaults))
;     . ,body))

fs:
(COMMENT DEFUN :disk-usage (&aux date size author)
  (FORMAT t "~%~16a ~5a  ~a  ~a ~a"
	  "Directory" "Files" "Last Creation Date" "Total Size" "Author")
  (DOLIST (f (READ-DIRECTORY-FILES (LOOKUP-DIRECTORY nil)))
    (SETQ date 0 size 0)
    (SETQ author (file-author (CAR (file-files f))))
    (DOLIST (file (file-files f))
      (SETQ date (MAX date (file-creation-date file)))
      (INCF size (map-npages (file-map file))))
    (FORMAT t "~%~16a ~5d  ~\time\  ~6d     ~a"
	    (file-name f) (LENGTH (file-files f)) date size
	    (IF (STRING-EQUAL (file-name f) author) "" author))))

(defun edit-output (&quote form)
  (zwei:with-editor-stream (*standard-output* :buffer-name "standard-output"
					    :create-p t
					    :end)
			   (eval form)))

(defun eval-while-possible (expression &optional (instance nil) &aux values)
 2 "Evals expression then evals the result of the previous evaluation, and so on
   until error, or until evaluation returns a value eq to a previous value,
    then returns the version of expression
   just before the error.
   If INSTANCE is non-nil, then each evaluation
   is performed in the context of the instance. "
  *(setq values (list expression))
  (loop	do
	(multiple-value-bind (the-value error?)
	    (ignore-errors
	      (cond (instance
		     (send instance :eval-inside-yourself (car values)))
		    (t (eval (car values)))))
	  (cond ((or error? (member the-value values))
		 (return (car values)))
		(t (push the-value values))))))

;(DEFUN first-atom (LIST)
;  "2Return the first Atom in LIST*"
;  (IF (ATOM LIST) LIST (first-atom (CAR LIST))))

;;; This is the first of two choice menus offered to the user.
;;; LOGOUT-CHOOSE offers to user the option of not automatically backing
;;; up all new files and/or not returning to the FEP.  Backing up and
;;; rebooting are the default options, selected by simply moving the mouse
;;; away from the menu. Abort gets you neither, you're just logged out - RCS - 9 Dec 83.
;;; If you want other actions going on here, add them to items and write
;;; the supporting code.

(defun LOGOUT-CHOOSE ()
  (let* ((items '(("Backup new files to Lambda-5" :value '(Backup-to-Lam5))
		  ("Disk Restore" :value '(disk-restore))))
         (your-choices
	   (logout-menu-choose "             Logout Options             " items items)))
    (if your-choices
	(mapcar
	  (function (lambda (x) (eval (cadar (cddr x))))) your-choices)))
  (format *terminal-io* "~2%Logout completed successfully"))


;;; LOGOUT-MENU-CHOOSE is a direct ripoff of Multiple-Menu-Choose from
;;; the explib file of NLMenu. This creates the menu used by LOGOUT-CHOOSE.
;;; There shouldn't be any reason to mess with this code unless you don't
;;; like the menu.

(defun LOGOUT-MENU-CHOOSE (label item-list
			     &optional (initially-highlighted-items nil)
			     &aux *menu* choices)
  (setq *menu*
	(tv:make-window 'tv:multiple-menu
	  :special-choices '(("Abort" :value nil)
			      ("Do It!" :eval
			       (send tv:selected-window :highlighted-items))
			      )
	  :item-list item-list
	  :highlighted-items (reverse initially-highlighted-items)
	  :label label))
  (send *menu* :expose-near '(:mouse))
  (setq choices (reverse (send *menu* :choose)))
  (send *menu* :set-highlighted-items nil)
  (send *menu* :deactivate)
  choices)

(DEFUN ll (&rest directories)
  "2Long directory listing.*"
  (COND (directories
         (fs:lmfs-list-files directories))
        (t
         (fs:lmfs-list-files "nichols"))))

(defmacro string-if-error ((error-header) &body body)
  "If an error occurs while evaluating body, return the error-header string
 appended to the error handler message.  If no error occurs, return the result from body"
  `(CONDITION-CASE (ERROR)
       (progn . ,body)
     (FERROR "~@[~a~%~]~a" ,error-header (SEND ERROR :report-string))))

(DEFMACRO td (&body body)
  "Eval body & print return the execution time in seconds"
  `(LET (start end value)
     (WITHOUT-INTERRUPTS
       (SETQ start (TIME:microsecond-time)) 
       (SETQ value (MULTIPLE-VALUE-LIST ,@body))
       (SETQ end ( TIME:microsecond-time)))
    (FORMAT t "~%~6$ Seconds" (/ (- end start) 1000000.0))
    (VALUES-LIST value)))

(COMMENT DEFUN td (&quote body)
  "Eval body & print return the execution time in seconds"
  (LET ((start (TIME:microsecond-time))
	end value)
    (SETQ value (MULTIPLE-VALUE-LIST (EVAL body)))
    (SETQ end ( TIME:microsecond-time))
    (FORMAT t "~%~6$ Seconds" (/ (- end start) 1000000.0))
    (VALUES-LIST value)))

(DEFUN topdir (&optional (host (SEND fs:local-host-pathname :host)))
  (let ((directories (IF (STRINGP host)
                         (fs:lmfs-all-directories (STRING-RIGHT-TRIM ":" host) nil)
                         (fs:lmfs-all-directories host nil))))
    (loop for (dir) in directories
	  do (format t "~&  ~35A~%" (send dir :directory)))))

(DEFVAR *type-filename* "foo.lisp")


(DEFUN VAXPS ()
  (UNLESS (ASSOC '("DNICHOLS" "VAX4") FS:USER-HOST-PASSWORD-ALIST :TEST #'EQUALP)
    (PUSH '(("DNICHOLS" "VAX4") "password") FS:USER-HOST-PASSWORD-ALIST))) 

;(defmacro with-real-time body
;  `(let ((old-sb-state (si:sb-on)))
;     (unwind-protect
;       (progn
;	 (si:sb-on '(:keyboard))
;	 . ,body)
;       (si:sb-on old-sb-state))))

;1;Now in Public;loadf*
; DEFMACRO WITHOUT-MORE-PROCESSING (STREAM &BODY BODY)
;  "Execute body with more-processing turned off on stream"
;  `(LET ((MORE (SEND ,STREAM :MORE-P)))
;    (SEND ,STREAM :SET-MORE-P NIL)
;    (UNWIND-PROTECT
;      (PROGN . ,BODY)
;      (SEND ,STREAM :SET-MORE-P MORE)))

(COMMENT DEFUN write-options (&optional (ALIST tv:*all-user-option-alists*) (STREAM *standard-output*)
		      &AUX (ALPHABETIC-CASE-AFFECTS-STRING-COMPARISON T)
		      (SI:PRINT-READABLY T))
  "Write forms on STREAM to set all non-default variables on ALIST to their current values.
That is, for each variable on ALIST whose current value is not its default,
a LOGIN-SETQ form is output to STREAM which records the variable's current value.
ALIST may be one list, or a list of alists."
  (WHEN (NLISTP (CAAR alist)) (SETQ alist (LIST alist)))
  (DOLIST (alist alist)
    (WHEN (SYMBOLP alist)
      (FORMAT stream "~2%~
~%;********************************************************************************~
~%;~%;  ~a~%;~
~%;********************************************************************************"
	      (DOCUMENTATION alist))
      (SETQ alist (SYMEVAL alist)))
    (DO ((ALIST ALIST (CDR ALIST))
	 (OPTION) (VALUE) (form))
	((NULL ALIST))
    (SETQ OPTION (CAAR ALIST)
	  value (GET OPTION 'tv:DEFAULT-VALUE)
	  form (CDDAR alist))
    (FORMAT stream "~2%#| ~a ~%~VQ|#~%" (GET option :documentation) form #'grind-top-level)
    (GRIND-TOP-LEVEL `(LOGIN-SETQ ,OPTION ,(IF (OR (NUMBERP VALUE) (MEMQ VALUE '(T NIL)))
						   VALUE `',VALUE))
			 95. STREAM))))
;(ADVISE fs:GET-USER-ID-AND-PASSWORD :around my-pw nil
;  (IF (STRING-EQUAL user-id "OREN")
;      (VALUES user-id "jiatwtm")
;    :do-it))


1;;;Add PUSH-END if not already loaded.*
;(UNLESS (FBOUNDP 'PUSH-END)
;  (DEFSUBST PUSH-END (item item-list)
;    2"This is similar to PUSH except that it puts the new element at the end of the*
;2existing list. This preserves the order of the elements as they are added to the*
;2list."*
;    (SETQ item-list (NCONC item-list (LIST item))))
;  (GLOBALIZE 'PUSH-END))

