;;; -*- Mode: LISP; Package: ZWEI; Base: 10.; Fonts: MEDFNT,HL12B,HL12BI -*-

;1;*
;1;   CAPITALIZE-KEYWORDS-MODE*
;1;*
;1;   This minor mode provides automatic capitalization of Lisp 'keywords'.  A Lisp keyword*
;1;   is defined here as a function or special form interned in package GLOBAL (i.e. any FOO*
;1;   such that (FUNCTIONP 'FOO T) returns non-NIL.  When any word abbreviation mode*
;1;   delimiter except '-' is typed, the editor will check the preceding atom to see if it*
;1;   needs capitalization.*
;1;*


;1;*
;1;     minor mode COM-CAPITALIZE-KEYWORDS-MODE*
;1;*

(defminor com-capitalize-keywords-mode capitalize-keywords-mode "Fcap" 3.
	  "Mode for capitalizing global functions, macros, etc." ()
  (command-hook 'capitalize-keywords-hook *command-hook*))


;1;*
;1;     command hook priority*
;1;*

(DEFPROP capitalize-keywords-hook 10. command-hook-priority)


;1;*
;1;     CAPITALIZE-KEYWORDS-HOOK*
;1;*

(DEFUN capitalize-keywords-hook (char)
  "2Capitalizes the atom preceding point if it is a global keyword.*"
  (IF (NOT (EQ *interval* (window-interval *mini-buffer-window*)))
      (capitalize-keyword-at-bp (point) char)))


(DEFUN capitalize-keyword-at-bp (bp &optional (char (bp-char bp)) (lowercase nil))
  "2Capitalizes atom before BP if it is a keyword.
Conditions:*	2(a) last command char must have been a WAM delimiter (except '-');*
		2(b) BP must not be inside a comment, string, or slash context.*"
    (AND (NOT (EQ (ldb %%ch-char char) #/-))
	 (expand-p char)
	 (NOT (MULTIPLE-VALUE-BIND (string slash comment)
		  (lisp-bp-syntactic-context bp (forward-defun bp -1 t))
		(or string slash COMMENT)))
	 (capitalize-keyword bp lowercase)))


;1;*
;1;     CAPITALIZE-KEYWORD*
;1;*

(DEFUN capitalize-keyword (bp &optional (lowercase nil))
  "2If the atom under BP is a global function or special form, capitalize it.*"
  (LET (bp1 str)
    (SETQ bp1  (forward-atom bp -1 t)
	  str  (STRING-UPCASE (string-interval bp1 bp)))
    (COND ((FUNCTIONP (INTERN-SOFT str 'global) t)
	   (UPCASE-INTERVAL BP1 BP T)
	   (must-redisplay *window* dis-line (bp-line bp1) (bp-index bp1)))
	  (lowercase
	   (DOWNCASE-INTERVAL BP1 BP T)
	   (must-redisplay *window* dis-line (bp-line bp1) (bp-index bp1))))))


;1;*
;1;     editor command COM-CAPITALIZE-KEYWORD*
;1;*

(defcom com-capitalize-previous-keyword "Capitalize atom under point if keyword" ()
  (capitalize-keyword (point))
  dis-none)


(defcom com-capitalize-keywords-region "Capitalize keywords from point to the mark.
If there is no region, the current DEFUN is used.
Make non-keywords lowercase, unless run with a numeric parameter." ()
  (LET (bp1 bp2)
    (IF (window-mark-p *window*)	  ;1 if there is a region*
	(SETQ bp1 (point) bp2 (mark))	  ;1 grab point and mark*
      (SETQ bp1 (forward-defun (point) -1 t) ;1 else use begin and end *
	    bp2 (forward-defun (point) 1 t)));1 of current DEFUN*
    (order-bps bp1 bp2)			  ;1 put BPs in order*
    (DO ((bp-temp (forward-char bp1 -1 t)))	  ;1 move forward one char so we don't*
						  ;1 catch the atom just before BP1*
	((OR (bp-< bp2 bp-temp)
	     (bp-= bp2 bp-temp)))	  ;1 stop at BP2*
            (SETQ bp-temp (forward-atom bp-temp 1 t))	  ;1 move forward one atom*
      (capitalize-keyword-at-bp bp-temp (bp-char bp-temp)
				(NOT *numeric-arg-p*))));1 and try captializing it*
  dis-text)


(set-comtab *standard-comtab*
	    '(#\super-c com-capitalize-previous-keyword
	      #\super-k com-capitalize-keywords-region)
	    (make-command-alist '(com-capitalize-keywords-mode)))