;;; -*- Mode: LISP; Package: ZWEI; Base: 10; Fonts: CPTFONT,HL10B,HL12B,CPTFONTB -*- 
;;;2                                                 code    short  full-line function* 
;;;2                                                      \\ comments //   names* 

;;2 Modify ELECTRIC FONT LOCK mode to distinguish 4 font contexts:* 
;; 
;;2  (0) code   This is set up so that it works when 1, 2, 3, or 4 fonts are set for the buffer.* 
;;2 R.Cohen, UTexas, June 1984* 
;;2 Modified from SYS:ZWEI*;2MODES.LISP.129 of 1/17/84, Release 5.0* 

;;2 Main function called by ZMACS when in ELECTRIC FONT LOCK mode.* 

(DEFVAR 3*FONT-FOR-CODE* *          0 "Electric font lock font number for code.")
(DEFVAR 3*FONT-FOR-COMMENTS* *      1 "Electric font lock font number for comments at end of a line of code.")
(DEFVAR 3*FONT-FOR-MAJOR-COMMENTS* *2 "Electric font lock font number for full line comments.")
(DEFVAR 3*FONT-FOR-FNAMES* *        3 "Electric font lock font number for function names.")

(DEFMACRO 3DFORMAT *(A . B)
  NIL)

(DEFUN 3FONT-LOCK-HOOK *(CHAR)
  (WHEN (NEQ *INTERVAL* (WINDOW-INTERVAL *MINI-BUFFER-WINDOW*))
    (LET* ((NEW-FONT 0)
           (POINT (POINT))      
           (LINE (BP-LINE POINT))                                ;1current line* 
        (INDEX (BP-INDEX POINT)))                                ;1current position in the line* 
      (SETQ NEW-FONT
            (CHOOSE-FONT-FROM-CONTEXT NIL LINE INDEX *FONT* CHAR))    ;1figure out what font to use* 
      (UNLESS (= *FONT* NEW-FONT)
        (SETQ *FONT* NEW-FONT)                                  ;1update current font if necessary,* 
     (UPDATE-FONT-NAME)))))                  ;1and the "default font" shown on the EMACS mode line.* 

(DEFUN 3CHOOSE-FONT-FROM-CONTEXT *(BP LINE INDEX DEFAULT-FONT
                                    &OPTIONAL (CHAR (AREF LINE INDEX))) ;1must supply char if its not in the line yet!* 
  "Use context info to decide what font we should use."
  (LET ((NEW-FONT DEFAULT-FONT))
    (multiple-value-bind (NIL NIL COMMENT)
        (IF BP                                                    ;1use his BP if he gave us one.* 
         (LISP-BP-SYNTACTIC-CONTEXT BP)
            (SHIFT-LOCK-HOOK-CACHED-SYNTACTIC-CONTEXT))
      (COND (COMMENT                                ;1figure out what font to use inside a comment* 
          (FONT-SHIFT-WITHIN-COMMENT LINE INDEX CHAR DEFAULT-FONT))
            ((IN-FUNCTION-SPEC LINE INDEX)
             *FONT-FOR-FNAMES*)                                                
        ;1use the big font for function name.* 
         (T DEFAULT-FONT)))))                                        ;1otherwise don't change font.* 


;;2 Figure out what font to use inside a COMMENT.* 
;;2 Comments at the end of a line of code use font 1.* 
;;2 Comments that start in column 0 are in font 3.* 
;;2 The string of semi-colons that start the comment are always in font 0.* 

(DEFUN 3FONT-SHIFT-WITHIN-COMMENT *(LINE INDEX CHAR &OPTIONAL (DEFAULT-FONT *FONT*))
  (LET ((LINE-SIZE (STRING-LENGTH LINE)))
    (cond ((zerop INDEX)                        ;1Is the line empty?* 
        (FORMAT T "~%Using code font")
           *FONT-FOR-CODE*)                     ;1yes...always start a line with default font (0)* 
       ((EQ CHAR #\RETURN)                   ;1Is it a <CR>?* 
        (INSERT-A-BLANK-WITH-FONT LINE INDEX *FONT-FOR-CODE*)  ;1yes...always change back to font 0 at the end of a line.* 
        *FONT-FOR-CODE*)
          ((EQ CHAR #/;)                        ;1Is it a semi-colon?* 
        (LET ((NOT-COMMENT-BEGINNING-SEMI    ;1yes...does it begin the comment?* 
                (STRING-SEARCH-NOT-CHAR #/; LINE 0 (SUB1 INDEX))))
             (IF NOT-COMMENT-BEGINNING-SEMI
                 DEFAULT-FONT                   ;1don't change font if in the middle of a comment* 
              *FONT-FOR-CODE*)))       ;1but force semicolons at beginning of the line into font 0.* 
       ((and (< index line-size)
                (eq (aref line index) #/;))
           DEFAULT-FONT)                   ;1don't change font until AFTER a string of semi-colons.* 
       ((eq (AREF LINE 0) #/;)
           *FONT-FOR-MAJOR-COMMENTS*)      ;1comment begins at left margin, so use font for large comments* 
       (t *FONT-FOR-COMMENTS*))))            ;1normal comment* 

(DEFUN 3IN-FUNCTION-SPEC *(LINE INDEX)
  "Check whether INDEX points to part of the function spec on a (DEF... line."
  (LET ((LINE-SIZE (STRING-LENGTH LINE)))
    (WHEN (AND (PLUSP LINE-SIZE)
               (STRING-EQUAL LINE "(DEF" 0 0 4 4))            ;1does this line start with "(DEF" ?* 
      (LET* ((FIRST-SPACE (STRING-SEARCH-CHAR #\SPACE LINE 0))
             (START-OF-FSPEC (AND FIRST-SPACE
                                  (OR (STRING-SEARCH-NOT-CHAR #\SPACE LINE (1+ FIRST-SPACE))
                                      (1- line-size))))
             (FSPEC-IN-PARENS (AND START-OF-FSPEC
                                   (EQ (ldb %%CH-CHAR (AREF LINE START-OF-FSPEC)) #/()))
             (ENDING-CHAR (IF FSPEC-IN-PARENS #/) #\SPACE))
             (ENDING-POS (AND START-OF-FSPEC
                              (STRING-SEARCH-CHAR ENDING-CHAR LINE (1+ START-OF-FSPEC)))))
;;2      (format terminal-io "~%FIRST-SPACE=~D,START-OF-FSPEC=~D,LINE[FSPEC]=~C (IN-PARENS=~A), ENDING-POS=~D"* 
;;2              first-space start-of-fspec (aref line (or start-of-fspec 0)) fspec-in-parens ending-pos)* 
        (IF (AND (NUMBERP FIRST-SPACE)          ;1we must have found a space after the "(DEF"* 
              (< FIRST-SPACE INDEX)          ;1and be passed the first space on the line* 
              (OR (NOT (NUMBERP ENDING-POS)) ;1and no be passed the end of the function spec (which may not exist on this line yet.)* 
                  ( INDEX ENDING-POS)))
            (IF FSPEC-IN-PARENS 'FNAME-IN-PARENS 'SIMPLE-FNAME)
            NIL)))))


(DEFCOM 3COM-ADJUST-CODE-FONTS-IN-BUFFER *"Add Electric Font Lock after the fact." ()
  (ADJUST-CODE-FONTS-IN-BUFFER)
  DIS-ALL)

(DEFUN 3ADJUST-CODE-FONTS-IN-BUFFER *()
  (LET ((CURRENT-FONT 0)
        (CHOSEN-FONT 0)
        (PREVIOUS-FONT 0)
        (BP (MAKE-BP))
        CHAR)
    (CHARMAP-PER-LINE ((INTERVAL-FIRST-BP *INTERVAL*)   ;1where to start* 
                    (INTERVAL-LAST-BP *INTERVAL*)    ;1where to stop* 
                    DIS-TEXT)                        ;1what to return when done* 
                   ((DFORMAT T "~%LINE: ~S" LINE)    ;1debug* 
                       (UNLESS (EQ (ARRAY-TYPE LINE) 'ART-FAT-STRING)   ;1make sure line is a fat-string* 
                      (SETQ LINE (SET-LINE-ARRAY-TYPE LINE 'ART-FAT-STRING))
)
                       (ALTER-BP BP
                                 BP-LINE LINE        ;1use BP into the line later* 
                              BP-INDEX 0))
      (SETQ CHAR (CHARMAP-CHAR))                     ;1cache this for ease* 
      (SETF (BP-INDEX BP) INDEX)                     ;1update our internal BP* 
      (SETQ CURRENT-FONT (LDB %%CH-FONT CHAR))       ;1save current font* 
      (SETQ CHOSEN-FONT                              ;1now check the font for each character in the line.* 
         (CHOOSE-FONT-FROM-CONTEXT BP LINE INDEX CURRENT-FONT CHAR)) ;1must supply char, because #\RETURN is not explicitly there.* 
      (UNLESS (= PREVIOUS-FONT CHOSEN-FONT)
        (DFORMAT T "~%Changing from font ~D to ~D at index ~D... ||~S||"
                PREVIOUS-FONT CHOSEN-FONT INDEX (SUBSTRING LINE 0 INDEX)))     
 ;1debug* 
      (UNLESS (= CURRENT-FONT CHOSEN-FONT)
        (DFORMAT T ".~D//~D" CHOSEN-FONT CURRENT-FONT)
        (SETQ CURRENT-FONT CHOSEN-FONT)
        (MUNG-LINE LINE)                                                       
 ;1mark line as having been munged* 
     (SETF (LDB %%CH-FONT (AREF LINE INDEX)) CHOSEN-FONT))   ;1change the font of this character* 
      (SETQ PREVIOUS-FONT CHOSEN-FONT)
      (WHEN (AND (= (LDB %%CH-CHAR CHAR) #\RETURN)           ;1<cr>'s never appear as explicit characters,* 
                 (NOT (= CURRENT-FONT *FONT-FOR-CODE*)))
        (DFORMAT T "~%Returning to font ~D at EOL." CHOSEN-FONT)
        (INSERT-A-BLANK-WITH-FONT LINE INDEX CHOSEN-FONT))   ;1add a blank at the end, if necessary* 
      )))                                                    

;;2 This is to put the shift back to font 0 at the end of a line, rather than at the beginning of the next line.* 
;;2 This makes line printer copy of mulit-font files more readable.* 
(DEFUN 3INSERT-A-BLANK-WITH-FONT *(LINE INDEX FONT)
  (LET ((BLANK (IN-CURRENT-FONT #\SPACE FONT))
        (BP (MAKE-BP BP-LINE LINE BP-INDEX INDEX)))
    (INSERT BP BLANK)))

(DEFSTRUCT 3(BP :LIST (:INCLUDE TEMP-BP)*)
  BP-STATUS					;1:NORMAL or :MOVES* 
  )

(DEFUN 3SHIFT-LOCK-HOOK-CACHED-SYNTACTIC-CONTEXT *()
  (DECLARE (VALUES STRING SLASH COMMENT))
  (LET ((POINT (POINT))
	(*LISP-PARSE-PREPARSED-FLAG* T))
    (UNLESS (AND (EQ *LAST-COMMAND-TYPE* 'SELF-INSERT)
		 (EQ (BP-LINE POINT) *SHIFT-LOCK-HOOK-LAST-LINE*))
      (SETQ *SHIFT-LOCK-HOOK-DEFUN-BEGINNING* (FORWARD-DEFUN POINT -1 T)
	    *SHIFT-LOCK-HOOK-LAST-LINE* (BP-LINE POINT)
	    *LISP-PARSE-PREPARSED-FLAG* NIL))
    (LISP-BP-SYNTACTIC-CONTEXT POINT *SHIFT-LOCK-HOOK-DEFUN-BEGINNING*)))

(DEFUN 3SHIFT-LOCK-HOOK *(CHAR)
  (WHEN (AND (OR (AND ( CHAR #/A) ( CHAR #/Z))
		 (AND ( CHAR #/a) ( CHAR #/z)))
	     (NEQ *INTERVAL* (WINDOW-INTERVAL *MINI-BUFFER-WINDOW*)))
    (MULTIPLE-VALUE-BIND (STRING SLASH COMMENT)
	(SHIFT-LOCK-HOOK-CACHED-SYNTACTIC-CONTEXT)
      (UNLESS (OR STRING SLASH COMMENT)
	(SETQ *LAST-COMMAND-CHAR* (IF *ELECTRIC-SHIFT-LOCK-XORS*
				      (LOGXOR CHAR 40)
				      (BOOLE 4 CHAR 40)))))))

(DEFUN 3FONT-LOCK-HOOK *(IGNORE)
  (WHEN (NEQ *INTERVAL* (WINDOW-INTERVAL *MINI-BUFFER-WINDOW*))
      (LET ((NEW-FONT (MULTIPLE-VALUE-BIND (NIL NIL COMMENT)
			  (SHIFT-LOCK-HOOK-CACHED-SYNTACTIC-CONTEXT)
			(IF COMMENT 1 0))))
	(UNLESS (= *FONT* NEW-FONT)
	  (SETQ *FONT* NEW-FONT)
	  (UPDATE-FONT-NAME)))))

