;;; -*- Mode:Common-Lisp; Package:ZWEI; Base:10 -*-

(define-mail-filter subject "By Subject"
  "Prompt the user for a string to be selected out of the subject line."
  (let ((string (ZWEI:TYPEIN-LINE-READLINE-WITH-DEFAULT
		  (if (boundp '*last-subject*) *last-subject* "")
		    "Subject to filter")))
    (setq *last-subject* string)
    (string-search string  (send msg :name))))

(define-mail-filter Get-message "Get message"
  (error))

(defun from-filter-function (msg string)
  "Function to call to generate messages for from filter created by user."
  (string-search string  (send msg :from)))


(defcom com-summary-create-from-filter
	"Create filter which contains messages from a selected sender."
	()
  (let* ((*package* (find-package 'zwei))
	 (mail-buffer (get *interval* :mail-buffer))
	 (filter-name)
	 (subject-string (ZWEI:TYPEIN-LINE-READLINE
			   "Sender to filter"))) 

      (setf filter-name (string-append "FROM " (string-upcase subject-string)))
      
      (let ((max-string-length (floor (- (/ (send *window* :width)
					    (send *window* :char-width)) 3))))
	(if (> (string-length filter-name) max-string-length)
	    (setf filter-name (nsubstring filter-name 0 (floor
							  (- (/ (send *window* :width)
								(send *window* :char-width)) 3))))))
      
      (send mail-buffer :mung)
      (send mail-buffer :put-mail-prop (remove-duplicates
					 (append
					   (send mail-buffer :get-mail-prop :filter-alist)
					   `((,filter-name from-filter-function ,subject-string)))
					 :test #'equal) :filter-alist)
      (setf *mail-filter-alist* (remove-duplicates
				  (append *mail-filter-alist*
					  `((,filter-name from-filter-function ,subject-string)))
				  :test #'equal))
      ;;Revert summary buffer if necessary -- just a redisplay -- mail file is not re-read.
      (when (eq *mail-summary-mode* :filtered)
	(mail-summary-revert *interval*)
	(must-redisplay *window* dis-text)))
  dis-none)

(defun subject-filter-function (msg string)
  "Function to call to generate messages for subject filter created by user."
  (string-search string  (send msg :name)))

(defcom com-summary-create-subject-filter
	"Create filter which contains messages with a specified string in the subject line."
	()
  (let* ((*package* (find-package 'zwei))
	 (mail-buffer (get *interval* :mail-buffer))
	 (filter-name)
	 (subject-string (ZWEI:TYPEIN-LINE-READLINE
			   "Subject to filter"))) 

      (setf filter-name (string-append "SUBJECT " (string-upcase subject-string)))
      
      (let ((max-string-length (floor (- (/ (send *window* :width)
					    (send *window* :char-width)) 3))))
	(if (> (string-length filter-name) max-string-length)
	    (setf filter-name (nsubstring filter-name 0 (floor
							  (- (/ (send *window* :width)
								(send *window* :char-width)) 3))))))
      
      (send mail-buffer :mung)
      (send mail-buffer :put-mail-prop (remove-duplicates
					 (append
					   (send mail-buffer :get-mail-prop :filter-alist)
					   `((,filter-name subject-filter-function ,subject-string)))
					 :test #'equal) :filter-alist)
      (setf *mail-filter-alist* (remove-duplicates
				  (append *mail-filter-alist*
					  `((,filter-name subject-filter-function ,subject-string)))
				  :test #'equal))
      ;;Revert summary buffer if necessary -- just a redisplay -- mail file is not re-read.
      (when (eq *mail-summary-mode* :filtered)
	(mail-summary-revert *interval*)
	(must-redisplay *window* dis-text)))
  dis-none)

(defun to-filter-function (msg string)
  "Function to call to generate messages for to filter created by user."
  (let* ((reply-list (send msg :reply-list))
	 (cc (nconc (rest (assoc :cc reply-list))
		    (rest (assoc :bcc reply-list))
		    (rest (assoc :resent-cc reply-list))
		    (rest (assoc :resent-bcc reply-list))
		    (rest (assoc :to reply-list))
		    (rest (assoc :resent-to reply-list)))))
    (dolist (address cc nil)
      (when address
	(dolist (sender (mail:address-local-part address))
	  (when (string-search string sender)
	    (return-from to-filter-function t)))))))

(defcom com-summary-create-to-filter
	"Create filter which contains messages with a specified string in the to line."
	()
  (let*  ((mail-buffer (get *interval* :mail-buffer))
	 (filter-name)
	 (string (nstring-upcase (ZWEI:TYPEIN-LINE-READLINE
				   "filter messages to"))))
	 
      (setf filter-name (string-append "TO " (string-upcase string)))
      
      (let ((max-string-length (floor (- (/ (send *window* :width)
					    (send *window* :char-width)) 3))))
	(if (> (string-length filter-name) max-string-length)
	    (setf filter-name (nsubstring filter-name 0 (floor
							  (- (/ (send *window* :width)
								(send *window* :char-width)) 3))))))
      
      (send mail-buffer :mung)
      (send mail-buffer :put-mail-prop (remove-duplicates
					 (append
					   (send mail-buffer :get-mail-prop :filter-alist)
					   `((,filter-name to-filter-function ,string)))
					 :test #'equal) :filter-alist)
      (setf *mail-filter-alist* (remove-duplicates
				  (append *mail-filter-alist*
					  `((,filter-name to-filter-function ,string)))
				  :test #'equal))
      ;;Revert summary buffer if necessary -- just a redisplay -- mail file is not re-read.
      (when (eq *mail-summary-mode* :filtered)
	(mail-summary-revert *interval*)
	(must-redisplay *window* dis-text)))
  dis-none)

(setq *summary-comtab-list* (nconc *summary-comtab-list*
				   '(("Create Subject Filter" . com-summary-create-subject-filter)
				     ("Create From Filter" . com-summary-create-from-filter)
				     ("Create To Filter" . com-summary-create-to-filter))))


