;;; -*- Mode:Common-Lisp; Package:ZWEI; Fonts:(CPTFONT TR10B TR10BI TR10I CPTFONTB); Base:10 -*-
;;; Created 3/20/85 17:38:42 by nichols
;
;;;*****************************************************************************
;;;
;;;               If something is worth doing, it's worth doing
;;;                  at a higher level of abstraction.
;;;

#|Documentation:

|#

;;;*****************************************************************************


(PROCLAIM '(SPECIAL SITE-PRETTY-NAME)) 

;;; 1This is from DLW "Dan Weinreb" for commenting regions of a program.*
(DEFCOM COM-COMMENT-REGION "Comment region of text.  With arg, remove comments." ()
  (WHEN (EQ "last-command-type" 'REGION)
    (SETF (WINDOW-MARK-P *WINDOW*) T))
  (IF *NUMERIC-ARG-P*
      (REGION-LINES (START-LINE STOP-LINE)
	(LOOP WITH C-BEG-LENGTH = #+elroy (LENGTH *COMMENT-BEGIN*) #-elroy (string-LENGTH *COMMENT-BEGIN*)
              WITH C-END-LENGTH = #+elroy (LENGTH *COMMENT-END*) #-elroy (string-LENGTH *COMMENT-END*)
              FOR LINE = START-LINE THEN (LINE-NEXT LINE)
              FOR LINE-LENGTH = #+elroy (LENGTH LINE) #-elroy (string-LENGTH LINE)
              UNTIL (EQ LINE STOP-LINE)
              DO (IF (AND (/= 0 C-BEG-LENGTH) (>= LINE-LENGTH C-BEG-LENGTH)
                (STRING-EQUAL *COMMENT-BEGIN* LINE :start1 0 :end1 0 :start2 C-BEG-LENGTH :end2 C-BEG-LENGTH)
                       )
                  (LET ((BP1 (CREATE-BP LINE 0))
                        (BP2 (CREATE-BP LINE C-BEG-LENGTH)))
                    (DELETE-INTERVAL BP1 BP2)))
       (SETQ LINE-LENGTH (LENGTH LINE))
              (IF (AND (/= 0 C-END-LENGTH) (>= LINE-LENGTH C-END-LENGTH)
                (STRING-EQUAL *COMMENT-END* LINE :start1 0 :end1 (- LINE-LENGTH C-END-LENGTH))
                       )
                  (LET ((BP1 (CREATE-BP LINE (- LINE-LENGTH C-END-LENGTH)))
                        (BP2 (CREATE-BP LINE LINE-LENGTH)))
                    (DELETE-INTERVAL BP1 BP2)))))
      (REGION-LINES (START-LINE STOP-LINE)
	(LOOP FOR LINE = START-LINE THEN (LINE-NEXT LINE)
              UNTIL (EQ LINE STOP-LINE)
              FOR BP = (CREATE-BP LINE 0)
              DO (INSERT BP *COMMENT-BEGIN*) (MOVE-BP BP (END-LINE BP))
              (INSERT BP *COMMENT-END*))))
  (SETQ *CURRENT-COMMAND-TYPE* 'REGION) DIS-TEXT) 

(DEFUN ZFORMAT (BP FORMAT-STRING &REST ARGS)
  "Format a line into the buffer at bp"
  (INSERT-MOVING BP (APPLY #'FORMAT () FORMAT-STRING ARGS))) 

(DEFCOM COM-NEW-ATTRIBUTE-LIST "Create a new mode line" ()
   (LET ((START-BP (COPY-BP (INTERVAL-FIRST-BP *INTERVAL*))))
     (KILL-INTERVAL START-BP (END-LINE START-BP) T T)
     (INSERT-MOVING START-BP
		    (APPLY #'FORMAT ()
			   ";;; -*- Mode: ~A; Package: ~A; Base: 10; Fonts:~@{ ~a~^,~}; -*-~%"
			   (CASE *MAJOR-MODE*
			     (COMMON-LISP-MODE 'COMMON-LISP)
			     (ZETALISP-MODE 'ZETALISP)
			     (OTHERWISE 'TEXT))1;*			   "LISP"  ;(send *major-mode* :mode-line-name)
			   (PACKAGE-NAME *PACKAGE*)
			   (OR (SEND *INTERVAL* :GET :FONTS)
			      '(CPTFONT TR10B TR10BI TR10I CPTFONTB))))
     (INSERT-MOVING START-BP
		    (FORMAT () ";;; Created ~A by ~A~%"
			    (TIME:PRINT-UNIVERSAL-TIME (GET-UNIVERSAL-TIME) ())
			    (COND
			      ((EQUAL FS:USER-PERSONAL-NAME-FIRST-NAME-FIRST "") USER-ID)
			      (FS:USER-PERSONAL-NAME-FIRST-NAME-FIRST))))
     (INSERT-MOVING START-BP
		    ";
;;;*****************************************************************************
;;;
;;;              1 If something is worth doing, it's worth doing*
;;;                 1 at a higher level of abstraction.*
;;;

#|1Documentation:*

|#

;;;*****************************************************************************
")
     (MOVE-BP START-BP START-BP));1move bp to end *
   (COM-REPARSE-ATTRIBUTE-LIST) DIS-TEXT) 

(defcom com-ti-attribute-list "Create a new mode line" ()
  (let ((start-bp (copy-bp (interval-first-bp *interval*))))
    (KILL-INTERVAL start-bp (END-LINE start-bp) T T)
    (insert-moving start-bp
		   (apply #'FORMAT nil
		   ";;; -*- Mode: ~A; Package: ~A; Base: 10; Fonts:~@{ ~a~^,~}; -*-~%"
			   (case *major-mode*
			     (common-lisp-mode 'common-lisp)
			     (zetalisp-mode 'zetalisp)
			     (otherwise 'text))
			   (package-name *package*)
			   (OR (SEND *interval* :get :fonts) '(CPTFONT TR10B TR10BI TR10I CPTFONTB))))
    (insert-moving start-bp
;";
1;===============================================================================
;
;   This data and information is proprietary to, and a valuable trade secret of
;   Texas Instruments, Incorporated, a Delaware corporation.  It is given in
;   confidence by Texas Instruments, and may not be used as the basis of
;   manufacture, or be reproduced or copied, or be distributed to any other
;   party, in whole or in part, without the prior written consent of Texas
;   Instruments.
;
";;;===============================================================================
;;;                                    RESTRICTED RIGHTS LEGEND 
;;; Use,  duplication, or  disclosure  by  the  Government is subject to restrictions
;;; as set forth in subdivision (b)(3)(ii) of the Rights in Technical Data and
;;; Computer Software clause at 52.227-7013. 
;;;
;;; TEXAS INSTRUMENTS INCORPORATED, P.O. BOX 2909 AUSTIN, TEXAS 78769  
;;; Copyright (C) 1986, Texas Instruments Incorporated. All rights reserved.
;;;===============================================================================

;;;
;;; Change history:
;;;
;;;  Date	Author	Description
;;; -------------------------------------------------------------------------------------*
")
    (insert-moving start-bp 
		   (format nil ";;; ~A	~A	Created~%"
			   (SUBSEQ (time:print-universal-time (time:get-universal-time) nil) 0 8)
			   (cond ((STRING-EQUAL user-id "3NICHOLS*") "3DAN*")
				 ((equal fs:user-personal-name-first-name-first "")
				  user-id)
				 (fs:user-personal-name-first-name-first))))
    (move-bp start-bp start-bp)) ;1move bp to end *

  (com-reparse-attribute-list)
  dis-text)


#|
(DEFMACRO with-modified-comtab ((comtab form) &body body)
  "1Execute BODY with a modified comtab.*"
  `(LET ((command-undo (set-comtab-return-undo ,comtab ,form)))
     (UNWIND-PROTECT 
       (PROGN . ,body)
       (EVAL command-undo))))

(ADVISE read-defaulted-pathname :around space-hack nil
  (with-modified-comtab (*COMPLETING-READER-COMTAB* '(#/space COM-COMPLETE))
    :do-it))

(DEFCOM COM-MACRO-EXPAND-EXPRESSION "Macro-expands the Lisp expression following Point.
Reads the Lisp expression following point, and expand the form itself but not
any of the subforms within it.  Types out the result on the typeout window.
With a numeric argument, pretty-prints the result back into the buffer immediately
after the expression." ()
  (LET ((STREAM (REST-OF-INTERVAL-STREAM (POINT)))
	expansion)
    (MOVE-POINT-ON-READ-ERROR
      (SETQ expansion (MACRO-EXPAND-TOP-LEVEL (READ STREAM)))
      (delete-local-declare-from-expansion expansion)
      (GRIND-TOP-LEVEL expansion
		       NIL
		       (IF *NUMERIC-ARG-P* STREAM STANDARD-OUTPUT))))
  (IF *NUMERIC-ARG-P* DIS-TEXT DIS-NONE))

(DEFUN delete-local-declare-from-expansion (expansion)
  (LOOP for form in expansion doing
	(WHEN (LISTP form)
	  (IF (EQ (CAR form) 'sys:instance-variables)
	      (RPLACD form "...")
	    (delete-local-declare-from-expansion form)))))

|#

; Modified to use macroexpand-1 instead of macroexpand
(DEFUN MACRO-EXPAND-TOP-LEVEL (FORM)
  (COND
    ((TYPECASE FORM
       (:LIST (SYSTEM:VALIDATE-FUNCTION-SPEC (CAR FORM)))
       (:SYMBOL T)
       (OTHERWISE NIL))
 (COPY-LIST (MACROEXPAND-1 FORM))
     )
    (T FORM))) 

;1 Offer to Revert any buffers that have been modified*

(DEFCOM COM-REVERT-MODIFIED-BUFFERS "Offers to revert any modified buffers" ()
   (LET* ((MOD-BUFFERS
	   (LOOP FOR BUF IN *ZMACS-BUFFER-LIST*
                 IF (AND (TYPEP BUF 'FILE-BUFFER)
                         (NOT
                           (EQUAL (SEND (OPEN (SEND BUF :PATHNAME) :DIRECTION () :CHARACTERS T) :INFO)
                                  (SEND BUF :FILE-INFO))))
                 COLLECT BUF))
	  (CHOICES (LOOP FOR BUF IN MOD-BUFFERS COLLECT `(,BUF ,(SEND BUF :NAME) ((:REVERT T))))))
     (IF (NULL CHOICES)
       DIS-NONE
       (LOOP FOR SELECTION IN (TV:MULTIPLE-CHOOSE "Buffers" CHOICES '((:REVERT "Revert" NIL)))
	  WITH RETN = DIS-NONE
          IF (EQ (CADR SELECTION) :REVERT)
          DO (LET ((SELECT (CAR SELECTION)))
	    (SEND SELECT :REVERT)
	    (IF (EQ SELECT *INTERVAL*)
	      (SETQ RETN DIS-TEXT)
	      (LET ((WINDOW
		     (DOLIST (WINDOW *WINDOW-LIST*)
		       (AND (EQ (WINDOW-INTERVAL WINDOW) SELECT) (RETURN WINDOW)))))
		(AND WINDOW (MUST-REDISPLAY WINDOW DIS-TEXT)))))
	  FINALLY (RETURN RETN))))) 


(DEFCOM COM-insert-documentation "Inserts the documentation for a function at point." ()
  (LET* ((stream (interval-stream-into-bp (point)))
	 (FUNCTION (READ-FUNCTION-name "Insert Documentation" (RELEVANT-FUNCTION-NAME (POINT)) :SOURCE-FILE-NAME)))
    (princ (DOCUMENTATION FUNCTION) stream))
  DIS-TEXT)

;(DEFCOM COM-insert-documentation "Inserts the documentation for a function at point." ()
;  (LET* ((stream (interval-stream-into-bp (point)))
;	 (FUNCTION (READ-FUNCTION-NAME "Insert Documentation" (RELEVANT-FUNCTION-NAME (POINT)) 'aarray-ok))
;	 (latex-p  (NOT *NUMERIC-ARG-P*)))
;    (IF (FBOUNDP FUNCTION)
;	(user:document-function FUNCTION latex-p stream)
;      (user:document-variable FUNCTION  latex-p stream)))
;  DIS-TEXT)


(set-comtab *zmacs-comtab* '(#\hyper-\; com-comment-region
                                #\hyper-m com-new-attribute-list
				#\hyper-n com-ti-attribute-list
				#\hyper-1z* com-insert-documentation)
			(make-command-alist '(com-new-attribute-list
					       com-comment-region
					1        *com-insert-documentation
					       com-revert-modified-buffers)))

(defcom zwei:com-kill-region-and-yank-last-kill
	"Kill the marked region, and replace it with current top
thing on the kill-ring.
With numeric-arg, the nth thing from the top of the kill-ring.
Afterwards, can use meta-Y to walk back through the kill-ring."
	()
  (let ((THING (send *KILL-HISTORY* :yank *NUMERIC-ARG*))
	(SWAP-P (bp-< (point) (mark))))
    (when (null THING) (barf))
    (com-kill-region)
    (move-bp (point) (insert-kill-ring-thing (point) THING))
    (when SWAP-P (swap-bps (point) (mark)))
    (setq *CURRENT-COMMAND-TYPE* 'yank)
    DIS-TEXT)
  )

(zwei:command-store 'zwei:com-kill-region-and-yank-last-kill
		    #\hyper-control-w zwei:*zmacs-comtab*)
;;
;;
;;
(defcom zwei:com-kill-line-and-yank-last-kill
	"Kill to end of line, and replace it with current top
thing on the kill-ring.
With numeric-arg, the nth thing from the top of the kill-ring.
Afterwards, can use meta-Y to walk back through the kill-ring."
	()
  (let ((THING (send *KILL-HISTORY* :yank *NUMERIC-ARG*))
	(SWAP-P (bp-< (point) (mark))))
    (when (null THING) (barf))
    (com-kill-line)
    (move-bp (point) (insert-kill-ring-thing (point) THING))
    (when SWAP-P (swap-bps (point) (mark)))
    (setq *CURRENT-COMMAND-TYPE* 'yank)
    DIS-TEXT)
  )

(zwei:command-store 'zwei:com-kill-line-and-yank-last-kill
		    #\hyper-control-k zwei:*zmacs-comtab*)
;;
;;
;;
(defcom zwei:com-kill-sexp-and-yank-last-kill
	"Kill the next-sexp, and replace it with current top
thing on the kill-ring.
With numeric-arg, the nth thing from the top of the kill-ring.
Afterwards, can use meta-Y to walk back through the kill-ring."
	()
  (let ((THING (send *KILL-HISTORY* :yank *NUMERIC-ARG*))
	(SWAP-P (bp-< (point) (mark))))
    (when (null THING) (barf))
    (com-kill-sexp)
    (move-bp (point) (insert-kill-ring-thing (point) THING))
    (when SWAP-P (swap-bps (point) (mark)))
    (setq *CURRENT-COMMAND-TYPE* 'yank)
    DIS-TEXT)
  )

(zwei:command-store 'zwei:com-kill-sexp-and-yank-last-kill
		    #\hyper-meta-control-k zwei:*zmacs-comtab*)
;;
;;
;;
(defcom zwei:com-kill-word-and-yank-last-kill
	"Kill the next-word, and replace it with current top
thing on the kill-ring.
With numeric-arg, the nth thing from the top of the kill-ring.
Afterwards, can use meta-Y to walk back through the kill-ring."
	()
;;  (com-kill-word)
  (LET ((THING (SEND *KILL-HISTORY* :YANK *NUMERIC-ARG*))
	(SWAP-P (BP-< (POINT) (MARK))))
    (WHEN (NULL THING) (BARF))
    (com-kill-word)
    (MOVE-BP (POINT) (INSERT-KILL-RING-THING (POINT) THING))
    (WHEN SWAP-P (SWAP-BPS (POINT) (MARK)))
    (SETQ *CURRENT-COMMAND-TYPE* 'YANK)
    DIS-TEXT)
  )

(zwei:command-store 'zwei:com-kill-word-and-yank-last-kill
		    #\hyper-meta-d zwei:*zmacs-comtab*)

(comment DEFCOM COM-exchange-string
	"Exchanges all occurrences of a given string with another.
It prompts first for the string to remove and second for the string to exchange
it with.  A numeric argument (n) means to make n exchanges.  By default, it
exchanges all occurrences of the first string that occur following point in the
buffer.

Usually it attempts to match the case of the replacements with the case of the
string being replaced.  This behavior is controlled by zwei:*case-replace-p*.
When it is null, case matching does not take place." ()
  (WITH-QUERY-REPLACE-INTERVAL (REGION-P)
    (LET* ((FROM (TYPEIN-LINE-HISTORY-READLINE *REPLACE-HISTORY* NIL T
		   "Exchange ~:[all~*~;next ~D~] occurrences ~:[in the region ~]of:"
		   *NUMERIC-ARG-P* *NUMERIC-ARG* (NOT REGION-P)))
	   (TO (TYPEIN-LINE-HISTORY-READLINE *REPLACE-HISTORY* T NIL
		 "Exchange ~:[all~*~;next ~D~] occurrences ~:[in the region ~]of /"~A/" with:"
		 *NUMERIC-ARG-P* *NUMERIC-ARG* (NOT REGION-P) FROM)))
      (TYPEIN-LINE "~D. exchanges~:P."
		   (PROGN 
		     (REPLACE-STRING (POINT) FROM "#$*@$%*" (AND *NUMERIC-ARG-P* *NUMERIC-ARG*))
		     (+ (REPLACE-STRING (POINT) TO FROM (AND *NUMERIC-ARG-P* *NUMERIC-ARG*))
			(REPLACE-STRING (POINT) "#$*@$%*" TO (AND *NUMERIC-ARG-P* *NUMERIC-ARG*)))))
      DIS-TEXT)))


(defcom com-phone-no "Print phone number" ()
  (LET ((xx (completing-read-from-mini-buffer
              "Phone Number For:"
              nil
              t
              t
              "Enter the name of the person/place you wish the number for."
	     )))
    (COND ((EQUAL xx "") (barf))
          (t
           (user:phone xx))))
  dis-none)

(zwei:command-store 'zwei:com-phone-no
		    #\hyper-p zwei:*zmacs-comtab*)

(defcom com-net-address "Get a net address" ()
  (LET ((xx (completing-read-from-mini-buffer
              "Person or Subject:"
              nil
              t
              t
              "Enter the person/subject you wish the address for."
              )))
    (COND ((EQUAL xx "") (barf))
          (t
           (FORMAT *query-io* "~&~A:" (user:net2 xx)))))
  dis-none)

(zwei:command-store 'zwei:com-net-address
                    #\hyper-o zwei:*zmacs-comtab*)

;1;; From Kirk Blackburn 3/86*
;;;
;;; THIS HACK ALLOWS A USER TO   DIRECTLY INVOKE A FUNCTION WITH ARGUMENTS, WITHOUT
;;; BEING IN A BREAK LOOP OR META-ESCAPE. JUST CREATE A REGION UNDER THE FUNCTION TO BE CALLED AND
;;;    TYPE C-SH-F.

(defun arg-prompt (fn-with-args)
    (let ((arglist (arglist fn-with-args)))
      (LOOP FOR i FROM 0
	      FOR name IN arglist
	     while (not (member name '(&optional )))
	      as value = (PROMPT-AND-READ :EVAL-READ "Arg ~D (~S):" I name)
      	      COLLECTING VALUE)))

(zwei:DEFCOM zwei:COM-FUNCALL-REGION "This command will do a funcall on a defined region." (Km)
	(MULTIPLE-VALUE-BIND (X)
	   (zwei:READ-FUNCTION-NAME "Funcall a Region" (zwei:RELEVANT-FUNCTION-NAME (zwei:POINT))
				'AARRAY-OK 'MULTIPLE-OK)
	  (print (APPLY X (arg-prompt x))))
	  zwei:dis-none)
;; THIS FUNCTION HANDLES ARGS

;; BIND TO C-S-F
zwei:(set-comtab  *zmacs-COMTAB* '(#\control-shift-f COM-FUNCALL-REGION)
		  '(("FUNCALL REGION" . com-funcall-region)))

;1;;From Kirk Blackburn
;;;The following command will insert the header for a change history line into the place
;;;indicated by point.  It tries hard to get the user's initials.  It first tries by
;;;looking at the user-id.  If it recognizes one then we are done.  Next it looks at the
;;;machine name, assuming that the user put in a funky user-id on their machine.  If the
;;;machine isn't recognized then we are stuck and have to prompt the user for their
;;;initials.  The READ function is used to do this, meaning that the user could enter ""
;;;and we still wouldn't have any initials.  This is the worst case so we use ??? as the
;;;user's initials.  For this worst case we continue to nag the user to try and get
;;;initials.  For all other cases, the initials are saved away where we can get them
;;;quickly next time.*

(DEFPARAMETER USER-ID-TO-INITIALS-MAPPING '(("NICHOLS" "DAN")))

(DEFPARAMETER HOST-TO-INITIALS-MAPPING '(("CEREBUS" "DAN")))

(DEFPARAMETER USER-INITIALS NIL)

(DEFCONSTANT PHONY-INITIALS "???"
  "2What to use if the user doesn't cooperate and give some initials.*")

(DEFUN READ-USER-INITIALS ()
  "2Read some initials from the user.*"
  (LET* ((PROMPT-STRING "Enter your initials into the hall of fame")
         (SIMPLE-WINDOW (MAKE-INSTANCE 'TV:WINDOW
                                       :BORDERS 4
                                       :LABEL NIL
                                       :INSIDE-WIDTH (SEND TV:INITIAL-LISP-LISTENER :STRING-LENGTH
                                                           PROMPT-STRING 0 NIL
                                                           (SEND TV:MAIN-SCREEN :INSIDE-WIDTH))
                                       :INSIDE-HEIGHT 50.
                                       :FONT-MAP (SEND TV:INITIAL-LISP-LISTENER :FONT-MAP))))
    (SEND SIMPLE-WINDOW :EXPOSE-NEAR '(:MOUSE))
    (SEND SIMPLE-WINDOW :SELECT)
    ;; Clear out the window and put the cursor at the top.
    (SEND SIMPLE-WINDOW :SET-CURSORPOS 0 0)
    (SEND SIMPLE-WINDOW :CLEAR-EOF)
    (SEND SIMPLE-WINDOW :LINE-OUT PROMPT-STRING)
    (PROG1
      (STRING (READ SIMPLE-WINDOW))
      ;; Clear out the window again.
      (SEND SIMPLE-WINDOW :SET-CURSORPOS 0 0)
      (SEND SIMPLE-WINDOW :CLEAR-EOF)
      (SEND SIMPLE-WINDOW :DEACTIVATE))))


(ZWEI:DEFCOM1 *ZWEI:COM-INSERT-CHANGE-HISTORY "Insert first part of a history line at the current point." (km)
  (LET* ((BP (ZWEI:POINT))
	 (POINT BP))
    (SETQ USER-INITIALS (OR
                          ;; First look at our saved variable to see if we have a
                          ;; good value.  The phony-initials don't count.
                          (IF (NOT (STRING-EQUAL USER-INITIALS PHONY-INITIALS))
                              USER-INITIALS)
                          ;; Next look at the user-id for a match.
                          (CADR (ASSOC USER-ID USER-ID-TO-INITIALS-MAPPING :TEST
                                       #'STRING-EQUAL))
                          ;; Now look at the machine name.
                          (CADR (ASSOC (SEND SI:LOCAL-HOST :SHORT-NAME) HOST-TO-INITIALS-MAPPING
                                       :TEST #'STRING-EQUAL))
                          ;; No luck, must ask the user.
                          (LET ((USER-INPUT (READ-USER-INITIALS)))
                            (WHEN (NOT (ZEROP (LENGTH USER-INPUT)))
                              USER-INPUT))
                          ;; The user isn't being very cooperative but we must put in something.
                          PHONY-INITIALS))
    (SETQ ZWEI:*FONT* 1)
    (ZWEI:UPDATE-FONT-NAME)
    (MULTIPLE-VALUE-BIND (IGNORE IGNORE IGNORE DAY MONTH YEAR)
        (TIME:GET-TIME)
      ;; Perform a consistency check on the year.
      (WHEN (= YEAR 1986)
        (TV:NOTIFY NIL "This year is 1987.  Updating clock appropriately.")
        (TIME:SET-LOCAL-TIME "one year from now"))
      ;; Make sure we are at the beginning of the line.
      (ZWEI:COM-BEGINNING-OF-LINE)
      (ZWEI:INSERT BP (ZWEI:IN-CURRENT-FONT (FORMAT NIL "~%")))
      (SETQ ZWEI:*FONT* 0)
      (ZWEI:UPDATE-FONT-NAME)
      (ZWEI:INSERT-MOVING POINT (ZWEI:IN-CURRENT-FONT ";"))
      (SETQ ZWEI:*FONT* 1)
      (ZWEI:UPDATE-FONT-NAME)
      (ZWEI:INSERT-MOVING POINT
                          (ZWEI:IN-CURRENT-FONT 
                            (FORMAT NIL ";;  ~2D/~2,VD/~2D  ~A~C"
                                    MONTH (CHAR-CODE #\0) DAY (MOD YEAR 100) USER-INITIALS #\TAB))))
    ZWEI:DIS-TEXT))


1;;; Bind this command to CONTROL SHIFT I.*
(ZWEI:SET-COMTAB  ZWEI:*zmacs-COMTAB*
                  `(
#+ELROY           #\CONTROL-SHIFT-I
                  ZWEI:COM-INSERT-CHANGE-HISTORY)
                  '(("INSERT CHANGE HISTORY " . ZWEI:COM-INSERT-CHANGE-HISTORY)))

;;;This method is a modified com-set-fonts from sys:zwei;font.lisp.86 ,release 5.1
;;;Each time a lisp mode buffer not associated with a file is activated this adds the default attribute list.
;(DEFMETHOD (ZMACS-BUFFER :AFTER :activate) (ignore)
;  (WHEN (AND (EQ (buffer-file-id self) T)
;             (EQUAL 'LISP-MODE *MAJOR-MODE*))
;    (com-new-attribute-list)))

;()

;;; These routines allow the user to manipulate minor modes
;;; and the default fonts,
;;; package and base for all files in LISP major mode.
;;; As it currently stands, the
;;; defaults are as follows:
;;;
;;; Variable                                  Value
;;; =========                                  ======
;;; *DEFAULT-PACKAGE-STRING*         "USER"
;;; *DEFAULT-FONTS-STRING*            "MEDFNT HL12B HL12BI"
;;; *DEFAULT-BASE-STRING*              "10."
;;;
;;; The variable "lisp-mode-hook" is set to the value of
;;;  'set-zmacs-defaults. This
;;; function, listed at the end of this file,
;;;  calls routines to set the above defaults
;;; then it sets the LISP minor mode to "Electric Font Lock Mode".
;;;
;;; The default values for the package, fonts,
;;;  and base will be set only if they have
;;; not already been set; so you will not overwrite
;;; the existing attribute values when
;;; you read in an existing file.



;(DEFVAR *DEFAULT-FONTS-STRING* "CPTFONT HL12B HL12BI")
;
;(DEFUN SET-DEFAULT-FONTS ()
;  "Change the set of fonts to use.
;   Sets the fonts to a default font list."
;  (let ((tem *DEFAULT-FONTS-STRING*)
;	(*set-attribute-updates-list* t))
;    (PKG-BIND "FONTS"
;      (SETQ TEM (READ-FROM-STRING (STRING-APPEND "(" TEM ")"))))
;    (DO ((L TEM (CDR L))
;	 (FONT)
;	 (AL NIL))
;	((NULL L)
;	 (SETQ TEM (NREVERSE AL)))
;      (SETQ FONT (CAR L))
;      (COND ((NOT (SYMBOLP FONT))
;	     (BARF "~S is not the name of a font" FONT))
;	    ((NOT (BOUNDP FONT))
;	     (FED:FIND-AND-LOAD-FONT FONT)
;	     (OR (BOUNDP FONT) (BARF "~S is not a defined font" FONT))))
;      (PUSH (CONS (GET-PNAME FONT) (SYMEVAL FONT)) AL))
;    (REDEFINE-FONTS *WINDOW* TEM)
;    (WHEN (SEND *INTERVAL* ':OPERATION-HANDLED-P ':PUTPROP)
;      (SEND *INTERVAL* ':PUTPROP TEM ':FONT-ALIST)
;      (AND (SEND *INTERVAL* ':OPERATION-HANDLED-P ':EDITING-FILE-P)
;	   (SET-ATTRIBUTE-INTERNAL ':FONTS "Fonts"
;				   (AND TEM (FORMAT NIL "~{~A~^,~}"
;						    (MAPCAR 'CAR TEM)))
;				   (MAKE-FONT-ALIST-ATTRIBUTE TEM))))
;    (UPDATE-FONT-NAME))
;  DIS-ALL)
;
;(DEFVAR *DEFAULT-PACKAGE-STRING* "USER")
;
;(DEFUN SET-DEFAULT-PACKAGE ()
;  "Changes the package associated with the buffer.
;   It offers to create the package if necessary."
;  (LET* ((PACKAGE-NAME *DEFAULT-PACKAGE-STRING*)
;	 (*SET-ATTRIBUTE-UPDATES-LIST* T))
;    (SETQ PACKAGE (PKG-FIND-PACKAGE PACKAGE-NAME ':ASK))	;query later
;    (SETQ PACKAGE-NAME (PACKAGE-NAME PACKAGE))
;    (SEND *INTERVAL* ':PUTPROP PACKAGE ':PACKAGE)
;    (SET-ATTRIBUTE-INTERNAL ':PACKAGE "Package"
;			    PACKAGE-NAME (INTERN PACKAGE-NAME SI:PKG-KEYWORD-PACKAGE)))
;  DIS-TEXT)
;
;(DEFVAR *DEFAULT-BASE-STRING* "10.")
;
;(DEFUN SET-DEFAULT-BASE ()
;  "Changes the base associated with the buffer."
;  (LET ((NEW-BASE-STRING *DEFAULT-BASE-STRING*)
;	(*SET-ATTRIBUTE-UPDATES-LIST* T))
;    (SETQ NEW-BASE-STRING (STRING-TRIM '(#\SPACE #\TAB) NEW-BASE-STRING))
;    (LET ((NEW-BASE (PARSE-NUMBER NEW-BASE-STRING)))
;      (IF (NULL NEW-BASE) (BARF "/"~A/" is not a number." NEW-BASE-STRING))
;      (SEND *INTERVAL* ':PUTPROP NEW-BASE ':BASE)
;      (SET-ATTRIBUTE-INTERNAL ':BASE "Base" NEW-BASE-STRING NEW-BASE)))
;  DIS-TEXT)
;
;
;;1;; This function sets the default base, package and fonts when a lisp file is*
;;1;; called, and also turns on the electric font lock mode.*
;(defun set-zmacs-defaults ()
;  (let ((attribute-string
;	  (first (find-attribute-list *interval*))))
;    (if (null (string-search "PACKAGE" attribute-string))
;	(set-default-package))
;    (if (null (string-search "FONTS" attribute-string))
;	(set-default-fonts))
;    (if (null (string-search "BASE" attribute-string))
;	(set-default-base))
;    (turn-on-mode 'electric-font-lock-mode)))
;
;(setf lisp-mode-hook 'set-zmacs-defaults)

