3;*;; -*- Mode:Common-Lisp; Package:ZWEI; Fonts:(CPTFONT HL12B HL12BI); Base:10 -*-


(DEFUN my-lisp-modes ()
  "1This function turns on the zmacs minor modes that I like.for lisp.
It must be called from within zmacs so the way to use this is to set the value
of a major mode hook symbol to the name of this function, for example*
	1(SETQ LISP-MODE-HOOK 'MY-LISP-MODES)
This will cause this function to be run whenever lisp mode is entered.*"
  (zwei:turn-on-mode 'electric-font-lock-mode)
  (zwei:turn-on-mode 'uppercase-global-functions-mode)
  (zwei:turn-on-mode 'return-indents-mode)
  ;(zwei:turn-on-mode 'word-abbrev-mode)
  (SETQ *comment-column*		432.
	*fill-column*		720.
	*max-reset-fraction*	0.4s0
	*min-reset-fraction*	0.6s0
	*point-pdl-max*		16.
        *check-unbalanced-parentheses-when-saving* T
        *indent-with-tabs*     nil     ;use spaces only to indent
	*region-marking-mode* ':reverse-video))

(DEFUN my-text-modes ()
  "1This function turns on the zmacs minor modes that I like.for text.
It must be called from within zmacs so the way to use this is to set the value
of a major mode hook symbol to the name of this function, for example*
	1(SETQ *TEXT1-MODE-HOOK 'MY-TEXT-MODES)
This will cause this function to be run whenever lisp mode is entered.*"
  (zwei:turn-on-mode 'auto-fill-mode)
  (zwei:turn-off-mode 'electric-font-lock-mode)
  (zwei:turn-off-mode 'return-indents-mode)
  (zwei:turn-off-mode 'uppercase-global-functions-mode)
  (SETQ *comment-column*		432.
	*fill-column*		576.
	*max-reset-fraction*	0.4s0
	*min-reset-fraction*	0.6s0
	*point-pdl-max*		16.))

(DEFUN my-tex-modes ()
  "1This function turns on the zmacs minor modes that I like.for *TeX1.
It must be called from within zmacs so the way to use this is to set the value
of a major mode hook symbol to the name of this function, for example*
	1(SETQ *TEX1-MODE-HOOK 'MY-TEX-MODES)
This will cause this function to be run whenever lisp mode is entered.*"
  (zwei:turn-on-mode 'auto-fill-mode)
  (zwei:turn-off-mode 'electric-font-lock-mode)
  (zwei:turn-off-mode 'uppercase-global-functions-mode)
  (zwei:turn-off-mode 'return-indents-mode)
  (zwei:turn-off-mode 'word-abbrev-mode)
  (SETQ *comment-column*		432.
	*fill-column*		720.
	*max-reset-fraction*	0.4s0
	*min-reset-fraction*	0.6s0
	*point-pdl-max*		16.))


;1this is a function so it can be compiled and therefore load faster.*
(DEFUN my-zmacs-init ()
  (DECLARE (SPECIAL lisp-mode-hook text-mode-hook
                    electric-font-lock-mode electric-shift-lock-mode
                    return-indents-mode tex-mode-hook)) 
  (UNLESS (FBOUNDP 'bind-key) (LOAD "lm:nichols.zmacs;bind-key"))
;1;*
;1;Change a few other minor things*
;1;*
  (SETQ ;*sticky-minor-modes*	    (DELETE 'word-abbrev-mode
        ;                                          (THE list *sticky-minor-modes*) :TEST #'EQ)
1;*      *unsticky-minor-modes*   (CONS 'word-abbrev-mode
1;*					  *unsticky-minor-modes*)
        electric-font-lock-mode  " Font"   ;1Shorten the mode line*
        electric-shift-lock-mode " Shift"  ;1Shorten the mode line*
        return-indents-mode      " Return" ;1Shorten the mode line*
        tex-mode-hook       'my-tex-modes    ;My TeX mode minor modes
        lisp-mode-hook	    'my-lisp-modes      ;1My lisp mode minor modes*
        text-mode-hook	    'my-text-modes)      ;1My text mode minor modes*
  
;  (SETF *sticky-minor-modes*     (DELQ 'word-abbrev-mode
;					    *sticky-minor-modes*)
;  (SETF *unsticky-minor-modes*   (CONS 'word-abbrev-mode
;					1     **unsticky-minor-modes*)
  (SETF electric-font-lock-mode  " Font")   ;1Shorten the mode line*
  (SETF electric-shift-lock-mode " Shift")  ;1Shorten the mode line*
  (SETF zetalisp-mode-hook	    'my-lisp-modes)      ;1My lisp mode minor modes*
  (SETF common-lisp-mode-hook	    'my-lisp-modes)      ;1My lisp mode minor modes*
  (SETF text-mode-hook	    'my-text-modes)     ;1My text mode minor modes*
  (SETQ *file-versions-kept* 2)
;  (setq *STICKY-MINOR-MODES* '(ZWEI:WORD-ABBREV-MODE 
;				ZWEI:ATOM-WORD-MODE))
  (SETQ1 **FIND-FILE-EARLY-SELECT* 'T)
  (SETQ *CHECK-UNBALANCED-PARENTHESES-WHEN-SAVING* 'T)
  (SETQ *REGION-MARKING-MODE* ':REVERSE-VIDEO)
;  (SETQ *initial-minor-modes*
;	'(((zwei:text-mode)
;	   auto-fill-mode)
;	  ((common-lisp-mode)
;	   electric-font-lock-mode Uppercase-Global-Functions-Mode)
;	  ((zetalisp-mode)
;	   electric-font-lock-mode Uppercase-Global-Functions-Mode)
;	  ((zetalisp-mode)
;	   electric-font-lock-mode)))
  (SETQ mail-mode-hook 'auto-fill-if-appropriate)1        *;1My mail mode minor modes*
  (SETQ *INITIAL-MINOR-MODES*
	'(ZWEI:UPPERCASE-GLOBAL-FUNCTIONS-MODE 
	   ZWEI:ELECTRIC-FONT-LOCK-MODE
	   ZWEI:RETURN-INDENTS-MODE))
;	   ZWEI:WORD-ABBREV-MODE))
;  (SETF *find-file-not-found-is-an-error* t)
  (SETQ *DEFAULT-BASE* '10.)
  (SETQ *file-versions-kept* 2)
  (SETQ *type-hog-alist*
	'((:xld 1 :non-contig-doesnt-matter)
	  (:xfasl 1 :non-contig-doesnt-matter)
	  (:qfasl 1 :non-contig-doesnt-matter)
	  (:bin 1 :non-contig-doesnt-matter)
	  (:s 2 :non-contig-doesnt-matter)
	  (:LIST 1 :non-contig-doesnt-matter)
	  (:MCR 1 :non-contig-doesnt-matter)
	  (:TBL 1 :non-contig-doesnt-matter)
	  (:CRASH 1 :non-contig-doesnt-matter)
	  (:LOG 1 :non-contig-doesnt-matter)
	  ("XLD" 1 :non-contig-doesnt-matter) ;1; Shouldn't have to specify strings, but the system's buggy*
	  ("XFASL" 1 :non-contig-doesnt-matter)
	  ("QFASL" 1 :non-contig-doesnt-matter)
	  ("BIN" 1 :non-contig-doesnt-matter)
	  ("S" 2 :non-contig-doesnt-matter)
	  ("LIST" 1 :non-contig-doesnt-matter)
	  ("MCR" 1 :non-contig-doesnt-matter)
	  ("TBL" 1 :non-contig-doesnt-matter)
	  ("CRASH" 1 :non-contig-doesnt-matter)
	  ("LOG" 1 :non-contig-doesnt-matter)))
   
;1;*
;1;Load in my word abbreviation file.*
;1;*
  (#+elroy zlc:FILLARRAY #-elroy fillarray *word-abbrev-table* '(0.))
  (LET ((init '(#\line #\return #\space #\))))
    (DOLIST (i init)
      (setf (aref *word-abbrev-table* i) 1.)))

;  (LET ((ABBREV-FILE "DAN:ZMACS;zmacs.qwabl"))
;    (WITH-OPEN-FILE (STREAM ABBREV-FILE :CHARACTERS T :DIRECTION :INPUT)
;      (LOAD-QWABL STREAM))
;    (SETQ *WORD-ABBREV-FILE-NAME* ABBREV-FILE
;	  *WORD-ABBREV-FILE-TICK* (TICK))
;    (FILL *WORD-ABBREV-TABLE* '(0.)))
;  (LET ((INIT "	 )]:},.?!
;
"))
;    (DOTIMES (I (LENGTH INIT))
;      (SETF (AREF *WORD-ABBREV-TABLE* (AREF INIT I)) 1.)))
  
;  (FILLARRAY zwei:*word-abbrev-table* '(0.))
;  (LET ((init '(#\line #\return #\space #\))))
;    (DOLIST (i init)
;      (ASET 1. zwei:*word-abbrev-table* i)))

;1;*
;1;Set some keys to hold some useful macro commands.*
;1;*
;1 Make M-X CF be Compile File, and CB be Compile Buffer*
  (set-comtab *zmacs-comtab* nil
	      '(("CF" . com-compile-file)
		("CB" . com-compile-buffer)
		("LF" . com-load-file)
		("CLF" . com-compile-and-load-file)
                ("ti"  . com-ti-attribute-list)))
  
;1 Bind super-s and super-r to extended search commands*
  (bind-key #\super-s 'com-extended-string-search)
  (bind-key #\super-r 'com-extended-reverse-string-search)
  
  (BIND-KEY #\H-TAB '(#\C-Q #\TAB)
	    "Insert Tab")
  (BIND-KEY #\S-J   '(#\C-\; #\C-SPACE #\C-E #\C-X #\C-J #\B #\c-S #\; #\altmode)
	    "Change comment font")
  
;1 Make space complete on select-buffer*
;1;;*  (set-comtab *completing-reader-comtab* '(#\space COM-COMPLETE-AND-EXIT-IF-UNIQUE))
  
;1 Make space complete when reading pathnames*
  (set-comtab  *PATHNAME-READING-COMTAB* '(#\space COM-PATHNAME-COMPLETE))
  
  (set-comtab  zwei:*zmacs-comtab* '(#\super-hyper-space zwei:com-move-to-previous-point))
  (SET-COMTAB zwei:*ZMACS-COMTAB* `(#\H-HELP zwei:com-list-buffers
                                            #\super-help zwei:com-self-document))
  (SET-COMTAB zwei:*ZMACS-CONTROL-X-COMTAB* '(#\I zwei:COM-INSERT-FILE
                                                   #\S zwei:COM-OCCUR
                                                   #\W zwei:COM-WRITE-REGION))
  (set-comtab zwei:*ZMACS-COMTAB* '(#\c-m-y zwei:COM-REPEAT-MINIBUFFER-COMMAND))

  (zwei:BIND-KEY #\f1 '(#\C-1 #\C-M-SPACE) "rotate point pdl")
  (zwei:BIND-KEY #\f2  '(#\C-- #\C-1 #\C-M-SPACE) "rotate point pdl backwards")
  (zwei:BIND-KEY #\h-. 'com-list-combined-methods)
  (ZWEI:BIND-KEY #\H-S-C '(#\H-C-C) "compile sexp")
  (ZWEI:BIND-KEY #\C-END '(#\M-^) "Delete indentation")
  (zwei:bind-key #\f4 '(";;; -*- Mode:COMMON-LISP; Package:USER; Base:10; Fonts:(CPTFONT TR10B TR10BI TR10I CPTFONTB) -*-" #\cr #\cr #\m-x "reparse mode line" #\cr)'
                 "2insert default mode line and reparse it*")
  (zwei:bind-key #\control-m '(#\c-p #\c-space #\m-f #\c-f #\m-w #\c-n #\c-y)
                 "2copy word from previous line*")
  (zwei:bind-key #\meta-shift-L '(#\C-3 #\C-M-L)
                1 "2Get third most previous buffer"**)  ;1rather than swapping two*
  (zwei:bind-key #\h-a	'(#\c-x #\c-x #\c-x #\c-x #\c-x #\c-j #\a)
                 "Change Font of region to font A.")
  (zwei:bind-key #\h-b	'(#\c-x #\c-x #\c-x #\c-x #\c-x #\c-j #\b)
                 "Change Font of region to font B.")
  (zwei:bind-key #\h-c	'(#\c-x #\c-x #\c-x #\c-x #\c-x #\c-j #\c)
                 "Change Font of region to font C.")
  (Bind-key #\s-n '(#\c-x #\c-j #\a) "Normal font for region")
  (Bind-key #\s-b '(#\c-x #\c-j #\b) "Boldify region")
  (Bind-key #\s-i '(#\c-x #\c-j #\c) "Italicize region")
  (zwei:bind-key #\h-\; '(#\c-s ";"             ;1hopefully move forward to next comment*
                          #\c-sp #\c-e #\h-b)
                 "Change Font of Next Comment to font B")
  (zwei:bind-key #\h-j   '(#\c-f #\c-x #\c-x #\c-b #\c-x #\c-j #\b)
                 "Change Font of Selected String to font B.")
  (zwei:bind-key #\h-k   '(#\c-f #\c-x #\c-x #\c-b #\c-x #\c-j #\c)
                 "Change Font of Selected String to font C.")
  (zwei:bind-key #\h-d   '(#\m-x "list definitions" #\return #\return)
                 "List Definitions in this Buffer.")
  (zwei:bind-key #\h-s   'zwei:com-kill-or-save-buffers "Kill or save buffers")
  (zwei:bind-key #\c-/ 'zwei:com-just-one-space)
  (zwei:bind-key #\m-\ '(#\c-d #\c-/) "2Wipe Next White Space*")
;  (zwei:bind-key #\h-f '(#\m-x
;                         "Capitalize Keywords Mode"
;                         #\cr
;                         #\m-x
;                         "Electric Font Lock Mode"
;                         #\cr)
;                 "2Rajs Capatilize Keywords and Electric Font Lock Mode*")
  (zwei:bind-key #\h-f 'zwei: com-fontify-region-or-buffer)
  (zwei:bind-key #\h-i '(#\c-m-a #\c-m-q #\c-m-space) "Reindent Sexpr")
  (zwei:bind-key #\h-s-q 'zwei:com-query-replace)
  (zwei:bind-key #\h-s-r 'zwei:com-replace-string)
  (zwei:bind-key #\c-lf '(#\c-e #\lf) "Indent for New Blank Line")
  (zwei:bind-key #\h-u '(#\m-- #\m-u) "Uppercase Previous Word")
  (zwei:bind-key #\h-c '(#\m-- #\m-c) "Capitalize Previous Word")
  (zwei:bind-key #\h-l '(#\m-- #\m-l) "Lowercase Previous Word")
  (zwei:bind-key #\s-f '(#\c-u #\c-v) "Scroll Forward")
;  (zwei:bind-key #\s-b '(#\c-u #\m-v) "Scroll Backward")
;  (zwei:bind-key #\h-t '(#\c-m-a                ;1move to beginning of fnc*
;                         #\h-s-e                ;1try to evaluate fnc*
;                         #\c-f                  ;1skip potential paren*
;                         #\c-m-f                ;1next sexp - hopefully fnc name*
;                         #\c-f                  ;1skip space*
;                         #\c-m-@                ;1mark this thing*
;                         #\m-w                  ;1save this region to kill ring*
;                         #\m-x
;                         "Trace"                ;1enter trace*
;                         #\cr
;                         #\c-y                  ;1pull fn name back out*
;                         #\c-y
;                         #\cr
;                         #\c-m-sp
;                         ) "Trace This Function")
  
;  (ZWEI:BIND-KEY #\LEFT-ARROW '(#\C-B) "Move left one character")
;  (ZWEI:BIND-KEY #\RIGHT-ARROW '(#\C-F) "Move right one character")
;  (ZWEI:BIND-KEY #\UP-ARROW '(#\C-P) "Move up one character")
;  (ZWEI:BIND-KEY #\DOWN-ARROW '(#\C-N) "Move down one character")
  
  (ZWEI:BIND-KEY #\C-LEFT-ARROW '(#\c-1 #\c-0 #\C-B) "Move left several characters")
  (ZWEI:BIND-KEY #\C-RIGHT-ARROW '(#\c-1 #\c-0 #\C-F) "Move right several characters")
  (ZWEI:BIND-KEY #\C-UP-ARROW '(#\c-1 #\c-0 #\C-P) "Move up several characters")
  (ZWEI:BIND-KEY #\C-DOWN-ARROW '(#\c-1 #\c-0 #\C-N) "Move down several characters")
  
  (ZWEI:BIND-KEY #\M-LEFT-ARROW '(#\M-B) "Move left a word")
  (ZWEI:BIND-KEY #\M-RIGHT-ARROW '(#\M-F) "Move right a word")
  (ZWEI:BIND-KEY #\M-UP-ARROW '(#\C-B #\H-R #\; #\C-F) "Previous comment")
  (ZWEI:BIND-KEY #\M-DOWN-ARROW '(#\H-S #\;) "Next comment")
  
;  (ZWEI:BIND-KEY #\C-M-LEFT-ARROW '(#\C-B #\H-R #\( #\C-F) "Move left one (")
;  (ZWEI:BIND-KEY #\C-M-RIGHT-ARROW '(#\H-S #\() "Move right one (")
  (ZWEI:BIND-KEY #\C-M-UP-ARROW '(#\C-M-B) "Move up one sexp")
  (ZWEI:BIND-KEY #\C-M-DOWN-ARROW '(#\C-M-F) "Move down one sexp")
  
  (ZWEI:BIND-KEY #\H-LEFT-ARROW '(#\C-- #\C-1 #\C-0 #\C-V) "scroll up 10 lines")
  (ZWEI:BIND-KEY #\H-RIGHT-ARROW '(#\C-1 #\C-0 #\C-V) "scroll down 10 lines")
  (ZWEI:BIND-KEY #\H-UP-ARROW '(#\C-- #\C-1 #\C-V) "scroll up 1 line")
  (ZWEI:BIND-KEY #\H-DOWN-ARROW '(#\C-1 #\C-V) "scroll down 1 line")
  
  (ZWEI:BIND-KEY #\S-LEFT-ARROW '(#\M-<) "Top of buffer")
  (ZWEI:BIND-KEY #\S-RIGHT-ARROW '(#\M->) "Bottom of buffer")
  (ZWEI:BIND-KEY #\S-UP-ARROW '(#\M-V) "Page up")
  (ZWEI:BIND-KEY #\S-DOWN-ARROW '(#\C-V) "Page down")
  
;  (ZWEI:BIND-KEY #\M-RUBOUT '(#\M-D) "Delete word")
;  (ZWEI:BIND-KEY #\C-M-RUBOUT '(#\C-M-K) "Delete sexp")
  )
  
(my-zmacs-init)