;; -*- Mode: Lisp; Package: USER; Base: 10 -*-
;;;>
;;;> *****************************************************************************************
;;;> This data and information is proprietary to, and a valuable trade
;;;> secret of, Symbolics, Inc.  It is given in confidence by Symbolics,
;;;> and may only be used as permitted under the license agreement under
;;;> which it has been distributed, and in no other way.
;;;>
;;;> ** (c) Copyright 1983, 1984, 1985 by Symbolics, Inc.  All rights reserved.
;;;>
;;;> Symbolics (TM), ZetaLisp (TM), and Macsyma (TM), are trademarks of Symbolics, Inc.
;;;>
;;;> The technical data and information provided herein are provided with
;;;> `limited rights', and the computer software provided herein is provided
;;;> with `restricted rights' as those terms are defined in DAR and ASPR 7-104.9(a).
;;;> *****************************************************************************************

(DEFFLAVOR WORD (ENGLISH ROMAJI) ()
  :GETTABLE-INSTANCE-VARIABLES
  :INITABLE-INSTANCE-VARIABLES
  :SETTABLE-INSTANCE-VARIABLES)

(DEFMETHOD (WORD :PRINT-SELF) (STREAM IGNORE SLASHIFY-P)
  (IF SLASHIFY-P
      (SYS:PRINTING-RANDOM-OBJECT (SELF STREAM :TYPEP)
	(SEND STREAM :STRING-OUT ENGLISH))
      (SEND STREAM :STRING-OUT ENGLISH)))

(DEFMETHOD (WORD :DISPLAY) (STREAM FORM)
  (SELECTQ FORM
    (:ENGLISH  (FORMAT STREAM "~&~A~30T~A" ENGLISH ROMAJI))
    (:ROMAJI   (FORMAT STREAM "~&~A~30T~A" ROMAJI ENGLISH))))
    ;(:JAPANESE (FORMAT STREAM "~&~A~30T~A~60T~A" JAPANESE ROMAJI ENGLISH))))

(COMPILE-FLAVOR-METHODS WORD)

(DEFVAR *DICTIONARY* (MAKE-ARRAY 500 :LEADER-LENGTH 1))

(PUTPROP :ENGLISH  (MAKE-EQUAL-HASH-TABLE :SIZE (ARRAY-LENGTH *DICTIONARY*)) 'INDEX)
(PUTPROP :ROMAJI   (MAKE-EQUAL-HASH-TABLE :SIZE (ARRAY-LENGTH *DICTIONARY*)) 'INDEX)
;(PUTPROP :JAPANESE (MAKE-EQUAL-HASH-TABLE :SIZE (ARRAY-LENGTH *DICTIONARY*)) 'INDEX)

(PUTPROP :ENGLISH  "English"  'FORMAT)
(PUTPROP :ROMAJI   "Romaji"   'FORMAT)
;(PUTPROP :JAPANESE "Japanese" 'FORMAT)

(DEFUN SUBSTRING-IF-NECESSARY (STRING BEGIN END)
  (IF (AND (= BEGIN 0)
	   (OR (NULL END) (= END (STRING-LENGTH STRING))))
      STRING
      (SUBSTRING STRING BEGIN END)))

(DEFUN LOOKUP-INTERNAL (FORM KEY &OPTIONAL (BEGIN 0) END)
  (VALUES
    (LET ((ALPHABETIC-CASE-AFFECTS-STRING-COMPARISON (EQ FORM :JAPANESE)))
      (SEND (GET FORM 'INDEX) :GET-HASH (SUBSTRING-IF-NECESSARY KEY BEGIN END)))))

(DEFUN LOOKUP-ENGLISH (KEY &OPTIONAL (BEGIN 0) END)
  (LOOKUP-INTERNAL :ENGLISH KEY BEGIN END))

(DEFUN LOOKUP-ROMAJI (KEY &OPTIONAL (BEGIN 0) END)
  (LOOKUP-INTERNAL :ROMAJI KEY BEGIN END))

;(DEFUN LOOKUP-JAPANESE (KEY &OPTIONAL (BEGIN 0) END)
;  (LOOKUP-INTERNAL :JAPANESE KEY BEGIN END))

(DEFUN STORE-INTERNAL (FORM KEY WORD)
  (LET* ((ALPHABETIC-CASE-AFFECTS-STRING-COMPARISON (EQ FORM :JAPANESE))
	 (INDEX (GET FORM 'INDEX))
	 (OLD-WORD (SEND INDEX :GET-HASH KEY)))
    (COND ((NULL OLD-WORD))
	  ((LISTP OLD-WORD)
	   (SETQ WORD (CONS WORD OLD-WORD)))
	  (T (SETQ WORD (LIST WORD OLD-WORD))))
    (SEND INDEX :PUT-HASH KEY WORD)))

(DEFUN STORE-ENGLISH  (KEY WORD) (STORE-INTERNAL :ENGLISH KEY WORD))
(DEFUN STORE-ROMAJI   (KEY WORD) (STORE-INTERNAL :ROMAJI KEY WORD))
;(DEFUN STORE-JAPANESE (KEY WORD) (STORE-INTERNAL :JAPANESE KEY WORD))

(DEFUN DEFINE-WORD (ENGLISH ROMAJI)
  (LET ((WORD (MAKE-INSTANCE 'WORD :ENGLISH ENGLISH :ROMAJI ROMAJI)))
    (ARRAY-PUSH-EXTEND *DICTIONARY* WORD)
    (STORE-ENGLISH ENGLISH WORD)
    (STORE-ROMAJI ROMAJI WORD)))
    ;(STORE-JAPANESE JAPANESE WORD)))

(DEFUN CLEAR-DICTIONARY ()
  (SETF (FILL-POINTER *DICTIONARY*) 0)
  (SEND (GET :ENGLISH 'INDEX) :CLEAR-HASH)
  (SEND (GET :ROMAJI 'INDEX) :CLEAR-HASH))
  ;(SEND (GET :JAPANESE 'INDEX) :CLEAR-HASH))

(DEFMACRO COERCE-TO-LIST (VARIABLE &BODY BODY)
  `(LET ((.ORIGINAL-VALUE. ,VARIABLE))
     (WITH-STACK-LIST (,VARIABLE ,VARIABLE)
       (IF (OR (NULL .ORIGINAL-VALUE.) (LISTP .ORIGINAL-VALUE.))
	   (SETQ ,VARIABLE .ORIGINAL-VALUE.))
       . ,BODY)))

(DEFUN discard-characters (STREAM characters)
  (COERCE-TO-LIST CHARACTERS
    (LOOP FOR CHAR = (SEND STREAM :ANY-TYI) DO
      (UNLESS (MEMQ CHAR CHARACTERS)
	(SEND STREAM :UNTYI CHAR)
	(RETURN))))
  ;; Suppress compiler warning
  NIL)

(DEFUN DISCARD-WHITESPACE (STREAM)
  (DISCARD-CHARACTERS STREAM *WHITESPACE*))

(DEFUN READ-WHITESPACE (STREAM)
  (DISCARD-CHARACTERS STREAM '(#\TAB #\SPACE)))

(DEFUN READ-WORD (STREAM)
  (READ-WHITESPACE STREAM)
  (READ-DELIMITED-STRING '(#\TAB #\RETURN) STREAM))

(DEFUN READ-DICTIONARY (&OPTIONAL (FILE "CEREBUS: NIHONGO; WORDS.TEXT"))
  (CLEAR-DICTIONARY)
  (WITH-OPEN-FILE (STREAM file)
;  (WITH-ZWEI-INPUT-FILE (STREAM FILE)
    (LOOP REPEAT 4 DO (SEND STREAM :LINE-IN))
    (LOOP NAMED TOP
	  FOR ENGLISH = (READ-WORD STREAM)
	  FOR ROMAJI = (READ-WORD STREAM)
	  ;FOR JAPANESE = (READ-WORD STREAM)
	  DO
      (DEFINE-WORD ENGLISH ROMAJI)
      (LOOP FOR CHAR = (SEND STREAM :TYI) DO
	(COND ((NULL CHAR) (RETURN-FROM TOP))
	      ((= CHAR #\RETURN))
	      (T (SEND STREAM :UNTYI CHAR)
		 (RETURN))))))
  ;; Suppress compiler warning
  NIL)

;; Sort words

(DEFUN PREPARE-STREAM (STREAM)
  ;(JAPANESE:JIS-FONTS STREAM)
  (SEND STREAM :CLEAR-WINDOW))

(DEFUN PRINT-INTERNAL (MESSAGE)
  (LET ((ARRAY (MAKE-ARRAY (FILL-POINTER *dictionary*))))
    (COPY-ARRAY-CONTENTS *DICTIONARY* ARRAY)
    (SORT ARRAY #'(LAMBDA  (A B) (STRING-LESSP (SEND A MESSAGE) (SEND B MESSAGE))))
    (PREPARE-STREAM STANDARD-OUTPUT)
    (LOOP FOR WORD BEING THE ARRAY-ELEMENTS OF ARRAY
	  DO (SEND WORD :DISPLAY STANDARD-OUTPUT MESSAGE))))

(DEFUN PRINT-ENGLISH  () (PRINT-INTERNAL :ENGLISH))
(DEFUN PRINT-ROMAJI   () (PRINT-INTERNAL :ROMAJI))
;(DEFUN PRINT-JAPANESE () (PRINT-INTERNAL :JAPANESE))

;; Lookup words

(DEFUN LOOP-INTERNAL (FORM-1 FORM-2)
  (PREPARE-STREAM STANDARD-OUTPUT)
  (LOOP FOR RESPONSE = (PROMPT-AND-READ :STRING-OR-NIL "~A:~20T" (GET FORM-1 'FORMAT))
	WHILE RESPONSE
	FOR WORD = (LOOKUP-INTERNAL FORM-1 RESPONSE)
	DO
    (IF (NULL WORD)
	(FORMAT T "~&~A not found in the dictionary.~2%" RESPONSE)
	(WITH-STACK-LIST (WORDS WORD)
	  (IF (LISTP WORD) (SETQ WORDS WORD))
	  (DOLIST (WORD WORDS)
	    (FORMAT T "~&~A:~20T~A"  ;~%~A:~20T~A~%"
		    (GET FORM-2 'FORMAT) (SEND WORD FORM-2)))
		    ;(GET FORM-3 'FORMAT) (SEND WORD FORM-3)))
	  (FORMAT T "~%")))))

(DEFUN ENGLISH-LOOP  () (LOOP-INTERNAL :ENGLISH :ROMAJI))
(DEFUN ROMAJI-LOOP   () (LOOP-INTERNAL :ROMAJI :ENGLISH))
;(DEFUN JAPANESE-LOOP () (LOOP-INTERNAL :JAPANESE :ROMAJI :ENGLISH))

(DEFUN QUIZ-INTERNAL (FORM-1 FORM-2)
  (PREPARE-STREAM STANDARD-OUTPUT)
  (LOOP FOR WORD = (AREF *DICTIONARY* (RANDOM (FILL-POINTER *DICTIONARY*)))
	DO
    (FORMAT T "~&~A:~10T~A~10T" (GET FORM-1 'FORMAT) (SEND WORD FORM-1))
    (*CATCH 'NEXT-WORD
      (QUIZ-WORD WORD FORM-2))
    (SEND STANDARD-OUTPUT :TYO #\RETURN)))

(DEFUN QUIZ-WORD (WORD FORM)
  (LET ((RESPONSE (PROMPT-AND-READ :STRING-OR-NIL "~A:~20T" (GET FORM 'FORMAT)))
	(ANSWER (SEND WORD FORM)))
    (IF (NOT RESPONSE) (*THROW 'NEXT-WORD T))
    (IF (NOT (EQUAL RESPONSE ANSWER))
	(FORMAT T "~&~A:~20T~A~%" (GET FORM 'FORMAT) ANSWER))))

(DEFUN ENGLISH-QUIZ  () (QUIZ-INTERNAL :ENGLISH :ROMAJI))
(DEFUN ROMAJI-QUIZ   () (QUIZ-INTERNAL :ROMAJI :ENGLISH))
;(DEFUN JAPANESE-QUIZ () (QUIZ-INTERNAL :JAPANESE :ROMAJI :ENGLISH))

(DEFVAR *CHOICES*
	(LOOP FOR CHOICE IN '(PRINT-ENGLISH PRINT-ROMAJI ENGLISH-LOOP ROMAJI-LOOP)
	      COLLECT (LIST (STRING-CAPITALIZE-WORDS CHOICE) CHOICE)))

(DEFUN JAPANESE-MENU ()
  (LOOP FOR CHOICE = (TV:MENU-CHOOSE *CHOICES*)
	WHILE CHOICE
	DO (FUNCALL CHOICE)))

(READ-DICTIONARY)




