;;; -*- Mode:Common-Lisp; Package:USER; Fonts:(MEDFNT HL12B); Base:10 -*-

;1;;================================================================*
;1;;                      A L A R M   C L O C K   U T I L I T Y*
;1;;*
;1;; HISTORY:*
;1;;   Original - GJ*
;1;;   1/30/86 - RLA : Added daily and weekly alarms, check-alarms, *
;1;;                     save to appointments file, restart code*
;1;;================================================================*


(SETQ user:appointments-file "cerebus:Nichols;appointments.lisp")

1;;; 1. To use, add this form to your login-init file:
;;;       (LOAD "<xfasl version of this file>")
;;;    This takes care of all process instantiation and initialization.
;;; 
;;; 2. Relevant functions [Pkg USER]:
;;;       a. (SET-ALARM reason minute &optional hour day month year sec)
;;;             Sets an alarm with associated reason.  All optional parameters default to the current time. 
;;;             DOES NOT SAVE.
;;;   ->  b. (SAVE-ALARM reason minute &optional hour day month year sec)
;;;             Same as SET-ALARM, but saves to the appointments file.
;;;             SAVING an alarm for a time but not for a day means that this alarm will go
;;;             off every day at this time.
;;;       c. (SET-WEEKLY-APPT  reason weekday hour &optional minute)
;;;             Sets a weekly alarm.  Weekday is a string starting with Mon, Tue ...
;;;             DOES NOT SAVE.
;;;   ->  d. (SAVE-WEEKLY-APPT reason weekday hour &optional minute)
;;;             Same as SET-WEEKLY-APPT, but saves to the appointments file.
;;;   ->  e. (CHECK-ALARMS)
;;;            Displays currently set alarms.  The currently set alarms include the REMAINING
;;;            alarms for today as well as NON-DAILY alarms for subsequent days.  There will
;;;            also be a **SPECIAL** entry for midnight, which sets alarms for the next day.
;;; 
;;; 3. Notes
;;;    a.  Turn the alarm off by hitting the TERM key (otherwise it beeps for 30 seconds).  It
;;;        then does a notify of the alarm reason.   (Hit RUBOUT after TERM to clear from
;;;        Terminal- state).
;;;    b.  If you don't like the default pathname "lm:<user-id>.alarm;appointments.lisp" (the directory will
;;;        be auto-created), you may precede the load with: 
;;;            (SETQ USER:APPOINTMENTS-FILE <pathname>)
;;;        This file can be edited, although it doesn't hurt to have old appointments in the file.
;;;        (the file just contains forms - calls to the above routines).
;;;    c.  Other variables of interest [Pkg USER]:
;;;          ALARM-TIME           - number of seconds alarm beeps (30) 
;;;          ALARM-EXPUNGE        - t to keep only 2 versions of appointments-file
;;;          ALARM-AUTO-DISPLAY   - t to call check-alarms after init and appointment file changes
                                           *
;1;;===================================================================================*


(DEFMACRO THEN (&BODY BODY)
  `(PROGN ,@BODY))

(DEFMACRO ELSE (&BODY BODY)
  `(PROGN ,@BODY))

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The WAKEUP-LIST is made up of two entry lists.  The first entry is the universal time
;;; the alarm should go off and the second entry is the reason the person wants to be 
;;; notified.
;;;*
(DEFPARAMETER WAKEUP-LIST NIL "2List of times and reasons*")

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ALARM-TIME is the number of seconds the alarm should ring before turing itself off.
;;;*
(DEFPARAMETER ALARM-TIME 30 "2Number of seconds the alarm should ring*")


1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ALARM-CLOCK waits for the wakeup list to get something on it "Alarm not set" and
;;; then waits for the time of the first element on the list to happen "Ticking".  When the
;;; specified time comes, the screen will blink and the beeper beep once every half second
;;; until the TERM key is struck or ALARM-TIME number of seconds pass.  If the TERM key
;;; is struck, a notify window pops up displaying the reason the user gave for wanting to
;;; have the alarm go off.
;;; *
(DEFUN ALARM-CLOCK (&AUX MSG)
  (LOOP (PROCESS-WAIT "Alarm not set" #'(LAMBDA ()
					     WAKEUP-LIST))
     (PROCESS-WAIT "Ticking"
		   #'(LAMBDA ()
		       (AND WAKEUP-LIST;1this can happen during re-init*
			  (> (GET-UNIVERSAL-TIME) (CAAR WAKEUP-LIST)))))
     (SETQ MSG (SECOND (FIRST WAKEUP-LIST)))
     (IF (STRING-EQUAL MSG "**SPECIAL**")
       (ALARM-RE-INIT T)
       ;1; else*
       (PROGN
	 (DO ((ALARM-COUNT 0 (1+ ALARM-COUNT)))
	     ((OR TV::KBD-TERMINAL-HAPPENED (= ALARM-COUNT (* 2 ALARM-TIME)))
	      (TV:NOTIFY () ">>> ALARM: ~A" MSG))
	   (IF (VARIABLE-BOUNDP TV::*BEEPING-FUNCTIONS*)
	     (BEEP 'ALARM-CLOCK)
	     (BEEP))
	   (PROCESS-SLEEP 30))
	 (SETF WAKEUP-LIST (CDR WAKEUP-LIST)))))) 

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ALARM-CLOCK-PROCESS starts up the alarm clock process.
;;;*
(DEFVAR alarm-clock-process-id nil)	  

(DEFUN ALARM-CLOCK-PROCESS ()
   (UNLESS alarm-clock-process-id 
     (SETQ alarm-clock-process-id (PROCESS-RUN-FUNCTION '(:Name "Alarm clock"
							  :restart-after-boot t
							  :restart-after-reset T)
							'ALARM-CLOCK))))

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; SET-ALARM accepts a text describing why the alarm should go off and the time it should
;;; go off.  The minute, hour, day, month, and year the alarm should go off can be specified
;;; by the user.  Only the minute is required.  The others default to "today".
;;;*
(DEFUN SET-ALARM (REASON-FOR-ALARM MINUTE &OPTIONAL (HOUR NIL) (DAY NIL) (MONTH NIL) (YEAR NIL) (SEC 0) &AUX
  DUMMY THIS-HOUR THIS-DAY THIS-MONTH THIS-YEAR UNIVERSAL-TIME)
  (MULTIPLE-VALUE-SETQ (DUMMY DUMMY THIS-HOUR THIS-DAY THIS-MONTH THIS-YEAR)
    (DECODE-UNIVERSAL-TIME (GET-UNIVERSAL-TIME)))
  (SETF HOUR (IF HOUR
	       HOUR
	       THIS-HOUR))
  (SETF DAY (IF DAY
	      DAY
	      THIS-DAY))
  (SETF MONTH (IF MONTH
		MONTH
		THIS-MONTH))
  (SETF YEAR (IF YEAR
	       YEAR
	       THIS-YEAR))
  (SETF UNIVERSAL-TIME (ENCODE-UNIVERSAL-TIME SEC MINUTE HOUR DAY MONTH YEAR))
  (IF (> UNIVERSAL-TIME (GET-UNIVERSAL-TIME))
    (THEN
     (IF (NOT WAKEUP-LIST)
       (THEN (SETF WAKEUP-LIST (LIST (LIST UNIVERSAL-TIME REASON-FOR-ALARM))))
       (ELSE
	(DO* ((INDEX 0 (1+ INDEX))
	      (ITEM (NTH INDEX WAKEUP-LIST) (NTH INDEX WAKEUP-LIST)))
	     ((OR (NOT ITEM) (< UNIVERSAL-TIME (CAR ITEM)))
	      (SETF WAKEUP-LIST
		    (APPEND (FIRSTN INDEX WAKEUP-LIST)
			    (LIST (LIST UNIVERSAL-TIME REASON-FOR-ALARM))
			    (NLEFT (- (LENGTH WAKEUP-LIST) INDEX) WAKEUP-LIST)))))))))) 
  

;1;;-------------------------- RLA*

(DEFPARAMETER days '("Mon" "Tue" "Wed" "Thu" "Fri" "Sat" "Sun"))

(DEFUN check-alarms ()
   (FORMAT *standard-output* "~%==========================~%")
   (FORMAT *standard-output*   "==    CURRENT ALARMS    ==~%")
   (FORMAT *standard-output*   "==========================~%")
   (DOLIST (event wakeup-list)
      (MULTIPLE-VALUE-BIND (sec min hour day mon year day-of-week)
         (TIME:decode-universal-time (FIRST event))
         (FORMAT *standard-output* "~A  ~2,48D-~2,48D-~2,48D  ~2,48D:~2,48D:~2,48D  ~A~%"
                     (NTH day-of-week days) mon day year hour min sec
		     (SECOND event))))
    (FORMAT *standard-output* "==========================~%")
    t)

(DEFUN days-away (d1 d2)
   (IF (<= d1 d2)
      (- d2 d1)
      (+ d2 (- 7 d1))))

(DEFUN SET-WEEKLY-APPT (REASON WEEKDAY HOUR &OPTIONAL (MINUTE 0) &AUX APPT-DAY NOW CURRENT-WEEKDAY CURRENT-DAY
  DAYS-AWAY)
  (IF (SETQ APPT-DAY (POSITION (SUBSEQ (STRING WEEKDAY) 0 3) DAYS :TEST #'STRING-EQUAL))
    (THEN (SETQ NOW (MULTIPLE-VALUE-LIST (DECODE-UNIVERSAL-TIME (GET-UNIVERSAL-TIME))))
     (SETQ CURRENT-WEEKDAY (SEVENTH NOW)) (SETQ CURRENT-DAY (FOURTH NOW))
     (SET-ALARM REASON MINUTE HOUR
      (+ CURRENT-DAY (SETQ DAYS-AWAY (DAYS-AWAY CURRENT-WEEKDAY APPT-DAY)))))
    (ELSE "Invalid day"))) 


(DEFVAR appointments-file nil)
(DEFVAR alarm-expunge t)
(DEFVAR alarm-auto-display t)

(DEFUN alarm-cleanup (&optional (file appointments-file) (keep 2) &aux path current del result)
  (WHEN (AND alarm-expunge (SETQ path (PROBE-FILE file)))
    (SETQ current (SEND path :version))
    (LOOP
        while (> current keep) do
          (UNLESS (ERRORP (SEND (SETQ del (SEND path :new-version (- current keep))) :delete-and-expunge nil))
             (PUSH del result))
          (DECF current)))
  result)

(DEFUN Save-ALARM (REASON-FOR-ALARM 
                  MINUTE
		  &OPTIONAL
		  (HOUR NIL)
		  (DAY NIL)
		  (MONTH NIL)
		  (YEAR NIL)
                  (sec 0))
 (set-alarm reason-for-alarm minute hour day month year sec)
 (WITH-OPEN-FILE (STREAM appointments-file :direction :output :if-exists :append :if-does-not-exist :create)
    (FORMAT stream "(set-alarm ~S ~A ~A ~A ~A ~A ~A)~%" reason-for-alarm minute hour day month year sec))
 (alarm-cleanup) 
 (WHEN alarm-auto-display (check-alarms))
 )

(DEFUN save-weekly-appt (reason weekday hour &optional (minute 0))
  (set-weekly-appt reason weekday hour minute)
  (WITH-OPEN-FILE (STREAM appointments-file :direction :output :if-exists :append :if-does-not-exist :create)
    (FORMAT stream "(set-weekly-appt ~S ~S ~A ~A)~%" reason  weekday hour minute))
 (alarm-cleanup)
 (WHEN alarm-auto-display (check-alarms))
  )


(DEFUN alarm-init (&aux dir)
   (alarm-clock-process)
   (UNLESS appointments-file
      (fs:create-directory (SETQ dir (FORMAT nil "lm:~A.alarm;" user-id)))
      (SETQ appointments-file  (STRING-APPEND dir "appointments.lisp")))
   (alarm-re-init)
   (WHEN alarm-auto-display (check-alarms)))

(DEFUN alarm-re-init (&optional wait)
   (WHEN wait
      (PROCESS-SLEEP 60 "Alarm Re-init"))

   (SETQ wakeup-list nil)
   (LOAD appointments-file :if-does-not-exist nil :verbose nil)

   ;(set-alarm "**SPECIAL**" 59 23 NIL NIL NIL 59)
   )



;1; Go ahead and set things up on load*
(SETQ alarm-clock-process-id nil)	   ;1make sure this guy gets cleared out on a load*
(alarm-init)

