;;; -*- Mode:Zetalisp; Package:user; Base:10; Fonts: MEDFNT,HL12B -*-

(DEFMACRO THEN (&BODY BODY)
  `(PROGN ,@BODY))

(DEFMACRO ELSE (&BODY BODY)
  `(PROGN ,@BODY))

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The WAKEUP-LIST is made up of two entry lists.  The first entry is the universal time
;;; the alarm should go off and the second entry is the reason the person wants to be 
;;; notified.
;;;*
(DEFPARAMETER WAKEUP-LIST NIL "2List of times and reasons*")

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ALARM-TIME is the number of seconds the alarm should ring before turing itself off.
;;;*
(DEFPARAMETER ALARM-TIME 30 "2Number of seconds the alarm should ring*")

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ALARM-CLOCK waits for the wakeup list to get something on it "Alarm not set" and
;;; then waits for the time of the first element on the list to happen "Ticking".  When the
;;; specified time comes, the screen will blink and the beeper beep once every half second
;;; until the TERM key is struck or ALARM-TIME number of seconds pass.  If the TERM key
;;; is struck, a notify window pops up displaying the reason the user gave for wanting to
;;; have the alarm go off.
;;; *
(DEFUN ALARM-CLOCK (
		    &AUX)
  
  (DO-FOREVER
    ()
    
    (PROCESS-WAIT "Alarm not set"
		  #'(LAMBDA ()
		      USER:WAKEUP-LIST))
    
    (PROCESS-WAIT "Ticking"              
		  #'(LAMBDA ()  
		      (> (TIME:GET-UNIVERSAL-TIME) (CAAR USER:WAKEUP-LIST))))
		   
    (DO ((ALARM-COUNT 0 (1+ ALARM-COUNT)))
	((OR TV:KBD-TERMINAL-HAPPENED
             (= ALARM-COUNT (* 2 ALARM-TIME)))
        ;  (IF TV:KBD-TERMINAL-HAPPENED
        ;     (THEN
	  (TV:NOTIFY NIL (CDAR WAKEUP-LIST)))
      (BEEP)
      (PROCESS-SLEEP 30))
    
    (SETF WAKEUP-LIST (CDR WAKEUP-LIST))))

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ALARM-CLOCK-PROCESS starts up the alarm clock process.
;;;*
(DEFUN ALARM-CLOCK-PROCESS ()
   (PROCESS-RUN-FUNCTION "Alarm clock" 'ALARM-CLOCK))

1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; SET-ALARM accepts a text describing why the alarm should go off and the time it should
;;; go off.  The minute, hour, day, month, and year the alarm should go off can be specified
;;; by the user.  Only the minute is required.  The others default to "today".
;;;*
(DEFUN SET-ALARM (REASON-FOR-ALARM 
                  MINUTE
		  &OPTIONAL
		  (HOUR NIL)
		  (DAY NIL)
		  (MONTH NIL)
		  (YEAR NIL)
                  &AUX
		  DUMMY THIS-HOUR THIS-DAY THIS-MONTH THIS-YEAR UNIVERSAL-TIME)
  
  (MULTIPLE-VALUE (DUMMY DUMMY THIS-HOUR THIS-DAY THIS-MONTH THIS-YEAR)
    (TIME:DECODE-UNIVERSAL-TIME (TIME:GET-UNIVERSAL-TIME)))
  
  (SETF HOUR (IF HOUR HOUR THIS-HOUR))
  (SETF DAY (IF DAY DAY THIS-DAY))
  (SETF MONTH (IF MONTH MONTH THIS-MONTH))
  (SETF YEAR (IF YEAR YEAR THIS-YEAR))
  
  (SETF UNIVERSAL-TIME (TIME:ENCODE-UNIVERSAL-TIME 0 MINUTE HOUR DAY MONTH YEAR))
  
  (IF (> UNIVERSAL-TIME (TIME:GET-UNIVERSAL-TIME))
      (THEN
	(IF (NOT WAKEUP-LIST)
	    (THEN
	      (SETF WAKEUP-LIST (LIST (LIST UNIVERSAL-TIME REASON-FOR-ALARM))))
	    (ELSE
	      (DO* ((INDEX 0 (1+ INDEX))
		    (ITEM (NTH INDEX WAKEUP-LIST) (NTH INDEX WAKEUP-LIST)))
		   ((OR (NOT ITEM)
			(< UNIVERSAL-TIME (CAR ITEM)))
		    (SETF WAKEUP-LIST
			  (APPEND (FIRSTN INDEX WAKEUP-LIST)
				  (LIST (LIST UNIVERSAL-TIME REASON-FOR-ALARM))
				  (NLEFT (- (LENGTH WAKEUP-LIST) INDEX) WAKEUP-LIST))))))))))
  
