;;;; -*- Mode:Common-Lisp; Package:User; Fonts:(Medfnt Hl12b); Base:10. -*-

;1;;*
;1;; REVISION HISTORY:*
;1;;   9/12/86, Modified to use :DELETE-AND-EXPUNGE-MULTLIPLE-FILES where possable. LaMott Oren.*
;1;;   5/29/86, Modified to include "DELETE-SELF" and "DELETE-PROTECTED-FILES" option.  Keith Sparacin.*
;1;;*

(DEFUN DELETE-DIRECTORY (PATHNAME
			 &OPTIONAL
			 &KEY
			 (QUERY NIL)
			 (SUBDIRECTORIES T)
			 (DONT-DELETE-NEWEST NIL)
			 (DELETE-PROTECTED-FILES NIL)
			 (DELETE-SELF nil)
			 &AUX DIRECTORY-PATHNAME-AS-FILE)
  "2Delete the files in the specified directory.
PATHNAME is the directory to delete.  The format is \"HOST:DIRECTORY\/IES;*.*\".        
Options available:
:QUERY is T, the caller will be prompted on whether or not to delete each file.
:SUBDIRECTORIES is T, the subdirectories will be deleted as well.
:DONT-DELETE-NEWEST is T, the new version of each file will not be deleted.
:DELETE-PROTECTED-FILES is T, delete protected files will be deleted.
:DELETE-SELF is T, the directory file itself will be deleted.*"
  
  (SETQ query (fs:make-file-query-function query))
  ;1; Delete files and subdirectories.*
  (DELETE-DIRECTORY-FILES PATHNAME QUERY SUBDIRECTORIES DONT-DELETE-NEWEST DELETE-PROTECTED-FILES)
  ;1; Delete the directory itself?*
  (WHEN DELETE-SELF			  
    (SETF DIRECTORY-PATHNAME-AS-FILE	   1; Create "host:x;y.directory" from "host:x.y;".*
	  (SEND (PATHNAME PATHNAME) :DIRECTORY-PATHNAME-AS-FILE))
    (WHEN (FUNCALL query		   ;1Query?, returns :NEVER-ASKED, :PROCEED, T, or NIL.*
		   "~&Delete ~A? "	   
		   (TRUENAME DIRECTORY-PATHNAME-AS-FILE))
      ;1; Would prefer to use (fs:delete-file) over :DELETE, but (fs:delete-file)*
      ;1; doesn't seem to want to delete the directory file.*
      (AND DELETE-PROTECTED-FILES	   
	   (FS:CHANGE-FILE-PROPERTIES (TRUENAME DIRECTORY-PATHNAME-AS-FILE) NIL :DONT-DELETE NIL)) ;1Unprotect*
      (SEND (TRUENAME DIRECTORY-PATHNAME-AS-FILE) :DELETE) ;1DELETE requires truename*
      (SEND DIRECTORY-PATHNAME-AS-FILE :EXPUNGE)))	   ;1EXPUNGE does not???*
  nil)

(DEFUN DELETE-DIRECTORY-FILES (PATHNAME
			       QUERY
			       SUBDIRECTORIES
			       DONT-DELETE-NEWEST
			       DELETE-PROTECTED-FILES
			       &AUX ENTRIES)
  "2Delete the files in the specified directory.
PATHNAME is the directory to delete.  The format is \"HOST:DIRECTORY\/IES;*.*\".        
Options available:
:QUERY is a function for propting the user on whether or not to delete each file.
:SUBDIRECTORIES is T, the subdirectories will be deleted as well.
:DONT-DELETE-NEWEST is T, the new version of each file will not be deleted.
:DELETE-PROTECTED-FILES is T, delete protected files will be deleted.*"
  
  (SETF PATHNAME (PATHNAME PATHNAME))	   ;1 Make the string an object so :EXPUNGE won't object*
  (SETF ENTRIES (DIRECTORY PATHNAME))	   ;1 List of files/directories in the directory*
  
  (LOOP for (entry next-entry) on entries
	for properties = (FS:FILE-PROPERTIES ENTRY)
	for do-delete = nil
	with dir and dir-entry
	do
	(WHEN (GETF (CDR PROPERTIES) :DIRECTORY)   ;1 If it is a directory*
	  (SETF DIR T)
	  (WHEN SUBDIRECTORIES		   ;1... and the caller wants subdirectories deleted*
	    (SETQ DIR-ENTRY (SEND (SEND ENTRY :PATHNAME-AS-DIRECTORY)
				  :NEW-PATHNAME
				  :NAME :WILD
				  :TYPE :WILD
				  :VERSION :WILD))
	    (DELETE-DIRECTORY-FILES DIR-ENTRY QUERY	   ;1... call ourself with the subdirectory as the pathname*
				    SUBDIRECTORIES
				    DONT-DELETE-NEWEST
				    DELETE-PROTECTED-FILES)))
	(WHEN (AND
		(OR (NOT DIR) SUBDIRECTORIES)
		(OR (NOT DONT-DELETE-NEWEST)        
		    (AND next-entry   ;1 Last entry? don't delete since last entry in the directory is the newest*
			 (EQUAL ;1; This is really kludgy... Somebody please rewrite this - lgo.*
			   (STRING-RIGHT-TRIM "0 1 2 3 4 5 6 7 8 9" ENTRY)
			   (STRING-RIGHT-TRIM "0 1 2 3 4 5 6 7 8 9" next-entry)))))
	  
	  (IGNORE-ERRORS		   ;1 If we get an error, don't errror off.  Just continue.*
	    (AND DELETE-PROTECTED-FILES	   ;1 Should we delete protected files?*
		 (GETF (CDR PROPERTIES) :DONT-DELETE)	   ;1Is the file delete protected?*
		 (FS:CHANGE-FILE-PROPERTIES ENTRY NIL :DONT-DELETE NIL))  ;1Passed the tests, unprotect file.*
	    (SETQ do-delete t)))

	when (AND do-delete (FUNCALL query "~&Delete ~A? " entry))
	collect entry into delete-list	1    *;1 Collect the files to be deleted*

	finally
	(WHEN delete-list		   ;1 Delete files by the fastest means*
	  (IF (SEND (FIRST delete-list) :operation-handled-p :delete-and-expunge-multiple-files)
	      (SEND (FIRST delete-list) :delete-and-expunge-multiple-files nil delete-list)
	    (DOLIST (file delete-list)
	      (fs:delete-file file))))
	(SEND PATHNAME :EXPUNGE)))
