 ;;; -*- Mode: LISP; Package: USER; Base: 10; -*-

;; Here is a DESTRUCTURING LET ... because ZETALISP does not yet include one.
;; This is the ELISP version.  Rename it LET! to avoid dialect problems and compiler problems.
;; (The compiler has some built-in knowledge about LET that would screw things up.)

;; This is not based on the Symbolics definition of destructuring LET, so it can be freely exported.
;; -- R.Cohen, Univ. of Texas, August 1983

(DEFMACRO LET! (BINDINGS &BODY FORMS)
  (%%LET! BINDINGS FORMS))

(DEFMACRO CONSP! (OBJ)
  "Returns OBJ if OBJ is LISTP, and NIL otherwise."
  `(LET ((VAL ,OBJ))
     (IF (LISTP VAL)
	 VAL
	 NIL)))

(DEFUN %%LET! (BINDINGS FORMS)
  `((LAMBDA ,(MAPCAN #'(lambda (BINDING) (OR (LISTIFY! (CAR (CONSP! BINDING)))
					(NCONS BINDING)))
		     BINDINGS)
      ,@(MAPCAN #'(lambda (BINDING) (AND (CONSP! (CAR (CONSP! BINDING)))
				    (%%LET0! (CAR BINDING))))
		BINDINGS)
      ,@FORMS)
    ,@(MAPCAN #'(lambda (BINDING) (COND ((ATOM BINDING) (NCONS NIL))
				   ((ATOM (CAR BINDING)) (NCONS (CADR BINDING)))
				   (T (CONS (CADR BINDING)
					    (MAPCAR #'(LAMBDA (IGNORE) NIL)	;CONS up enough NIL's for the extra variables
						    (CDR (LISTIFY! (CAR BINDING))))))))
	      BINDINGS)))

(DEFUN %%LET0! (THING-BEING-BOUND)		;THING-BEING-BOUND may be either an atom or a list to be destructured.
  ((LAMBDA (%%LET-STACK!)
     (DECLARE (SPECIAL %%LET-STACK!))
     (%%LET1! THING-BEING-BOUND) %%LET-STACK!) ()))

(DEFUN %%LET1! (THING-BEING-BOUND)
  (DECLARE (SPECIAL %%LET-STACK!))
  (COND ((ATOM THING-BEING-BOUND) THING-BEING-BOUND)
	(((LAMBDA (Y Z)
	    (SETQ THING-BEING-BOUND (OR Y Z))
	    (AND Y (PUSH `(SETQ ,Y (CAR ,THING-BEING-BOUND)) %%LET-STACK!))
	    (AND Z (PUSH `(SETQ ,Z (CDR ,THING-BEING-BOUND)) %%LET-STACK!))
	    THING-BEING-BOUND)
	  (%%LET1! (CAR THING-BEING-BOUND))
	  (%%LET1! (CDR THING-BEING-BOUND))))))

(DEFUN LISTIFY! (X)
  "Converts a dotted list into a list.  Leaves lists & atoms alone."
    (COND ((NULL X) NIL)
	  ((ATOM X) (LIST X))
	  (T (NCONC (LISTIFY! (CAR X)) (LISTIFY! (CDR X))))))

#| Examples of use: (run m-x macro expand expression on these)

(LET! (((a b c) d)
       (x y)
       z)
  (foo))

(LET! (((a b . c) d)
       (x y)
       z)
  (foo))

|#
