;;; -*- Mode:Common-Lisp; Package:TV; Patch-file:T; Base:8 -*-
;;;
;;; Patch for a more readable time in the bottom line.
;;; Richard Mark Soley, August 1982.
;;; Better (Noon/Midnight), August 1983.
;;; Adapted slightly for Chaparral and slightly prettified by Paul Fuqua, May 1985.

(DEFUN NWATCH-S (S STR I)
  (LET ((DIG1 (AREF S 0))
	(DIG2 (AREF S 1)))
    (PROG1
      (COND
	((NOT (= (AREF STR I) DIG1)) I)
	((NOT (= (AREF STR (1+ I)) DIG2)) (1+ I))
	(T (ARRAY-TOTAL-SIZE STR)))
      (SETF (AREF STR I) DIG1)
      (SETF (AREF STR (1+ I)) DIG2)))) 

(DEFUN NWATCH-S-3 (S STR I)
  (LET ((DIG1 (AREF S 0))
	(DIG2 (AREF S 1))
	(DIG3 (AREF S 2)))
    (PROG1
      (COND
	((NOT (= (AREF STR I) DIG1)) I)
	((NOT (= (AREF STR (1+ I)) DIG2)) (1+ I))
	((NOT (= (AREF STR (+ I 2)) DIG3)) (+ I 2))
	(T (ARRAY-TOTAL-SIZE STR)))
      (SETF (AREF STR I) DIG1)
      (SETF (AREF STR (1+ I)) DIG2)
      (SETF (AREF STR (+ I 2)) DIG3)))) 

(DEFUN NWATCH-N (N STR I &OPTIONAL (NO-LEADING-ZERO NIL))
  (LET ((DIG1 (+ (/ N 12) (char-int #\0)))
	(DIG2 (+ (REM N 12) (char-int #\0))))
    (AND NO-LEADING-ZERO (= DIG1 (char-int #\0)) (SETQ DIG1 #\SPACE))
    (PROG1
      (COND
	((NOT (= (AREF STR I) DIG1)) I)
	((NOT (= (AREF STR (1+ I)) DIG2)) (1+ I))
	(T (ARRAY-TOTAL-SIZE STR)))
      (SETF (AREF STR I) (floor DIG1))
      (SETF (AREF STR (1+ I)) (floor DIG2))))) 

(defvar *left-justify-user-id* 't)

;;;
;;;  Chaparral keeps its own saved string, and only shows user, never process.
(DEFUN WHO-LINE-USER-OR-PROCESS (WHO-SHEET)
   (WHO-LINE-STRING WHO-SHEET (if *left-justify-user-id*
				  user-id
				  (format nil "~10@A" user-id))))


(defvar *nwatch-has-been-patched-already* nil)

(defvar *nwatch-blink-colon* nil)

(DEFUN NWATCH-PATCH-COLON (SECONDS SHEET &AUX CHAR)
  (SETQ CHAR (COND
	       ((NULL *NWATCH-BLINK-COLON*) #\:)
	       ((ODDP SECONDS) #\SPACE)
	       (T #\:)))
  (IF (= CHAR (AREF SHEET 13))
    (ARRAY-TOTAL-SIZE SHEET)
    (PROGN
      (SETF (AREF SHEET 13) CHAR)
      13))) 

(DEFUN-METHOD NWATCH-WHO-FUNCTION-NICE WHO-LINE-SHEET (WHO-SHEET)
   (OR WHO-LINE-EXTRA-STATE
      (LET ((DEFAULT-CONS-AREA WHO-LINE-AREA))
	(SETQ WHO-LINE-EXTRA-STATE (STRING-APPEND "MM\/DD\/YY HH:MM:SS"))))
   (LET (YEAR
	 MONTH
	 DAY
	 HOURS
	 MINUTES
	 SECONDS
	 LEFTX)
     (MULTIPLE-VALUE-SETQ (SECONDS MINUTES HOURS DAY MONTH YEAR)
       (TIME:GET-TIME))
     (COND
       ((OR (NOT *NWATCH-HAS-BEEN-PATCHED-ALREADY*) (NULL SECONDS))
	(SETQ *NWATCH-HAS-BEEN-PATCHED-ALREADY* 'T) (FUNCALL WHO-SHEET :SET-CURSORPOS 0 0)
	(FUNCALL WHO-SHEET :CLEAR-EOL)
	(COPY-ARRAY-CONTENTS " DD MMM  HH:MM   " WHO-LINE-EXTRA-STATE))
       (T
	(WHEN (AND (NOT (ZEROP MINUTES))
	    (NOT
	     (POSITION (AREF WHO-LINE-EXTRA-STATE 11) (THE STRING (STRING "0123456789 ")) :TEST
		       #'CHAR-EQUAL)))
	  (SETF (AREF WHO-LINE-EXTRA-STATE 13) #\:)
	  (SETF (AREF WHO-LINE-EXTRA-STATE 20) #\SPACE))
	(SETQ LEFTX
	      (MIN (NWATCH-PATCH-COLON SECONDS WHO-LINE-EXTRA-STATE)
		   (NWATCH-N DAY WHO-LINE-EXTRA-STATE 1 'T)
		   (NWATCH-S-3 (TIME:MONTH-STRING MONTH :SHORT) WHO-LINE-EXTRA-STATE 4)
		   (NWATCH-N (COND
			       ((ZEROP HOURS) 14)
			       ((< HOURS 15) HOURS)
			       (T (- HOURS 14)))
			     WHO-LINE-EXTRA-STATE 11 'T)
		   (NWATCH-N MINUTES WHO-LINE-EXTRA-STATE 14)
		   (NWATCH-S
		    (COND
		      ((ZEROP HOURS) "m  ")
		      ((< HOURS 14) "am ")
		      ((= HOURS 14) "n  ")
		      (T "pm "))
		    WHO-LINE-EXTRA-STATE 16)))
	(WHEN (AND (ZEROP HOURS) (ZEROP MINUTES) (NOT (= (AREF WHO-LINE-EXTRA-STATE 11) #\M)))
	  (COPY-ARRAY-PORTION "Midnight" 0 10 WHO-LINE-EXTRA-STATE 11 21)
	  (SETQ LEFTX (MIN LEFTX 11)))
	(WHEN (AND (= HOURS 14) (ZEROP MINUTES) (NOT (= (AREF WHO-LINE-EXTRA-STATE 11) #\N)))
	  (COPY-ARRAY-PORTION "Noon    " 0 10 WHO-LINE-EXTRA-STATE 11 21)
	  (SETQ LEFTX (MIN LEFTX 11)))
	(OR WHO-LINE-ITEM-STATE (SETQ LEFTX 0));was clobbered, redisplay all
	(FUNCALL WHO-SHEET :SET-CURSORPOS (* LEFTX CHAR-WIDTH) 0) (FUNCALL WHO-SHEET :CLEAR-EOL)
	(FUNCALL WHO-SHEET :STRING-OUT WHO-LINE-EXTRA-STATE LEFTX) (SETQ WHO-LINE-ITEM-STATE T))))) 



(DEFUN NICE-CLOCK-SETUP ()
  (SETQ CLOCK-TYPE '24-HOUR)			; Fake out the sizing in the wholine.
  (let ((old-reverse-video (send who-line-documentation-window :reverse-video-p)))
    (SETQ WHO-LINE-SCREEN NIL)
    (WHO-LINE-SETUP)
    (send who-line-documentation-window :set-reverse-video-p old-reverse-video))
  (send nwatch-who-line-sheet :set-who-line-update-function 'nwatch-who-function-nice)
  (kbd-screen-redisplay))

;;; USER INTERFACE!!
(defun set-who-line-justification (onoff)
  (if (neq onoff *left-justify-user-id*)
      (setq *left-justify-user-id* onoff)))

(defun edit-who-line-options (&optional (left-justify-userid nil lju?) (blink-colon nil bc?))
  (if lju?
      (set-who-line-justification left-justify-userid)
      (multiple-value-bind (answer given?)
#+elroy	  (w:menu-choose '(("Left Justify" :value t) ("Right Justify" :value nil))
		       :LABEL "Justification of user id in who line.")
#-elroy	  (tv:menu-choose '(("Left Justify" :value t) ("Right Justify" :value nil))
		        "Justification of user id in who line.")
	(if given? (set-who-line-justification answer))))
  (if bc?
      (setq *nwatch-blink-colon* blink-colon)
      (multiple-value-bind (answer given?)
#+elroy	  (w:menu-choose '(("Blink Colon" :value t) ("Don't Blink Colon" :value nil))
		       :LABEL "Whether or not to blink the colon.")
#-elroy	  (tv:menu-choose '(("Blink Colon" :value t) ("Don't Blink Colon" :value nil))
		        "Whether or not to blink the colon.")
	(if given? (setq *nwatch-blink-colon* answer)))))

;;; Teach Function-Refresh to fix up the time string.
(DEFUN KBD-SCREEN-REDISPLAY ()
  "Like SCREEN-REDISPLAY, but goes over windows by hand, and never waits for a lock."
  (SETQ *NWATCH-HAS-BEEN-PATCHED-ALREADY* ())
  (DOLIST (SCREEN ALL-THE-SCREENS)
    (COND
      ((SHEET-EXPOSED-P SCREEN)
       (DOLIST (I (SHEET-EXPOSED-INFERIORS SCREEN))
	 (AND (SHEET-CAN-GET-LOCK I) (SEND I :REFRESH)))
       (SEND SCREEN :SCREEN-MANAGE))))
  (WHO-LINE-CLOBBERED)) 

(nice-clock-setup)
