;;; -*- Mode: ZETALISP; Package: USER; Base: 10; Fonts: MEDFNT, HL12B, HL12BI; -*-
;===============================================================================
;
;   (c) Unpublished Copyright 1985 by Texas Instruments.  All rights reserved.
;
;===============================================================================

;;; 1Created 8/22/85 13:45:42 by LaMott G. OREN*


(defun set-host (host directed-to-host)
  "1Make HOST really be directed-to-host.
 This routine remembers the real host, so you can do (set-host 'host 'host to set it back.*"
  (let* ((host-plist (make-plist (send (si:parse-host host) :network-addresses)))
	 (directed-host-plist (make-plist (send (si:parse-host directed-to-host) :network-addresses)))
	 (chaos-address (or (get directed-host-plist :real-chaos) (get directed-host-plist :chaos))))
    (unless (get host-plist :real-chaos)
      (nconc host-plist (list :real-chaos (get host-plist :chaos))))
    (putprop host-plist chaos-address :chaos)))
