;; -*- Mode:Common-Lisp; Package:TV; Fonts:(CPTFONT HL12B HL12BI); Base:8; Patch-file:T -*-

#|

From WINDOW;WHOLIN.  Written by Steve Ford, hacked up by Tom Ekberg.

This file redefines the function which displays the user-id to also
display the current read-print base and language mode.  This makes these
items very visible to the user.  Previously, one could be uncertain which
mode one was in, without explicitly checking.
|#

(DEFUN WHO-LINE-USER-OR-PROCESS (WHO-SHEET &AUX CURRENT-LANGUAGE CURRENT-PRINT-BASE SG)
  (DECLARE (:SELF-FLAVOR WHO-LINE-SHEET))
  (WHEN (SETQ LAST-WHO-LINE-PROCESS
	 (OR WHO-LINE-PROCESS
	    (AND SELECTED-IO-BUFFER (IO-BUFFER-LAST-OUTPUT-PROCESS SELECTED-IO-BUFFER))))
    (SETQ SG (PROCESS-STACK-GROUP LAST-WHO-LINE-PROCESS))
    (COND
      ((EQ SG %CURRENT-STACK-GROUP)
       (SETQ CURRENT-LANGUAGE SI::*LISP-MODE*
	     CURRENT-PRINT-BASE *READ-BASE*))
      ((TYPEP SG 'STACK-GROUP)
       (SETQ CURRENT-LANGUAGE (SYMEVAL-IN-STACK-GROUP 'SI::*LISP-MODE* SG)
	     CURRENT-PRINT-BASE (SYMEVAL-IN-STACK-GROUP '*READ-BASE* SG)))
      (T (SETQ CURRENT-LANGUAGE SI::*LISP-MODE*
	       CURRENT-PRINT-BASE *READ-BASE*)))
    (WHO-LINE-STRING WHO-SHEET
		     (CONCATENATE 'STRING USER-ID " "
				  (IF (EQ CURRENT-LANGUAGE :ZETALISP)
				    "ZL"
				    "CL")
				  " "
				  (LET ((*NOPOINT NIL)
					(*PRINT-BASE* 12))
				    (FORMAT () "~A" CURRENT-PRINT-BASE)))))) 

