;;; -*- Mode:LISP; Package:USER; Fonts:(MEDFNT HL12B HL12BI); Base:10 -*-

1;;;
;;;      lam2:nichols;cvv-test.lisp
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;*	1                  Choose-Variable-Values Tests
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;*		1If something is worth doing, it's worth doing
;;;*		1   at a higher level of abstraction.
;;;

#|Documentation:

This file contains the global parameters used by the various despike routines.

End documentation|# 

;**********************************************************************************************
;1GLOBALS*

(DEFVAR *D-LENGTH* 9
  "2least mean spuare operator in spn points*")       ;13 <= length <= 99*
(DEFVAR *XSD* 2.5
  "2rejection level in standard deviations*")          ;10.0 < xsd* 
(DEFVAR *NIT* 3
  "2number of iterations to perform*")               ;11 <= nit* 
(DEFVAR *ALPHA* 0.20
  "2exponentioal update rate*")                     ;10.0 < alpha <= 1.0*
(DEFVAR *PER* 10.0
 2 "percentage of avg delta angular reading that is
   acceptable low level acceptance threshold.")  *    ;10.0 <= per*
(DEFVAR *SMOOTH-MENU* nil
  "2menu of smoothing parameters*")
(DEFVAR *S-LENGTH* 9
  "2least mean square operator in spn points*")
(DEFVAR *GRADE* "high"
  "2selection of filter values*")
(DEFVAR grade-doc-string "1\/90 Hz"
  "2who-line documentation for *GRADE**")
(DEFVAR *S-OPT* "yes"
  "2interpolate missing spns?*")
(DEFVAR *FILTER-2* "1\/90 Hz"
  "2value for filter 2*")
(DEFVAR *FILTER-3* "1.25*F2"
  "2value for filter 3*")

(DEFCONST *DESPIKE-PARMS* '(
                          (*D-LENGTH* "Despike Length"
                                      :constraint check-length
                                      "Length must be between 3 and 99"
                                      :documentation
                                      "2least mean spuare operator in spn points*"
                                      :number)
                          (*XSD*      "XSD"
                                      :constraint check-xsd
                                      "must be greater than 0.0"
                                      :documentation
                                      "2rejection level in standard deviations*"
                                      :number)
                          (*NIT*      "NIT"
                                      :constraint check-nit
                                      "NIT must be >= 1"
                                      :documentation
                                      "2number of iterations to perform*"
                                      :number)
                          (*ALPHA*    "Alpha"
                                      :constraint check-alpha
                                      "must be between 0.0 and 1.0"
                                      :documentation
                                      "2exponentioal update rate*"
                                      :number)
                          (*PER*      "Thresh"
                                      :constraint check-per
                                      "must be >= 0.0"
                                      :documentation
                                      2"percentage of avg delta angular reading that is an
acceptable low level acceptance threshold."*
                                      :number)
                          (*SMOOTH-MENU*  "Smooth Menu"
                                          :documentation
                                          "Click here to choose parameters for Smooth"
                                          :side-effect (call-smooth-menu)
                                          :choose ("Smoothing Parameters"))))


(DEFVAR grade-list '(("HIGH" :value "HIGH"
                      :documentation "1\/90 Hz")
                     ("MEDIUM" :value "MEDIUM"
                      :documentaion "1\/180 Hz")))
(DEFCONST *SMOOTH-PARMS* `(
                           (*S-LENGTH* "Smooth Length"
                                       :documentation
                                      2 "least mean square operator in spn points"*
                                       :number)
                           (*GRADE*    "Grade"
                                       :documentation
                                       ,grade-doc-string
                                       :side-effect (update-smooth-filters)
                                       :menu-alist ,grade-list)
                           (*S-OPT*    "Smooth Option"
                                       :documentation
2                                       *         2"interpolate missing spns?"*
                                       :choose ("YES" "NO"))
                           (*FILTER-2* "F2"
                                       :documentation
                                      2 "value for filter 2"*
                                       :any)
                           (*FILTER-3* "F3"
                                       :documentation
                                      2 "value for filter 3"*
                                       :any)))

1;*********************************************************************************************
;METHODS AND FUNCTIONS*


(DEFUN update-smooth-filters (win var new-val old-val)
  "2this function changes the smoothing filters, f2 and f3,
    based on the choice of *GRADE**"
  (SELECTOR *GRADE* EQUAL 
    ("HIGH"   (SETQ *FILTER-2* "1\/90 Hz")
              (SETQ grade-doc-string "1\/90 Hz"))
    ("MEDIUM" (SETQ *FILTER-2* "1\/180 Hz")
              (SETQ grade-doc-string "1\/180 Hz"))
    ("LOW"    (SETQ *FILTER-2* "1\/360 Hz")
              (SETQ GRADE-DOC-STRING "1\/360 Hz"))
    ("VLOW"   (SETQ *FILTER-2* "1\/720 Hz")
              (SETQ GRADE-DOC-STRING "1\/720 Hz"))
    ("ELOW"   (SETQ *FILTER-2* "1\/1440 Hz")
              (SETQ GRADE-DOC-STRING "1\/1440 Hz"))
    ("USER"   (SETQ *FILTER-2* -1.0)
              (SETQ GRADE-DOC-STRING "Choose your own filter values."))
    (otherwise (FERROR nil "Non-existant GRADE - ~S" *GRADE*)))

  (COND ((NUMBERP *FILTER-2*) (SETQ *FILTER-3* -1.0))
        (t (SETQ *FILTER-3* "1.25*F2")))

  (SEND tv:selected-window ':refresh))
  ;(SEND tv:selected-window ':refresh-variable *FILTER-2*)
  ;(SEND tv:selected-window ':refresh-variable *FILTER-3*))



(DEFUN call-despike-menu ()
  "2this actually brings up a cvv menu of the despike parameters*"
  (tv:choose-variable-values *DESPIKE-PARMS*
                             :label "DESPIKE PARAMETERS"))
(DEFUN call-smooth-menu ()
  "2this actually brings up a cvv menu of the smooth parameters*"
  (tv:choose-variable-values *SMOOTH-PARMS*
                             :label "SMOOTH PARAMETERS"))


(DEFUN check-length (new-val)
  (IF (AND (>= new-val 3)
           (<= new-val 99))
      t
    nil))

(DEFUN check-xsd (new-val)
  (IF (> new-val 0.0)
      t
    nil))

(DEFUN check-nit (new-val)
  (IF (>= new-val 1)
      t
    nil))

(DEFUN check-alpha (new-val)
  (IF (AND (> new-val 0.0)
           (<= new-val 1.0))
      t
    nil))

(DEFUN check-per (new-val)
  (IF (>= new-val 0.0)
      t
    nil))