;;; -*- Mode:Common-Lisp; Package:TV; Fonts:(CPTFONT TR10B TR10BI TR10I CPTFONTB); Base:10. -*-

(defvar 4scroll-bar-tester* nil "2Contains the window tester frame instance.*")

(defun 4user:scroll-bar-test* ()
  (WHEN scroll-bar-tester (SEND scroll-bar-tester :kill))
  (SETQ scroll-bar-tester (MAKE-INSTANCE 'scroll-bar-test-window))
  (SEND scroll-bar-tester :select))  

(DEFFLAVOR 4scroll-bar-test-window *()
           (w:essential-window
            w:borders-mixin)
  :gettable-instance-variables
  :settable-instance-variables
  :inittable-instance-variables
  )
    

(defflavor 4scroll-bar-test-interactor* ()
	   (UCL:COMMAND-AND-LISP-TYPEIN-WINDOW
	    PREEMPTABLE-READ-ANY-TYI-MIXIN NOTIFICATION-MIXIN
	    AUTOEXPOSING-MORE-MIXIN tv:AUTO-SCROLLING-MIXIN WINDOW))

(defflavor 4dynamic-multicolumn-command-menu* ()
	   (dynamic-multicolumn-mixin command-menu))

(defflavor 4scroll-bar-test-display-pane* ()
           (borders-mixin
	    centered-label-mixin
	    top-label-mixin
	    box-label-mixin
            text-scroll-window
	    w:scroll-bar-mixin
	    w:window)
  :gettable-instance-variables
  (:documentation "3The display pane for the window tester.*")
  (:default-init-plist
    :border-margin-width 2))

(defflavor 4scroll-bar-test-frame*
	   ()
	   (ucl:command-loop-mixin
	    FULL-SCREEN-HACK-MIXIN
	    FRAME-DONT-SELECT-INFERIORS-WITH-MOUSE-MIXIN
	    BASIC-CONSTRAINT-FRAME CONSTRAINT-FRAME-FORWARDING-MIXIN
	    BORDERS-MIXIN LABEL-MIXIN BASIC-FRAME)
  :gettable-instance-variables
  (:default-init-plist
    :active-command-tables '(scroll-bar-test-cmd-table)
    :all-command-tables '(scroll-bar-test-cmd-table)
    :menu-panes '((menu scroll-bar-test-menu))
    :typein-handler :handle-typein-input
    :save-bits nil
    :border-margin-width 0))


(DEFMETHOD 4(scroll-bar-test-frame :before :INIT*) (ignore &aux io-buffer) 
  (SETQ io-buffer (MAKE-DEFAULT-IO-BUFFER)
	panes `((interactor scroll-bar-test-interactor
			    :label nil
			    :io-buffer ,io-buffer)
		(menu dynamic-multicolumn-command-menu
		      :font-map ,(list fonts:cptfont)
		      :item-list nil
		      :column-spec-list nil
		      :io-buffer ,io-buffer)
		(display scroll-bar-test-display-pane
			 :label (:string "3Default scroll-bar*" :font hl12bi)
			 :io-buffer ,io-buffer)
		(display2 scroll-bar-test-display-pane
			 :label (:string "3Width = 21. Height = 23.*" :font hl12bi)
			 :io-buffer ,io-buffer
			 :scroll-bar-icon-width 21.
			 :scroll-bar-icon-height 23.)
		(display3 scroll-bar-test-display-pane
			 :label (:string "3Mode = :minimum*" :font hl12bi)
			 :io-buffer ,io-buffer
			 :scroll-bar-mode :minimum)
		(display4 scroll-bar-test-display-pane
			 :label (:string "3Mode = :maximum*" :font hl12bi)
			 :io-buffer ,io-buffer
			 :scroll-bar-mode :maximum)
		(display5 scroll-bar-test-display-pane
			 :label (:string "3Side = :right*" :font hl12bi)
			 :io-buffer ,io-buffer
			 :scroll-bar-side :right)
		(display6 scroll-bar-test-display-pane
			 :label (:string "3Width = 0*" :font hl12bi)
			 :io-buffer ,io-buffer
			 :scroll-bar-icon-width 0)
		(display7 scroll-bar-test-display-pane
			 :label (:string "3Icon Height = 0*" :font hl12bi)
			 :io-buffer ,io-buffer
			 :scroll-bar-icon-height 0)
		(display8 scroll-bar-test-display-pane
			 :label (:string "3W = 5 H = 7*" :font hl12bi)
			 :io-buffer ,io-buffer
			 :scroll-bar-icon-width 5
			 :scroll-bar-icon-height 7)
		(display9 scroll-bar-test-display-pane
			 :label (:string "3No Edge*" :font hl12bi)
			 :io-buffer ,io-buffer
			 :scroll-bar-draw-edge-p nil
			 :label-box-p nil))
	constraints '((main . ((display menu interactor)
			       ((interactor 6. :lines))
			       ((menu 5 :lines)) ;1; :ask :pane-size does not work for multicolumn menus.*
			       ((display :even))))
		      (scroll-bar . ((display-panes+menu interactor)
				     ((interactor 6. :lines))
				     ((display-panes+menu
					:horizontal (:even)
					(display+menu display23456789)
					((display+menu
					   :vertical (:even)
					   (display menu)
					   ((menu 5 :lines))
					   ((display :even)))
					 (display23456789
					   :vertical (:even)
					   (display2345 display6789)
					   ((display2345
					      :horizontal (:even)
					      (display23 display45)
					      ((display23
						 :vertical (:even)
						 (display2 display3)
						 ((display2 :even)
						  (display3 :even)))
					       (display45
						 :vertical (:even)
						 (display4 display5)
						 ((display4 :even)
						  (display5 :even)))))
					    (display6789
					      :horizontal (:even)
					      (display67 display89)
					      ((display67
						 :vertical (:even)
						 (display6 display7)
						 ((display6 :even)
						  (display7 :even)))
					       (display89
						 :vertical (:even)
						 (display8 display9)
						 ((display8 :even)
						  (display9 :even)))))))))))))))

(defvar 4scroll-bar-test-item-list* nil)
(setq scroll-bar-test-item-list
      (append 
	'("3This is a frame for testing the scroll-bar.*"
	  "3Each pane has a scroll-bar of different parameters.*"
	  "3Look at all the panes and see if they look right.*"
	  "3Test each of the clicks described in the who-line.*"
	  "3Try invoking the scroll-bar in each pane.*"
	  "3Execute the ITEMS command and repeat.*"
	  "3Scroll-bar functions should not be available*"
          "3 when there is nothing to scroll.*")
	(let (list)
	  (dotimes (index 100. list)
	    (setq list (cons index list))))))

(DEFMETHOD 4(scroll-bar-test-frame :AFTER :INIT*) (IGNORE)
  "2Select the interaction pane.*"
  (send self :set-all-item-lists scroll-bar-test-item-list)  
  (send self :set-configuration 'scroll-bar)
  (SEND (SEND self :get-pane 'interactor) :select))

(DEFMETHOD 4(scroll-bar-test-frame :set-all-item-lists*) (list)
  "2Select the interaction pane.*"
  (send (send self :get-pane 'display) :set-items list)
  (send (send self :get-pane 'display2) :set-items list)
  (send (send self :get-pane 'display3) :set-items list)
  (send (send self :get-pane 'display4) :set-items list)
  (send (send self :get-pane 'display5) :set-items list)
  (send (send self :get-pane 'display6) :set-items list)
  (send (send self :get-pane 'display7) :set-items list)
  (send (send self :get-pane 'display8) :set-items list)
  (send (send self :get-pane 'display9) :set-items list))

(DEFMETHOD 4(scroll-bar-test-frame :DESIGNATE-IO-STREAMS*) ()
  "2Redefine this UCL method to set up the correct i/o bindings.*"
  (SETQ *terminal-io* (SEND SELF :get-pane 'interactor)
	*standard-input* *terminal-io*
	*standard-output* *terminal-io*))

(DEFCOMMAND 4(scroll-bar-test-frame :config*) ()
  '(:DESCRIPTION "3Switch to a different configuration.*"
    :NAMES "3Config*"
    :KEYS (#\hyper-c))
  (if (string-equal (send self :configuration) 'main)
      (send self :set-configuration 'scroll-bar)
      (send self :set-configuration 'main)))

(DEFCOMMAND 4(scroll-bar-test-frame :items*) ()
  '(:DESCRIPTION "3Switch to a different item list.*"
    :NAMES "3Items*"
    :KEYS (#\control-i))
  (if (> (length (send (send self :get-pane 'display) :items)) 4)
      (send self :set-all-item-lists '(1 2 3 4))
      (send self :set-all-item-lists scroll-bar-test-item-list)))

(defvar 4draw-cmds* nil)
(defvar 4label-cmds* nil)
(defvar 4output-cmds* nil)
(defvar 4misc-cmds* '(:config))
(defvar 4scroll-bar-cmds* '(:items))

(build-command-table 'scroll-bar-test-cmd-table 'scroll-bar-test-frame
  (append draw-cmds label-cmds misc-cmds output-cmds scroll-bar-cmds))


(let ((item-list nil))
  (dolist (item Scroll-bar-cmds)
    (setq item-list (cons (list item :column "3Scroll-bar*") item-list)))
  (dolist (item misc-cmds)
    (setq item-list (cons (list item :column "3Misc*") item-list)))
  (dolist (item draw-cmds)
    (setq item-list (cons (list item :column "3Drawing*") item-list)))
  (dolist (item label-cmds)
    (setq item-list (cons (list item :column "3Labels*") item-list)))
  (dolist (item Output-cmds)
    (setq item-list (cons (list item :column "3Output*") item-list)))
  (BUILD-MENU 'scroll-bar-test-menu 'scroll-bar-test-frame
	    :column-list-order
	    '(("3Scroll-bar*" :font fonts:hl10b)
	      ("3Misc*" :font fonts:hl10b)
	      ("3Drawing*" :font fonts:hl10b)
	      ("3Labels*" :font fonts:hl10b)
	      ("3Output*" :font fonts:hl10b))
	    :item-list-order item-list))


;1(scroll-bar-test)