;;; -*- Mode:Common-Lisp; Package:USER; Fonts:(CPTFONT HL12B HL12BI); Base:10 -*-

1;;;
;;; Description:  Test suite for window :draw methods and %draw-character function
;;;*

(DEFVAR  NUMBER-OF-RANDOM-REPETITIONS 100)

(defvar dg-message-window nil)
(defvar dg-test-window nil)
(defvar dg-x-array (make-array 20. :type :art-fix))
(defvar dg-y-array (make-array 20. :type :art-fix))
(defvar dg-bitblt-array nil)
(defvar dg-all-colors (LIST 0 1 2 3 4 5 6 7 8 nil w:black w:white))
(defvar dg-various-thicknesses '(1 32 997))

(defun random-x () (- (random 800.) 50.))
(defun random-y () (- (random 450.) 50.))

(defun rect-height () (random 100.))
(defun rect-width () (random 100.))

  
(defun random-x-near (x) (+ x (- (random 50.) 25.)))
(defun random-y-near (y) (+ y (- (random 50.) 25.)))
  

(defun random-theta () (random 720.0))
(defun random-sides () (* (random 20.) (expt -1 (random 2))))
  
(defun random-height () (- (random 200.) 100.))
(defun random-width () (- (random 200.) 100.))

(DEFUN dg-random-array ()
  (LET* ((n     (RANDOM 2047))
	 (array (MAKE-ARRAY (1+ n))))
    (LOOP for i from 0 to n
	  do (SETF (AREF array i) (random-x))
	  )
    array
    )
  )

(defun dg-initialize-test (string)
  ;(prepare-test-case string)
  ;(INCF user:*number-of-tests-attempted*)
  (dg-display-message string)
  )

(DEFUN dg-display-message (string)
  (send dg-test-window :expose)
  (send dg-test-window :refresh)
  (send dg-message-window :expose)
  (format dg-message-window string)
  (format dg-message-window "~%")
  )

(DEFUN dg-point-inside-p (x y left top right bottom)
  "2Return non-nil iff (x,y) is inside the given rectangle.*"
  (AND (> x left) (< x right) (> y top) (< y bottom))
  )

(setq dg-test-window (make-instance 'w:window
                                    :deexposed-typeout-action :expose
                                    :edges '(100. 450. 800. 700.)
                                    :border-margin-width 25.
                                    :label "Test window with wide border margin"))
  

(setq dg-message-window (make-instance 'w:window
                                       :deexposed-typeout-action :expose
                                       :edges '(100. 100. 800. 400.)
                                       :border-margin-width 5
                                       :label "Message window"
                                       :more-p nil))
  
(DEFUN char-test ()
  (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
    (send dg-test-window :draw-char fonts:cptfont #o117
	  (random-x) (random-y))
    (send dg-test-window :draw-char fonts:bigfnt #o117
	  (random-x) (random-y))))

(DEFUN point-test ()
  (SETQ NUMBER-OF-RANDOM-REPETITIONS 1000)  

  (DO* ((all-pixel-values '(0 1)                   (CDR all-pixel-values))
	(pixel-value      (CAR all-pixel-values)   (CAR all-pixel-values)))
       ((NULL all-pixel-values))
    (DECLARE (SPECIAL  pixel-value))    
;    (dg-initialize-test
;      (FORMAT nil "Test (:method w:graphics-mixin :draw-point), pixel-value ~a" pixel-value))
    
    (MULTIPLE-VALUE-BIND (left top right bottom) (SEND  dg-test-window :inside-edges)
      (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
	(LET ((point-x (random-x))
	      (point-y (random-y)))
	  (DECLARE (SPECIAL point-x point-y))
	  (send dg-test-window :draw-point
		point-x    point-y
		w:alu-seta pixel-value)
;	  (IF (dg-point-inside-p point-x point-y left top right bottom)
;	      (compare-safely = (SEND dg-test-window :point point-x point-y) pixel-value)
;	      (compare-safely = (SEND dg-test-window :point point-x point-y) 0)
;	      )
          )))))

(DEFUN line-test ()
  (SETQ NUMBER-OF-RANDOM-REPETITIONS 100)
  
  (DOLIST (color dg-all-colors)
    (DOLIST (thickness dg-various-thicknesses)
      (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-line), color ~a, thickness ~a"
		color thickness))
      
      (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
	(send dg-test-window :draw-line
	      (random-x) (random-y)
	      (random-x) (random-y)
	      thickness color
	      ))
      (PROCESS-SLEEP 100))))

(DEFUN lines (thickness color)
  (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
	(send dg-test-window :draw-line
	      (random-x) (random-y)
	      (random-x) (random-y)
	      thickness color
	      )))

(DEFUN poly-test ()
    (SETQ NUMBER-OF-RANDOM-REPETITIONS 10)

  (DOLIST (color dg-all-colors)
    (DOLIST (thickness dg-various-thicknesses)

  (dg-initialize-test
    (FORMAT nil "Test (:method w:graphics-mixin :draw-polyline), color ~a, thickness ~a"
		color thickness))
  
  (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
    (send dg-test-window :draw-polyline
	  (dg-random-array) (dg-random-array)
	  thickness         color
	  )))))

(DEFUN arc-test ()
    (SETQ NUMBER-OF-RANDOM-REPETITIONS 100)

  (DOLIST (color dg-all-colors)
    (DOLIST (thickness dg-various-thicknesses)
      
      (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-arc), color ~a, thickness ~a"
		color thickness))
      
      (dotimes (n NUMBER-OF-RANDOM-REPETITIONS)
	  (send dg-test-window :draw-arc
		0          0
		(random-x) (random-y)
		(random-theta)
		thickness         color)))))

1;;;
;;; Test :draw-cubic-spline
;;;*

(DEFUN cubic-spline-test ()
  (SETQ  NUMBER-OF-RANDOM-REPETITIONS 10)

  (DOLIST (color dg-all-colors)
    (DOLIST (thickness dg-various-thicknesses)
      
      (dg-initialize-test
	(FORMAT nil "Test (:method w:graphics-mixin :draw-cubic-spline), color ~a, thickness ~a"
		color thickness))
      
      (dotimes (x NUMBER-OF-RANDOM-REPETITIONS)
	(dotimes (z 20.)
	  (aset (random-x) dg-x-array z)
	  (aset (random-y) dg-y-array z))
	(send dg-test-window :draw-cubic-spline
	      dg-x-array dg-y-array 4.
	      thickness  color
	      w:alu-seta
	      :relaxed :relaxed)
	(dotimes (z 20.)
	  (aset (random-x) dg-x-array z)
	  (aset (random-y) dg-y-array z))
	(send dg-test-window :draw-cubic-spline
	      dg-x-array dg-y-array 4.
	      thickness  color  
	      w:alu-seta
	      :clamped :clamped 0 0.5 0.75 1.0)))))
  
(DEFUN farc-test (angle)
  (LET* 
    ((mid-x  (ROUND (- (w:sheet-inside-right dg-test-window)
                       (w:sheet-inside-left dg-test-window)) 2))
     (mid-y  (ROUND (- (w:sheet-inside-bottom dg-test-window)
                       (w:sheet-inside-top dg-test-window)) 2))
     (start-x (+ mid-x (ROUND (MIN (w:sheet-inside-height dg-test-window)
                                   (w:sheet-inside-width dg-test-window))
                              4))))
    (send dg-test-window :draw-filled-arc
          mid-x      mid-y
          start-x    mid-y
          angle)))

(defun draw-circle (x-center y-center radius num-points &optional (window tv:selected-window))
;  (declare (special my-window))
;  (unless (boundp 'my-window)
;    (setq my-window (w:make-instance 'w:window)))
;    (if (not (send my-window :exposed-p))
;    (send my-window :expose))
  (send window :draw-circle x-center y-center radius
                               2 w:black w:normal num-points)
 )    

(DEFUN dfr (&optional (window w:selected-window))
  (LET* ((mid-x  (ROUND
                   (- (w:sheet-inside-right window)
                      (w:sheet-inside-left window)) 2))
         
         (mid-y  (ROUND
                   (- (w:sheet-inside-bottom window)
                      (w:sheet-inside-top window)) 2))
	 )   
    (send window :draw-filled-rectangle
          100 400 mid-x mid-y
          w:black w:alu-seta t)                       ;draw edges
    (send window :draw-filled-rectangle
          100 400 mid-x mid-y
          w:black w:alu-xor nil)                      ;erase interior
    ))

(DEFUN dfp (nsides &optional (window w:selected-window))
  (LET* ((mid-x  (ROUND (- (w:sheet-inside-right window)
                           (w:sheet-inside-left window)) 2))
         (mid-y  (- (ROUND (- (w:sheet-inside-bottom window)
                           (w:sheet-inside-top window)) 2) 100)))   
    (SEND window :draw-regular-polygon
	  mid-x mid-y (+ mid-x 64) (+ mid-y 64) nsides w:black w:alu-seta t)      ;draw edges
    (PROCESS-SLEEP 150)
    (SEND window :draw-regular-polygon
	  mid-x mid-y (+ mid-x 64) (+ mid-y 64) nsides w:black w:alu-xor nil)     ;erase interior
    ))

