/*
 * interp.h
 *
 * macroinstruction interpreter interface
 */

#ifndef INTERP_H
#define INTERP_H

int step_miscop(u16 opcode);
u32 ppss_mask(int ppss);
int ppss_position(int ppss);
int ppss_numbits(int ppss);
u16 get_opcode(void);
int step_auxop(u16 opcode);
int step(void);
void do_branch(u16 opcode);

lisp_q load_target(u16 opcode);
void store_target(u16 opcode, lisp_q value);
lisp_q locative_target(u16 opcode);

int fixnum_value(lisp_q fixnum);
u32 positive_integer_value(lisp_q x);

/* FIXME: These next three probably belong in a separate header */
int math_plus(lisp_q src1, lisp_q src2);
int math_minus(lisp_q src1, lisp_q src2);
int math_times(lisp_q src1, lisp_q src2);

int ldb_generic(lisp_q val, u32 mask, int pos, int bits, lisp_q *result);

int resolve_aref(lisp_q array, int num_dims, int force, lisp_q dimptr,
		 lisp_q *header, lisp_q *locative, int *offset);
int read_aref(lisp_q header, lisp_q locative, int offset, lisp_q *destination, int cl_ar);
int write_aref(lisp_q header, lisp_q locative, int offset, lisp_q value);

lisp_q equal(lisp_q foo, lisp_q bar);


#endif /* INTERP_H */

/* EOF */
