#include <iostream.h>
#include <unistd.h>
#include <stdlib.h>

#include "band.h"

e3Band::e3Band(char *band_to_load)
{
  load_band = new ifstream(band_to_load, ios::in);

  if (!load_band)
    {
      cerr << "cannot open " << band_to_load << endl;
      abort();
    }
}

e3Band::~e3Band()
{
  cout << "e3Band::~e3Band" << endl;
  close();
}

void e3Band::close(void)
{
  if (load_band)
    {
      load_band->close();
      load_band = NULL;
    }
}

/*
 * 
 */

class e3DPMTEntry
{
public:
  e3DPMTEntry(e3Word word1, e3Word word2);

  void dump(ostream &os) const;

  e3u16 sa;
  e3u16 device_a;
  e3u16 sb;
  e3u16 device_b;
  e3u16 device_assignment_bit_map;

  e3u16 device_a_offset;
  e3u16 device_b_offset;
};

e3DPMTEntry::e3DPMTEntry(e3Word word1, e3Word word2)
{
  sa = (word1.getBits() >> 29);
  device_a = (word1.getBits() >> 24) & 0x1f;

  sb = (word1.getBits() >> 21) & 0x7;
  device_b = (word1.getBits() >> 16) & 0x1f;

  device_assignment_bit_map = (word1.getBits() & 0xffff);

  device_a_offset = (word2.getBits() >> 16);
  device_b_offset = (word2.getBits() & 0xffff);
}

void e3DPMTEntry::dump(ostream &os) const
{
  os << hex;

  os << "sa=" << sa ;
  os << " device_a=" << device_a ;
  os << " sb=" << sb ;
  os << " device_b=" << device_b ;
  os << " device_assignment_bit_map=" << device_assignment_bit_map ;

  os << " device_a_offset=" << device_a_offset ;
  os << " device_b_offset=" << device_b_offset ;
}



/*
 *
 */

#define REGION_QUANTUM_SIZE_IN_PAGES 64
#define NUM_REGIONS                  2048

void e3Band::dumpRegions(void)
{
  e3WordAddr table_start = NUM_REGIONS;

  for (e3WordAddr r=0; r<NUM_REGIONS; r++)
    {
      e3WordAddr origin_addr = table_start + r;
      e3WordAddr length_addr = NUM_REGIONS + origin_addr;
      e3WordAddr bits_addr = NUM_REGIONS + length_addr;
      e3WordAddr free_pointer_addr = NUM_REGIONS + bits_addr;
      e3WordAddr gc_pointer_addr = NUM_REGIONS + free_pointer_addr;
      e3WordAddr list_thread_addr = NUM_REGIONS + gc_pointer_addr;

      e3Word origin = readWord(origin_addr);
      e3Word length = readWord(length_addr);
      e3Word bits = readWord(bits_addr);
      e3Word free_pointer = readWord(free_pointer_addr);
      e3Word gc_pointer = readWord(gc_pointer_addr);
      e3Word list_thread = readWord(list_thread_addr);

      cout << "r = " << r << endl;
      cout << "  origin       = " << origin << endl;
      cout << "  length       = " << length << endl;
      cout << "  bits         = " << bits << endl;
      cout << "  free_pointer = " << free_pointer << endl;
      cout << "  gc_pointer   = " << gc_pointer << endl;
      cout << "  list_thread  = " << list_thread << endl;

#ifdef NOTDEF
      if (r == 9) dpmt = origin;
#endif
    }

#ifdef NOTDEF
  /* Stroll through the DPMT. */
  {
    e3u32 origin_address = dpmt.getPointer();
    cout << "origin_address = " << origin_address << endl;
#ifdef NOTDEF
    dump(cout, origin_address, 0x2000);
#endif

    for (e3u32 cluster_number=0; cluster_number<0x1000; cluster_number++) // Going in pairs.
      {
	e3Word word1 = readWord(origin_address + (cluster_number * 2));
	e3Word word2 = readWord(origin_address + (cluster_number * 2) + 1);

	e3DPMTEntry e(word1, word2);

	cout << cluster_number << ": ";
	e.dump(cout);
	cout << endl;
      }  
  }
#endif
}

#define PAGE_SIZE_IN_WORDS        512
#define PAGE_CLUSTER_SIZE          16
#define CLUSTER_SIZE_IN_WORDS    8192
#define CLUSTER_SIZE_IN_BLOCKS     32
#define PAGE_SIZE_IN_BYTES       2048
#define BYTES_IN_A_DISK_BLOCK    1024
#define WORDS_IN_A_DISK_BLOCK     256
#define DISK_BLOCKS_PER_PAGE        2


/*
 * $$$$$$$$$$ Fails to check bitmap.
 */

e3WordAddr e3Band::loadCluster(e3MemMap *m, e3u32 vaddr_clusternum, e3u32 disk_clusternum)
{
  e3WordAddr vaddr = vaddr_clusternum * CLUSTER_SIZE_IN_WORDS;
  e3u32 diskwordnum = disk_clusternum * CLUSTER_SIZE_IN_BLOCKS * WORDS_IN_A_DISK_BLOCK;

#ifdef NOTDEF
  cout << hex << "vaddr_clusternum " << vaddr_clusternum << " <== " << disk_clusternum << endl;
  cout << hex << "vaddr " << vaddr << " <== " << diskwordnum << endl;
#endif

  {
    char *to = (char *)&(m->myWord[vaddr]);

    load_band->seekg(sizeof(e3Word) * diskwordnum);

    load_band->read(to, CLUSTER_SIZE_IN_WORDS * sizeof(e3Word));
  }

  return(vaddr - 1);
}

e3WordAddr e3Band::loadClusters(e3MemMap *m, e3u32 origin_address)
{
  e3WordAddr highest_address = 0;

  /* $ For some reason, these clusters aren't valid in the DPMT (?!?!?!?). */
  loadCluster(m, 0, 0);
  loadCluster(m, 1, 1);
  loadCluster(m, 2, 2);

  for (e3u32 cluster_number=0; cluster_number<0x1000; cluster_number++) // Going in pairs.
    {
      e3Word word1 = readWord(origin_address + (cluster_number * 2));
      e3Word word2 = readWord(origin_address + (cluster_number * 2) + 1);

      e3DPMTEntry e(word1, word2);

      if (e.device_assignment_bit_map)
	{
#ifdef NOTDEF
	  cout << hex << cluster_number << ": ";
	  e.dump(cout);
	  cout << endl;
#else
 //	  cout << "Loading cluster " << hex << cluster_number << " of " << 0x1000 << endl;
#endif
	  highest_address = loadCluster(m, cluster_number, e.device_b_offset);
	}
    }  

  return(highest_address);
}
  


e3WordAddr e3Band::load(e3MemMap *m)
{
#ifdef NOTDEF
  dumpRegions();
#endif

  e3Word dpmt = readWord(NUM_REGIONS + 9);
  e3u32  origin_address = dpmt.getPointer();

  cout << "origin_address = " << hex << origin_address << endl;

  e3WordAddr highest_virtual_address = loadClusters(m, origin_address);

  close();
  cout << "Done!" << endl;

  return(highest_virtual_address);
}

e3Word e3Band::readWord(e3WordAddr a)
{
  size_t offset = sizeof(e3Word) * a;

#ifdef NOTDEF
  cout << "e3Band::readWord(" << hex << a << ")" << endl;
#endif

  load_band->seekg(offset);

  if (load_band->bad())		// Sought past EOF.
    {
      abort();
    }
  else
    {
      e3Word tmp;
      *load_band >> tmp;
      return(tmp);
    }
}

void e3Band::dump(ostream &os, e3WordAddr start_addr, e3u32 length)
{
  os << "e3Band::dump --" << endl;

  for (e3u32 i=start_addr; i<(start_addr + length); i++)
    {
      e3Word tmp = readWord(i);

      /* Print the word address. */
      os << hex;
      os.fill('0');
      os.width(8);
      os << i << ": ";

      /* Print the contents. */
      os << tmp << endl;
    }

  close();
  os << "Done!" << endl;
}
