#ifndef E3BAND_H
#define E3BAND_H

#include <fstream.h>
#include "memmap.h"

class e3Band
{
 public:

  e3Band(char *band_to_load);
  ~e3Band();

  e3WordAddr  load(e3MemMap *m);
  e3Word      readWord(e3WordAddr a);
  void         dump(ostream &os, e3WordAddr start_addr, e3u32 length);

 private:

  e3WordAddr  loadClusters(e3MemMap *m, e3u32 origin_address);
  e3WordAddr  loadCluster(e3MemMap *m, e3u32 vaddr_clusternum, e3u32 disk_clusternum);
  void         dumpRegions(void);
  void         close(void);

  ifstream *load_band;
};




#endif /* E3BAND_H */
