#include <iostream.h>
#include <fstream.h>
#include <unistd.h>

#include "band.h"
#include "lispm.h"

/*
 *
 */

e3LispM::e3LispM()
  : e3MacroOpCodeEngine()
{
  ;
}

e3LispM::~e3LispM()
{
  cout << "e3LispM::~e3LispM" << endl;
}

void e3LispM::runMainLoop(void)
{
  cout << "e3LispM::runMainLoop" << endl;

  setInitialStateFromScratchPadInitArea();

#ifndef NOTDEF
  e3WordAddr initial_fef_header_addr = myDTPFunction.getPointer();
  disassembleMemory(initial_fef_header_addr, 1);
  dumpMemory(initial_fef_header_addr, 12);

  e3WordAddr five = readWord(initial_fef_header_addr+5).getPointer();
  cout << "FIVE" << endl;
  disassembleMemory(five, 1);

  e3WordAddr six = readWord(initial_fef_header_addr+6).getPointer();
  cout << "SIX" << endl;
  disassembleMemory(six, 1);
#endif

  while (runMacroOpCode())
    {
      ;
    }
}


int e3LispM::loadBand(char *band_to_load)
{
  cout << "Loading band \"" << band_to_load << "\"" << endl;

  e3Band band(band_to_load);

  myNumberOfWordsLoaded = band.load(this);

#ifdef NOTDEF
  findNIL();
#endif

#ifdef NOTDEF
  dumpInterestingAreas();
#endif

  return(1);
}

