#include <iostream.h>

#include <stdio.h>		// temporarily for printf
#include <stdlib.h>		// temporarily for abort

#include "memobj.h"

/*
 *
 */

/*
 *
 */

memObj::memObj(e3WordAddr a)
{
  myWordAddress = a;
}

memObj::~memObj()
{
  ;
}

e3u32 memObj::sizeOfInWords(void) const
{
  return(1);
}

e3Word memObj::readMe(void) const
{
  e3Word retval = lispm->readWord(myWordAddress);
  return(retval);
}

e3Word memObj::readWordAt(e3WordAddr addr) const
{
  e3Word retval = lispm->readWord(addr);
  return(retval);
}


void memObj::dump(ostream &os) const
{
  os << readMe() << endl;
}

/*
 *
 */

memTrap::memTrap(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_TRAP, "memTrap::memTrap -- not E3_DTP_TRAP");
}

/*
 *
 */

memList::memList(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_LIST, "memList::memList -- not E3_DTP_LIST");
}

e3u32 memList::sizeOfInWords(void) const
{
  e3Word w = readMe();
  e3CdrCode cdr_code = w.getCdrCode();

  switch (cdr_code)
    {
    case E3_CDR_CODE_NORMAL:
      return(2);
    case E3_CDR_CODE_ERROR:
      {
	cerr << "memList::sizeOfInWords -- attempt to get size of 2nd half of normal cons cell" << endl;
	return(1);
      }
    case E3_CDR_CODE_NIL:	// cdr-coded list of length 1?
      return(1);
    case E3_CDR_CODE_NEXT:	// Walk array, keeping track of length.  Return upon hitting nil.
      {
	e3u32 retval = 0;
	e3WordAddr cdr_coded_list_address = myWordAddress;

	while (1)
	  {
	    e3Word bar = readWordAt(cdr_coded_list_address++);
	    retval++;
	    
	    if (bar.getCdrCode() == E3_CDR_CODE_NIL)
	      {
		break;
	      }
	  }

	return(retval);
      }
    default:
      {
	cerr << "memList::sizeOfInWords -- bad cdr code in list = " << (int)cdr_code << endl;
	return(1);
      }
    }
}

void memList::dump(ostream &os) const
{
  e3Word w = readMe();
  e3CdrCode cdr_code = w.getCdrCode();

  os << "E3_DTP_LIST" << endl;

  switch (cdr_code)
    {
    case E3_CDR_CODE_NORMAL:
      {
	e3Word car = readMe();
	e3Word cdr = readWordAt(myWordAddress+1);

	os << "          car = " << car << endl;
	os << "          cdr = " << cdr << endl;
      }
      break;

    case E3_CDR_CODE_ERROR:
      {
	cerr << "memList::dump -- attempt to dump 2nd half of normal cons cell" << endl;
	os << "          cdr = " << w << endl;
      }
      break;

    case E3_CDR_CODE_NIL:	// cdr-coded list of length 1?
      {
	os << "          cdr-coded car length 1 = " << w << endl;
      }
      break;

    case E3_CDR_CODE_NEXT:	// Walk array and return upon hitting nil.
      {
	e3WordAddr cdr_coded_list_address = myWordAddress;

	while (1)
	  {
	    e3Word bar = readWordAt(cdr_coded_list_address++);
	    
	    if (bar.getCdrCode() == E3_CDR_CODE_NIL)
	      {
		os << "          cdr-coded last = " << bar << endl;
		break;
	      }
	    else
	      {
		os << "          cdr-coded car  = " << bar << endl;
	      }
	  }
      }
      break;

    default:
      cerr << "memList::dump -- bad cdr code list = " << (int)cdr_code << endl;
    }
}

/*
 * $$$$$$$$$$ This is undocumented in SSDN for the E1.
 */

memStackList::memStackList(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_STACK_LIST, "memStackList::memStackList -- not E3_DTP_STACK_LIST");
}

e3u32 memStackList::sizeOfInWords(void) const
{
  abort();
  return(0);
}

void memStackList::dump(ostream &os) const
{
  abort();
}


/*
 *
 */

memSymbol::memSymbol(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_SYMBOL, "memSymbol::memSymbol -- not E3_DTP_SYMBOL");
}

/*
 *
 */

memArray::memArray(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_ARRAY, "memArray::memArray -- not E3_DTP_ARRAY");
}

void memArray::dump(ostream &os) const
{
  os << "E3_DTP_ARRAY    address=" << hex << getArrayHeaderAddress() << endl;
}

/* SSDN2 pg 7-11 */
e3WordAddr memArray::getArrayHeaderAddress(void) const
{
  e3Word w = readMe();
  e3u32 array_header_address = w.getPointer();
  return(array_header_address);
}


/*
 * SSDN2 pg 7-6
 */

memFix::memFix(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_FIX, "memFix::memFix -- not E3_DTP_FIX");
}

e3s32 memFix::value(void) const
{
  e3Word me = readMe();

  e3u8  sign_bit = me.selectBitsPPSS(24, 1);
  e3u32 magnitude = me.selectBitsPPSS(0, 24);
  e3s32 signed_magnitude = magnitude;

  if (sign_bit)
    {
      signed_magnitude *= -1;	// Probably should just set sign bit.
    }

  return(signed_magnitude);
}

/*
 *
 */

memCharacter::memCharacter(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_CHARACTER, "memCharacter::memCharacter -- not E3_DTP_CHARACTER");
}

/*
 * $$$$$$$$$$ This is undocumented in SSDN for the E1.
 */

memSingleFloat::memSingleFloat(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_SINGLE_FLOAT, "memSingleFloat::memSingleFloat -- not E3_DTP_SINGLE_FLOAT");
}

e3u32 memSingleFloat::sizeOfInWords(void) const
{
  abort();
  return(0);
}

void memSingleFloat::dump(ostream &os) const
{
  abort();
}

/*
 *
 */

memShortFloat::memShortFloat(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_SHORT_FLOAT, "memShortFloat::memShortFloat -- not E3_DTP_SHORT_FLOAT");
}

/*
 *
 */

memInstance::memInstance(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_INSTANCE, "memInstance::memInstance -- not E3_DTP_INSTANCE");
}

/*
 *
 */

memExtendedNumber::memExtendedNumber(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_EXTENDED_NUMBER, "memExtendedNumber::memExtendedNumber -- not E3_DTP_EXTENDED_NUMBER");
}

/*
 *
 */

memLocative::memLocative(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_LOCATIVE, "memLocative::memLocative -- not E3_DTP_LOCATIVE");
}

/*
 *
 */

memFunction::memFunction(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_FUNCTION, "memFunction::memFunction -- not E3_DTP_FUNCTION");
}

/*
 *
 */

memClosure::memClosure(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_CLOSURE, "memClosure::memClosure -- not E3_DTP_CLOSURE");
}

/*
 *
 */

memLexicalClosure::memLexicalClosure(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_LEXICAL_CLOSURE, "memLexicalClosure::memLexicalClosure -- not E3_DTP_LEXICAL_CLOSURE");
}

e3u32 memLexicalClosure::sizeOfInWords(void) const
{
  abort();
  return(0);
}

void memLexicalClosure::dump(ostream &os) const
{
  abort();
}

/*
 *
 */

memUEntry::memUEntry(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_U_ENTRY, "memUEntry::memUEntry -- not E3_DTP_U_ENTRY");
}

/*
 *
 */

memStackGroup::memStackGroup(e3WordAddr a)
  : memArray(a)
{
  readMe().abortIfNot(E3_DTP_STACK_GROUP, "memStackGroup::memStackGroup -- not E3_DTP_STACK_GROUP");
}

void memStackGroup::dump(ostream &os) const
{
  os << "E3_DTP_ARRAY    address=" << hex << getArrayHeaderAddress() << endl;
}

/*
 *
 */

memGCForward::memGCForward(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_GC_FORWARD, "memGCForward::memGCForward -- not E3_DTP_GC_FORWARD");
}

/*
 *
 */

memExternalValueCellPointer::memExternalValueCellPointer(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_EXTERNAL_VALUE_CELL_POINTER,
		      "memExternalValueCellPointer::memExternalValueCellPointer -- not E3_DTP_EXTERNAL_VALUE_CELL_POINTER");
}

/*
 *
 */

memOneQForward::memOneQForward(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_ONE_Q_FORWARD, "memOneQForward::memOneQForward -- not E3_DTP_ONE_Q_FORWARD");
}

/*
 *
 */

memHeaderForward::memHeaderForward(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_HEADER_FORWARD, "memHeaderForward::memHeaderForward -- not E3_DTP_HEADER_FORWARD");
}

/*
 *
 */

memBodyForward::memBodyForward(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_BODY_FORWARD, "memBodyForward::memBodyForward -- not E3_DTP_BODY_FORWARD");
}

/*
 *
 */

memSymbolHeader::memSymbolHeader(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_SYMBOL_HEADER, "memSymbolHeader::memSymbolHeader -- not E3_DTP_SYMBOL_HEADER");
}

e3u32 memSymbolHeader::sizeOfInWords(void) const
{
  return(5);
}

e3Word memSymbolHeader::printNameCell(void) const
{
  e3Word print_name_cell = readMe();
  return(print_name_cell);
}

e3Word memSymbolHeader::valueCell(void) const
{
  e3Word value_cell = readWordAt(myWordAddress+1);
  return(value_cell);
}

e3Word memSymbolHeader::functionCell(void) const
{
  e3Word function_cell = readWordAt(myWordAddress+2);
  return(function_cell);
}

e3Word memSymbolHeader::propertyCell(void) const
{
  e3Word property_cell = readWordAt(myWordAddress+3);
  return(property_cell);
}

e3Word memSymbolHeader::packageCell(void) const
{
  e3Word package_cell = readWordAt(myWordAddress+4);
  return(package_cell);
}

void memSymbolHeader::dump(ostream &os) const
{
  os << "E3_DTP_SYMBOL_HEADER" << endl;
  os << "          PRINT-NAME-CELL: " << printNameCell() << endl;
  os << "          VALUE-CELL     : " << valueCell() << endl;
  os << "          FUNCTION-CELL  : " << functionCell() << endl;
  os << "          PROPERTY-CELL  : " << propertyCell() << endl;
  os << "          PACKAGE-CELL   : " << packageCell() << endl;
}

/*
 *
 */

memHeader::memHeader(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_HEADER, "memHeader::memHeader -- not E3_DTP_HEADER");
}

memHeaderType memHeader::getHeaderType(void) const
{
  e3Word w = readMe();
  e3u32 header_type_bits = w.selectBitsPPSS(023, 04);
  return((memHeaderType)header_type_bits);
}  

e3u32 memHeader::getHeaderRestField(void) const
{
  e3Word w = readMe();
  e3u32 rest_field = w.selectBitsPPSS(0, 023); // See %%HEADER-TYPE-FIELD
  return(rest_field);
}

void memHeader::dump(ostream &os) const
{
  os << readMe() << endl;

  switch(getHeaderType())
    {
    case HEADER_TYPE_ERROR:
      os << "HEADER_TYPE_ERROR" << endl;
      break;

    case HEADER_UNUSED_1:
      os << "HEADER_UNUSED_1 unused on Explorer" << endl;
      break;
      
    case HEADER_TYPE_ARRAY_LEADER: // SSND2 pg 8-4
      os << "HEADER_TYPE_ARRAY_LEADER unused on Explorer" << endl;
      {
	e3u32 numQs = getHeaderRestField();

	for (e3u32 i=0; i<numQs; i++)
	  {
	    os << "  Q[" << i << "] = " << readWordAt(myWordAddress+i) << endl;
	  }
      }
      break;
      
    case HEADER_TYPE_UNUSED_3:
      os << "HEADER_TYPE_UNUSED_3" << endl;
      break;
      
    case HEADER_TYPE_SINGLE_FLOAT:
      os << "HEADER_TYPE_SINGLE_FLOAT" << endl;
      break;

    case HEADER_TYPE_COMPLEX:
      os << "HEADER_TYPE_COMPLEX" << endl;
      break;

    case HEADER_TYPE_BIGNUM:
      os << "HEADER_TYPE_BIGNUM" << endl;
      break;

    case HEADER_TYPE_RATIONAL:
      os << "HEADER_TYPE_RATIONAL" << endl;
      break;

    case HEADER_TYPE_DOUBLE_FLOAT:
      os << "HEADER_TYPE_DOUBLE_FLOAT" << endl;
      break;

    default:
      os << "memHeader::dump -- unknown header type = " << getHeaderType() << endl;
    }
}


/*
 *
 */

memArrayHeader::memArrayHeader(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_ARRAY_HEADER, "memArrayHeader::memArrayHeader -- not E3_DTP_ARRAY_HEADER");
}

/*
 * The following few routines implement header word access
 * SSDN2 pg 8-2, Figure 8-1.
 */

e3ArrayTypes memArrayHeader::arrayType(void) const
{
  e3Word me = readMe();
  e3u32  tmp = me.selectBitsPPSS(19,5);
  return((e3ArrayTypes)tmp);
}

/* SSDN2 pg 8-6. */
e3Boolean memArrayHeader::physicalBit(void) const
{
  e3Word me = readMe();
  e3u32  tmp = me.selectBitsPPSS(18, 1);

  if (tmp)
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

/* SSDN2 pg 8-3. */
e3Boolean memArrayHeader::hasLeader(void) const
{
  e3Word me = readMe();
  e3u32  tmp = me.selectBitsPPSS(17, 1);

  if (tmp)
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

/* SSDN2 pg 8-5. */
e3Boolean memArrayHeader::isDisplaced(void) const
{
  e3Word me = readMe();
  e3u32 tmp = me.selectBitsPPSS(16, 1);

  if (tmp)
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

/* SSDN2 pg 8-4. */
e3Boolean memArrayHeader::simpleBit(void) const
{
  e3Word me = readMe();
  e3u32 tmp = me.selectBitsPPSS(15, 1);

  if (tmp)
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}
  
/* SSDN2 pg 8-5. */
e3u8 memArrayHeader::numberOfDims(void) const
{
  e3Word me = readMe();
  e3u32  tmp = me.selectBitsPPSS(12, 3);
  return((e3u8)tmp);
}

/* SSND2 pg 8-7. */
e3Boolean memArrayHeader::longLengthFlag(void) const
{
  e3Word me = readMe();
  e3u32 tmp = me.selectBitsPPSS(11, 1);

  if (tmp)
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

/* SSDN2 pg 8-4. */
e3Boolean memArrayHeader::namedStructureFlag(void) const
{
  e3Word me = readMe();
  e3u32  tmp = me.selectBitsPPSS(10, 1);

  if (tmp)
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

/* SSDN2 pg 8-5. */
e3u16 memArrayHeader::indexLength(void) const
{
  e3Word me = readMe();
  e3u32  tmp = me.selectBitsPPSS(0, 10);
  return((e3u16)tmp);
}

#ifdef NOTDEF
e3u32 memArrayHeader::maxIndexLength(void) const
{
  e3Word w = readMe();
  
  if (w.getArrayHeaderLongLengFlag())
    {
      cout << "LONG LENGTH" << endl;
      e3Word max_index_q = readWordAt(myWordAddress+1); // Immediately follows hdr.
      e3u32 max_index = max_index_q.getFixed();
      return(max_index);
    }
  else
    {
      e3u32 max_index = w.getArrayHeaderIndexLength();
      return(max_index);
    }
}
  
e3u32 memArrayHeader::sizeOfInWords(void) const
{
  e3Word w = readMe();

  if (isDisplaced())
    {
      return(3);		// Header, pointer, and index length words.
    }
  else
    {
      e3u32 max_index = maxIndexLength();
      e3u32 num_elements = max_index + 1;
      e3u32 num_bits = 0;

      /*
       * I'm making a LOT of assumptions here. -jm
       * Hope they're right.
       */

      switch (arrayType())
	{
	case ART_ERROR:
	  num_bits = num_elements * 32; // What the hell 
	  cerr << "memArrayHeader::sizeOfInWords -- ART_ERROR" << endl;
	  break;		// $ Don't know what else to do here.
	case ART_1B:
	  num_bits = num_elements;
	  break;
	case ART_2B:
	  num_bits = num_elements * 2;
	  break;
	case ART_4B:
	  num_bits = num_elements * 4;
	  break;
	case ART_8B:
	  num_bits = num_elements * 8;
	  break;
	case ART_16B:
	  num_bits = num_elements * 16;
	  break;
	case ART_32B:
	case ART_Q:
	case ART_Q_LIST:
	  num_bits = num_elements * 32; // $ Not sure of ART_Q_LIST
	  break;
	case ART_STRING:
	  num_bits = num_elements * 8;
	  break;
	case ART_STACK_GROUP_HEAD:
	case ART_SPECIAL_PDL:
	  num_bits = num_elements * 32;
	  break;
	case ART_HALF_FIX:
	  num_bits = num_elements * 16;
	  break;
	case ART_REG_PDL:
	  num_bits = num_elements * 32;
	  break;
	case ART_DOUBLE_FLOAT:	// $ These are the *same*????
	case ART_SINGLE_FLOAT:
	  num_bits = num_elements * 32;
	  break;
	case ART_FAT_STRING:
	  num_bits = num_elements * 16;
	  break;
	case ART_COMPLEX_DOUBLE_FLOAT: // $ This can't be right.
	case ART_COMPLEX:
	case ART_COMPLEX_SINGLE_FLOAT:
	  num_bits = num_elements * 32;
	  break;
	case ART_FIX:
	  num_bits = num_elements * 25; // $ Huh?
	  break;
	case ART_EXTENDED_FIX:
	  max_index = num_elements * 32;
	  break;
	default:
	  num_bits = num_elements * 32;
	  cerr << "memArrayHeader::sizeOfInWords -- unknown arrayType" << endl;
	  break;
	}

      e3u32 num_words = num_bits / 32;	// Num completely-filled Qs.

      if (num_bits % 32)	// We need another Q.
	{
	  num_words += 1;
	}

      return(num_words);
    }
}
#endif

/* SSDN2 pg 8-3. */
e3s32 memArrayHeader::leaderLength(void) const
{
  memFix fix(myWordAddress - 1);
  e3s32 leader_length = fix.value();
#ifdef DEBUG
  cout << " LEADER LENGTH  = " << leader_length << endl;
#endif
  return(leader_length);
}

/* LISP "pointer" offsets are from HIGH ADDRESS (i.e., END of leader) */
e3Word memArrayHeader::leaderWordFromEnd(e3s32 index) const
{
#ifdef PARANOID
  if (index < 0)
    {
      cerr << "memArrayHeader::leaderWord() -- index too small " << index << endl;
      abort();
      /* $$$$$ Later, after e3Word mutators set, return some sort of trap. */
      e3Word garbage;
      return(garbage);
    }
  else if (index >= leaderLength())
    {
      cerr << "memArrayHeader::leaderWord() -- index too big " << index << " for array size " << leaderLength() << endl;
      abort();
      /* $$$$$ Later, after e3Word mutators set, return some sort of trap. */
      e3Word garbage;
      return(garbage);
    }
  else
#endif
    {
      e3WordAddr array_leader_first_datum_addr = myWordAddress - 1 - 1; // Skip fixnum as well as array-header
  
      e3WordAddr desired_addr = array_leader_first_datum_addr - index;

      e3Word retval = readWordAt(desired_addr);

      return(retval);
    }
}  

void memArrayHeader::dumpLeader(ostream &os) const
{
  os << "            ARRAY LEADER LENGTH " << leaderLength() << endl;

  e3s32      num = leaderLength();
  e3WordAddr location_of_leader_header = leaderAddress();
  e3Word     hopefully_leader_header_word = readWordAt(location_of_leader_header);

#ifdef NOTDEF
  os << "memArray::dumpLeader -- leader? " << hopefully_leader_header_word << endl;
#endif

  for (e3s32 w=0; w<num; w++)
    {
      os << "            ARRAY LEADER " << w << " = " << leaderWordFromEnd(w) << endl;
    }
}

void memArrayHeader::dump(ostream &os) const
{
  os << "E3_DTP_ARRAY_HEADER" << endl;
  os << "          array_type =" << dec << arrayType() << endl;

  if (hasLeader())
    {
      os << "          leader " << endl;
      dumpLeader(os);
    }

  if (isDisplaced())
    {
      e3Word pointer_q = readWordAt(myWordAddress+1);
      e3Word index_length_q = readWordAt(myWordAddress+2);
      os << "          displaced to " << pointer_q << endl;
      os << "          index length " << index_length_q << endl;
    }
  else
    {
      e3WordAddr start_of_dimensions_if_any = myWordAddress+1;

      if (longLengthFlag())
	{
	  e3Word long_index_length_q = readWordAt(myWordAddress+1);
	  os << "          long length = " << long_index_length_q << endl;
	  start_of_dimensions_if_any++;
	}

      if (numberOfDims() > 1)
	{
	  for (e3u8 d = 0;
	       d < (numberOfDims() - 1);
	       d++)
	    {
	      memFix this_dimension_size(start_of_dimensions_if_any + d);
	      os << "          dimension " << d << " = " << this_dimension_size.value() << endl;
	    }
	}

      if (namedStructureFlag())
	{
	  e3Word structure_name_q;
	  
	  if (hasLeader())
	    {
	      structure_name_q = readWordAt(myWordAddress-2);
	    }
	  else
	    {
	      structure_name_q = readWordAt(start_of_dimensions_if_any
						       + numberOfDims());
	    }

	  os << "          structure name = " << structure_name_q << endl;
	}

      /* $ We don't currently print out the elements. */
    }
}

e3WordAddr memArrayHeader::leaderAddress(void) const
{
  e3WordAddr location_of_leader_header =
    myWordAddress
    - 1				// For the leader-length
    - leaderLength()		// For the number of words
    - 1;			// For the leader header word.
  return(location_of_leader_header);
}


/*
 * This is simply a convenience class that exists only
 * to make the code clearer -- it is just the same as
 * a vanilla memArrayHeader.
 */

memStackGroupArrayHeader::memStackGroupArrayHeader(e3WordAddr a)
  : memArrayHeader(a)
{
  if (arrayType() != ART_STACK_GROUP_HEAD)
    {
      cerr << "memStackGroupArrayHeader::memStackGroupArrayHeader -- not ART_STACK_GROUP_HEAD" << endl;
    }
}

/*
 * See lroy-qcom ST-State-Fields
 */

memStackGroupState memStackGroupArrayHeader::getCurrentState(void) const
{
  e3Word state_q = getState();
  e3u32 current_state = state_q.selectBitsPPSS(00,06);

  return((memStackGroupState)current_state);
}
  
e3Boolean memStackGroupArrayHeader::getFootholdExecuting(void) const
{
  e3Word state_q = getState();

  if (state_q.selectBitsPPSS(06, 01))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

e3Boolean memStackGroupArrayHeader::getProcessingError(void) const
{
  e3Word state_q = getState();

  if (state_q.selectBitsPPSS(07, 01))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

e3Boolean memStackGroupArrayHeader::getProcessingInterruptRequest(void) const
{
  e3Word state_q = getState();

  if (state_q.selectBitsPPSS(010, 01))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

e3Boolean memStackGroupArrayHeader::getSafe(void) const
{
  e3Word state_q = getState();

  if (state_q.selectBitsPPSS(011, 01))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

e3u8 memStackGroupArrayHeader::getInstDisp(void) const
{
  e3Word state_q = getState();
  e3u8 retval = state_q.selectBitsPPSS(012, 02);
  return(retval);
}

e3Boolean memStackGroupArrayHeader::getSwapSvOfSgThatCallsMe(void) const
{
  e3Word state_q = getState();

  if (state_q.selectBitsPPSS(024, 01))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

e3Boolean memStackGroupArrayHeader::getSwapSvOnCallOut(void) const
{
  e3Word state_q = getState();

  if (state_q.selectBitsPPSS(025, 01))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

e3Boolean memStackGroupArrayHeader::getInSwappedInState(void) const
{
  e3Word state_q = getState();

  if (state_q.selectBitsPPSS(026, 01))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

e3Boolean memStackGroupArrayHeader::getRestoreMicrostack(void) const
{
  e3Word state_q = getState();

  if (state_q.selectBitsPPSS(027, 01))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}




// See SSDN page 14-6, Table 14-1.
//
// SSDN is ambiguous about treatment of these data.  Either this Q of
// DTP-FIXNUM is a single value representing the state *xor* it is composed of
// bit flags, each with its own value.  Par 14.2.3 refers to 'fields' in this
// Q, but Table 14-1 specifies only 'value' and not particular bits (as eg
// Table 14-2).
//
// Below implementation offers two choices.  
void memStackGroupArrayHeader::getStateDetail(ostream &os, char *fill) const
{
#undef SG_STATE_DETAIL_BITS
  
#ifdef SG_STATE_DETAIL_BITS

  e3Word word = readWordAt(myWordAddress-11);

  // Shouldn't happen.
  if(word.getBits() & 1)
    { os << fill << "SG-STATE-ERROR" << endl; }

  // Actually executing.
  if(word.getBits() & 2)
    { os << fill << "SG-STATE-ACTIVE" << endl; }

  // Reached by interrupt or error recovery completed.  Restore state
  // and continue.
  if(word.getBits() & 4)
    { os << fill << "SG-STATE-RESUMABLE" << endl; }

  // After doing legitimate sg-call.
  if(word.getBits() & 8)
    { os << fill << "SG-STATE-AWAITING-RETURN" << endl; }

  // Error system can produce this state when it wants to activate
  // foothold or perform retry.
  if(word.getBits() & 0x10)
    { os << fill << "SG-STATE-INVOKE-CALL-ON-RETURN" << endl; }

  // If forced to take interrupt at inopportune moment.
  if(word.getBits() & 0x20)
    { os << fill << "SG-STATE-INTERRUPTED-DIRTY" << endl; }

  // Immediately after error, before recovery.
  if(word.getBits() & 0x40)
    { os << fill << "SG-STATE-AWAITING-ERROR-RECOVERY" << endl; }

  // SG is ready to be called.
  if(word.getBits() & 0x80)
    { os << fill << "SG-STATE-AWAITING-CALL" << endl; }

  // Initial state of SG before being called.
  if(word.getBits() & 0x100)
    { os << fill << "SG-STATE-AWAITING-INITIAL-CALL" << endl; }

  // SG has finished running.
  if(word.getBits() & 0x200)
    { os << fill << "SG-STATE-EXHAUSTED" << endl; }

#elif 0

  switch(word.getBits() & 0x003fffff)
    {
    case 0: os << fill << "SG-STATE-ERROR" << endl; break;
    case 1: os << fill << "SG-STATE-ACTIVE" << endl; break;
    case 2: os << fill << "SG-STATE-RESUMABLE" << endl; break;
    case 3: os << fill << "SG-STATE-AWAITING-RETURN" << endl; break;
    case 4: os << fill << "SG-STATE-INVOKE-CALL-ON-RETURN" << endl; break;
    case 5: os << fill << "SG-STATE-INTERRUPTED-DIRTY" << endl; break;
    case 6: os << fill << "SG-STATE-AWAITING-ERROR-RECOVERY" << endl; break;
    case 7: os << fill << "SG-STATE-AWAITING-CALL" << endl; break;
    case 8: os << fill << "SG-STATE-AWAITING-INITIAL-CALL" << endl; break;
    case 9: os << fill << "SG-STATE-EXHAUSTED" << endl;
    }

#else

  switch(getCurrentState())
    {
    case SG_STATE_ERROR:
      os << fill << "SG_STATE_ERROR" << endl;
      break;
    case SG_STATE_ACTIVE:
      os << fill << "SG_STATE_ACTIVE" << endl;
      break;
    case SG_STATE_RESUMABLE:
      os << fill << "SG_STATE_RESUMABLE" << endl;
      break;
    case SG_STATE_AWAITING_RETURN:
      os << fill << "SG_STATE_AWAITING_RETURN" << endl;
      break;
    case SG_STATE_INVOKE_CALL_ON_RETURN:
      os << fill << "SG_STATE_INVOKE_CALL_ON_RETURN" << endl;
      break;
    case SG_STATE_INTERRUPTED_DIRTY:
      os << fill << "SG_STATE_INTERRUPTED_DIRTY" << endl;
      break;
    case SG_STATE_AWAITING_ERROR_RECOVERY:
      os << fill << "SG_STATE_AWAITING_ERROR_RECOVERY" << endl;
      break;
    case SG_STATE_AWAITING_CALL:
      os << fill << "SG_STATE_AWAITING_CALL" << endl;
      break;
    case SG_STATE_AWAITING_INITIAL_CALL:
      os << fill << "SG_STATE_AWAITING_INITIAL_CALL" << endl;
      break;
    case SG_STATE_EXHAUSTED:      
      os << fill << "SG_STATE_EXHAUSTED" << endl;
      break;
    default:
      os << fill << "UNKNOWN STACK GROUP CurrentState!" << endl;
    }

  if (getFootholdExecuting())
    {
      os << fill << "FOOTHOLD-EXECUTING" << endl;
    }
  if (getProcessingError())
    {
      os << fill << "PROCESSING-ERROR" << endl;
    }
  if (getProcessingInterruptRequest())
    {
      os << fill << "PROCESSING-INTERRUPT-REQUEST" << endl;
    }
  if (getSafe())
    {
      os << fill << "SAFE" << endl;
    }
  os << fill << "INST-DISP = " << (int)getInstDisp() << endl;
  if (getSwapSvOfSgThatCallsMe())
    {
      os << fill << "SWAP-SV-OF-SG-THAT-CALLS-ME" << endl;
    }
  if (getSwapSvOnCallOut())
    {
      os << fill << "SWAP-SV-ON-CALL-OUT" << endl;
    }
  if (getInSwappedInState())
    {
      os << fill << "IN-SWAPPED-IN-STATE" << endl;
    }
  if (getRestoreMicrostack())
    {
      os << fill << "RESTORE-MICROSTACK" << endl;
    }

#endif // SG_STATE_DETAIL_BITS
}

// See SSDN page 14-7, Table 14-2.
//
// This Q contains the processor flags for a SG saved as a fixnum.
void memStackGroupArrayHeader::getSavedMFlagsDetail(ostream &os, char *fill) const
{
  e3Word word = readWordAt(myWordAddress-19);
  e3u32 bits = 0;

  // 0: This flag is no longer used.
  os << fill << "QBBFL: ";
  (word.getBits() & 1) ? (os << "true - xyzzy") : (os << "false - xyzzy");
  os << endl;

  // 1-2: CAR of symbol mode.
  os << fill << "CAR-SYM-MODE: ";
  bits = word.selectBitsPPSS(1, 2);
  switch(bits)
    {
    case 0: os << "0 - error"; break;
    case 1: os << "1 - error except (CAR NIL) is NIL"; break;
    case 2: os << "2 - NIL"; break;
    case 3: os << "3 - error";
    }
  os << endl;

  // 3-4: CAR of number mode.
  os << fill << "CAR-NUM-MODE: ";
  bits = 0; bits = word.selectBitsPPSS(3, 2);
  switch(bits)
    {
    case 0: os << "0 - error"; break;
    case 1: os << "1 - NIL"; break;
    case 2: os << "2 - error"; break;
    case 3: os << "3 - error";
    }
  os << endl;

  // 5-6: CDR of symbol mode.
  os << fill << "CDR-SYM-MODE: ";
  bits = 0; bits = word.selectBitsPPSS(5, 2);
  switch(bits)
    {
    case 0: os << "0 - error"; break;
    case 1: os << "1 - error except (CDR NIL) is NIL"; break;
    case 2: os << "2 - NIL"; break;
    case 3: os << "3 - property-list";
    }
  os << endl;

  // 7-8: CDR of number mode.
  os << fill << "CDR-NUM-MODE: ";
  bits = 0; bits = word.selectBitsPPSS(7, 2);
  switch(bits)
    {
    case 0: os << "0 - error"; break;
    case 1: os << "1 - NIL"; break;
    case 2: os << "2 - error"; break;
    case 3: os << "3 - error";
    }
  os << endl;

  // 9: Flag for creating fresh pages.
  os << fill << "DONT-SWAP-IN: ";
  (word.getBits() & 0x100) ? (os << "true") : (os << "false");
  os << endl;

  // 10: Enable error trapping when set.
  os << fill << "TRAP-ENABLE: ";
  (word.getBits() & 0x200) ? (os << "true") : (os << "false");
  os << endl;

  // 11-12: MAR mode.
  os << fill << "MAR-MODE: ";
  bits = 0; bits = word.selectBitsPPSS(11, 2);
  os << "read-trap=";
  (bits & 1) ? (os << "true") : (os << "false");
  os << "; write-trap=";
  (bits & 2) ? (os << "true") : (os << "false");
  os << endl;

  // 13: Flag used by page fault routine.
  os << fill << "PGF-WRITE: ";
  (word.getBits() & 0x1000) ? (os << "true") : (os << "false");
  os << endl;

  // 14: In microcode interrupt.
  os << fill << "INTERRUPT-FLAG: ";
  (word.getBits() & 0x2000) ? (os << "true") : (os << "false");
  os << endl;

  // 15: In scavenger.
  os << fill << "SCAVENGE-FLAG: ";
  (word.getBits() & 0x4000) ? (os << "true") : (os << "false");
  os << endl;

  // 16: In transporter.
  os << fill << "TRANSPORT-FLAG: ";
  (word.getBits() & 0x8000) ? (os << "true") : (os << "false");
  os << endl;

  // 17: Switching stack groups.
  os << fill << "STACK-GROUP-SWITCH-FLAG: ";
  (word.getBits() & 0x10000) ? (os << "true") : (os << "false");
  os << endl;

  // 18: Sequence break pending but inhibited.
  os << fill << "DEFERRED-SEQUENCE-BREAK-FLAG: ";
  (word.getBits() & 0x20000) ? (os << "true") : (os << "false");
  os << endl;

  // 19: Metering enabled for this stack group.
  os << fill << "METER-ENABLE: ";
  (word.getBits() & 0x40000) ? (os << "true") : (os << "false");
  os << endl;

  // 20: Trap on attempting to activate new frame.
  os << fill << "TRAP-ON-CALL: ";
  (word.getBits() & 0x80000) ? (os << "true") : (os << "false");
  os << endl;
}

void memStackGroupArrayHeader::dump(ostream &os) const
{
#ifdef NOTDEF
  /* Only needed this to debug following lines. */
  memArrayHeader::dump(os);
#endif

  os << "  Name                 " << getName() << endl;
  os << "  RegularPDL           " << getRegularPDL() << endl;
  os << "  RegularPDLLimit      " << getRegularPDLLimit() << endl;
  os << "  SpecialPDL           " << getSpecialPDL() << endl;
  os << "  SpecialPDLLimit      " << getSpecialPDLLimit() << endl;
  os << "  InitialFunctionIndex " << getInitialFunctionIndex() << endl;

  os << "  TrapTag              " << getTrapTag() << endl;
  os << "  RecoveryHistory      " << getRecoveryHistory() << endl;
  os << "  FootholdData         " << getFootholdData() << endl;

  os << "  State                " << getState() << endl;
  getStateDetail(os, "                       ");
  os << "  PreviousStackGroup   " << getPreviousStackGroup() << endl;
  os << "  CallingArgsPointer   " << getCallingArgsPointer() << endl;
  os << "  CallingArgsNumber    " << getCallingArgsNumber() << endl;
  os << "  TrapAPLevel          " << getTrapAPLevel() << endl;

  os << "  RegularPDLPointer    " << getRegularPDLPointer() << endl;
  os << "  SpecialPDLPointer    " << getSpecialPDLPointer() << endl;
  os << "  TrapMicroPC          " << getTrapMicroPC() << endl;
  os << "  SavedMFlags          " << getSavedMFlags() << endl;
  getSavedMFlagsDetail(os, "                       ");
  os << "  PDLPhase             " << getPDLPhase() << endl;
  os << "  SavedVMA             " << getSavedVMA() << endl;
  os << "  VMAM1M2Tags          " << getVMAM1M2Tags() << endl;
  os << "  M3M4Tags             " << getM3M4Tags() << endl;

  os << "  SGAC1                " << getSGAC1() << endl;
  os << "  SGAC2                " << getSGAC2() << endl;
  os << "  SGAC3                " << getSGAC3() << endl;
  os << "  SGAC4                " << getSGAC4() << endl;
  os << "  SGACA                " << getSGACA() << endl;
  os << "  SGACB                " << getSGACB() << endl;
  os << "  SGACC                " << getSGACC() << endl;
  os << "  SGACD                " << getSGACD() << endl;
  os << "  SGACE                " << getSGACE() << endl;
  os << "  SGACF                " << getSGACF() << endl;
  os << "  SGACG                " << getSGACG() << endl;
  os << "  SGACH                " << getSGACH() << endl;
  os << "  SGACI                " << getSGACI() << endl;
  os << "  SGACJ                " << getSGACJ() << endl;
  os << "  SGACK                " << getSGACK() << endl;
  os << "  SGACL                " << getSGACL() << endl;
  os << "  SGACQ                " << getSGACQ() << endl;
  os << "  SGACR                " << getSGACR() << endl;
  os << "  SGACS                " << getSGACS() << endl;
  os << "  SGACZR               " << getSGACZR() << endl;
  os << "  SGACT                " << getSGACT() << endl;

  os << "  CatchPointer         " << getCatchPointer() << endl;
}
  
#ifdef NOTDEF
  e3WordAddr array_address = getArrayHeaderAddress();
  memArrayHeader array(array_address);
  array.dump(os);

  abort();
#endif


/*
 *
 */

memInstanceHeader::memInstanceHeader(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_INSTANCE_HEADER, "memInstanceHeader::memInstanceHeader -- not E3_DTP_INSTANCE_HEADER");
}

e3u32 memInstanceHeader::sizeOfInWords(void) const
{
  abort();
  return(1);
}

void memInstanceHeader::dump(ostream &os) const
{
  os << "memInstanceHeader::dump -- NOP" << endl;
}

/*
 * SSDN2 pg 11-12.
 * 0: header
 * 1: storage length
 */


memFEFHeader::memFEFHeader(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_FEF_HEADER, "memFEFHeader::memFEFHeader -- not E3_DTP_FEF_HEADER");
}

e3u32 memFEFHeader::sizeOfInWords(void) const
{
  memFix storage_length_q(myWordAddress+1);	// Second word is storage length.

  e3u32 storage_length = storage_length_q.value();

  return(storage_length);
}

/* 1st word and accessors. */

e3Word memFEFHeader::getHeaderQ(void) const
{
  e3Word header_q = readMe();
  return(header_q);
}

/* $ Using the ones from lroy-qcom in preference to SSDN1. */

e3Boolean memFEFHeader::isSpecialForm(void) const
{
  e3Word w = getHeaderQ();

  if (w.selectBitsPPSS(037, 1))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

e3Boolean memFEFHeader::isSubst(void) const
{
  e3Word w = getHeaderQ();

  if (w.selectBitsPPSS(036, 1))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

e3Boolean memFEFHeader::selfMappingTable(void) const
{
  e3Word w = getHeaderQ();

  if (w.selectBitsPPSS(030, 1))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

vlmCallType memFEFHeader::callType(void) const
{
  e3Word w = getHeaderQ();

  vlmCallType call_type = (vlmCallType)w.selectBitsPPSS(025, 3);
  return(call_type);
}

e3u8 memFEFHeader::numberOptionalArgs(void) const
{
  e3Word w = getHeaderQ();

  e3u8 num_optional_args = w.selectBitsPPSS(022, 3);
  return(num_optional_args);
}
    
e3u8 memFEFHeader::numberArgs(void) const
{
  e3Word w = readMe();

  e3u8 num_args = w.selectBitsPPSS(016, 4);
  return(num_args);
}
    
e3u8 memFEFHeader::numberLocals(void) const
{
  e3Word w = readMe();

  e3u8 num_locals = w.selectBitsPPSS(012, 4);
  return(num_locals);
}
    
e3u16 memFEFHeader::locationCounterOffset(void) const
{
  e3Word w = readMe();

  e3u16 location_counter_offset = w.selectBitsPPSS(0, 012);
  return(location_counter_offset);
}


/* 2nd word. */
e3Word memFEFHeader::getStorageLengthQ(void) const
{
  e3Word w = readWordAt(myWordAddress+1);
  return(w);
}

/* Documented in lroy-qcom.lisp, but nowhere I could find in SSDN2. */

e3Boolean memFEFHeader::isGenericFunction(void) const
{
  e3Word w = readWordAt(myWordAddress+1); // Read this bit from storage length Q.

  if (w.selectBitsPPSS(036, 1))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}


/* 3rd word. */

e3Word memFEFHeader::getPointerToDebuggingInfo(void) const
{
  e3Word w = readWordAt(myWordAddress+2);
  return(w);
}

/* Optional 4th word and accessors. */

e3Word memFEFHeader::getOptionalLongArgsWordQ(void) const
{
#ifdef PARANOID
  if (callType() != CALL_LONG)	// Shouldn't have one.
    {
      cerr << "memFEFHeader::getOptionalLongArgsWordQ -- shouldn't have one" << endl;
    }
#endif

  e3Word w = readWordAt(myWordAddress+4);
  return(w);
}

e3Boolean memFEFHeader::longArgsOptionals(void) const
{
  e3Word w = getOptionalLongArgsWordQ();

  if (w.selectBitsPPSS(025, 1))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

e3Boolean memFEFHeader::longArgsLocals(void) const
{
  e3Word w = getOptionalLongArgsWordQ();

  if (w.selectBitsPPSS(024, 1))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

e3Boolean memFEFHeader::longArgsRestArg(void) const
{
  e3Word w = getOptionalLongArgsWordQ();

  if (w.selectBitsPPSS(023, 1))
    {
      return(e3True);
    }
  else
    {
      return(e3False);
    }
}

e3u8 memFEFHeader::longArgsMinArgs(void) const
{
  e3Word w = getOptionalLongArgsWordQ();
  e3u32 min_args = w.selectBitsPPSS(015, 6); // Fewer than 8 bits.

  return((e3u8)min_args);
}

e3u8 memFEFHeader::longArgsMaxArgs(void) const
{
  e3Word w = getOptionalLongArgsWordQ();
  e3u32 max_args = w.selectBitsPPSS(07, 6); // Fewer than 8 bits.

  return((e3u8)max_args);
}

e3u8 memFEFHeader::longArgsNumberOfLocals(void) const
{
  e3Word w = getOptionalLongArgsWordQ();
  e3u32 num_locals = w.selectBitsPPSS(0, 7); // Fewer than 8 bits.

  return((e3u8)num_locals);
}

/* Optional 5th word. */

e3Word memFEFHeader::getFlavorNameQ(void) const
{
  e3Word w;

  if (callType() == CALL_LONG)	// Got an optional 4th word, so we're 5th.
    {
      w = readWordAt(myWordAddress+4);
    }
  else				// We're the 4th word.
    {
      w = readWordAt(myWordAddress+3);
    }

  return(w);
}

/*
 * Dump it.
 */

e3u32 memFEFHeader::numberOfMacroInstructions(void) const
{
  e3u32 number_of_macro_instruction_words = sizeOfInWords() - locationCounterOffset();
  e3u32 number_of_halfwords = number_of_macro_instruction_words * 2;

  cout << "memFEFHeader::number_of_macro_instruction_words\n";
  cout << "  sizeOfInWords         = " << sizeOfInWords() << endl;
  cout << "  locationCounterOffset = " << locationCounterOffset() << endl;
  cout << "  number_of_halfwords   = " << number_of_halfwords << endl;

  return(number_of_halfwords);
}

void memFEFHeader::dump(ostream &os) const
{
  os << "memFEFHeader::dump -- NOP" << endl;

  /* 1st word. */

  e3Word header_q = getHeaderQ();
  os << "          header_q                      " << header_q << endl;
  /* lroy-qcom.lisp */
  e3u32 cc = header_q.getCdrCode();
  e3u32 dtp = header_q.getDataType();
  e3u32 special_form = isSpecialForm();
  e3u32 if_defsubst = isSubst();
  e3u32 get_self_mapping_table = selfMappingTable();
  e3u32 call_type = callType();
  e3u32 number_of_optional_arguments = numberOptionalArgs();
  e3u32 number_of_required_arguments = numberArgs();
  e3u32 number_of_locals = numberLocals();
  e3u32 entry_pc_offset_in_words = locationCounterOffset();

  os << "              cc = " << cc << endl;
  os << "              dtp = " << dtp << endl;
  os << "              special_form = " << special_form << endl;
  os << "              if_defsubst = " << if_defsubst << endl;
  os << "              get_self_mapping_table = " << get_self_mapping_table << endl;
  os << "              call_type = " << call_type << endl;
  os << "              number_of_optional_arguments = " << number_of_optional_arguments << endl;
  os << "              number_of_required_arguments = " << number_of_required_arguments << endl;
  os << "              number_of_locals = " << number_of_locals << endl;
  os << "              entry_pc_offset_in_words = " << entry_pc_offset_in_words << endl;

  /* 2nd word. */

  e3Word storage_length_q = getStorageLengthQ();
  os << "          storage_length_q              " << storage_length_q << endl;
  e3Boolean is_generic_function = isGenericFunction();
  os << "              is_generic_function = " << is_generic_function << endl;

  /* 3rd word. */

  e3Word pointer_to_debugging_info_q = getPointerToDebuggingInfo();
  os << "          pointer_to_debugging_info_q   " << pointer_to_debugging_info_q << endl;

  /* 4th word. */
  
  if (callType() == CALL_LONG)
    {
      e3Word long_args_word_q = getOptionalLongArgsWordQ();
      os << "          long_args_word_q              " << long_args_word_q << endl;

      os << "              optionals                 " << longArgsOptionals() << endl;
      os << "              locals                    " << longArgsLocals() << endl;
      os << "              rest_arg                  " << longArgsRestArg() << endl;
      os << "              min_args                  " << longArgsMinArgs() << endl;
      os << "              max_args                  " << longArgsMaxArgs() << endl;
      os << "              num_locals                " << longArgsNumberOfLocals() << endl;
    }

  /* $$$$$ 4th/5th word? */

  if (selfMappingTable())
    {
      e3Word flavor_name_q = getFlavorNameQ();
      os << "          flavor_name_q                 " << flavor_name_q << endl;
    }

  /* Dump macroinstructions. */
  
  e3u32 number_of_macroinstructions = numberOfMacroInstructions();

  for (e3u32 i=0; i<number_of_macroinstructions; i++)
    {
      e3MacroInstruction instr = readMacroInstruction(entry_pc_offset_in_words, i);

      printf(" pc=%04o", i);
      //os << " pc=" << (int)i;
      instr.dump(os);
      os << endl;
    }
}

e3MacroInstruction memFEFHeader::readMacroInstruction(e3u32 entry_offset, e3u8 relative_pc) const
{
  e3Word foo = readWordAt(myWordAddress + entry_offset + (relative_pc / 2));

  if (!(relative_pc & 0x1))		// Even or high word.
    {
      e3MacroInstruction retval((foo.getBits() >> 16) & 0xffff);
      return(retval);
    }
  else				// Odd or low word.
    {
      e3MacroInstruction retval(foo.getBits() & 0xffff);
      return(retval);
    }
}


/*
 *
 */

memSelfRefPointer::memSelfRefPointer(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_SELF_REF_POINTER, "memSelfRefPointer::memSelfRefPointer -- not E3_DTP_SELF_REF_POINTER");
}

/*
 *
 */

memGCYoungPointer::memGCYoungPointer(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_GC_YOUNG_POINTER,
		      "memGCYoungPointer::memGCYoungPointer -- not E3_DTP_GC_YOUNG_POINTER");
}

e3u32 memGCYoungPointer::sizeOfInWords(void) const
{
  abort();
  return(1);
}

void memGCYoungPointer::dump(ostream &os) const
{
  abort();
}

/*
 *
 */

memFree::memFree(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_FREE, "memFree::memFree -- not E3_DTP_FREE");
}

/*
 *
 */

memNull::memNull(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_NULL, "memNull::memNull -- not E3_DTP_NULL");
}

/*
 *
 */

memOnesTrap::memOnesTrap(e3WordAddr a)
  : memObj(a)
{
  readMe().abortIfNot(E3_DTP_ONES_TRAP, "memOnesTrap::memOnesTrap -- not E3_DTP_ONES_TRAP");
}

/*
 *
 */

/*
 *
 */

#ifdef NOTDEF
	    cout << "E3_DTP_STACK_LIST" << endl;
	    cout << "E3_DTP_ARRAY" << endl;
	    cout << "E3_DTP_FIX" << endl;
	    cout << "E3_DTP_CHARACTER" << endl;
	    cout << "E3_DTP_SINGLE_FLOAT" << endl;
	    cout << "E3_DTP_SHORT_FLOAT" << endl;
	    cout << "E3_DTP_INSTANCE" << endl;
	    cout << "E3_DTP_EXTENDED_NUMBER" << endl;
	    cout << "E3_DTP_LOCATIVE" << endl;
	    cout << "E3_DTP_FUNCTION" << endl;
	    cout << "E3_DTP_CLOSURE" << endl;
	    cout << "E3_DTP_LEXICAL_CLOSURE" << endl;
	    cout << "E3_DTP_U_ENTRY" << endl;
	    cout << "E3_DTP_STACK_GROUP" << endl;
	    cout << "E3_DTP_GC_FORWARD" << endl;
	    cout << "E3_DTP_EXTERNAL_VALUE_CELL_POINTER" << endl;
	    cout << "E3_DTP_ONE_Q_FORWARD" << endl;
	    cout << "E3_DTP_HEADER_FORWARD" << endl;
	    cout << "E3_DTP_BODY_FORWARD" << endl;
	    cout << "E3_DTP_HEADER" << endl;
	    cout << "E3_DTP_ARRAY_HEADER" << endl;
	    cout << "          " << tmp << endl;
	    cout << "E3_DTP_INSTANCE_HEADER" << endl;
	    cout << "E3_DTP_FEF_HEADER" << endl;
	    cout << "E3_DTP_SELF_REF_POINTER" << endl;
	    cout << "E3_DTP_GC_YOUNG_POINTER" << endl;
	    cout << tmp << endl;
	    cout << tmp << endl;
	    cout << "E3_DTP_ONES_TRAP" << endl;


#endif

/*
 * Should probably be some kind of factory class.
 */

#include "memmap.h"

memObj *memObj::makeRightObjType(e3WordAddr i)
{
  e3Word tmp = lispm->readWord(i);

  switch(tmp.getDataType())
    {
    case E3_DTP_TRAP:
      return(new memTrap(i));
    case E3_DTP_LIST:
      return(new memList(i));
    case E3_DTP_STACK_LIST:
      return(new memStackList(i));
    case E3_DTP_SYMBOL:
      return(new memSymbol(i));
    case E3_DTP_ARRAY:
      return(new memArray(i));
    case E3_DTP_FIX:
      return(new memFix(i));
    case E3_DTP_CHARACTER:
      return(new memCharacter(i));
    case E3_DTP_SINGLE_FLOAT:
      return(new memSingleFloat(i));
    case E3_DTP_SHORT_FLOAT:
      return(new memShortFloat(i));
    case E3_DTP_INSTANCE:
      return(new memInstance(i));
    case E3_DTP_EXTENDED_NUMBER:
      return(new memExtendedNumber(i));
    case E3_DTP_LOCATIVE:
      return(new memLocative(i));
    case E3_DTP_FUNCTION:
      return(new memFunction(i));
    case E3_DTP_CLOSURE:
      return(new memClosure(i));
    case E3_DTP_LEXICAL_CLOSURE:
      return(new memLexicalClosure(i));
    case E3_DTP_U_ENTRY:
      return(new memUEntry(i));
    case E3_DTP_STACK_GROUP:
      return(new memStackGroup(i));
    case E3_DTP_GC_FORWARD:
      return(new memGCForward(i));
    case E3_DTP_EXTERNAL_VALUE_CELL_POINTER:
      return(new memExternalValueCellPointer(i));
    case E3_DTP_ONE_Q_FORWARD:
      return(new memOneQForward(i));
    case E3_DTP_HEADER_FORWARD:
      return(new memHeaderForward(i));
    case E3_DTP_BODY_FORWARD:
      return(new memBodyForward(i));
    case E3_DTP_SYMBOL_HEADER:
      return(new memSymbolHeader(i));
    case E3_DTP_HEADER:
      return(new memHeader(i));
    case E3_DTP_ARRAY_HEADER:
      return(new memArrayHeader(i));
    case E3_DTP_INSTANCE_HEADER:
      return(new memInstanceHeader(i));
    case E3_DTP_FEF_HEADER:
      return(new memFEFHeader(i));
    case E3_DTP_SELF_REF_POINTER:
      return(new memSelfRefPointer(i));
    case E3_DTP_GC_YOUNG_POINTER:
      return(new memGCYoungPointer(i));
    case E3_DTP_FREE:
      return(new memFree(i));
    case E3_DTP_NULL:
      return(new memNull(i));
    case E3_DTP_ONES_TRAP:
      return(new memOnesTrap(i));
    default:
      {
	cout << "E3 UNKNOWN DTP!!!!!!!!!!!!!" << endl;
	return(NULL);
      }
    }
}


//
// Local Variables:
// compile-command: "make cycle"
// fill-column: 78
// End:
