/*
 * fileslurp.h
 *
 * Common main function for file-slurping utilities
 */

#include <stdlib.h>
#include <stdio.h>
#include "types.h"


#ifndef FILESLURP_NO_ARGPARSER
#  ifndef ARGPARSER
int argparser(int argc, char *argv[])
{
    if (argc != 2) {
	fprintf(stderr, "usage: %s <file>\n", argv[0]);
	return 1;
    }

    return 0;
}
#  else
int argparser(int argc, char *argv[]);
#  endif
#endif

u8 *fileslurp(char *filename, int *length)
{
    FILE *infile;
    u8 *data;
    int len;

    if (!strcmp(filename, "-")) {
	infile = stdin;
    } else {
	infile = fopen(filename, "rb");
    }
#ifdef SLURPSIZE
    len = SLURPSIZE;
#else
    fseek(infile, 0, SEEK_END);
    len = ftell(infile);
    fseek(infile, 0, SEEK_SET);
#endif

    data = malloc(len);
    if (!data) {
	fclose(infile);
	fprintf(stderr, "insufficient memory.\n");
	return NULL;
    }

    if (fread(data, 1, len, infile) != len) {
	fclose(infile);
	perror("read failure");
	return NULL;
    }

    fclose(infile);

    if (length) *length = len;
    return data;
}

#ifndef FILESLURP_NO_MAIN
int process_data(u8 *, int);

int main(int argc, char *argv[])
{
    char *data;
    int length;

    if (argparser(argc, argv)) return -1;

    data = fileslurp(argv[1], &length);

    if (!data) return -1;

    return process_data(data, length);
}
#endif

/* EOF */
