; -*- Mode:LISP; Base:8 -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1985-1989 Texas Instruments Incorporated. All rights reserved.

;	** (c) Copyright 1980 Massachusetts Institute of Technology **

;ELEMENTS IN Q-CORRESPONDING-VARIABLE-LIST ARE SYMBOLS WHOSE VALUES IN MACLISP ARE LISTS
;  ALL OF WHOSE MEMBERS ARE SYSTEM CONTANTS.  THESE SYSTEM CONSTANTS HAVE MACLISP VALUES
;  AND ARE MADE TO HAVE THE IDENTICAL VALUES IN LISP MACHINE LISP.
(SETQ Q-CORRESPONDING-VARIABLE-LISTS '(
   system-constants
   Q-LISP-CONSTANTS
   ;;;RTB-RTB-BITS RTB-RTS-BITS RTB-RTO-OPS 
   ;;;RTB-MISC RTM-OPS READTABLE-%%-BITS 
   MISC-Q-VARIABLES 
   SYSTEM-CONSTANT-LISTS SYSTEM-VARIABLE-LISTS
   SCRATCH-PAD-VARIABLES FASL-GROUP-FIELDS FASL-OPS 
   FASL-TABLE-PARAMETERS FASL-CONSTANTS FASL-CONSTANT-LISTS
   STACK-GROUP-HEAD-LEADER-QS))

(setq system-constants nil)

;ELEMENTS IN SYSTEM-CONSTANT-LISTS ARE SYMBOLS WHOSE MACLISP AND LISP MACHINE
;VALUES ARE LISTS OF SYMBOLS WHICH SHOULD GET SYSTEM-CONSTANT PROPERTY FOR THE COMPILER.
;NORMALLY SHOULD BE VERY CLOSE TO Q-CORRESPONDING-VARIABLES-LISTS
(SETQ SYSTEM-CONSTANT-LISTS '(
   Q-LISP-CONSTANTS
   ;RTB-RTB-BITS RTB-RTS-BITS RTB-RTO-OPS
   ;RTB-MISC RTM-OPS READTABLE-%%-BITS
   SYSTEM-CONSTANT-LISTS SYSTEM-VARIABLE-LISTS ;SOME THINGS LOOK AT SUBLISTS OF THESE
   ;NOT SCRATCH-PAD-VARIABLES
   ;NOT SCRATCH-PAD-POINTERS SCRATCH-PAD-PARAMETERS SCRATCH-PAD-TEMPS 
   FASL-GROUP-FIELDS FASL-OPS
   FASL-TABLE-PARAMETERS FASL-CONSTANTS FASL-CONSTANT-LISTS))

;LIKE ABOVE BUT GET DECLARED SPECIAL RATHER THAN SYSTEM-CONSTANT
(SETQ SYSTEM-VARIABLE-LISTS '(
	A-MEMORY-LOCATION-NAMES M-MEMORY-LOCATION-NAMES 
	IO-STREAM-NAMES LISP-VARIABLES MISC-Q-VARIABLES
))

(SETQ IO-STREAM-NAMES '(
	STANDARD-INPUT STANDARD-OUTPUT ERROR-OUTPUT QUERY-IO TERMINAL-IO TRACE-OUTPUT
))

;These get declared special, and get their Maclisp values shipped over
(SETQ MISC-Q-VARIABLES '(SYSTEM-CONSTANT-LISTS SYSTEM-VARIABLE-LISTS PRIN1 FOR-CADR
			 COLD-INITIALIZATION-LIST BEFORE-COLD-INITIALIZATION-LIST
			 WARM-INITIALIZATION-LIST
                         ONCE-ONLY-INITIALIZATION-LIST SYSTEM-INITIALIZATION-LIST))

;These get declared special, but don't get sent over.  They get initialized
; some other way, e.g. from a load-time-setq in some compile list, or from special
; code in COLD, or by LISP-REINITIALIZE when the machine is first started.
(SETQ LISP-VARIABLES '(BASE IBASE PRINLENGTH PRINLEVEL *NOPOINT *RSET FASLOAD
		       ;; 5/3/89 DNG - Removed these 3 since they are now in ZLC.
		       ;;EVALHOOK PACKAGE READTABLE
		       + - *
		       USER-ID LISP-CRASH-LIST SCHEDULER-STACK-GROUP
		       RUBOUT-HANDLER LOCAL-DECLARATIONS STREAM-INPUT-OPERATIONS
		       STREAM-OUTPUT-OPERATIONS %INITIALLY-DISABLE-TRAPPING))

;These get declared SYSTEM-CONSTANT (which is similar to SPECIAL) and get their
; Maclisp values shipped over.
(SETQ Q-LISP-CONSTANTS '( PAGE-SIZE SIZE-OF-OB-TBL SIZE-OF-REGION-ARRAYS
			  SIZE-OF-AREA-ARRAYS LENGTH-OF-ATOM-HEAD 
			  %ADDRESS-SPACE-MAP-BYTE-SIZE %ADDRESS-SPACE-QUANTUM-SIZE
			  ARRAY-ELEMENTS-PER-Q ARRAY-BITS-PER-ELEMENT %FEF-HEADER-LENGTH
			  LAMBDA-LIST-KEYWORDS A-MEMORY-COUNTER-BLOCK-NAMES
                          A-Memory-Virtual-Address IO-Space-Virtual-Address))

(SETQ LAMBDA-LIST-KEYWORDS '(&OPTIONAL &REST &KEY &AUX &QUOTE &ALLOW-OTHER-KEYS
			     &SPECIAL &LOCAL
			     &FUNCTIONAL
			     &EVAL
			     &LIST-OF &BODY &WHOLE	;for DEFMACRO
                             &EXTENSION
			     &ENVIRONMENT	;added PMH 9/23
			     ))

;;; Data on how to set up the initial areas in the cold load.

;Don't put FUNCTION around the symbols in here -- that means if you
;redefine the function the microcode does not get the new definition,
;which is not what you normally want.  Saying FUNCTION makes it a couple
;microseconds faster to call it.  Not all of these data are actually
;used; check the microcode if you want to know.
(SETQ SUPPORT-VECTOR-CONTENTS '((QUOTE PRINT)                       ;#o0
				(QUOTE NAMED-STRUCTURE-INVOKE)   ;#o1
				(QUOTE DEFSTRUCT-DESCRIPTION)    ;#o2
				(QUOTE APPLY-LAMBDA)             ;#o3
 				(QUOTE EQUAL)                    ;#o4
				(QUOTE PACKAGE)                  ;#o5
				(QUOTE EXPT-HARD)                ;#o6
				(QUOTE NUMERIC-ONE-ARGUMENT)     ;#o7
				(QUOTE NUMERIC-TWO-ARGUMENTS)    ;#o10
				(QUOTE "unbound")                ;#o11            
				(QUOTE INSTANCE-HASH-FAILURE)    ;#o12
				(QUOTE INSTANCE-INVOKE-VECTOR)   ;#o13
				(QUOTE EQUALP)                   ;#o14
				(QUOTE EQUALP-ARRAY)             ;#o15
				(QUOTE LDB-HARD)                 ;#o16
				(QUOTE DPB-HARD)                 ;#o17
				(QUOTE CALL-STACK-GROUP)         ;#o20
				(QUOTE GLOBAL:AREF)              ;#o21
				(QUOTE MASK-FIELD-HARD)          ;#o22
				(QUOTE DEPOSIT-FIELD-HARD)       ;#o23
				;; Prolog SVCs.
				(QUOTE unify)	                 ;#o24
				(QUOTE stack-grow)               ;#o25
				(QUOTE get-arity)                ;#o26
				(QUOTE eval-arithmetic-term)     ;#o27
				(QUOTE |2.|)                     ;#o30
				(QUOTE undefined-pred)           ;#o31
				(QUOTE |fail|)                   ;#o32
				(QUOTE NIL)                  ;#o33 - place-holder for svc-pl-rehash
				(QUOTE :ALLOW-OTHER-KEYS)    ;#o34 - svc-allow-other-keys
				;; svc-tv-lisp-module-ops              ;#o35-#o54 - beginning of mac tv lisp vectors
                                                                       ;            (length 16)
				;; bitblt + args		       ;#o55-#o56 -similar to module-op processing for bitblt

                                ;; %svc-clos-Find-Generic-hash-table   ;#o57        - Clos call out function to to get
				                                       ;              hash table
				;; %svc-clos-class-description         ;#o60 -#o117 - Clos data-type class descriptions
				;; %svc-clos-array-description         ;#o120-#o157 - Clos data-type Array descriptions
                                ;; %svc-clos-Self-Ref-Pointer-Failure  ;#o160  - Function for Clos to call when self-ref-
				                                       ;         pointer led to list of nil instead of
				                                       ;         slot number
                                ;; %svc-clos-obsolete-class-description;#o161  - Function for Clos to call when the 
				                                       ;         %%clos-obsolete-flag is set in the class
                                                                       ;         description.
				;; %SVC-CLOS-CLASS-DESCRIPTION-NIL     ;#o162  - Clos class description for NIL

				))

;;(SETQ CONSTANTS-PAGE '(NIL T 0 1 2 3 4 5 6 7 8 9 10. -1 -2 -3 -4))		;CONTENTS OF CONSTANTS PAGE

(SETQ SCRATCH-PAD-VARIABLES '(SCRATCH-PAD-POINTERS SCRATCH-PAD-PARAMETER-OFFSET 
  SCRATCH-PAD-PARAMETERS SCRATCH-PAD-TEMP-OFFSET SCRATCH-PAD-TEMPS))

(SETQ SCRATCH-PAD-POINTERS '(INITIAL-TOP-LEVEL-FUNCTION ERROR-HANDLER-STACK-GROUP 
	CURRENT-STACK-GROUP INITIAL-STACK-GROUP	LAST-ARRAY-ELEMENT-ACCESSED))

(SETQ SCRATCH-PAD-PARAMETER-OFFSET 20)

(COND ((> (LENGTH SCRATCH-PAD-POINTERS) SCRATCH-PAD-PARAMETER-OFFSET) 
	(BARF 'BARF 'SCRACH-PAD-PARAMETER-OFFSET 'BARF)))

(SETQ SCRATCH-PAD-PARAMETERS '(ERROR-TRAP-IN-PROGRESS DEFAULT-CONS-AREA 
	BIND-CONS-AREA LAST-ARRAY-ACCESSED-TYPE LAST-ARRAY-ACCESSED-INDEX 
	INVOKE-MODE INVISIBLE-MODE 
	CDR-ATOM-MODE CAR-ATOM-MODE ACTIVE-MICRO-CODE-ENTRIES))

(SETQ SCRATCH-PAD-TEMP-OFFSET 20)

(COND ((> (LENGTH SCRATCH-PAD-PARAMETERS) SCRATCH-PAD-TEMP-OFFSET)
	(BARF 'BARF 'SCRATCH-PAD-TEMP-OFFSET 'BARF)))

(SETQ SCRATCH-PAD-TEMPS '(LAST-INSTRUCTION TEMP-TRAP-CODE LOCAL-BLOCK-OFFSET 
	SCRATCH-/#-ARGS-LOADED TEMP-PC SPECIALS-IN-LAST-BLOCK-SLOW-ENTERED))

;; No initial initializations
;; These variables must be initialized to NIL
;; BEFORE the first fasl file is loaded.
(SETQ COLD-INITIALIZATION-LIST NIL BEFORE-COLD-INITIALIZATION-LIST NIL
      WARM-INITIALIZATION-LIST NIL
      ONCE-ONLY-INITIALIZATION-LIST NIL SYSTEM-INITIALIZATION-LIST NIL)

;;; The documentation that used to be here has been moved to LMDOC;FASLD >

(SPECIAL FASL-TABLE FASL-GROUP-LENGTH FASL-GROUP-FLAG FASL-RETURN-FLAG)

(SETQ FASL-GROUP-FIELD-VALUES '(%FASL-GROUP-CHECK 100000 
   %FASL-GROUP-FLAG 40000 %FASL-GROUP-LENGTH 37700 
   FASL-GROUP-LENGTH-SHIFT -6 %FASL-GROUP-TYPE 77 
  %%FASL-GROUP-CHECK 2001 %%FASL-GROUP-FLAG 1701 %%FASL-GROUP-LENGTH 0610 
  %%FASL-GROUP-TYPE 0006))

(SETQ FASL-GROUP-FIELDS (GET-ALTERNATE FASL-GROUP-FIELD-VALUES))
(ASSIGN-ALTERNATE FASL-GROUP-FIELD-VALUES)

;; 1/31/89 DNG - New operators FASL-OP-PROG1, FASL-OP-EVAL2, FASL-OP-APPLY1, 
;;		and FASL-OP-NO-PROTECT to support MAKE-LOAD-FORM and LOAD-TIME-VALUE for release 6.
(SETQ FASL-OPS '(FASL-OP-ERR FASL-OP-NOOP FASL-OP-INDEX FASL-OP-SYMBOL FASL-OP-LIST 
  FASL-OP-TEMP-LIST FASL-OP-FIXED FASL-OP-FLOAT 
  FASL-OP-ARRAY
  FASL-OP-UNUSED09 ; used to be FASL-OP-EVAL, supported by LOAD before rel 6 but not used by FASD since 1983
  FASL-OP-MOVE 
  FASL-OP-FRAME FASL-OP-LIST-COMPONENT FASL-OP-ARRAY-PUSH FASL-OP-STOREIN-SYMBOL-VALUE 
  FASL-OP-STOREIN-FUNCTION-CELL FASL-OP-STOREIN-PROPERTY-CELL 
  FASL-OP-FETCH-SYMBOL-VALUE FASL-OP-FETCH-FUNCTION-CELL FASL-OP-FETCH-PROPERTY-CELL
  FASL-OP-BOMB; used to be FASL-OP-APPLY, don't use because it crashes the loader for release 5 or earlier.
  FASL-OP-END-OF-WHACK 
  FASL-OP-END-OF-FILE FASL-OP-SOAK FASL-OP-FUNCTION-HEADER FASL-OP-FUNCTION-END 
  FASL-OP-NULL-ARRAY-ELEMENT FASL-OP-PROG1 FASL-OP-VM2-LIST
  FASL-OP-VM2-TEMP-LIST FASL-OP-VM2-LIST-COMPONENT FASL-OP-APPLY1
  ;; the next 3 used to be FASL-OP-S-V-CELL FASL-OP-FUNCELL FASL-OP-CONST-PAGE
  FASL-OP-UNUSED32 FASL-OP-UNUSED33 FASL-OP-EVAL2
  FASL-OP-SET-PARAMETER ; supported by loader but not used by FASD
  FASL-OP-INITIALIZE-ARRAY 
  FASL-OP-CHARACTER FASL-OP-CREATE-AND-STORE-CEF FASL-OP-PEF
  FASL-OP-IEEE-FLOAT FASL-OP-KEYWORD-SYMBOL FASL-OP-LISP-SYMBOL	; Replaced UNUSED3 with IEEE-FLOAT
  FASL-OP-FEF FASL-OP-STRING FASL-OP-STOREIN-ARRAY-LEADER 
  FASL-OP-INITIALIZE-NUMERIC-ARRAY FASL-OP-NO-PROTECT FASL-OP-PACKAGE-SYMBOL
  FASL-OP-EVAL1 FASL-OP-FILE-PROPERTY-LIST FASL-OP-REL-FILE FASL-OP-RATIONAL
  FASL-OP-COMPLEX FASL-OP-LARGE-INDEX FASL-OP-STOREIN-SYMBOL-CELL))

(ASSIGN-VALUES FASL-OPS 0)

(SETQ FASL-TABLE-PARAMETERS '(FASL-NIL FASL-EVALED-VALUE FASL-TEM1 FASL-TEM2 FASL-TEM3 
    FASL-SYMBOL-HEAD-AREA 
    FASL-SYMBOL-STRING-AREA FASL-STRING-AREA FASL-ARRAY-AREA 
    FASL-FRAME-AREA FASL-LIST-AREA FASL-TEMP-LIST-AREA 
    FASL-UNUSED FASL-UNUSED2 FASL-UNUSED3 
    FASL-UNUSED6 FASL-UNUSED4 FASL-UNUSED5))
(ASSIGN-VALUES FASL-TABLE-PARAMETERS 0)

(SETQ FASL-CONSTANTS '(LENGTH-OF-FASL-TABLE FASL-TABLE-WORKING-OFFSET))

(SETQ FASL-CONSTANT-LISTS '(FASL-GROUP-FIELDS FASL-OPS FASL-TABLE-PARAMETERS 
    FASL-CONSTANTS))

(SETQ FASL-TABLE-WORKING-OFFSET 40)

(COND ((> (LENGTH FASL-TABLE-PARAMETERS) FASL-TABLE-WORKING-OFFSET)
	(IOC V)
	(PRINT 'FASL-TABLE-PARAMETER-OVERFLOW)))

;PEOPLE CALL THIS YOU KNOW, DON'T GO RANDOMLY DELETING IT!
(DEFUN FASL-ASSIGN-VARIABLE-VALUES NIL 
 ())  ;I GUESS WHAT THIS USED TO DO IS DONE AT TOP LEVEL IN THIS FILE
