;;; -*- Mode:Lisp; Base:8 -*-
;;;
;;;  Phil Mueller  July 1983
;;;
;;; This file contains the constant definitions for all of the Raven microcode
;;; fields.  This file was created for the Raven Simulator.
;;;

(DefVar *Ravfmt-Loaded* 't "Ravfmt Load Indicator")
(defconst *Format-File-Type* "Raven")

;;; Generate a value for the a byte field.
;;;
(DefMacro Byte-Value (value field)
  (Dpb (Eval value) (Eval field) 0))

;;; Fetch a multiplier the starting bit position for a field.
(DefMacro Byte-Position-Multiplier (field)
  (Ash 1 (byte-position (Eval field))))

;;;
;;;  A hack necessary for Seymour (which loads this file twice into two different
;;;  packages and expects to reference this macro without package specifier).
;(global:globalize 'byte-position-multiplier)


;; Define Memory Sizes

(DefConst %Size-A-Mem 2000)
(DefConst %Size-M-Mem 100)
(DefConst %Size-D-Mem 10000)
(DefConst %Size-I-Mem 40000)
(DefConst %Size-T-Mem 20)
(DefConst %Size-PDL-Buffer 2000)
(DefConst %Size-Micro-Stack 100)
(DefConst %Size-Level-1-Memory-Map 10000)
(DefConst %Size-Level-2-Memory-Map 10000)
(DefConst %Size-PROM-Mem 4000)
(DefConst %Size-Main-Mem (* 10. 256.))
(DefConst %Size-Trace-Mem 2000)
(DefConst %Number-of-Misc-Ops 1024.)

;; Maximum overlay size
(DefConst %Size-O-Mem 4000)

;;; Codes used to initialize memories

(DefConst %Array-Code-D-Memory 01000000000) 
(DefConst %Array-Code-A-Memory 02000000000) 
(DefConst %Array-Code-M-Memory 03000000000) 
(DefConst %Array-Code-I-Memory 04000000000) 
(DefConst %Array-Code-PDL-Buffer 05000000000)
(DefConst %Array-Code-Micro-Stack 06000000000)
(DefConst %Array-Code-Level-1-Memory-Map 07000000000)
(DefConst %Array-Code-Level-2-Memory-Map 10000000000)
(DefConst %Array-Code-PROM-Memory 11000000000)

;;; Define MCR File Block Codes

(DefConst %Block-Code-EOF 0)
(DefConst %Block-Code-I-Mem 1)
(DefConst %Block-Code-D-Mem 2)
(DefConst %Block-Code-Main-Mem 3)
(DefConst %Block-Code-A-Mem 4)
(DefConst %Block-Code-T-Mem 5)


;;; Define Q Format

(DefConst %%R-Q-CDR-Code (Byte 2. 30.))
(DefConst %%R-Q-Data-Type (Byte 5. 25.))
(DefConst %%R-Q-Pointer (Byte 25. 0.))
(DefConst %%R-Q-All-But-Pointer (Byte 7. 25.))
(DefConst %%R-Q-Boxed-Sign-Bit (Byte 1. 24.))

;;; Define TM0- states

(DefConst %NuBus-Byte-Access 0)
(DefConst %NuBus-Word-Access 1)

;;; Define Map Level 2 Meta Bit Fields

(DefConst %%R-Region-Oldspace-Meta-Bit (Byte 1. 27.))

;; Define Micro Instruction Opcodes

(DefConst %Opcode-ALU      0)
(DefConst %Opcode-BYTE     1)
(DefConst %Opcode-JUMP     2)
(DefConst %Opcode-DISPATCH 3)

;;; Define Micro Program Counter trap address

(DefConst %Address-Reset 0)
(DefConst %Address-Power-Fail 4)
(DefConst %Address-Parity-Error 10)
(DefConst %Address-Warm-Start 14)
(DefConst %Address-Call-to-Illop 20)
(DefConst %Address-Call-to-Trap 24)
(DefConst %Address-Call-to-BUSERR 30)

;;; Define Device Base Addresses and Sizes

(DefConst %Base-Cadr-Disk 17377774)
(DefConst %Size-Cadr-Disk 4.)
(Defconst %Size-Sector 256.)

;;; Define Next Instruction Modify Fields

(DefConst %%OA-High-Context (Byte 24. 32.))
(DefConst %%OA-Low-Context (Byte 32. 0.))


;; Define ALU Instruction Format

(DefConst %%MInst-Opcode (Byte 2. 54.))
(DefConst %%MInst-Abbrv-Jump (Byte 3. 51.))
(DefConst %%MInst-Parity (Byte 1. 50.))
(DefConst %Minst-Parity (dpb 1 %%MInst-Parity 0))
(DefConst %%MInst-Halt (Byte 1 49.))
(DefConst %%MInst-M-Source-Address (Byte 7. 42.))
(DefConst %%MInst-A-Source-Address (Byte 10. 32.))
(DefConst %%MInst-Destination-A-Memory-Select (Byte 1. 31.))
(DefConst %%MInst-Destination-Address (Byte 13. 19.))
(DefConst %%MInst-Destination-A-Memory-Address (Byte 10. 19.))
(DefConst %%MInst-Destination-Functional-Destination (Byte 6. 25.))
(DefConst %%MInst-Destination-M-Memory-Address (Byte 6. 19.))
(DefConst %%MInst-Output-Bus-Control (Byte 3. 16.))
(DefConst %%MInst-Condition-Invert-Sense-Bit (Byte 1. 15.))
(DefConst %%MInst-Condition-Classifier-RAM-select (Byte 1. 14.))
(DefConst %%MInst-Condition-Select (Byte 4. 10.))
(DefConst %%MInst-Condition (Byte 5. 10.))
(DefConst %%MInst-Write-Classifier-RAM (Byte 1. 9.))
(DefConst %%MInst-ALU-Tagged (Byte 1. 8.))
(DefConst %%MInst-ALU-Opcode (Byte 5. 3.))
(DefConst %%MInst-ALU-Carry-In (Byte 1. 2.))
(DefConst %%MInst-Q-Control (Byte 2. 0.))
(DefConst %%MInst-A-Destination-Field (Byte 24. 32.))
(DefConst %%MInst-M-Destination-Field (Byte 32. 0.))

;; Define ALU Opcodes

(DefConst %ALU-Opcode-SETZ  0)
(DefConst %ALU-Opcode-AND   1)
(DefConst %ALU-Opcode-ANDCA 2)
(DefConst %ALU-Opcode-SETM  3)
(DefConst %ALU-Opcode-ANDCM 4)
(DefConst %ALU-Opcode-SETA  5)
(DefConst %ALU-Opcode-XOR   6)
(DefConst %ALU-Opcode-IOR   7)
(DefConst %ALU-Opcode-ANDCB 10)
(DefConst %ALU-Opcode-EQV   11)
(DefConst %ALU-Opcode-SETCA 12)
(DefConst %ALU-Opcode-ORCA  13)
(DefConst %ALU-Opcode-SETCM 14)
(DefConst %ALU-Opcode-ORCM  15)
(DefConst %ALU-Opcode-ORCB  16)
(DefConst %ALU-Opcode-SETO  17)
(DefConst %ALU-Opcode-ADD   31)
(DefConst %ALU-Opcode-SUB   36)
(DefConst %ALU-Opcode-M+M   37)
(DefConst %ALU-Opcode-M+    34)
(DefConst %ALU-Opcode-M+1   34)
(DefConst %ALU-Opcode-MUL       20)
(DefConst %ALU-Opcode-MUL-Last  21)
(DefConst %ALU-Opcode-DIV       22)
(DefConst %ALU-Opcode-DIV-Last  22)
(DefConst %ALU-Opcode-DIV-First 23)
(DefConst %ALU-Opcode-DIV-Corr  24)

;;; Define Output Bus Control

(DefConst  %Output-Bus-A-Bus 0)
(DefConst  %Output-Bus-R-Bus 1)
(DefConst  %Output-Bus-A-Bus2 2)
(DefConst  %Output-Bus-Normal 3)
(DefConst  %Output-Bus-LeftShift-1 4)
(DefConst  %Output-Bus-RightShift-1 5)
(DefConst  %Output-Bus-Pointer-Extend 6)
(DefConst  %Output-Bus-Mirror 7)

;;; Define Q Control

(DefConst  %Q-Control-Nop 0)
(DefConst  %Q-Control-Shift-Left 1)
(DefConst  %Q-Control-Shift-Right 2)
(DefConst  %Q-Control-Load 3)


;; Define BYTE Instruction Format

;(DefConst %%MInst-Opcode (Byte 2. 54.))
;(DefConst %%MInst-Abbrv-Jump (Byte 3. 51.))
;(DefConst %%MInst-Parity (Byte 1. 50.))
;(DefConst %%MInst-Halt (Byte 1 49.))
;(DefConst %%MInst-M-Source-Address (Byte 7. 42.))
;(DefConst %%MInst-A-Source-Address (Byte 10. 32.))
;(DefConst %%MInst-Destination-A-Memory-Select (Byte 1. 31.))
;(DefConst %%MInst-Destination-Address (Byte 12. 19.))
;(DefConst %%MInst-Destination-Functional-Destination (Byte 6. 25.))
;(DefConst %%MInst-Destination-M-Memory-Address (Byte 6. 19.))
(DefConst %%MInst-Mask-Rotate (Byte 1. 18.))
(DefConst %%MInst-Source-Rotate (Byte 1. 17.))
(DefConst %%MInst-Byte-Op (Byte 2. 17.))  ; MR and SR taken together
(DefConst %%MInst-Rotation-Direction (Byte 1. 16.))
;(DefConst %%MInst-Condition-Invert-Sense-Bit (Byte 1. 15.))
;(DefConst %%MInst-Condition-Classifier-RAM-select (Byte 1. 14.))
;(DefConst %%MInst-Condition-Select (Byte 4. 10.))
;(DefConst %%MInst-Condition (Byte 5. 10.))
(DefConst %%MInst-Rotation-Length (Byte 5 5.))
(DefConst %%MInst-Rotation-Count (Byte 5. 0.))
(DefConst %%MInst-Rotation-Count-And-Length (Byte 10. 0.))
;(DefConst %%MInst-A-Destination-Field (Byte 24. 32.))
;(DefConst %%MInst-M-Destination-Field (Byte 32. 0.))

(DefConst %Byte-Size-Correction 0)

(DefConst %Byte-Op-Unused 0)
(DefConst %Byte-Op-LDB 1)
(DefConst %Byte-Op-Selective-Deposit 2)
(DefConst %Byte-Op-Deposit-Byte 3)

(DefConst %Rotate-Right-Bit (Byte-Value 1 %%MInst-Rotation-Direction))


;; Define JUMP Instruction Format

;(DefConst %%MInst-Opcode (Byte 2. 54.))
;(DefConst %%MInst-Abbrv-Jump (Byte 3. 51.))
;(DefConst %%MInst-Parity (Byte 1. 50.))
;(DefConst %%MInst-Halt (Byte 1 49.))
;(DefConst %%MInst-M-Source-Address (Byte 7. 42.))
;(DefConst %%MInst-A-Source-Address (Byte 10. 32.))
(DefConst %%MInst-New-Micro-PC (Byte 14. 18.))
(DefConst %%MInst-M-Source-Select (Byte 1. 17.))
;(DefConst %%MInst-Rotation-Direction (Byte 1. 16.))
;(DefConst %%MInst-Condition-Invert-Sense-Bit (Byte 1. 15.))
;(DefConst %%MInst-Condition-Classifier-RAM-select (Byte 1. 14.))
;(DefConst %%MInst-Condition-Select (Byte 4. 10.))
;(DefConst %%MInst-Condition (Byte 5. 10.))
(DefConst %%MInst-Bit-Set-Condition (Byte 5. 10.))
(DefConst %%MInst-Write-Control-Store (Byte 1. 9.))
(DefConst %%MInst-Read-Control-Store (Byte 1. 8.))
(DefConst %%MInst-Jump-Op (Byte 3. 5.))
(DefConst %%MInst-Return-Bit (Byte 1. 7.))
(DefConst %%MInst-Call-Bit (Byte 1. 6.))
(DefConst %%MInst-Inhibit-Bit (Byte 1. 5.))
;(DefConst %%MInst-Rotation-Count (Byte 5. 0.))
;(DefConst %%MInst-A-Destination-Field (Byte 24. 32.))
;(DefConst %%MInst-M-Destination-Field (Byte 32. 0.))

;;; Define Jump Instruction Opcodes

(DefConst %Jump-Branch-Xct-Next 0)
(DefConst %Jump-Branch 1)
(DefConst %Jump-Call-Xct-Next 2)
(DefConst %Jump-Call 3)
(DefConst %Jump-Return-Xct-Next 4)
(DefConst %Jump-Return 5)
(DefConst %Jump-Nop 6)
(DefConst %Jump-Skip 7)


;; Define DISPATCH Instruction Format

;(DefConst %%MInst-Opcode (Byte 2. 54.))
;(DefConst %%MInst-Abbrv-Jump (Byte 3. 51.))
;(DefConst %%MInst-Parity (Byte 1. 50.))
;(DefConst %%MInst-Halt (Byte 1 49.))
;(DefConst %%MInst-M-Source-Address (Byte 7. 42.))
;(DefConst %%MInst-A-Source-Address (Byte 10. 32.))
(DefConst %%MInst-Dispatch-Constant (Byte 10. 32.))
(DefConst %%MInst-Dispatch-Address (Byte 12. 20.))
(DefConst %%MInst-Dispatch-Unused (Byte 3. 17.))
;(DefConst %%MInst-Rotation-Direction (Byte 1. 16.))
(DefConst %%MInst-Enable-Instruction-Stream (Byte 1. 15.))
(DefConst %%MInst-Alter-Return-Address (Byte 1. 17.))
(DefConst %%MInst-Dispatch-Source (Byte 2. 12.))
(DefConst %%MInst-Map-Old-Space-Bit (Byte 1. 11.))
(DefConst %%MInst-Map-GC-Volatility-Bit (Byte 1. 10.))
(DefConst %%MInst-Map-Enable (Byte 2. 10.))
(DefConst %%MInst-Dispatch-Op (Byte 2. 8.))
(DefConst %%MInst-Write-Dispatch-Memory (Byte 1. 9.))
(DefConst %%MInst-Read-Dispatch-Memory (Byte 1. 8.))
(DefConst %%MInst-Mask-Length (Byte 3. 5.))
;(DefConst %%MInst-Rotation-Count (Byte 5. 0.))
;(DefConst %%MInst-A-Destination-Field (Byte 24. 32.))
;(DefConst %%MInst-M-Destination-Field (Byte 32. 0.))

;;; Dispatch Sources

(DefConst %Dispatch-Source-M-Source 0)
(DefConst %Dispatch-Source-M-Tag 1)
(DefConst %Dispatch-Source-MIR 2)
(DefConst %Dispatch-Source-MIR2 3)

;;; Dispatch Map Enable Codes

(DefConst %Dispatch-Map-Normal 0)
(DefConst %Dispatch-Map-GC-Volatility 1)
(DefConst %Dispatch-Map-Old-Space-Bit 2)
(DefConst %Dispatch-Map-GC-Volatility-Or-Old-Space-Bit 3)

;;; Define Dispatch Memory Format

(DefConst %%Dispatch-Memory-Parity-Bit (Byte 1. 17.))
(DefConst %%Dispatch-Memory-R-Bit (Byte 1. 16.))
(DefConst %%Dispatch-Memory-P-Bit (Byte 1. 15.))
(DefConst %%Dispatch-Memory-R-P-Bits  (Byte 2. 15.))
(DefConst %%Dispatch-Memory-N-Bit (Byte 1. 14.))
(DefConst %%Dispatch-Memory-Destination (Byte 14. 0.))

;;; Define Dispatch R-P combination codes

(DefConst %Dispatch-R-P-Normal 0)
(DefConst %Dispatch-R-P-Call 1)
(DefConst %Dispatch-R-P-Return 2)
(DefConst %Dispatch-R-P-Fall-Through 3)

;;; Define Dispatch Operations

(DefConst %Dispatch-Op-Dispatch 0)
(DefConst %Dispatch-Op-Read 1)
(DefConst %Dispatch-Op-Write 2)
(DefConst %Dispatch-Op-Error 3)


;;; Define M-Bus Functional Sources

(DefConst %MBS-VMA 100)
(DefConst %MBS-Q-R 101)
(DefConst %MBS-Macro-Instruction-Argument-Field 102)
(DefConst %MBS-Micro-Stack-Pointer 103)
(DefConst %MBS-MCR 104)     ; Machine Control Register
(DefConst %MBS-Location-Counter 105)
(DefConst %MBS-Memory-Map-Level-2-Address 106)
(DefConst %MBS-Read-I-Arg 107)
(DefConst %MBS-Memory-Map-Level-1 110)
(DefConst %MBS-Memory-Map-Level-2-Control 111)
(DefConst %MBS-Macro-Instruction-Buffer 112)
(DefConst %MBS-Macro-Instruction-Branch-Field 113)
(DefConst %MBS-Micro-Stack-Data 120)
(DefConst %MBS-Micro-Stack-Data-Pop 121)
(DefConst %MBS-MD 122)
(DefConst %MBS-C-PDL-Buffer-Pointer 140)
(DefConst %MBS-C-PDL-Buffer-Index 141)
(DefConst %MBS-C-PDL-Buffer-Pointer-Pop 144)
(DefConst %MBS-C-PDL-Buffer-Index-Decrement 145)
(DefConst %MBS-PDL-Buffer-Pointer 150)
(DefConst %MBS-PDL-Buffer-Index 151)
(DefConst %MBS-PDL-Buffer-Pointer-Pop 154)
(DefConst %MBS-PDL-Buffer-Index-Decrement 155)



;;; Define M-Bus Functional Destinations

(DefConst %MBD-Nop 0)
(DefConst %MBD-Location-Counter 1)
(DefConst %MBD-MCR 2)  ; Machine Control Register
(DefConst %MBD-Micro-Stack-Pointer 3)
(DefConst %MBD-Micro-Stack-Data 4)
(DefConst %MBD-Micro-Stack-Data-Push 5)
(DefConst %MBD-OA-Reg-Low 6)
(DefConst %MBD-OA-Reg-High 7)
(DefConst %MBD-Macro-Instruction-Buffer 10)	;
(DefConst %MBD-Test-Synch 17)
(DefConst %MBD-VMA 20)
(DefConst %MBD-VMA-Write-Map-Level-1 21)
(DefConst %MBD-VMA-Write-Map-Level-2-Control 22)
(DefConst %MBD-VMA-Write-Map-Level-2-Address  23)
(DefConst %MBD-VMA-Start-Read 24)
(DefConst %MBD-VMA-Start-Write 25)
(DefConst %MBD-VMA-Start-Read-Unmapped 26)
(DefConst %MBD-VMA-Start-Write-Unmapped 27)
(DefConst %MBD-MD 30)
(DefConst %MBD-MD-Write-Map-Level-1 31)
(DefConst %MBD-MD-Write-Map-Level-2-Control 32)
(DefConst %MBD-MD-Write-Map-Level-2-Address 33)
(DefConst %MBD-MD-Start-Read 34)
(DefConst %MBD-MD-Start-Write 35)
(DefConst %MBD-MD-Start-Read-Unmapped 36)
(DefConst %MBD-MD-Start-Write-Unmapped 37)
(DefConst %MBD-C-PDL-Buffer-Pointer 40)
(DefConst %MBD-C-PDL-Buffer-Index 41)
(DefConst %MBD-C-PDL-Buffer-Pointer-Push 44)
(DefConst %MBD-C-PDL-Buffer-Index-Increment 45)
(DefConst %MBD-PDL-Buffer-Pointer 50)
(DefConst %MBD-PDL-Buffer-Index 51)
(DefConst %MBD-VMA-Start-Read-Unmapped-NU 66)
(DefConst %MBD-VMA-Start-Write-Unmapped-NU 67)
(DefConst %MBD-MD-Start-Read-Unmapped-NU 76)
(DefConst %MBD-MD-Start-Write-Unmapped-NU 77)



;;; Define Abbreviated Jump Field Values

(DefConst %A-Jump-Field-Nop 0)
(DefConst %A-Jump-Field-Skip 1)
(DefConst %A-Jump-Field-Call-Illop 2)
(DefConst %A-Jump-Field-Call-Trap 3)
(DefConst %A-Jump-Field-Call-Buserr 4)
(DefConst %A-Jump-Field-Unused 5)
(DefConst %A-Jump-Field-Popj 6)
(DefConst %A-Jump-Field-Popj-After-Next 7)

;;; Define Miscellaneous Functions

(DefConst  %Misc-Function-Normal 0)
(DefConst  %Misc-Function-Halt 1)
(DefConst  %Misc-Function-Write-D-Mem 2)
(DefConst  %Misc-Function-Unused 3)


;;; Define Conditional Field

(DefConst %Condition-Bit-Set 0)
(DefConst %Condition-Less 1)
(DefConst %Condition-Less-Or-Equal 2)
(DefConst %Condition-Not-Equal 3)
(DefConst %Condition-Page-Fault 4)
(DefConst %Condition-Page-Fault-or-Interrupt 5)
(DefConst %Condition-Page-Fault-or-Interrupt-or-Sequence-Break 6)
(DefConst %Condition-True 7)
(DefConst %Condition-True-ALU 7)
(DefConst %Condition-True-BYTE 7)
(DefConst %Condition-Tag-Not-Equal 10)
(DefConst %Condition-Not-Memory-Busy 11)
(DefConst %Condition-Q0 12)
(DefConst %Condition-NU-Bus-Error 13)
(DefConst %Condition-Not-Fixnum-Overflow 14)
(DefConst %Condition-Boxed-Sign-Bit 15)
(DefConst %Condition-No-Interrupt 16)
(DefConst %Condition-Tag-Classify 20)


;;; Define Map Level 1 Bits

(DefConst %%ML1-Map-Entry-Valid (Byte 1. 11.))
(DefConst %%ML1-Oldspace-Bit (Byte 1. 10.))
(DefConst %%ML1-GC-Volatility-Bits (Byte 3. 7.))
(DefConst %%ML1-Address (Byte 7. 0.))
(DefConst %%ML1-Control-And-Address (Byte 14. 0.))

(DefConst %%ML1-VMA-Address-Bits (Byte 12. 13.))

;;; Define Map Level 2 Bits

(DefConst %%ML2-GC-Volatility-Bits (Byte 2. 33.))
(DefConst %%ML2-Forced-Access-Bit (Byte 1. 32.))
(DefConst %%ML2-Access-Bit (Byte 1. 31.))
(DefConst %%ML2-Map-Status-Code (Byte 3. 28.))
(DefConst %%ML2-Meta-Bits (Byte 6. 22.))
(DefConst %%ML2-All-Control-Bits (Byte 13. 22.))
(DefConst %%ML2-Physical-Page-Number (Byte 22. 0.))

(DefConst %%ML2-VMA-Address-Bits (Byte 5. 8.))
(DefConst %%ML2-ML1-Address-And-VMA-Address-Bits (Byte 7. 5.))

(DefConst %%Mem-VMA-Address-Bits (Byte 8. 0.))
(DefConst %%Mem-ML2-Address-And-VMA-Address-Bits (Byte 22. 8.))

;;; Define Map Level 2 Status Codes

(DefConst %ML2-Map-Status-Miss 0)
(DefConst %ML2-Map-Status-Meta-Only 1)
(DefConst %ML2-Map-Status-Read-Only 2)
(DefConst %ML2-Map-Status-Read-Write-First 3)
(DefConst %ML2-Map-Status-Read-Write 4)
(DefConst %ML2-Map-Status-PDL 5)
(DefConst %ML2-Map-Status-MAR-Trap 6)
(DefConst %ML2-Map-Status-Not-Used 7)


;;; Define Fields of Machine-Control-Register

(DefConst %%MCR-Slot-ID (Byte 4. 28.))
(DefConst %%MCR-Chaining-Enable (Byte 1. 26.))
(DefConst %%MCR-Misc-Op-Group-1 (Byte 1. 25.))
(DefConst %%MCR-Misc-Op-Group-0 (Byte 1. 24.))
(DefConst %%MCR-Loop-On-Test (Byte 1. 23.))
(DefConst %%MCR-Need-Fetch (Byte 1. 22.))
(DefConst %%MCR-NU-Bus-Reset (Byte 1. 21.))
(DefConst %%MCR-Local-Reset (Byte 1. 20.))
(DefConst %%MCR-Int-Level-3 (Byte 1. 19.))
(DefConst %%MCR-Int-Level-2 (Byte 1. 18.))
(DefConst %%MCR-Int-Level-1 (Byte 1. 17.))
(DefConst %%MCR-Int-Level-0 (Byte 1. 16.))
(DefConst %%MCR-Interrupts (Byte 4. 16.))
(DefConst %%MCR-Int-Enable (Byte 1. 15.))
(DefConst %%MCR-Sequence-Break (Byte 1. 14.))
(DefConst %%MCR-Parity-Trap-Enable (Byte 1. 13.))
(DefConst %%MCR-Parity-Halt-Enable (Byte 1. 12.))
(DefConst %%MCR-PROM-Disable (Byte 1. 11.))
(DefConst %%MCR-Interlocked-Memory-Control (Byte 1. 10.))
(DefConst %%MCR-Forced-Access-Request (Byte 1. 9.))
(DefConst %%MCR-Memory-Cycle-Enable (Byte 1. 8.))
(DefConst %%MCR-LED-5- (Byte 1. 5.))
(DefConst %%MCR-LED-4- (Byte 1. 4.))
(DefConst %%MCR-LED-3- (Byte 1. 3.))
(DefConst %%MCR-LED-2- (Byte 1. 2.))
(DefConst %%MCR-LED-1- (Byte 1. 1.))
(DefConst %%MCR-LED-0- (Byte 1. 0.))

;;; Spy port definitions.

;;; Processor status (PS) fields.
(DefConst PS-Running 0101)
(DefConst PS-MD-Not-Enabled 0301)
(DefConst PS-VMA-Not-Enabled 0401)
(DefConst PS-Not-TestSync 0501)
(DefConst PS-Not-JTakenLast 0601)
(DefConst PS-Next-NOP 0701)
(DefConst PS-IMODLO 1001)
(DefConst PS-IMODHI 1101)
(DefConst PS-Not-Page-Fault 1201)
(DefConst PS-Not-Control-Store-Parity 1301)
(DefConst PS-Not-Halt-Bit-Set 1401)
(DefConst PS-Not-Buserr 1501)
(DefConst PS-Not-Prom 1601)

;;;
;;;  Trace-memory format.
(defconst %%previous-instruction-inhibited #o1701)
(defconst %%instruction-reached-by-jump	   #o1601)
(defconst %%traced-instruction		   #o0016)


;;; Special constants the Microcode Assembler needs to be modular.

(DefConst Dispatch-Instruction-Code
  (Byte-Value %Opcode-DISPATCH %%MInst-Opcode))

(DefConst Byte-Instruction-Code
  (Byte-Value %Opcode-BYTE %%MInst-Opcode))

(DefConst ALU-Instruction-Code
  (Byte-Value %Opcode-ALU %%MInst-Opcode))

(DefConst JUMP-Instruction-Code
  (Byte-Value %Opcode-JUMP %%MInst-Opcode))

(DefConst Dispatch-P-Bit
  (Byte-Value 1 %%Dispatch-Memory-P-Bit))

(DefConst Dispatch-N-Bit
  (Byte-Value 1 %%Dispatch-Memory-N-Bit))

(DefConst Dispatch-R-Bit
  (Byte-Value 1 %%Dispatch-Memory-R-Bit))

(DefConst Byte-Default-A-Bus-Source
  (Byte-Value 2 %%MInst-A-Source-Address)) ; A memory location 2

(DefConst Byte-Default-M-Bus-Source
  (Byte-Value 0 %%MInst-M-Source-Address))	; M memory location 2

(DefConst ALU-Default-Output-Bus-Selector
  (Byte-Value %Output-Bus-Normal %%MInst-Output-Bus-Control))

(DefConst Dispatch-Address-Multiplier
  (Byte-Position-Multiplier %%MInst-Dispatch-Address))

(DefConst Dispatch-Field-Multiplier
  (Byte-Position-Multiplier %%MInst-Mask-Length))

(DefConst Byte-Field-Multiplier
  (Byte-Position-Multiplier %%MInst-Rotation-Length))

(DefConst *T-Mem-Supported* 't)
(DefConst *Entry-Address-Supported* 't)
