unit UEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Spin;

type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    SpinEdit2: TSpinEdit;
    Button1: TButton;
    Button2: TButton;
    OpenDialog1: TOpenDialog;
    procedure PaintBox1Paint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button1Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private-Deklarationen }
    Level : array[0..13, 0..13] of Byte;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

const
  BrickColors : array[0..5] of TColor = ($ffffff, $000000, $666666, $888888, $aaaaaa, $cccccc);
  MaxLevelPos = 41806;

implementation

{$R *.DFM}

procedure TForm1.PaintBox1Paint(Sender: TObject);
var i, j: Integer;
begin
  for i:=0 to 13 do
  begin
    for j:=0 to 13 do
    begin
      PaintBox1.Canvas.Brush.Color := BrickColors[Level[i, j]];
      PaintBox1.Canvas.FillRect(Rect(j*22, i*16, j*22+21, i*16+15));
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var i, j: Integer;
begin
  for i:=0 to 13 do
  begin
    for j:=0 to 13 do
    begin
      Level[i, j]:=0;
    end;
  end;
end;

procedure TForm1.PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var i, j: Integer;
begin
  i := Y div 16;
  j := X div 22;
  if (ssShift in Shift) then
  begin
    Level[i, j] := Level[i, j]+5;
  end
  else
  begin
    Level[i, j] := Level[i, j]+1;
  end;
  Level[i, j] := Level[i, j] mod 6;
  PaintBox1Paint(self);
end;

procedure TForm1.Button1Click(Sender: TObject);
var f: File of Byte;
    b: Byte;
    i, j: Integer;
begin
  if not FileExists(OpenDialog1.FileName) then
  begin
    if not (OpenDialog1.Execute) then
    begin
      Application.MessageBox(
        'You havent picked a file yet!',
        'Error opening File',
        MB_OK);
    end;
  end;
  AssignFile(f, OpenDialog1.FileName);
  Reset(f);
  Seek(f, MaxLevelPos);
  Read(f, b);
  SpinEdit1.Value := b;
  Seek(f, MaxLevelPos+1+(SpinEdit2.Value-1)*14*14);
  for i:=0 to 13 do
  begin
    for j:=0 to 13 do
    begin
      Read(f, b);
      Level[i, j]:=b;
    end;
  end;
  CloseFile(f);
  PaintBox1Paint(Self);
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
var f: file of Byte;
    b: Byte;
begin
  if not FileExists(OpenDialog1.FileName) then
  begin
    exit;
  end;
  AssignFile(f, OpenDialog1.FileName);
  Reset(f);
  Seek(f, MaxLevelPos);
  b:=SpinEdit1.Value;
  Write(f, b);
  CloseFile(f);
end;

procedure TForm1.Button2Click(Sender: TObject);
var f: file of Byte;
    i, j: Integer;
begin
  if not FileExists(OpenDialog1.FileName) then
  begin
    Application.MessageBox(
      'You havent picked a file yet!',
      'Error opening File',
      MB_OK);
    exit;
  end;
  AssignFile(f, OpenDialog1.FileName);
  Reset(f);
  Seek(f, MaxLevelPos);
  Seek(f, MaxLevelPos+1+(SpinEdit2.Value-1)*14*14);
  for i:=0 to 13 do
  begin
    for j:=0 to 13 do
    begin
      Write(f, Level[i, j]);
    end;
  end;
  CloseFile(f);
end;

end.
