;--------------------------------------------------------------


;WorldTimePicker 

;makes long constants at $79CF,$79D3 obselete
                                
;Creates and execute world/localtimepicker

;       entry:          
;               L=1: LocalCity, 0:WorldTime
        
                .org    $4C93
                                                
                push    ix
                push    hl              ;L=WorlTimePicker Type
                ld      ix,0
                add     ix,sp
                ld      a,l
                and     a
                jr      z,L4CBE        ;jp worldtime
        
                ;LocalTime
                                        
                ld      a,$00           ;set Localtime as active field
                ld      ($9877),a       
                ld      a,($985F)       ;LocalTime WorldTimeIndex       
                ld      ($9876),a       ;Selected WorldTimeIndex
                ld      a,($987E)
                or      $03             ;enable both page arrows
                ld      ($987E),a       
L4CBE:
                ld      hl,$0013        ;OK cancel buttons
                push    hl
                ld      l,h             ;stack long 0
                push    hl              
                push    hl
                push    hl              ;stack long 0
                push    hl
                ld      hl,$009D        ;City/Location
                call    $0180           ;GetSysMessageAddr
                call    $3099           ;StackLong
                ld      l,$EF
                push    hl
                ld      l,$9F
                push    hl
                ld      l,$65
                push    hl
                ld      e,$00
                ld      l,$64
                ld      bc,$4513        ;CreateDeskBox
                call    $3000
                ex      de,hl           ;DE=*dsk
                ld      hl,$0014
                add     hl,sp
                ld      sp,hl
                
                ld      hl,5
                add     hl,de
                res     2,(hl)          ;disable hardkeys

                ld      hl,$48D0        ;WorldTimePickerEvent
                call    $3120           ;GetFarptr
                ld      hl,$0012
                add     hl,de
                call    $311D           ;StoreBankedAddress
                ld      a,(ix+$00)
                and     a
                ld      hl,$48D9        ;LocalTimePickerDraw
                jr      nz,loc0
                ld      hl,$48CD        ;WorldTimePickerDraw
loc0:           call    $3120           ;GetFarptr
                ld      hl,$000E
                add     hl,de
                call    $311D           ;StoreBankedAddress
        
                ld      a,(ix+$00)
                and     a
                jp      nz,L4E6C        ;jp LocalCity
        
;Add checkboxes for Worldtime 

                push    de              ;*dsk
                ld      c,$04
                ld      a,($9877)       ;WorldTimeNr
                and     a
                ld      a,c
                jr      z,loc1        ;jp worldtime not local time
                xor     a               ;Local checkbox not checked
loc1:           ld      hl,$9867        
                ld      (hl),a       
                dec     hl
                ld      (hl),a          ;set bool
                push    bc              ;bit mask
                push    hl              ;*byte
                ld      l,$DC           ;top
                push    hl
                ld      e,$0A
                ld      l,$4B
                ld      bc,$43B7        ;create BoolField
                call    $3000
                pop     bc
                pop     bc
                pop     bc
                ex      de,hl           ;DE=*bool
		Call	SetEvent
                pop     hl
                call    Insert
                
                push    hl
                ld      c,8
	        ld      hl,$9866
                push    bc              ;bool mask
                push    hl              ;*bool
                ld      l,$DC           ;top
                push    hl
                ld      hl,$009F        ;'Local'
                ld      e,0
                call    $0177
                ld      a,l
                add     a,$0A+$0F+$0A
                ld      e,a             ;Left
                ld      l,$4B
                ld      bc,$43B7        ;create BoolField
                call    $3000
                pop     bc
                pop     bc
                pop     bc
                ex      de,hl           ;set correct right
		Call	SetEvent
                pop     hl
                call    Insert
                ex      de,hl           ;de = *dsk
L4E6C:
                push    de              
                ld      hl,$1009        ;cmDn
                push    hl
                ld      hl,$1008        ;cmUp
                push    hl
                ld      hl,$0000        ;control
                push    hl
                ld      hl,$0009
                add     hl,de
                ld      a,(hl)          ;dsk.botom
                sub     $16-$04
                ld      c,a
                push    bc              ;Top
                dec     hl
                ld      a,(hl)          ;dsk.right
                sub     $01+$0D
                ld      e,a             ;Left
                ld      l,$70
                call    $52DC           ;CreatePageArrow
                pop     bc
                pop     bc
                pop     bc
                pop     bc
                ex      de,hl           ;de= *pga
                pop     hl              ;HL= *dsk
                Call    Insert
                
                push    hl              
                ld      bc,$4522        ;ExecuteView
                call    $3000
                ex      (sp),hl         
                ld      bc,$451F        ;DestroyResource
                call    $3000
                pop     hl
                push    hl              ;save endstate
                ld      de,$0003        ;cmOK
                and     a
                sbc     hl,de
                jp      nz,L5199        ;jp no change if not cmOK
        
;Check which time to change
                                        
                ld      a,(ix+$00)
                and     a
                jp      nz,L5120        ;jp local time
                                        
;Change a WorldTime 
                                        
                ld      a,($9877)       ;WorldTimeNr
                ld	c,a
                ld      b,0
                ld      hl,$985F        ;LocalTimeCityIndex
                add     hl,bc
                ld	a,($9866)
		cp	$08		;test clear checked
                ld      a,($9868)       ;NewCityIndex
		jr	nz,norm
		ld	a,$FF
norm:           ld      (hl),a          ;set the new WorldTimeIndex
                ld	a,($9866)
                cp      $04		;test local checked
                jr	z,swap

		;order world times
		                
ord:            ld	hl,$9860
                ld	bc,4
                ld	a,$FF
ord0:           cpir
                jp	nz,L5199	;all worldtimes set
                jp	po,L5199	;only last not set	
      		ld	d,h
      		ld	e,l
      		dec	de		;Point to reset entry
ord1:  		cpi
      		jr	nz,ord2		;Found
                jp	po,L5199	
                jr	ord1		;more to test
                
ord2:      	dec	hl	
		ld	a,(hl)
		ld	(hl),$FF
                ld	(de),a	
                jr      ord
      		
                
                ;Swap LocalTime and WorldTimeNr
swap:        
                ld      a,($985F)       ;LocalTimeCityIndex
                ld      ($9868),a       ;NewCityIndex
                ld      a,(hl)
                ld      ($985F),a       ;set LocalTime index to WorldTimeNr index
                ld      a,($9868)
                ld      (hl),a          ;WorldTime Nr index is LocalTime Index
                
                ld      l,$00
                push    hl
                ld      a,($9865)       ;Old LocalTime Index
                ld      e,a
                ld      hl,$978A        ;*buffer
                ld      bc,$48DF        ;GetWorldTimeInfo
                call    $3000
                pop     bc
                
                ld      l,$00           ;Get AllInfo
                push    hl
                ld      a,($985F)       ;LocalTime Index
                ld      e,a
                ld      hl,$97AC        ;*Buffer
                ld      bc,$48DF        ;GetWorldTimeInfo
                call    $3000
                pop     bc
                ld      hl,$9759
                call    $004A           ;GetDate
                ld      hl,$9756
                call    $0044           ;GetTime
                ld      hl,$978A        ;.. Time GMT Hour difference
                ld      a,($97AC)       ;Local Time GMT Hour difference
                sub     (hl)
                ld      c,a             ;Hour Difference
                
                inc     hl
                ld      a,($97AD)       ;Local Time GMT min difference
                sub     (hl)
                ld      hl,$9864        ;DST mins ?
                sub     (hl)
                ld      l,a
                push    hl
                push    bc
                ld      de,$9756        ;*Time
                ld      h,d
                ld      l,e
                call    $607E           ;SumTimeDifference
                pop     bc
                pop     bc
                
                push    hl              ;DayStatus
                ld      hl,$9759
                call    $6329           ;GetDaysOfFebruary
                ld      hl,$9759
                ld      d,h
                ld      e,l
                call    $635E           ;SumOneDayDifference
                pop     bc
                ld      l,$01
                push    hl
                ld      hl,($985F)      ;LocalTime Index
                push    hl
                ld      hl,$9759        
                ld      d,h
                ld      e,l
                call    $680C           ;GetDayLightSavingsMinutes
                pop     bc
                pop     bc
                ld      ($9864),a       ;DST Minutes
                and     a
                jp      z,L50FD         ;jp no DST minutes
        
                ;Add DST minutes
                
                ld      l,a
                push    hl
                ld      l,$00
                push    hl
                ld      hl,$9756
                ld      d,h
                ld      e,l
                call    $607E           ;SumTimeDifference
                pop     bc
                pop     bc
                push    hl              ;DayStatus
                ld      hl,$9759
                call    $6329           ;GetDaysOfFebruary
                ld      hl,$9759
                ld      d,h
                ld      e,l
                call    $635E           ;SumOneDayDifference
                pop     bc
L50FD:
                ld      a,($985F)
                ld      ($9865),a 
                ld      de,$9756
                ld      hl,$9759
                ld      bc,$46B4        ;SetDateTime
                call    $3000
                jp      L5199           ;end
        
;For LocalCity
                                        
L5120:
                ld      a,($9868)       ;New WorldTimeIndex
                ld      ($985F),a       ;Local TimeIndex
                ld      l,$00
                push    hl
                ld      e,a
                ld      hl,$97AC
                ld      bc,$48DF        ;GetWorldTimeInfo
                call    $3000
                pop     bc
                
                ld      a,($985F)       
                ld      ($9865),a       ;Set LocalTime Index
                ld      hl,$9759
                call    $004A           ;GetDate
                ld      hl,$9756
                call    $0044           ;GetTime
                ld      l,$00           
                push    hl
                ld      a,($985F)       ;LocalTime WorldTimeIndexNr
                ld      l,a
                push    hl              ;SP+2 LocalTime WorldTimeIndexNr
                ld      de,$9756
                ld      hl,$9759
                call    $680C           ;GetDayLightSavingsMinutes
                pop     bc
                pop     bc
                ld      ($9864),a       ;DST minutes
        
                ;end
L5199:
                pop     hl              ;endstate
                pop     bc
                pop     ix
                ret

;--------------------------
;Call Deskbox insert method

;               HL=*Deskbox
;               DE=*object to insert

Insert: 
                push    hl
                ld      bc,$002A+1      ;Call Insert
                add     hl,bc
                ld      b,(hl)
                dec     hl
                ld      c,(hl)
                call    $311A           ;LoadBank
                pop     hl              ;*dsk
                push    hl              
                call    $3018           ;indirect_call
                pop     hl
                ret

;----------------------------------------
;SetBoolEvent

SetEvent:       ld	hl,6		;Create bool bugfix to set correct right property
	        add	hl,de
	        ld	a,(hl)		
	        add	a,14
	        inc	hl
	        inc	hl
	        ld	(hl),a
                ld      a,($9877)       ;test if local time field
                and     a
                jr      nz,loc2        ;no local time
        
; bool can not be changed for local city
        
                ld      hl,$48CA        ;BoolFieldWarningEvent
                call    $3120           ;GetFarptr
                ld      hl,$0012
                add     hl,de
                call    $311D           ;StoreBankedAddress
                ret
                
;only one bool may be checked
               
loc2:		ld	bc,BoolOnlyOneEvent
                ld      hl,$0012
                add     hl,de
		ld	(hl),c
		inc	hl
		ld	(hl),b
		inc	hl
		push	hl
		call	$000F
		ex	(sp),hl
		pop	bc
		ld	(hl),c
		inc	hl
		ld	(hl),b
		ret
		
;----------------------------------------
BoolOnlyOneEvent:

	        push    de
	        push    hl
	        ld      hl,$000C	;offset to SP+4
	        add     hl,sp
		ld      b,(hl)      	;(SP+4) y
	        dec	hl
	        dec	hl
	        ld      c,(hl)      	;(SP+2) x
	        pop	hl		;hl=*bool
	        push	hl
	        push	bc		;C=x,B=y
	        ld	c,b
	        push	bc
	        ld      bc,$44E9        ;HandleEvent
	        call    $3000
	        pop     bc
	        pop     bc		 ;C=x,B=y
	        pop	de		 ;*bool
	        pop	hl		 ;*event
	        ld	a,(hl)
	        inc	hl
	        dec	a
	        or	(hl)
	        jr      nz,boolend       ;end not evPenDown
	        
	        push	de
		Call	PenDown
		pop	de
		jr	z,boolend
		
		ld	hl,$001A
		add	hl,de
		ld	b,(hl)		;Bit
		dec	hl
		ld	a,(hl)
		dec	hl
		ld	l,(hl)
		ld	h,a
		ld	a,b
		cpl
		and	(hl)		;test other bits set
		jr	nz,boolbeep
	
		;toggle	
		
		ld	a,b
		xor	(hl)
		ld	(hl),a		;set new bool
		ld	hl,$000E+1	;Call drawing method
		add	hl,de
		ld	b,(hl)
		dec	hl
		ld	c,(hl)
		call	$311A		;LoadBank
		ex	de,hl
		call	$3018		;IndirectCall
		jr	boolend
boolbeep:
		call	$01A7    	;WarningBeep	
boolend:	
		ret		
		


                .fill   $51B8-$,$FF                             
;--------------------------------------------------------------
;WorldTimeBoolFieldEvent
	
	;Performs a warningbeep when tapped inside bool area

		.org	$51B8	
		
	        push    de
	        push    hl
	        ld      hl,$000C	;offset to SP+4
	        add     hl,sp
		ld      b,(hl)      	;(SP+4) y
	        dec	hl
	        dec	hl
	        ld      c,(hl)      	;(SP+2) x
	        pop	hl		;hl=*bool
	        push	hl
	        push	bc		;C=x,B=y
	        ld	c,b
	        push	bc
	        ld      bc,$44E9        ;HandleEvent
	        call    $3000
	        pop     bc
	        pop     bc		 ;C=x,B=y
	        pop	de		 ;*bool
	        pop	hl		 ;*event
	        ld	a,(hl)
	        inc	hl
	        dec	a
	        or	(hl)
	        jr      nz,L52D4        ;end not evPenDown

		;evPenDown 

	        call	PenDown
		call    nz,$01A7    	;WarningBeep
L52D4:
	        ret
	        
;---------------------------------------
	        
PenDown:        ld	hl,6
	        add	hl,de
	        ld	e,(hl)		;6
	        inc	hl
	        ld	d,(hl)
	        ld      a,d      	;7
	        add     a,$0A
	        ld      l,a
	        push    hl              ;Top+10
	        ld      a,e
	        add     a,$09
	        ld      l,a      	;Left+9
	        push    hl 
	        ld      a,d
	        add     a,$04
	        ld      l,a      	;invert top=top+4
	        push    hl              ;Top    
	        ld      a,e
	        add     a,$03
	        ld      l,a      	;invert left=Left+3
	        push    hl              ;left inv range
	        ld      a,d
	        add     a,$0B
	        ld      l,a      	;rectangle Bottom=top+11
	        push    hl              ;sP+8 rectangle bottom
	        ld      a,e
	        add     a,$0A
	        ld      l,a      	;rectangle right=Left+10
	        push    hl              ;sP+6 rectangle right
	        ld      a,d
	        add     a,$03
	        ld      l,a		;rectangle Top=Top+3
	        push    hl              ;sP+4 rectangle top
	        ld      a,e
	        add     a,$02
	        ld      l,a
	        push    hl              ;sP+2 rectangle left=Left+2 
	        ld      e,b    		;y top
	        ld      l,c		;x Left
	        ld      bc,$44BF
	        call    $3000           ;PressAtButtonInvert
	        ld      hl,$0010
	        add     hl,sp
	        ld      sp,hl
	        and	a
	        
                .fill   $52DB-$,$FF
;-----------------------------------------

                .end