#include "ressdk.h"
#include "windows.h"
#include "keyb.h"
#include "aviglyph.h"
#include "keybs.h"

/*extern unsigned char StartRomBank;*/

BANKED int GetKeybState(void)
{
 return (KeybMode);
}

static BANKED void InitLanguage(void)
{
 if (GetLanguageType()==2)
 {
  LowerCharTable     = FR_LowerCharTable; 
  CapsCharTable      = FR_CapsCharTable; 
  ShiftCharTable     = FR_ShiftCharTable;
  ShiftCapsCharTable = FR_ShiftCapsCharTable;
 }
}

static BANKED void DrawKeyboard(void)
{
 int i = 0;

 while(Keyboards[i].Keyb != 0)
 {
  if (Mode == Keyboards[i].Mode) 
  	DrawSystemIcon(1, KEYB_TOP, Keyboards[i].Keyb, PUT);
  i++;
 }
}

static BANKED void ProcessClick(byte handle, byte x, byte y)
{
 int i = 0;
 char c = 0;
 Coord *Coords;

 if (RectSaved) return;
 /* check function keys */
 do
 {
  if (Mode & MODE_SYMBOL)		Coords = &SymbCoords[i];
  else Coords = &KeybCoords[i];

  if (((x >= Coords->r.left) && (x <= Coords->r.right)) &&
      ((y >= Coords->r.top) && (y <= Coords->r.bottom)))
  {
   switch(Coords->key)
   {
    case KEY_ACC1:
    case KEY_ACC2:
    case KEY_ACC3:
    case KEY_ACC4:
    case KEY_SHIFT:
    case KEY_CAPS:
			Mode ^= Coords->Mode;
    		DrawKeyboard();
    		return;

    case KEY_SYMBOL:
    		OldMode = Mode;
    		Mode = 0;

    case KEY_CANCEL:
			InverseLCDArea( Coords->r.left, Coords->r.top, Coords->r.right, Coords->r.bottom);
			/* save inverted area */
			Mode ^= Coords->Mode;
    		DrawKeyboard();
			break;


	case KEY_BACKSPACE:
			c = 8;
			InverseLCDArea( Coords->r.left, Coords->r.top, Coords->r.right, Coords->r.bottom);
			/* save inverted area */
			memcpy(&SavedRect, &Coords->r, sizeof(rect));
			RectSaved = TRUE;
			break;

    default:
			InverseLCDArea( Coords->r.left, Coords->r.top, Coords->r.right, Coords->r.bottom);
			/* save inverted area */
			memcpy(&SavedRect, &Coords->r, sizeof(rect));
			RectSaved = TRUE;
			/* get character */		
			if (Mode == (MODE_SHIFT|MODE_CAPS))  c = ShiftCapsCharTable[Coords->key];
            else
			if (Mode == MODE_CAPS)  		c = CapsCharTable[Coords->key];
			else 
			if (Mode == MODE_SHIFT)	c = ShiftCharTable[Coords->key];
            else
			if (Mode == MODE_SYMBOL)  c = SymbolsCharTable[Coords->key];
			else 
			c = LowerCharTable[Coords->key];
    		break;
   }
   break;
  }
  i++;
 }while(Coords->r.left != 0);
 
 /* search for char pressed */
 if (!c)
 {
  /* line1   1 < y > 13 */
  /* Line2  15 < y > 27   */
  /* Line3  29 < y > 41  */
  /* Line4  43 < y > 55  */
  /* line5  57 < y > 69 */
 }

 /* send char */
 if (c)
 {
  MustRestore = TRUE;
  PenBeep();
  PostMessage(CallerWin, evChar, c, 0);
 }
}

static BANKED void InitGlyphPane(byte handle)
{
 rect r;
 int y, w, h;

 GetWindowsRect(handle, &r);
 w = (r.right - r.left) / 2;
 h = (r.bottom - r.top) / 2;			 
 y = r.top + (h - (h/2)) + 4;	
 InitGlyph(15, y, w, h);
}

static BANKED int KeybWndProc(byte handle, unsigned short evType, byte x, byte y)
{
 switch(evType)
 {
  case 100:
  		PenBeep();
  		PostMessage(CallerWin, evChar, x, 0);
  		break;

  case evDestroy:
		break;

  case evKeyDown:
		PostMessage(CallerWin, evType, x, y);
		break;

  case evCommand:
  		switch((word) x << 8 | (word) y)
  		{
		 case mcAbout:
			MessageBox(MK_FAR_PTR(KeybAbout), mfInformation | mfOKButton);
			break;

		 case mcKeyboard:
			if (KeybMode != 0)
			{
             KeybMode = 0;
             PostMessage(handle, evPaint, 0, 0);
			}break;

		 case mcGlyph:
			if (KeybMode == 0)
			{
             KeybMode = 1;
 			 InitGlyphPane(handle);
             PostMessage(handle, evPaint, 0, 0);
			}break;
		}
		break;

  case evTimer:
		break;

  case evCreate:
  		if (KeybMode) InitGlyphPane(handle);
 		break;

  case evPaint:
  		if (KeybMode)	ResetGlyphPad();
  		else			DrawKeyboard();
 		break;

  case evPenUp:
  		if (KeybMode)	DoGlyph(x, y, 3);
  		else
		if ((RectSaved) && (MustRestore))
		{
 		 InverseLCDArea( SavedRect.left, SavedRect.top, SavedRect.right, SavedRect.bottom);
		 RectSaved = FALSE;
		 MustRestore = FALSE;
		
		 /* reset temporary states */
		 if (Mode & MODE_SHIFT)		{Mode ^= MODE_SHIFT;DrawKeyboard();}
		 if (Mode & MODE_ACC1)		{Mode ^= MODE_ACC1;DrawKeyboard();}
		 if (Mode & MODE_ACC2)		{Mode ^= MODE_ACC2;DrawKeyboard();}
		 if (Mode & MODE_ACC3)		{Mode ^= MODE_ACC3;DrawKeyboard();}
		 if (Mode & MODE_ACC4)		{Mode ^= MODE_ACC4;DrawKeyboard();}
		 if (Mode & MODE_SYMBOL)	{Mode = OldMode;DrawKeyboard();}
        }
		break;

  case evPenDown:
		if (KeybMode)	DoGlyph(x, y, 1);
		else			ProcessClick(handle, x, y);
  		break;

  case evPenDownMove:
  		if (KeybMode)	DoGlyph(x, y, 2);
  		break;
 }
}

BANKED byte StartKeyBoard(byte caller, int StartMode)
{
 Window Win;

 CallerWin = caller;
 KeybMode = StartMode;

 InitLanguage();

 Win.wTitle = MK_FAR_PTR(KeybTitle);
 Win.wMenu =  MK_FAR_PTR(KeybMenu);
 Win.wleft = 0;
 Win.wtop = 157;
 Win.wright = 159;
 Win.wbottom = 239;
 Win.Modal = FALSE;
 Win.wDir = 0;
 Win.wflags = bafDotTitle;
 BankedAssign(Win.WndProc,KeybWndProc);
 return(CreateWindow(MK_FAR_PTR(Win)));
}
