#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <alloc.h>
#include <mem.h>
#include "ticlib.inc"

#define INTROSCREEN "TICSCRN.DTA"
#define I asm
void fadein(char far *);
void fadeout(char far * palptr);
void CycleColors(char far *PalPtr,int start, int stop);

void wait_vbi(void)
{
I    mov        dx,3DAh
vent1:
I    in         al,dx
I    test       al,8
I    jz         vent1
I    cli
vent2:
I    in         al,dx
I    test       al,8
I    jnz        vent2
I    sti
}


void GetColor (unsigned char Color,
					unsigned char *Red,
					unsigned char *Green,
					unsigned char *Blue)
{       /* GetColor */
  outp(967,Color);
  *Red=inp(969);
  *Green=inp(969);
  *Blue=inp(969);
}       /* GetColor */

void SetColor (unsigned char Color,
					unsigned char Red,
					unsigned char Green,
					unsigned char Blue)
{       /* SetColor */
  outp(968,Color);
  outp(969,Red);
  outp(969,Green);
  outp(969,Blue);
}       /* SetColor */

size_t freadfar(unsigned Segm, unsigned Offs, size_t start, size_t size, char FName[80])
{
size_t WasRead;
unsigned fhandle;
	unsigned int Segment;
	unsigned int Offsett;

	Segment = FP_SEG(FName);
	Offsett = FP_OFF(FName);

asm {
	PUSH DS

	mov ax, Segment
	mov ds, ax
	mov DX, Offsett
	MOV AX, 3D00h
	INT 21h                            //open file
	JC  EXIT

	MOV fhandle, AX                    // save filehandle

	MOV BX, AX                         // BX Has to hold File Handle
	MOV CX,size                        // DX holds the size
	MOV DX, Segm                       // DS:DX points to the read buffer
	MOV DS, DX
	MOV DX, Offs
	MOV AH,3Fh                         // function to read data
	INT 21h                            // read file
	MOV WasRead, AX

	mov bx, fhandle
	MOV AH, 3Eh
	INT 21h                            //close file
}
EXIT: asm POP DS
	if(start);								  // sorry this is not yet implemented
	return(WasRead);
}


void intro(void)							  // game intro!!! C00L!!!!
{void far *Scrn;
 char far *pallete;
 char tmppal[768];
 int count;

 Scrn = farcalloc(64000,1);               // allocate memory for the buffer
										  // get memory for the image screen &\& pallete
 if(!Scrn)
 {  printf("error allocating 64000 bytes for Screen Buffer");
	 return;
 }
 freadfar(FP_SEG(Scrn),FP_OFF(Scrn),0 , 64000, INTROSCREEN);

 asm {                               // set up VGA 320*200*256
	mov ax, 13h
	int 10h
	}
 pallete=Plt;
 for(count=0;count<256;count++)     // clear the pallete
	 SetColor(count,0,0,0);
 wait_vbi();

 for(count=0;count<768;count++)
    tmppal[count]=pallete[count];

 pallete[223*3]=pallete[57*3];      // clear the colors of the pink words in the middle
 pallete[223*3+1]=pallete[57*3+1];      // clear the colors of the pink words in the middle
 pallete[223*3+2]=pallete[57*3+2];      // clear the colors of the pink words in the middle
 pallete[224*3]=pallete[57*3];      // clear the colors of the pink words in the middle
 pallete[224*3+1]=pallete[57*3+1];      // clear the colors of the pink words in the middle
 pallete[224*3+2]=pallete[57*3+2];      // clear the colors of the pink words in the middle
 pallete[225*3]=pallete[57*3];      // clear the colors of the pink words in the middle
 pallete[225*3+1]=pallete[57*3+1];      // clear the colors of the pink words in the middle
 pallete[225*3+2]=pallete[57*3+2];      // clear the colors of the pink words in the middle

 movedata(FP_SEG(Scrn),FP_OFF(Scrn),0xA000,0,64000);
 fadein(pallete);
 delay(1000);
 pallete[225*3]=tmppal[225*3];
 pallete[225*3+1]=tmppal[225*3+1];
 pallete[225*3+2]=tmppal[225*3+2];
 SetColor(225,pallete[225*3],pallete[225*3+1],pallete[225*3+2]);
 wait_vbi();
 delay(1000);
 pallete[224*3]=tmppal[224*3];
 pallete[224*3+1]=tmppal[224*3+1];
 pallete[224*3+2]=tmppal[224*3+2];
 SetColor(224,pallete[224*3],pallete[224*3+1],pallete[224*3+2]);
 wait_vbi();
 delay(1000);
 pallete[223*3]=tmppal[223*3];
 pallete[223*3+1]=tmppal[223*3+1];
 pallete[223*3+2]=tmppal[223*3+2];
 SetColor(223,pallete[223*3],pallete[223*3+1],pallete[223*3+2]);
 wait_vbi();

 for(count=0;count<768;count++)             // save pallete for cycling;
    tmppal[count]=pallete[count];

 delay(1000);
 while(!kbhit())
 /*   CycleColors(tmppal,226,254)*/;         // have to fix the cycling. Ohh well
 while(kbhit())
    getch();
 fadeout(tmppal);
 farfree(Scrn);
 delay(2000);
}

void fadein(char far * palptr)
{char far *Pallete;
 char Current[256][3];
 int i;
 int cycle;

 Pallete = palptr;

 for(i=0;i<256;i++)
 {	Current[i][0]=0;	Current[i][1]=0;	Current[i][2]=0; }

 for(cycle=0;cycle<64;cycle++)
 {
 for(i=0;i<256;i++)
 {
	if(Current[i][0]<Pallete[i*3]) Current[i][0]++;
	if(Current[i][1]<Pallete[i*3+1]) Current[i][1]++;
	if(Current[i][2]<Pallete[i*3+2]) Current[i][2]++;
 }
 delay(10);
 wait_vbi();
 for(i=0;i<256;i++)
	SetColor(i,Current[i][0],Current[i][1],Current[i][2]);
 }
}

void fadeout(char far * palptr)
{char far *Pallete;
 char Current[256][3];
 int i;
 int cycle;

 Pallete = palptr;

 for(i=0;i<256;i++)
 {  Current[i][0]=Pallete[i*3];
    Current[i][1]=Pallete[i*3+1];
    Current[i][2]=Pallete[i*3+2]; }

 for(cycle=0;cycle<64;cycle++)
 {
 for(i=0;i<256;i++)
 {
    if(Current[i][0]>0) Current[i][0]--;
    if(Current[i][1]>0) Current[i][1]--;
    if(Current[i][2]>0) Current[i][2]--;
 }
 delay(10);
 wait_vbi();
 for(i=0;i<256;i++)
	SetColor(i,Current[i][0],Current[i][1],Current[i][2]);
 }
}

void CycleColors(char far *PalPtr,int start, int stop)
{  unsigned char r,g,b;
   unsigned char R,G,B;
   unsigned char count;

  if (stop > start)
  {				// Main Cycle
     wait_vbi();
	 GetColor(stop,&r,&g,&b);

	 for(count=stop;count>start;count--)
     {   GetColor(count-1,&R,&G,&B);
		 SetColor(count,R,G,B);
         PalPtr[count*3]=R;
         PalPtr[count*3+1]=G;
         PalPtr[count*3+2]=B;
	 }
	 SetColor(start,r,g,b);
  }
}

