#include "ressdk.h"
#include "packet.h"
#include "f_sdkapi.h"
#include "windows.h"
#include "about.h"

#define mcOK	0x0105
static TAbout	SAbout;

static BANKED void OnAboutCommand(byte handle, word Cmd)
{
 switch(Cmd)
 {
  case mcOK:  
  	  DestroyWindow(handle);
      break;
 }
}


static BANKED void AboutWndProc(byte handle, short evType, byte x, byte y)
{
 rect r;
 PVIEW *btn;

 switch(evType)
 {
  case evCommand:
		OnAboutCommand(handle, ((word) x << 8) | (word) y);
		break;

  case evCreate:
  		GetWindowsRect(handle, &r);
  		
  		btn = (PVIEW *) CreateButton('B', r.right-35, r.bottom-20, r.right-5, MK_FAR_PTR("Ok"), mcOK, bttBasic);
  		InsertControl(handle, (PVIEW *) btn);
  		break;

  case evPaint:
  		GetWindowsRect(handle, &r);

		SetFontType(PRPFONT7N);
 		DrawString(handle, 5, (r.bottom-r.top)-22, MK_FAR_PTR("contact@astecsoft.com"), 0);
 		DrawString(handle, 5, (r.bottom-r.top)-12, MK_FAR_PTR("www.astecsoft.com/avigo"), 0);
 		SetFontType(PRPFONT11N);

  		LoadBank(&(SAbout.CallBack));
        SAbout.CallBack(handle, &r);
        break;
        
  case evDestroy:
  case evPenDown:
  case evPenUp:
  case evTimer:
  case evFastTimer:
  case evPenDownMove:
  		break;

  case evKeyDown:
  		PostQuitMessage(handle, x);
  		break;
 }
}

BANKED void AboutBox(byte handle, CONST_FAR_PTR About)
{
 Window Win;
 short ret;

 fmemcpy(SAbout, About, sizeof(TAbout));

 Win.wTitle = 0;
 Win.wMenu =  0;
 Win.wleft = (ScreenWidth()-SAbout.width)/2;
 Win.wtop = (ScreenHeight()-SAbout.height)/2;
 Win.wright = Win.wleft+SAbout.width;
 Win.wbottom = Win.wtop+SAbout.height;

 Win.Modal = TRUE;
 Win.wDir = GetDisplayDirection();
 Win.wflags = bafDialog;

 BankedAssign(Win.WndProc, AboutWndProc);

 ret = CreateModalWindow(MK_FAR_PTR(Win), handle, FALSE);
}
