#include <p100plib.h>
#include <ressdk.h>
#include <math.h>
#include <packet.h>

#include "myapp.h"
#include "about.h"


static const unsigned char myTitle[]	= "About";
static const unsigned char txtOK[]		= "Ok";


static PBUTTON *btnOK;
static unsigned char left;	/* Left-hand location of the dialog */
static unsigned char top;	/* Top location of the dialog */

/* NOTE!! 	If you use "BackupWindow" and "RestoreWindow", you need to 
			be sure that your window is a multiple of 8 pixels AND
			starts/ends at an 8-pixel boundary too. This is in the docs.
			So that's why my width & height are divisible by 8.
			Keep it that way if you resize.
*/
#define aboutWidth	152
#define aboutHeight	96
#define okWidth		25
#define okHeight	20

static unsigned char landscapeMode;
static const short screenWidth[2]	= { 160, 240 };
static const short screenHeight[2]	= { 240, 160 };


/***************************************************************************
* Actual draw handler.
****************************************************************************/
static void drawAbout(void)
{
	unsigned char currentY;
	unsigned char currentX;
	unsigned short i;
	unsigned char buffer[MAXABOUTSIZE];


/* Logic:
 *	Display the "About" logo stuff */

	/* Clear buffer */
	for (i=0;i<MAXABOUTSIZE;i++)
		buffer[i] = 0;

	/* Thank you SDK for this pain in the ass */
/*	if ((currentFont == PRPFONT7N) && landscapeMode)
		currentY = startY[landscapeMode] - 7;
	else
		currentY = startY [landscapeMode];
*/

	/* Application Name */
	currentY = top  + 10;
	currentX = left + 10;
	SetFontType (PRPFONT14B);
	WriteString (currentX, currentY, appName, 0);

	/* Copyright & company name */
	currentY += 14;
	strcpy (buffer, "\xA9 ");
	strcat (buffer, appDate);
	strcat (buffer, " ");
	strcat (buffer, companyName);
	SetFontType (PRPFONT11B);
	WriteString (currentX + 5, currentY, buffer, 0);

	/* Center the website thing */
	currentY += 14;
	currentX = (screenWidth[landscapeMode] - GetStringLength(companySite, PRPFONT11N)) / 2;
	SetFontType (PRPFONT11N);
	WriteString (currentX, currentY, companySite, 0);
	
	/* Center the email */
	currentY += 11;
	currentX = (screenWidth[landscapeMode] - GetStringLength(companyEmail, PRPFONT11N)) / 2;
	SetFontType (PRPFONT11N);
	WriteString (currentX, currentY, companyEmail, 0);

	/* NOTE!!!	The SDK WriteString doesn't work correctly for 
				PRPFONT11N and LANDSCAPE orientation.
				That's why I am subtracting 7 pixels, to move it UP
				to correct place when in landscape (rotated) view.
				You do NOT need to do this in Portrait view */

	/* credits */
	if (GetDisplayDirection())
		currentY += 5;
	else
		currentY += 12;
	SetFontType (PRPFONT7N);
	currentX = (screenWidth[landscapeMode] - GetStringLength(gratitude, PRPFONT7N)) / 2;
	WriteString (currentX, currentY, gratitude, 0);

	/* Left-hand the Application Version */
	currentY = top + aboutHeight - 17;
	if (GetDisplayDirection())
		currentY -= 7;	/* Again, move "up" to correct place when in landscape view */
	SetFontType (PRPFONT7N);
	WriteString (left + 10, currentY, appVersion, 0);

}


/***************************************************************************
* Draw handler for deskbox. 
****************************************************************************/

void about_Draw(VOID_PTR thisView)
{
	PDESKBOX_draw(thisView);
	drawAbout();
}


/**********************************************************************************
*
* Deskbox event handler.
* Call the default event handler and then process event commands (evCommand).
*
**********************************************************************************/
void about_HandleEvent(VOID_PTR thisView, unsigned short *evType, unsigned char x, unsigned char y)
{
	PDESKBOX_handleEvent(thisView, evType, x, y);

	if(*evType == evCommand)
	{
		switch (TOWORD(x, y))
		{
            case cmCancel:
				ClearEvent(evType);         /* Clear the event */
				break;
	    }
	}
}


/********************************************************************************
* Create a deskbox
********************************************************************************/

far VOID_PTR createAboutDeskbox(void)
{
	VOID_PTR retval;
	PDESKBOX *dsk;
	
	CONST_FAR_PTR fp1;
	unsigned char btnLeft;

	fp1 = MK_FAR_PTR(myTitle);
	dsk = (PDESKBOX *) CreateDeskBox('A', left, top, left + aboutWidth, top + aboutHeight, fp1, 0, 0, bafClose | bafDialog);
    dsk->options &= ~ofFindable;

	BankedAssign(dsk->handleEvent, about_HandleEvent);
	BankedAssign(dsk->draw, about_Draw);


    fp1 = MK_FAR_PTR(txtOK);
    btnLeft = left + ((aboutWidth - okWidth)/2);
    btnOK = (PBUTTON *)CreateButton('B', btnLeft, top + aboutHeight - okHeight, btnLeft + okWidth, fp1, cmCancel, bttSingle);
    LoadBank(&(dsk->insert));
    dsk->insert((VOID_PTR)dsk, (PVIEW *)btnOK);

    retval = dsk;
	return retval;

}



/**********************************************************************
 *	showAbout:
 *		Show "About..." information.
 **********************************************************************/
BANKED unsigned short showAbout(void)
{
	PDESKBOX *dsk;
    unsigned short retval;

	/* What is orientation? */
	landscapeMode = GetDisplayDirection();

	/* Calculate the placement of the box */
	left = (screenWidth[landscapeMode] - aboutWidth) / 2;
	top  = (screenHeight[landscapeMode] - aboutHeight) / 2;

	BackupWindow(left, top, left+aboutWidth, top+aboutHeight, GetLCDBackBufAddr());

	dsk = (PDESKBOX *) createAboutDeskbox();
	retval = ExecView ((PGROUP *) dsk);

	Destroy ((VOID_PTR) dsk);

	RestoreWindow(left, top, GetLCDBackBufAddr(), PUT);
	
	return retval;
}

