/*4Cell for Palm Pilot  Pocket C by  Jeremy Dewey
Card library by Rich Heslip modified by John Vann
Ported to Avigo by Heidi Gerstle
and added card moves, and simple undo*/

/*If someone could help with the following I would appreciate it:
- after having coded the multicard move, I found that the app would
	hang sometimes when I had "New game" as a menu option, and I
	clicked it. I didn't do anything more about it, but found a problem
	when I coded the undo function as a menu option:
- I found that undo wouldn't work, and the reason was that clicking
	the menu, triggered the evPenDown event which would set the fcol to be 0.
	(fcol is the column that the card was moved from.) I have tried various 
	ways around this without any success. Any ideas?????????
	Could this also be the reason why Avigo would sometimes freeze (above)
	because both evCommand and evPenDown was triggered at the same time.
	
There are several ways around this:
	- Doing buttons instead like I have.
	- Showing all the cards further down the screen in order to limit evPenDown
		to the screen below where the menu needs to be clicked.
	- Swapping the reserve pile and the build up pile, to accomplish the same.
		However this would be different from what to be the standard for Freecell
		games.
However I really would like to know a better way!!!!!!!!!!

The program is also really close to have used up the 16 k. If it goes to 32k, code needs to be
changed, otherwise displaying message boxes will cause a reset.*/


/*Still to do:
Improve Undo: Is very simple: only one card and not after multicard moves or autoFinish
Multicard moves: The rules for when it's o.k. a little too simple.*/

/*From Palm version:
- no multicard move -- added (Heidi)
- sluggish card movement ??  (not in Avigo)
- no saving/ selecting games, or stats.*/

#include <avsys.h>
#include <avdata.h>
#include <avicons.h>
#include <avgui.h>


#define cmNewGame    0x2000
#define cmUndo    	 0x2001
#define cmHelp   	 0x2002
#define cmAbout  	 0x2003
#define cmExit		 0x2004

unsigned int 	id=100;
unsigned int 	tapCount=0;
int 			deck[52],cardpos;
int 			cardvalue[13];
/*const int 		acevalue=14;
const int 		xcardsz=18;
const int 		ycardsz=28;*/
unsigned int 	acevalue=14;
unsigned int 	xcardsz=18;
unsigned int 	ycardsz=28;
unsigned int 	friCol;
unsigned int 	friRes;
unsigned int 	key;
	/*the following two are for some reason necessary as global var.
	otherwise it resets the simulator*/
unsigned char 	name[1];
unsigned char 	cardstr[1];
unsigned char 	penx,peny;
int 			pXOff[16],pYOff[16];
int 			pXPos[16],pYPos[16];
int 			pNum[16], pMax[16];
int 			pCards[320];
int 			pileError;
unsigned int 	cardRow=0;
int 			cardsToMove=1;
/*int				undoCards=0;*/
int 			fcol,tcol;
int 			fcard, fsuit, fval;
int 			tcard, tsuit, tval;
/*uses less space if global var*/
int 			empty,evt;  
int 			tcol2, check;
int 			x,y;
int 			p;
unsigned int 	r,n;
unsigned int 	c,up;
int 			suite;
unsigned int 	temp;
int 			deep;
int 			num, col;

/*Prototypes*/
extern int suit(int card);
extern int pileTopCardIs(int p);
void pileHiliteTop(int p);
extern int validMove(int fcol, int tcol);
void erasecard(int x,int y);
void pileEraseTop(int p);
void pileRmvCard(int p);
void draw_diamond(int x, int y);
void draw_club(int x, int y);
void draw_spade(int x, int y);
void draw_heart(int x, int y);
void showcard(int card,int x,int y,int up);
void pileShowTop(int p) ;
extern int autoFinish();
extern int pileInit(int p, int xpos,int ypos, int max, int stack);
extern int pileAddCard(int p,int card,int up);
extern int value(int card);
void shuffle();
extern int deal();
void initcards();
int whichCol(int px, int py); 
void youwin();
void startGame();
void firstClick();
void secondClick();
void availableSpace();
void multiMove();

#pragma codeseg
char Message[]= 	"Freecell \n Ported from Palm Pocket C \n by Heidi Gerstle \n March 2001.";
char WindowTitle[]=	"Freecell 2.0";
char HelpMsg[]= 	"Multicard Moves: Click on highest card to be moved.\nDouble click for reserve pile."; /*\nUndo: one card only*/ /*too long*/
char NoSpace[]= 	"You cannot move that many cards!";
char NewGameBtn[]= 	"New Game";
char UndoBtn[]=		"Undo";
#pragma defaultseg
 
int ExitCode = APPLICATION;

MENUITEM MainMenu[]=
{
  /*	{"New Game", cmNewGame, lstDisplay},
  	{"Undo", 	 cmUndo, 	lstDisplay| lstUnderLine},*/
  	{"Help", 	 cmHelp, 	lstDisplay},
 	{"About", 	 cmAbout, 	lstDisplay| lstUnderLine},
   	{"Exit",	 cmCancel, 	lstDisplay},
  	{"\0", 0, 0} 
};

PDESKBOX *dsk;

int main()
{
   dsk = (PDESKBOX *)CreateDeskBox(id++, 0, 0, 159, 239, 
         MK_FAR_PTR(WindowTitle),MK_FAR_PTR(MainMenu), NULL_FP,
         bafClose|bafComLine); 
   InsertButton(dsk, id++, MK_FAR_PTR(NewGameBtn), cmNewGame, bttBasic, 0);
   InsertButton(dsk, id++, MK_FAR_PTR(UndoBtn), cmUndo, bttBasic, 1);
   
   BankedAssign1(dsk->draw,dsk_draw);
   BankedAssign2(dsk->handleEvent,dsk_handleEvent);

   ExecView((PGROUP_PTR) dsk);
 
   Destroy((VOID_PTR) dsk);

   return ExitCode;
}

void dsk_draw(VOID_PTR view)
{ 
   PDESKBOX_draw(view); 
/*   DisableCommand(cmUndo);*/
   SetFontType(PRPFONT11N);
   startGame();
}


void dsk_handleEvent(VOID_PTR view, unsigned int *evType, unsigned char x,
                     unsigned char y)
{  
  	int done; /*won't work if global*/
    PDESKBOX_handleEvent(view,evType,x,y); 
    SetFontType(PRPFONT11N);
	switch (*evType)
	{
	  case evCommand:
	  		DisableCommand(cmUndo); /*if not disabled for menu items 
	  							the undo will be incorrect*/
		switch(TOWORD(x,y))
		{
		  case cmAbout :
		  				MessageBox(Message, mfInformation | mfOKButton);
                        ClearEvent(evType);
                        break;
         case cmHelp:	MessageBox(HelpMsg, mfInformation | mfOKButton);
                        ClearEvent(evType);
                        break;
         case cmNewGame :
         				tapCount=0;	
         				cardsToMove=1;
         				cardRow=0;
         				startGame();
         				ClearEvent(evType);
                        break;
         case cmUndo:
         				doUndo();
         				ClearEvent(evType);
                        break;
         case cmCancel: ClearEvent(evType);
                        break;
         default:       ClearEvent(evType);
   				        break;     
        }
        ClearEvent(evType);
		break;
		case evPenUp:
				for(done=1; done>0;done=autoFinish());
		   			if(-1==done)
		   			{
						youwin();
		    		}
				ClearEvent(evType);
				break;
		case evPenDown:
				ClearEvent(evType);
				key=GetKey(&penx, &peny);
				if(peny<218)  /*above commandline*/
				{
					/*	cardRow=(peny-42)/10+1;*/
				if(tapCount==0) 
				{
			  		cardRow=(peny-42)/10+1;
			  		firstClick();
			  		DisableCommand(cmUndo);
			  		break;
				}
				if(tapCount==1)		/* get 2nd click*/
				{  
			  		pileHiliteTop(fcol);
					tcol=whichCol(penx,peny);
					if(tcol==fcol) /*simulates double click */
					{
		 				for(n=8; n<16; n++) /*move to reserve pile*/
		  				{
		 			  		tcol=n;  	
		 	  				fcard=validMove(fcol,tcol);
		 	  				if(fcard!=-1) break;
		  				}
	 				}
			 		/* check rules*/
			 		secondClick();
			  		break;
				}
				ClearEvent(evType);
				break; 
				}
		default:
				ClearEvent(evType);
				break;   
	 }
}

void startGame()
{	
  	DisableCommand(cmUndo);
    /*SetDisplayDirection(1);*/   /*causes permanent direction for other apps too*/
   	initcards(); 			/*Draws card*/
	shuffle();				/*otherwise only aces*/
	/*ClearLCDArea(1,20,159,235,0);*/
	ClearLCDArea(1,20,159,200,0);
	col=ycardsz+4;
	num=-151;
		/*Drawing reserve pile*/
	for(col=8;col<12;++col)
		{
			pileInit(col,num+col*19,15, 1, 0); /*position*/
			pileShowTop(col);     /*drawing*/
		}
	num=-144;
		/*Drawing build up pile */
		for(col=12;col<16;++col)
		{
	   		pileInit(col,num+col*19,15, 13, 0);
	   		pileShowTop(col);
		}
	deep=7;
			/*drawing all faceup cards*/
		for(col=0;col<8;++col)
		{
			if(col>3){deep=6;}
			pileInit(col,1+col*20,47, 52, 1);
			for(num=0;num<deep; ++num)
			{
				pileAddCard(col,deal(),1);	/*build up cards*/
				pileShowTop(col);
			}
		}
}

void  firstClick()
{
 	/*checks to see if  card alone or part of stack - if so- hilites, otherwise not*/
 	/*DisableCommand(cmUndo);*/
 	fcol=whichCol(penx, peny);
  	if (fcol>7)
  	{
  	  cardsToMove=1;
  	}
  	else
  	{
		cardsToMove=pNum[fcol]-cardRow+1;
	}
	/*undoCards=cardsToMove;*/
		/*test to see if card is part of a series of alternating suits*/
	if (cardsToMove>1)
	{	
	   fcard=pCards[fcol*20+pNum[fcol]-1];
	   for(n=2;n<cardsToMove+1;n++)
	  {
	  	tcard=pCards[fcol*20+pNum[fcol]-n];
	  	fsuit = suit(fcard);	
		fval = fcard-(fcard/13)*13;
		tsuit = suit(tcard);
		tval = tcard-(tcard/13)*13;
		if ((fval == tval-1) && (fsuit%2 != tsuit%2)) /*test*/
		{
			fcard=tcard;
			/*availableSpace();*/
		 	 /*pileHiliteTop(fcol);
			tapCount=tapCount+1;
				continue;*/
		}
		else  /*not part of stack*/
		{
		  	tapCount=0;
			pileHiliteTop(fcol); /*reverses hiliting*/
		  	break;
		}
			/*	fcard=-1;	*/
			/*	pileHiliteTop(fcol);*/
		tapCount=1;
			/*	tapCount=tapCount+1;*/
			/*fcard=pCards[fcol*20+pNum[fcol]-n+1];*/
		fcard=pCards[fcol*20+pNum[fcol]-n]; /*3/16*/
	  }
		/*	tapCount=tapCount+1;*/
		availableSpace(); /*3/21 if above: it will move incorrect cards*/
	}
	else  /*one card move*/
	{
	  	pileHiliteTop(fcol);
		tapCount=tapCount+1;
	}
		/* if legit, hilite card*/
		/*pileHiliteTop(fcol);*/
		/*	tapCount=tapCount+1;*/
}

void  secondClick()
{
	pileHiliteTop(fcol);	
	if (tcol>7)
	{
	  cardsToMove=1;
	 }
	 
	if (cardsToMove>1)
	{
		multiMove();
		/*DisableCommand(cmUndo);*/
	 }
	else
	{
 		fcard=validMove(fcol,tcol);
		if(fcard !=-1) 
		{
		 	if(!pileAddCard(tcol,fcard,0)) 	/* do move*/
		 	{
				pileEraseTop(fcol);
				pileRmvCard(fcol);
				pileShowTop(fcol); 
				pileShowTop(tcol);
				tapCount=0;
				cardRow=0;
				cardsToMove=1;
				EnableCommand(cmUndo);
		  	}
		}
		else pileHiliteTop(fcol);
	}
	tapCount=0;
}

extern int autoFinish() 
{
	int fcol, tcol;  /*need tcol &tcol here, otherwise card won't move*/
	
	empty=0;
	for(fcol=0; fcol<12; fcol++) 
	{
		evt=evNothing;
		if((evt==evPen)||(evt==evPenDown)) 	  
			return 0;
		fcard = pileTopCardIs(fcol);
		if(-1==fcard) 
		{
			empty++;
			continue;
		}
		fsuit = suit(fcard);
		fval = fcard-(fcard/13)*13;
	   	check = 0;
	 	for(tcol=12; tcol<16; tcol++) 
	 	{
	   		tcard = pileTopCardIs(tcol);
	   		tsuit = suit(tcard);
	   		tval = tcard-(tcard/13)*13;
			if(tcard==-1)
			{
		   		if(!fval)
		   		{
					tcol2=tcol;
					check=3;
					break;
		   		} 
		   		else 
		   		{
					continue;
		   		}
			}
			if((tsuit==fsuit)&& (tval==fval-1)) 
			{
				tcol2=tcol;
				check++;
				if(!tval) 
			  	{			
					check=3;	
					break;	
				}	
			}
			if ((fsuit%2 != tsuit%2) && (tval >= fval-1))
				check++;
	   	}
		if(3==check) 
		{
		  if(!pileAddCard(tcol2,fcard, 1)) 
		  {
			pileEraseTop(fcol); 
			pileRmvCard(fcol);	
			pileShowTop(fcol);
			pileShowTop(tcol2);
			if (tcol>11) 
			{
				tapCount=0;
				cardRow=0;
				cardsToMove=1;
				DisableCommand(cmUndo);
			}
			return 1;
		  }
		}
	}
	if(12==empty) return -1;		/*all done?*/
	return 0;
}

void availableSpace()
{
  check=0;
  friRes=0;	
  friCol=0;
  for(n=0;n<8;n++)
  {
    	if(pNum[n]<=0) friCol=friCol+1;
  }
  for(n=8;n<12;n++)
  {
  	  if(pNum[n]<=0) friRes=friRes+1;
  }
  if(cardsToMove<=7)
  {
      if((friRes+friCol)>(cardsToMove-2))
      {
    	  	check=1;
    	  /*pileHiliteTop(fcol);*/
      }
	}	
  else
  	{
    	if((friRes+friCol)>(cardsToMove-3))
    	{
    	  	check=0;
    	  	tapCount=0;
			/*MessageBox(NoSpace, mfInformation | mfOKButton);
			SetFontType(PRPFONT11N);
			InverseLCDArea(x, y,x+xcardsz, y+ycardsz);*/
	   	}
	}
  	if(check==1)
		pileHiliteTop(fcol);
		
	else 
	{
	  	tapCount=0;
		MessageBox(NoSpace, mfInformation | mfOKButton);
		SetFontType(PRPFONT11N);
	}
}

extern int validMove(int fcol, int tcol)
{
	fcard = pileTopCardIs(fcol);  
	tcard = pileTopCardIs(tcol);
	
	if (tcol == fcol) return -1;
	if (fcol > 11) return -1;
	
	fsuit = suit(fcard);	
	fval = fcard-(fcard/13)*13;
	tsuit = suit(tcard);
	tval = tcard-(tcard/13)*13;
	
	if ((pNum[tcol]==0) && (tcol < 12))		/* target empty*/
		return fcard;
		/*cell full gets caught;add fails*/
		/*if ((tcol > 7) && (tcol < 12))
			return fcard;*/ /*, chaned 8 to 7, disabled to make doubleclicks*/

	if (tcol < 8) 
	{
		if ((fval == tval-1) && (fsuit%2 != tsuit%2))
			return fcard;
	} 
	else 
	{
		if (tcard==-1) tsuit = fsuit;
		if ((fval == tval+1) && (fsuit == tsuit))
			return fcard;
	}
	return -1;
}

void multiMove()
{
 	tcard = pileTopCardIs(tcol);
	if(-1==tcard) 		/*if empty:*/
		{
  			if ((friCol==1) && (cardsToMove>1))
 			{	
 			  	if((cardsToMove>friRes+1) || (cardsToMove>6))
 				{	tapCount=0;
					MessageBox(NoSpace, mfInformation | mfOKButton);
  					cardsToMove=0;
  					pileHiliteTop(fcol);
  				}
  			}
		}
	fcard=pCards[fcol*20+pNum[fcol]-cardsToMove];
	fval = fcard-(fcard/13)*13;
	tcard = pileTopCardIs(tcol);
	tval = tcard-(tcard/13)*13;
	/*if(tval==fval)*/	/*to prevent incorrect tapping leading to move*/
	if(!(fval == tval-1)&&(pNum[tcol]>0))
	{
	  	tapCount=0;
  		cardsToMove=0;
  		pileHiliteTop(fcol);
	}
	if (cardsToMove>0)
	{
  	for(n=cardsToMove;n>0;n--)
	{
	  	fcard=pCards[fcol*20+pNum[fcol]-n];
	   	fsuit = suit(fcard);	
		fval = fcard-(fcard/13)*13;
		tcard = pileTopCardIs(tcol);
	/*	if(-1==tcard) 
		{
  			if ((friCol==1) && (cardsToMove>2))
 			{
 				tapCount=0;
				MessageBox(NoSpace, mfInformation | mfOKButton);
				SetFontType(PRPFONT11N);
			}
		}*/
		tsuit = suit(tcard);
		tval = tcard-(tcard/13)*13;
		if (((fval == tval-1) && (fsuit%2 != tsuit%2)) ||(pNum[tcol]==0))
		{
		  	pCards[tcol*20+pNum[tcol]]=fcard;
			++pNum[tcol];
			pileShowTop(tcol);
			/*if(pNum[p]>0)
				{*/
			x=pXPos[fcol]+pXOff[fcol]*(pNum[fcol]-n);
			y=pYPos[fcol]+pYOff[fcol]*(pNum[fcol]-n);
			erasecard(x,y); 
				/*	pNum[fcol]--;*/
				/*	pileShowTop(fcol);*/
				/*	} */
			pileShowTop(tcol); 
		}
		else
		{	
		  	 /*InverseLCDArea(x, y,x+xcardsz, y+ycardsz);*/
		 	 tapCount=0;
		 	 cardsToMove=0;
		}
		tapCount=0;
		cardRow=0;
			/*cardsToMove=1;*/
	}
	for(n=1;n<cardsToMove+1;n++)
	{
	  	pNum[fcol]--;
	}
	cardsToMove=1;
	pileShowTop(fcol);
	tapCount=0;
	}
}

void doUndo()
{
  if(cardsToMove==1)
  {
    fcard = pileTopCardIs(tcol); 
    pileAddCard(fcol,fcard,0);
    pileEraseTop(tcol);
    pileRmvCard(tcol);
    pileShowTop(tcol);
    pileShowTop(fcol);
    tapCount=0;
    /*DisableCommand(cmUndo);*/
  }
}

void youwin()
{
 	/*ClearLCDArea(0,45,159,235,0);*/
 	ClearLCDArea(0,45,159,200,0);
	WriteString(35,100,"You did it!",0);
}

void initcards()
{
	for(n=0;n<13;++n)
		cardvalue[n]=n+1;
	cardvalue[0]=acevalue;
}

/*calculates position for use in drawing routine - pileAddCard*/
extern int pileInit(int p, int xpos,int ypos, int max, int stack) 
{
	pMax[p]=max;
	pNum[p]=0;
	pXPos[p]=xpos;
	pYPos[p]=ypos;
	pXOff[p]=stack/2*10;
	pYOff[p]=stack%2*10;
	pileError=0;
	return pileError;
}

extern int deal()  
{
	if(cardpos>51)shuffle();
	return deck[cardpos++];
}

void shuffle()
{
  	for(n=0;n<52;++n) deck[n]=n;
	for(n=0;n<52;++n) 
	{
		c=random(52);
		temp=deck[n];
		deck[n]=deck[c];
		deck[c]=temp;
	}
	cardpos=0;
}

extern int suit(int card)
{
	return card/13;
}

extern int whichCol(int px, int py) 
{
	p=0;
	if (py<42) p=8;
	return p+( px/20);
}


extern int pileTopCardIs(int p) /*or clicked card is*/
{
	if(pNum[p]==0) return -1; /*no autofinish without this*/
	return pCards[p*20+pNum[p]-1]; 
}

void pileRmvCard(int p) 	/*otherwise just copies card*/
{
	if(pNum[p] > 0) 
	{
		pNum[p]--;
	}
}

void pileEraseTop(int p)
{
  	
	if(pNum[p]>0)
	{
		x=pXPos[p]+pXOff[p]*(pNum[p]-1);
		y=pYPos[p]+pYOff[p]*(pNum[p]-1);
		erasecard(x,y); 
	} 
}

void erasecard(int x,int y)
{
	ClearLCDArea(x, y,x+xcardsz, y+ycardsz,0);
	DrawRect(x, y,x+xcardsz, y+ycardsz, 2);
}


extern int pileAddCard(int p,int card,int up) /*drawing of cards based on position above*/
{
	pileError=0;
	if(pNum[p] >= pMax[p]) 
	{
		pileError=1;
	} 
	else 
	{
		pCards[p*20+pNum[p]]=card;
		++pNum[p];
	}
	return pileError;
}


void pileHiliteTop(int p)
{
	if(pNum[p]<=0)	 
	{
		pileError=1;
	} 
	else 
	{
		if(pNum[p]<=cardRow)
		{ 
			x=pXPos[p]+pXOff[p]*(pNum[p]-1); 
			y=pYPos[p]+pYOff[p]*(pNum[p]-1);
			pileError=0;
		}
		else
		{
			x=pXPos[p]+pXOff[p]*(cardRow-1); 
			y=pYPos[p]+pYOff[p]*(cardRow-1);
			pileError=0;
		}
		/*hilites a whole card in upper row on purpose to make it easier to see
		instead of just hiliting upper part see fourcell 6*/
		
		InverseLCDArea(x, y,x+xcardsz, y+ycardsz);
		pileError=0;
    }
}

void pileShowTop(int p) 
{
  	
	if(pNum[p]<=0)
	{	
		c=0; 
		up=0;
		x=pXPos[p];
		y=pYPos[p]; 
	} 
	else 
	{
		c = pCards[p*20+ pNum[p]-1];
		x=pXPos[p]+pXOff[p]*(pNum[p]-1);
		y=pYPos[p]+pYOff[p]*(pNum[p]-1);
		up=1;
	}
	showcard(c,x,y,up); 
}


void showcard(int card,int x,int y,int up)
{
	erasecard(x,y);
	DrawRect(x, y,x+xcardsz, y+ycardsz, 0);
	if(up==0) return;
	suite=card/13;
	card=value(card); 
	if((card>1) && (card<11))
	{
		itoa(card,cardstr,10);
		strcpy(name,cardstr);
	}
	if(card==acevalue) 
			strcpy(name,"A");
	if(card==11)
	{
		strcpy(name,"J");
	}
	if(card==12)
	{
		strcpy(name,"Q");
	}
	if(card==13)
	{
		strcpy(name,"K"); 
	}
	
	ClearLCDArea(x+1, y+1,x+xcardsz-1, y+ycardsz-1,0);
	switch(suite) 
  	{
   		case 0: draw_diamond(x+xcardsz-4, y+5); 
    		break;
    	case 1: draw_club(x+xcardsz-4, y+5); 
        	break;
		case 2: draw_heart(x+xcardsz-4, y+5);  
    		break;
		case 3: draw_spade(x+xcardsz-4, y+5); 
    		break;
		default: break;    
 	}
	WriteString(x+1,y+1,name,0);
	WriteString(x+xcardsz-10,y+ycardsz-11,name,0);
}
	
extern int value(int card)
{
	return cardvalue[card-(card/13)*13];
}

/******* Draws the suit symbol************/

void first(int x, int y)
{
	DrawDot(x-3,y,DRAW_BLACK);
 	DrawDot(x-2,y+1,DRAW_BLACK);
	DrawDot(x-1,y- 2,DRAW_BLACK);
	DrawDot(x,y+3,DRAW_BLACK);
	DrawDot(x+1,y-2,DRAW_BLACK);
	DrawDot(x+2,y+1,DRAW_BLACK);
	DrawDot(x+3,y,DRAW_BLACK);
}

void second(int x, int y)
{
 	DrawDot(x-2,y-1,DRAW_BLACK);
	DrawDot(x,y-3,DRAW_BLACK);
	DrawDot(x+2,y-1,DRAW_BLACK);
}

void third(int x, int y)
{
	DrawDot(x-1,y+2,DRAW_BLACK);
	DrawDot(x+1,y+2,DRAW_BLACK);
}

void fourth(int x, int y)
{
	DrawDot(x-2,y,DRAW_BLACK);
	DrawDot(x-1,y,DRAW_BLACK);
	DrawDot(x-1,y+3,DRAW_BLACK);
	DrawDot(x,y-2,DRAW_BLACK);
	DrawDot(x,y-1,DRAW_BLACK);
	DrawDot(x,y,DRAW_BLACK);
	DrawDot(x,y+1,DRAW_BLACK);
	DrawDot(x,y+2,DRAW_BLACK);
	DrawDot(x+1,y,DRAW_BLACK);
	DrawDot(x+1,y+3,DRAW_BLACK);
	DrawDot(x+2,y,DRAW_BLACK);
}
 
void draw_diamond(int x, int y)
{
	first(x, y);
	second(x, y);
	third(x, y);
}

void draw_club(int x, int y)
{
	first(x, y);
	second(x, y);
	fourth(x, y);
}

void draw_spade(int x, int y)
{
	first(x, y);
	second(x, y);
	fourth(x, y);
	DrawDot(x-1,y-1,DRAW_BLACK);
	DrawDot(x-1,y+1,DRAW_BLACK);
	DrawDot(x+1,y-1,DRAW_BLACK);
	DrawDot(x+1,y+1,DRAW_BLACK);
}

void draw_heart(int x, int y)
{
	first(x, y);
	third(x, y);
	DrawDot(x-3,y-1,DRAW_BLACK);
	DrawDot(x-2,y-2,DRAW_BLACK);
	DrawDot(x+2,y-2,DRAW_BLACK);
	DrawDot(x+3,y-1,DRAW_BLACK);
	DrawDot(x,y-1,DRAW_BLACK);
	DrawDot(x,y,DRAW_BLACK);
}
/**************************************/
