program Exbancall;

type
  Callstring = string[32];
  Callrectype = record
    addr : word;
    name : Callstring;
  end;
  Func = record
    call : word;
    addr : word;
    bank : byte;
  end;

var
  Infile : file of byte;
  Outfile : text;
  Infname, Outfname : string;
  CallCount : integer;
  I, Start : word;
  Len : longint;
  BankNo, Address, BC : word;
  Finished, Inactive : boolean;
  CallName : Callstring;
  InString : Callstring;
  CallList : array[1..400] of callrectype;
  Bank : array[$0000..$3FFF] of byte;
  FuncCount : integer;
  FuncList : array[1..250] of Func;

function Hex(Number : word) : String;
  var
    B3, B2, B1, B0 : word;

  const
    HexList : Array [0..15] of char = ('0','1','2','3','4','5','6','7',
                                       '8','9','A','B','C','D','E','F');
  begin
    B3 := Number div $1000;
    Number := Number mod $1000;
    B2 := Number div $100;
    Number := Number mod $100;
    B1 := Number div $10;
    B0 := Number mod $10;

    Hex := Concat(HexList[B3], HexList[B2], HexList[B1], HexList[B0]);

  end;

function Decimal(Hex : string) : word;

  function IsValidHex(Digit : char) : boolean;
  begin
     if Digit in ['0'..'9','A'..'F','a'..'f'] then
        IsValidHex := true
     else
        IsValidHex := false;
   end;

  function HexVal(Digit : char) : byte;
  begin
     Digit := UpCase(Digit);
     if Digit in ['A'..'F'] then
       HexVal := Ord(Digit) - $37
     else
       HexVal := Ord(Digit) - $30;
  end;

  var
    Base, RetVal : word;
    First, Last, I, SL : integer;
    Blank : boolean;

  begin
    SL := Length(Hex);
    Base := $0001;
    RetVal := $0000;
    First := 0;
    Blank := true;
    Last := SL;
    for I:= 1 to SL do
    begin
      if (First=0) and (IsValidHex(Hex[I])) then
      begin
        Blank := false;
        First := I;
      end
      else if (not IsValidHex(Hex[I])) and (not blank) and (Last=SL) then
        Last := I;
    end; {for}
    if Last > First + 3 then
      Last := First + 3;
    If (not Blank) then
    begin
      for I := Last downto First do
      begin
        RetVal := HexVal(Hex[I]) * Base + RetVal;
        Base := Base shl 4;
      end;
    end;
    Decimal := RetVal;
  end;

procedure LoadCallList;
  Var
    BadData : Boolean;
    CallFile : text;
    Ch : Char;
    Mode : integer;
    Name : CallString;
    Addr : String[5];
    Str : String[1];

  Const
    mSeekName = 0;
    mGetName  = 1;
    mSeekAddr = 2;
    mGetAddr  = 3;

  begin
    BadData := False;
    CallCount := 0;
    Assign(CallFile, 'bankcall.dat');
    Reset(CallFile);
    ReadLn(CallFile);
    While not SeekEOF(CallFile) do {for all lines}
    begin
      Name := '';
      Addr := '';
      Mode := mSeekName;
      While not SeekEOLn(CallFile) do {for all chars in line}
      begin
        Read(CallFile, Ch);
        case Mode of
          mSeekName : begin
                        if (Ch > #33) and (Ch < #127) then
                        begin
                          Name := Name + Ch;
                          Mode := mGetName;
                        end;
                      end;
          mGetName  : begin
                        if Ch = '=' then
                          Mode := mSeekAddr
                        else if Length(Name) < 32 then
                          Name := Name + Ch;
                      end;
          mSeekAddr : begin
                        if (Ch > #32) and (Ch < #127) then
                        begin
                          Addr := Addr + Ch;
                          Mode := mGetAddr;
                        end;
                      end;
          mGetAddr  : begin
                        if Length(Addr) < 5 then
                          Addr := Addr + Ch;
                      end;
        end; {case}
      end; {while}
      ReadLn(CallFile);
      if mode=mGetAddr then
      begin
        CallCount := CallCount + 1;
        CallList[CallCount].name := Name;
        CallList[CallCount].addr := Decimal(Addr);
      end
      else
        BadData:=true;
    end; {while}
    Close(CallFile);
    if CallCount=0 then
    begin
      WriteLn('FATAL ERROR: Unable to load ANY banked call entries from the data file');
      WriteLn('"bankcall.dat".  Consult the documentation.  Extraction aborted.');
      Inactive := true;
    end
    else if BadData then
    begin
       WriteLn('WARNING: One or more entries in the "bankcall.dat" file was skipped due to');
       WriteLn('being in the improper format.  A text editor can be used to correct the');
       WriteLn('problem.  Consult the EXBANCAL documentation.  Extraction will continue.');
       WriteLn('---------------------------------------------------------------------------');
    end;
  end;

function LookupCall(CallNo : word) : CallString;
  var
    I : integer;

  begin
    I := 1;
    while ((I<=CallCount) and (CallList[I].addr<>CallNo)) do
      I := I + 1;
    if I > CallCount then
      LookupCall := concat('UNKNOWN CALL #',Hex(CallNo))
    else
      LookupCall := CallList[I].name;
  end;

procedure WriteInstructions;
  begin
    WriteLn('This program will take an Avigo .app file (created with the Avocet C com-');
    WriteLn('piler) and output a textfile with all the "banked" function calls made by');
    WriteLn('the app.  It uses a file named "bankcall.dat" to look up the names of the');
    WriteLn('functions.');
    WriteLn('---------------------------------------------------------------------------');
    WriteLn('Usage: EXBANCAL <appfile> <outputfile>');
    Inactive := true;
end;

function FoundFirstABC(I : word) : boolean;
  begin
    if (Bank[I+3]=$CD) and (Bank[I+4]=$03) and (Bank[I+5]=$30)
    and (Bank[I]=$01) and (Bank[I+2]>$39) then
      FoundFirstABC:=true
    else
      FoundFirstABC:=false;
  end;

function ThisCall(BankNo : word; Addr : word) : word;
  var
    I : integer;

  begin
    ThisCall := $0000;
    for I := 1 to FuncCount do
      if (FuncList[I].bank=BankNo) and (FuncList[I].addr=Addr+$4000) then
        ThisCall:=FuncList[I].call;
  end;

begin {main program}
  BankNo := 0;
  Finished := false;
  Inactive := false;
  FuncCount := 0;

  WriteLn('Avigo Application Banked Function Call Extractor');
  WriteLn('By Randy Gill - November 1998');
  WriteLn('---------------------------------------------------------------------------');
  if ParamCount < 2 then
    WriteInstructions
  else
  begin
    WriteLn('Reading call list...');
    LoadCallList;
    if not inactive then
    begin
      Infname:=ParamStr(1);
      Outfname:=ParamStr(2);
      Assign(Infile, Infname);
      Reset(Infile);
      Assign(Outfile, Outfname);
      Rewrite(Outfile);
      WriteLn(Outfile, 'Banked Call Extraction of "',Infname,'".');
    end;
  end;

  while not (Finished or Inactive) do
  begin
    Len := $0000;
    WriteLn('Reading bank #',BankNo,'...');
    while ((not EOF(infile)) and (Len<$4000)) do
    begin
      Read(Infile, Bank[Len]);
      Len:=Len+1;
    end;

    if EOF(infile) then
      Finished:=true;

    if BankNo=0 then
      Start := $01BA
    else
      Start := $0005;

    if BankNo=0 then
    begin
      WriteLn('Building application banked function table...');
      I := Start;
      repeat
        I := I + 1;
      until (I=$3FFF) or (FoundFirstABC(I));

      I := $100*(Bank[I+2]-$40)+Bank[I+1];

      while (I<$3FFE) and (Bank[I]<>$FF) do
      begin
        FuncCount := FuncCount + 1;
        FuncList[FuncCount].call := $4000 + I;
        FuncList[FuncCount].addr := $100*Bank[I+1] + Bank[I];
        FuncList[FuncCount].bank := Bank[I+2];
        I := I + 3;
      end; {while}
    end;{ if bank 0}

    WriteLn('Extracting call names...');
    WriteLn(OutFile,'====================================================');
    WriteLn(OutFile,'Bank# ',Hex(BankNo));
    WriteLn(OutFile,'====================================================');
    WriteLn(OutFile,'Addr Function Name');
    WriteLn(OutFile,'---- -----------------------------------------------');

    for I := Start to Len do
    begin
       if ThisCall(BankNo,I-5)<>$0000 then
         WriteLn(Outfile, Hex(I+$4000-$0005), ' Begin banked function ',Hex(ThisCall(BankNo,I-5)),' **');
       if (Bank[I-2]=$CD) and (Bank[I-1]=$03) and (Bank[I]=$30) then {found CALL $3003}
       begin
         Address := I+$4000-$0002;
         if (Bank[I-5]=$01) then {found LD BC,XXXX}
         begin
           BC := Bank[I-3]*$100+Bank[I-4];
           if BC<$4000 then {this is a system or library call}
             WriteLn(Outfile, Hex(Address), '   ', LookupCall(BC))
           else {this is a banked application call}
             WriteLn(OutFile, Hex(Address), '   Banked Application Call # ',Hex(BC));
         end
         else {wasn't preceded by LD BC,XXXX}
         begin
           WriteLn(Outfile, Hex(Address), '   POSSIBLE MISSED CALL');
         end;{else}
       end; {if}
    end; {for}
    BankNo:=BankNo + 1;
  end; {while}
  if not Inactive then
  begin
    WriteLn('Extraction complete.');
    Close(Outfile);
    Close(InFile);
  end;
end.
