
#include <avsys.h>
#include "gfx.h"

#define GetRamBank 0x0015
#define SetRamBank 0x0012

static void gfx_blit(int x,int y,int spw,int sph,unsigned char* spdata,int mode)
{
	int rambank;
	unsigned char schptr;
	char w;

	if(x<-7)
	{
		spw-=(-x)>>3;
		if(spw<=0)
		{
			return;
		}
		spdata+=(-x)>>3;
		x=-((-x)&7);
	}
	if(x+spw*8>168)
	{
		spw=(168-x)>>3;
		if(spw<=0)
		{
			return;
		}
	}
	if(y<0)
	{
		sph+=y;
		if(sph<=0)
		{
			return;
		}
		spdata+=(-y)<<3;
		y=0;
	}
	if(y+sph>240)
	{
		sph=240-y;
		if(sph<=0)
		{
			return;
		}
	}

_asm
{
 di
 call GetRamBank
 ld _rambank+0(ix),l
 ld _rambank+1(ix),h
 ld hl,#2
 call SetRamBank

 ld a,_x(ix)
 and #7
 ld b,a
 sla a
 add b
 cpl
 ld b,#255
 ld c,a
 ld a,_mode(ix)
 ld iy,#borjptab+1
 cp #0
 jr z,modeok
 ld iy,#bnandjptab+1
 cp #1
 jr z,modeok
 ld iy,#bxorjptab+1
modeok:
 add iy,bc

 ld e,_y(ix)
 ld a,_x+0(ix)
 srl a
 srl a
 srl a
 cp #0x1f
 jr nz,bxok
 ld d,#0x7f
 jr bxok2
bxok:
 or #0x80
 ld d,a
bxok2:
 ld _schptr(ix),d
 ld l,_spdata+0(ix)
 ld h,_spdata+1(ix)
byloop:
 ld a,_spw(ix)
 ld _w(ix),a
bxloop:
 ld a,#0
 ld b,(hl)
 jp(iy)

 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
borjptab:
 ld c,a
 ld a,#0x7f
 cp d
 jr z,borclip1
 ld a,(de)
 or b
 ld (de),a
borclip1:
 inc d
 ld a,#0x94
 cp d
 jr z,borclip2
 ld a,(de)
 or c
 ld (de),a
borclip2:
 inc hl
 dec _w(ix)
 jr nz,bxloop
 jr bxloop2

 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
bnandjptab:
 cpl
 ld c,a
 ld a,#0x7f
 cp d
 jr z,bnandclip1
 ld a,b
 cpl
 ld b,a
 ld a,(de)
 and b
 ld (de),a
bnandclip1:
 inc d
 ld a,#0x94
 cp d
 jr z,bnandclip2
 ld a,(de)
 and c
 ld (de),a
bnandclip2:
 inc hl
 dec _w(ix)
 jr nz,bxloop
 jr bxloop2

 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
 srl b
 rra
bxorjptab:
 ld c,a
 ld a,#0x7f
 cp d
 jr z,bxorclip1
 ld a,(de)
 xor b
 ld (de),a
bxorclip1:
 inc d
 ld a,#0x94
 cp d
 jr z,bxorclip2
 ld a,(de)
 xor c
 ld (de),a
bxorclip2:
 inc hl
 dec _w(ix)
 jp nz,bxloop

bxloop2:
 ld l,_spdata+0(ix)
 ld h,_spdata+1(ix)
 ld bc,#8
 add hl,bc
 ld _spdata+0(ix),l
 ld _spdata+1(ix),h
 inc e
 ld d,_schptr(ix)
 dec _sph(ix)
 jp nz,byloop

 ld l,_rambank+0(ix)
 ld h,_rambank+1(ix)
 call SetRamBank
 ei
}

}

