#include <avsys.h>
#include "gfx.h"

/*
	SOKOBAN
	
	Written by G. Vermeulen.
	Levels taken somewhere from the net.

	This example compiles with the Freeware Avigo SDK.
*/

extern char levels[];

#define LEVOFFY 64

#define SPR_MASK SPRITE(56,0)
#define SPR_MAND SPRITE(0,0)
#define SPR_MANU SPRITE(24,0)
#define SPR_MANL SPRITE(8,0)
#define SPR_MANR SPRITE(16,0)
#define SPR_DIAMOND0 SPRITE(0,8)
#define SPR_DIAMOND1 SPRITE(8,8)
#define SPR_DIAMOND2 SPRITE(16,8)
#define SPR_DIAMONDX SPRITE(48,0)
#define SPR_GROUND SPRITE(32,0)
#define SPR_BLANK SPRITE(32,8)
#define SPR_WALL SPRITE(40,0)
#define SPR_TARGET SPRITE(24,8)
#define SPR_LUP SPRITE(40,8)
#define SPR_LDN SPRITE(48,8)

#define UNDOX 0+16
#define UNDOY 211
#define EXITX (160-17)-16
#define EXITY 206
#define RSTX (160-16)-16
#define RSTY 216

int g_manx,g_many;
int g_currlevelno;
char g_currlevel[20][16];
int g_eol;

char* font[]=
{
	SPRITE(0,16),
	SPRITE(8,16),
	SPRITE(16,16),
	SPRITE(24,16),
	SPRITE(32,16),
	SPRITE(40,16),
	SPRITE(48,16),
	SPRITE(56,16),
	SPRITE(0,24),
	SPRITE(8,24),
	SPRITE(16,24),
	SPRITE(24,24),
	SPRITE(32,24),
	SPRITE(40,24),
	SPRITE(48,24),
	SPRITE(56,24),
	SPRITE(0,32),
	SPRITE(8,32),
	SPRITE(16,32),
	SPRITE(24,32),
	SPRITE(32,32),
	SPRITE(40,32),
	SPRITE(48,32),
	SPRITE(56,32),
	SPRITE(0,40),
	SPRITE(8,40),
	SPRITE(16,40),
	SPRITE(24,40),
	SPRITE(32,40),
	SPRITE(40,40),
	SPRITE(48,40),
	SPRITE(56,40),
	SPRITE(0,48),
	SPRITE(8,48),
	SPRITE(16,48),
	SPRITE(24,48),
};

unsigned char undo_buf[256];
int undo_ptr;

void write_string(int x,int y,char* str)
{
	int c;

	while(*str)
	{
		c=*str++;
		c-='A';
		if(c<0) c+=('A'-'0')+26;
		gfx_blit(x,y,1,8,font[c],GFX_BLIT_OR);
		x+=8;
	}
}

void blit_sprite(int x,int y,unsigned char* spr)
{
	gfx_blit(x,y+LEVOFFY,1,8,SPR_MASK,GFX_BLIT_CLEAR);
	gfx_blit(x,y+LEVOFFY,1,8,spr,GFX_BLIT_OR);
}

char* level_spr[]=
{
	SPR_GROUND,
	SPR_BLANK,
	SPR_WALL,
	SPR_TARGET,
	SPR_DIAMOND0,
	SPR_MAND,
	SPR_DIAMONDX,
};

void blit_level_char(int x,int y)
{
	int c=g_currlevel[x][y];
	if(c==5)
	{
		g_currlevel[x][y]=1;
		g_manx=x;
		g_many=y;
	}
	blit_sprite(x*8,y*8,level_spr[c]);
}

void draw_level()
{
	int x,y;
	char lev[3];

	SetToVirtualLCD(0);
	ClearLCD(0);
	SetToRealLCD(0);

	for(y=0;y<16;y++)
	{
		for(x=0;x<20;x++)
		{
			blit_level_char(x,y);
		}
	}
	blit_sprite(g_manx*8,g_many*8,SPR_MAND);

	write_string(48,212,"LEVEL");
	lev[0]=(g_currlevelno+1)/10+'0';
	lev[1]=(g_currlevelno+1)%10+'0';
	lev[2]=0;
	write_string(96,212,lev);

	gfx_blit(96,204,1,8,SPR_LUP,GFX_BLIT_OR);
	gfx_blit(104,204,1,8,SPR_LUP,GFX_BLIT_OR);
	gfx_blit(96,220,1,8,SPR_LDN,GFX_BLIT_OR);
	gfx_blit(104,220,1,8,SPR_LDN,GFX_BLIT_OR);

	gfx_blit(48,25,8,13,SPRITE(0,56),GFX_BLIT_OR);

	gfx_blit(UNDOX,UNDOY,3,9,SPRITE(0,70),GFX_BLIT_OR);
	gfx_blit(EXITX,EXITY,3,9,SPRITE(24,70),GFX_BLIT_OR);
	gfx_blit(RSTX,RSTY,2,9,SPRITE(48,70),GFX_BLIT_OR);

	LCDCopy(VIRTTOREAL);
}

void set_level()
{
	int x,y;
	unsigned char c1,c2;

	for(y=0;y<16;y++)
	{
		for(x=0;x<10;x++)
		{
			c1=levels[g_currlevelno*10*16+x+10*y];
			c2=c1>>4;
			c1=c1&15;
			g_currlevel[x*2][y]=c2;
			g_currlevel[x*2+1][y]=c1;
		}
	}
	g_eol=0;
}

void clear_undo()
{
	int t;
	for(t=0;t<256;t++)
	{
		undo_buf[t]=255;
	}
	undo_ptr=0;
}

void move_man_ok(int dx,int dy)
{
	PenBeep();
	blit_level_char(g_manx,g_many);
	g_manx+=dx;
	g_many+=dy;
	blit_sprite(g_manx*8,g_many*8,SPR_MAND);
	LCDCopy(VIRTTOREAL);
	Delay_10ms();
	Delay_10ms();
	Delay_10ms();
	Delay_10ms();
	Delay_10ms();
}

void check_eol()
{
	int x,y;

	for(y=0;y<16;y++)
	{
		for(x=0;x<20;x++)
		{
			if(g_currlevel[x][y]==4)
			{
				return;
			}
		}
	}
	g_eol=1;
}

void move_man(int dx,int dy)
{
	int c=g_currlevel[g_manx+dx][g_many+dy];
	int cn=g_currlevel[g_manx+dx*2][g_many+dy*2];
	int undocode;

	undocode=dx>0?1:0;
	undocode+=dy<0?2:0;
	undocode+=dy>0?3:0;

	if((c==1)||(c==3))
	{
		move_man_ok(dx,dy);
		undo_buf[undo_ptr++]=undocode;
	}
	if((c==4)&&(cn==1))
	{
		g_currlevel[g_manx+dx*2][g_many+dy*2]=4;
		g_currlevel[g_manx+dx][g_many+dy]=1;
		blit_level_char(g_manx+dx*2,g_many+dy*2);
		move_man_ok(dx,dy);
		undocode|=1*16;
		undo_buf[undo_ptr++]=undocode;
	}
	if((c==4)&&(cn==3))
	{
		g_currlevel[g_manx+dx*2][g_many+dy*2]=6;
		g_currlevel[g_manx+dx][g_many+dy]=1;
		blit_level_char(g_manx+dx*2,g_many+dy*2);
		move_man_ok(dx,dy);
		undocode|=2*16;
		undo_buf[undo_ptr++]=undocode;
		Buzzer(2,1);
		Buzzer(4,1);
		check_eol();
	}
	if((c==6)&&(cn==1))
	{
		g_currlevel[g_manx+dx*2][g_many+dy*2]=4;
		g_currlevel[g_manx+dx][g_many+dy]=3;
		blit_level_char(g_manx+dx*2,g_many+dy*2);
		move_man_ok(dx,dy);
		undocode|=3*16;
		undo_buf[undo_ptr++]=undocode;
		Buzzer(4,1);
		Buzzer(2,1);
	}
	if((c==6)&&(cn==3))
	{
		g_currlevel[g_manx+dx*2][g_many+dy*2]=6;
		g_currlevel[g_manx+dx][g_many+dy]=3;
		blit_level_char(g_manx+dx*2,g_many+dy*2);
		move_man_ok(dx,dy);
		undocode|=4*16;
		undo_buf[undo_ptr++]=undocode;
	}

	undo_ptr&=255;
}

void undo()
{
	int u=(undo_ptr-1)&255;
	int dx=0;
	int dy=0;

	if(undo_buf[u]==255)
	{
		WarningBeep();
		return;
	}

	switch(undo_buf[u]&0x0f)
	{
		case 0: dx=1; break;
		case 1: dx=-1; break;
		case 2: dy=1; break;
		case 3: dy=-1; break;
	}

	switch(undo_buf[u]&0xf0)
	{
		case 1*16:
		{
			g_currlevel[g_manx-dx][g_many-dy]=1;
			g_currlevel[g_manx][g_many]=4;
		} break;
		case 2*16:
		{
			g_currlevel[g_manx-dx][g_many-dy]=3;
			g_currlevel[g_manx][g_many]=4;
		} break;
		case 3*16:
		{
			g_currlevel[g_manx-dx][g_many-dy]=1;
			g_currlevel[g_manx][g_many]=6;
		} break;
		case 4*16:
		{
			g_currlevel[g_manx-dx][g_many-dy]=3;
			g_currlevel[g_manx][g_many]=6;
		} break;
	}

	blit_level_char(g_manx,g_many);
	blit_level_char(g_manx-dx,g_many-dy);
	g_manx+=dx;
	g_many+=dy;
	blit_sprite(g_manx*8,g_many*8,SPR_MAND);

	LCDCopy(VIRTTOREAL);
	undo_ptr--;
	undo_ptr&=255;
	undo_buf[undo_ptr]=255;
}

void release_pen()
{
	unsigned char penx,peny;

	while(GetKey(&penx,&peny));
}

int pen_press(int x,int y)
{
	int dx,dy;

	if((y>=LEVOFFY)&&(y<LEVOFFY+8*16))
	{
		y-=LEVOFFY;
		dx=(x>>3)-g_manx;
		dy=(y>>3)-g_many;
		if(dx<0) dx=-1;
		if(dx>0) dx=1;
		if(dy<0) dy=-1;
		if(dy>0) dy=1;
		if((dx&&!dy)||(!dx&&dy))
		{
			move_man(dx,dy);
		}
		return 0;
	}
	if((x>96)&&(x<104)&&(y>204)&&(y<212))
	{
		PenBeep();
		gfx_blit(96,204,1,8,SPR_MASK,GFX_BLIT_XOR);
		LCDCopy(VIRTTOREAL);
		g_currlevelno+=10;
		if(g_currlevelno>84)
		{
			g_currlevelno=84;
		}
		release_pen();
		return 1;
	}
	if((x>104)&&(x<112)&&(y>204)&&(y<212))
	{
		PenBeep();
		gfx_blit(104,204,1,8,SPR_MASK,GFX_BLIT_XOR);
		LCDCopy(VIRTTOREAL);
		g_currlevelno++;
		if(g_currlevelno>84)
		{
			g_currlevelno=84;
		}
		release_pen();
		return 1;
	}
	if((x>96)&&(x<104)&&(y>220)&&(y<228))
	{
		PenBeep();
		gfx_blit(96,220,1,8,SPR_MASK,GFX_BLIT_XOR);
		LCDCopy(VIRTTOREAL);
		g_currlevelno-=10;
		if(g_currlevelno<0)
		{
			g_currlevelno=0;
		}
		release_pen();
		return 1;
	}
	if((x>104)&&(x<112)&&(y>220)&&(y<228))
	{
		PenBeep();
		gfx_blit(104,220,1,8,SPR_MASK,GFX_BLIT_XOR);
		LCDCopy(VIRTTOREAL);
		g_currlevelno--;
		if(g_currlevelno<0)
		{
			g_currlevelno=0;
		}
		release_pen();
		return 1;
	}

	if((x>UNDOX)&&(x<UNDOX+18)&&(y>UNDOY)&&(y<UNDOY+9))
	{
		PenBeep();
		SetToVirtualLCD(0);
		InverseLCDArea(UNDOX,UNDOY,UNDOX+18,UNDOY+8);
		SetToRealLCD(1);
		release_pen();
		SetToVirtualLCD(0);
		InverseLCDArea(UNDOX,UNDOY,UNDOX+18,UNDOY+8);
		SetToRealLCD(1);
		undo();
	}
	if((x>RSTX)&&(x<RSTX+14)&&(y>RSTY)&&(y<RSTY+8))
	{
		PenBeep();
		SetToVirtualLCD(0);
		InverseLCDArea(RSTX,RSTY,RSTX+14,RSTY+8);
		SetToRealLCD(1);
		release_pen();
		SetToVirtualLCD(0);
		InverseLCDArea(RSTX,RSTY,RSTX+14,RSTY+8);
		SetToRealLCD(1);
		return 1;
	}
	if((x>EXITX)&&(x<EXITX+16)&&(y>EXITY)&&(y<EXITY+8))
	{
		PenBeep();
		SetToVirtualLCD(0);
		InverseLCDArea(EXITX,EXITY,EXITX+16,EXITY+8);
		SetToRealLCD(1);
		release_pen();
		SetToVirtualLCD(0);
		InverseLCDArea(EXITX,EXITY,EXITX+16,EXITY+8);
		SetToRealLCD(1);
		return -1;
	}

	return 0;
}

int main_loop()
{
	unsigned char penx,peny;
	int key;

	while(-1)
	{
		if(g_eol)
		{
			Buzzer(1,1); Buzzer(3,1); Buzzer(5,1);
			Buzzer(1,1); Buzzer(3,1); Buzzer(5,1);
			g_currlevelno++;
			if(g_currlevelno>84)
			{
				g_currlevelno=0;
			}
			return 0;
		}

		key=GetKey(&penx,&peny);

		if(key==PGDN)
		{
			key=0;
		}
		if(key==PGUP)
		{
			key=0;
		}
		if(key&&key!=255)
		{
			return key;
		}
		if(key&&key==255)
		{
			if(key=pen_press(penx,peny))
			{
				if(key==-1)
				{
					return APPLICATION;
				}
				return 0;
			}
		}
	}
}

void intro()
{
	int s,t,u;
	unsigned char penx,peny;
	int ly[7],lv[7];

	for(t=0;t<7;t++)
	{
		ly[t]=281;
		lv[t]=-128;
	}

	SetToVirtualLCD(0);
	ClearLCD(0);
	SetToRealLCD(0);

	u=1;
	while(lv[6])
	{
		for(s=0;s<u;s++)
		{
			gfx_blit(48,ly[s],8,13,SPRITE(0,56),GFX_BLIT_OR);
		}
		LCDCopy(VIRTTOREAL);
		for(s=0;s<u;s++)
		{
			gfx_blit(48,ly[s],8,13,SPRITE(0,56),GFX_BLIT_CLEAR);
			if(lv[s]!=0)
			{
				ly[s]+=lv[s]/8;
				lv[s]+=4;
			}
		}
		u++;
		if(u>7) u=7;
	}

	SetFontType(PRPFONT11B);
	s=GetStringLength("Written by",PRPFONT11B);
	WriteString((160-s)/2,60,"Written by",DRAW_BLACK);
	s=GetStringLength("G. Vermeulen",PRPFONT11B);
	WriteString((160-s)/2,74,"G. Vermeulen",DRAW_BLACK);

	SetFontType(PRPFONT7N);
	s=GetStringLength("Tap screen to start",PRPFONT7N);

	t=0;
	while(!GetKey(&penx,&peny))
	{
		if(t&16)
		{
			WriteString((160-s)/2,140,"Tap screen to start",DRAW_BLACK);
		}
		else
		{
			WriteString((160-s)/2,140,"Tap screen to start",DRAW_WHITE);
		}
		Delay_10ms();
		t++;
	}
	PenBeep();
}

int main()
{
	int key;
	int t,x,y;

	g_currlevelno=0;

	intro();

	while(-1)
	{
		clear_undo();
		set_level();
		draw_level();
		key=main_loop();
		if(key)
		{
			break;
		}
	}

	return key;
}

