/*
 * Vexed v1.4a - Vexed.c "The Main Stuff, i.e. event handlers, loops, etc"
 * Copyright (C) 1999 James McCombe (cybertube@earthling.net)
 *
 * Adaptation for the Avigo
 * Copyright (C) 2001 Jean-michel Bunouf
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */

#include <avsys.h>
#include <avgui.h>
#include <avicons.h>

#include "pbitmap.h"
#include "protos.h"


struct
{
    struct
    {
        int x, y;
    }
    begin, end;
}
playermove;

extern struct
{
    Boolean
    PieceMoveAnim, /* whether the movement of a piece by the user is animated */
    GravityAnim, /* whether the gravity effect is animated */
    EliminationAnim, /* whether piece elimination is animated */
    Sound; /* whether sound is on or off */
    int CurrentLevel, SolvedLevels; /* stores the level the user was last at */
}
VexedPreferences;

extern int current [9] [11];
extern int stored [9] [11];

static MENUITEM MainMenu[]=
{
    {"Preferences...", ItemPreferences , lstDisplay},
    {"Help", ItemHowToPlay , lstDisplay},
    {"About", ItemAbout , lstDisplay | lstUnderLine},
    {"Exit", cmOK , lstDisplay},
    {"\0", 0, 0}
};

char LineHelp;

static char *StringHelp[] =
{
    " ",
    "GAME :",
    " ",
    "The object of Vexed is to end",
    "up with no boxes left on a",
    "level.",
    " ",
    "When 2 or more boxes of the",
    "same type are together,",
    "they will all disappear.",
    " ",
    "Remember the boxes all",
    "adhere to gravity, i.e. if you",
    "remove a box from the",
    "bottom of a pile, they will all",
    "tumble down!",
    " ",
    "To move the blocks, hold the",
    "stylus on the block you want",
    "to move and slide to the",
    "right or left and lift the",
    "stylus.",
    " ",
    "If you make a mistake and a",
    "level is impossible to",
    "complete, you can press the",
    "\"Restart\" button (the",
    "circular arrow on the bottom",
    "right).",
    " ",
    "You may navigate through",
    "the rather large set of levels",
    "(59) using the arrows and",
    "the lookup feature (the",
    "\"magnifying glass\"  icon)",
    " ",
    "In order to memorise the",
    "state of a current level you",
    "are working on, push \"M\".  If",
    "you make a mess, you can",
    "push \"R\" (recall) and it will",
    "return to where you were",
    "when you last memorised.",
    "This memory is removed",
    "when Vexed is quit or when",
    "you move between levels",
    " ",
    " ",
    "PREFERENCES :",
    " ",
    "The function of the first 4",
    "checkboxes are self",
    "explanatory.  The \"Reset\"",
    "button however makes",
    "vexed forget how many",
    "levels you have actually",
    "solved and puts you back to",
    "level one and will not let you",
    "browse through the levels",
    "until you solve them again.",
};


extern unsigned int about, restart, back, forward, lookup, first, last, memory, recall;
unsigned int ibank;

unsigned char CheckBoxPieceAnim;
unsigned char CheckBoxGravityAnim;
unsigned char CheckBoxEliminationAnim;
unsigned char CheckBoxSound;


static int StartApplication(void)
{
    LoadBitmapResources();
    LoadPreferences();
    DrawIntro(); /* draws the intro screen upon game startup */
    LoadLevel(VexedPreferences.CurrentLevel);
}

void AboutDialog()
{
    PDESKBOX *FormAbout;
    FormAbout = (PDESKBOX *)CreateDeskBox(210, 14, 50, 145, 190, MK_FAR_PTR((char*)"About"),
                                          NULL_FP, NULL_FP, bafDialog);
    AssignBankNo(about, ibank);
    PGROUP_insert((VOID_PTR) FormAbout, (PVIEW *)
                  CreateBitmap(211, 33, 61, ibank, (unsigned int)&about, PUT));
    PGROUP_insert((VOID_PTR) FormAbout, (PVIEW *)
                  CreateLabel( 212, 10, 59, 125, 73, MK_FAR_PTR((char *)"Vexed V1.4a"),
                  lbofAlignRight|lbofDefineFont, PRPFONT14N));
    PGROUP_insert((VOID_PTR) FormAbout, (PVIEW *)
                  CreateLabel( 213, 10, 74, 125, 85, MK_FAR_PTR((char *)"14 oct 2001"),
                  lbofAlignRight|lbofDefineFont, PRPFONT11N));
    PGROUP_insert((VOID_PTR) FormAbout, (PVIEW *)
                  CreateLabel( 214, 10, 95, 150, 106, MK_FAR_PTR((char *)"Original Palm version"),
                  lbofAlignCenter|lbofDefineFont, PRPFONT11N));
    PGROUP_insert((VOID_PTR) FormAbout, (PVIEW *)
                  CreateLabel( 215, 10, 107, 150, 118, MK_FAR_PTR((char *)"by James McCombe"),
                  lbofAlignCenter|lbofDefineFont, PRPFONT11N));
    PGROUP_insert((VOID_PTR) FormAbout, (PVIEW *)
                  CreateLabel( 216, 10, 131, 150, 142, MK_FAR_PTR((char *)"Adaptation for Avigo"),
                  lbofAlignCenter|lbofDefineFont, PRPFONT11N));
    PGROUP_insert((VOID_PTR) FormAbout, (PVIEW *)
                  CreateLabel( 217, 10, 143, 150, 154, MK_FAR_PTR((char *)"by Jean-michel Bunouf"),
                  lbofAlignCenter|lbofDefineFont, PRPFONT11N));
    PGROUP_insert((VOID_PTR) FormAbout, (PVIEW *)
                  CreateButton( 218, 42, 160, 118, 176, MK_FAR_PTR("OK"), cmOK, bttBasic));

    LCDCopy(REALTOVIRT);
    ExecView((PGROUP_PTR) FormAbout);
    Destroy((VOID_PTR) FormAbout);
    LCDCopy(VIRTTOREAL);
}


frmHelpDrawH (VOID_PTR thisView)
{
    char y, l=LineHelp ;

    PDESKBOX_draw(thisView);
    SetFontType(PRPFONT7N);
    for (y = 0; y <= 14; y ++)
        WriteString( 10, 48+y*8, StringHelp[l++], 0); /* draw the text string */

}

frmHelpEventH (VOID_PTR thisView, unsigned int *evType, unsigned char penx, unsigned char peny)
{

    PDESKBOX_handleEvent (thisView, evType, penx, peny);

    if (*evType == evKeyDown)
        switch(penx)
    {
        case PGUP:
            if (LineHelp>=15) LineHelp -=15;
            frmHelpDrawH (thisView);
            ClearEvent(evType);
            break;
        case PGDN:
            if (LineHelp<=30) LineHelp += 15;
            frmHelpDrawH (thisView);
            ClearEvent(evType);
            break;
    }

    if (*evType == evCommand)
        switch(TOWORD (penx,peny))
    {
        case cmPgUp:
            if (LineHelp>=15) LineHelp -=15;
            frmHelpDrawH (thisView);
            ClearEvent(evType);
            break;
        case cmPgDn:
            if (LineHelp<=30) LineHelp += 15;
            frmHelpDrawH (thisView);
            ClearEvent(evType);
            break;
    }

}


void HelpDialog()
{
    PDESKBOX *FormHelp;

    LineHelp=0;
    FormHelp = (PDESKBOX *)CreateDeskBox(190, 2, 32, 158, 206, MK_FAR_PTR((char*)"Help"),
                                         NULL_FP, NULL_FP, bafDotTitle | bafClose | bafComLine);

    InsertPageArrow( FormHelp, 191, (PVIEW *) FormHelp);
    PGROUP_insert((VOID_PTR) FormHelp, (PVIEW *)
                  CreateButton( 192, 4, 188, 34, 204, MK_FAR_PTR("Exit"), cmQuit, bttBasic));
    BankedAssign1( FormHelp->draw, frmHelpDrawH);
    BankedAssign2( FormHelp->handleEvent, frmHelpEventH);

    LCDCopy(REALTOVIRT);
    ExecView((PGROUP_PTR) FormHelp);
    Destroy((VOID_PTR) FormHelp);
    LCDCopy(VIRTTOREAL);
}


void SelectLevel()
{

    unsigned char Level = 0;
    unsigned short Button;
    PDESKBOX *FormSelectLevel;


    FormSelectLevel = (PDESKBOX *)CreateDeskBox(193, 14, 50, 145, 144, MK_FAR_PTR((char*)"Select level"),
                                                NULL_FP, NULL_FP, bafDotTitle | bafClose);
    PGROUP_insert((VOID_PTR) FormSelectLevel, (PVIEW *)
                  CreateButton( 194, 41, 118, 70, 134, MK_FAR_PTR("OK"), cmOK, bttBasic));
    PGROUP_insert((VOID_PTR) FormSelectLevel, (PVIEW *)
                  CreateButton( 195, 75, 118, 122, 134, MK_FAR_PTR("Cancel"), cmQuit, bttBasic));
    PGROUP_insert((VOID_PTR) FormSelectLevel, (PVIEW *)
                  CreateLabel( 196, 40, 82, 155, 91, MK_FAR_PTR((char *)"Go to level"),
                  lbofAlignLeft|lbofDefineFont, PRPFONT11N));
    PGROUP_insert((VOID_PTR) FormSelectLevel, (PVIEW *)
                  CreateNumberSet( 197, 95, 80, 0, VexedPreferences.SolvedLevels, 1, &Level));

    LCDCopy(REALTOVIRT);
    Button = ExecView((PGROUP_PTR) FormSelectLevel);
    Destroy((VOID_PTR) FormSelectLevel);
    LCDCopy(VIRTTOREAL);

    if (Button == cmOK )
    {
        VexedPreferences.CurrentLevel=Level;
        LoadLevel(VexedPreferences.CurrentLevel); /* load and draw the level onscreen */
    }

}




frmPrefsEventH (VOID_PTR thisView, unsigned int *evType, unsigned char penx, unsigned char peny)
{

    if (*evType == evCommand)
        switch(TOWORD (penx,peny))
    {
        case cmOK:
        /* set the preferences state to the state of the checkboxes on the form */
            VexedPreferences.PieceMoveAnim = CheckBoxPieceAnim;
            VexedPreferences.GravityAnim = CheckBoxGravityAnim;
            VexedPreferences.EliminationAnim = CheckBoxEliminationAnim;
            VexedPreferences.Sound = CheckBoxSound ;
            break;

        case cmReset:
            if (MessageBox( "Erase all memory of \nsolved levels?", mfWarning | mfYesNo) == cmYes )
            {
                /* reset level */
                VexedPreferences.SolvedLevels = 0;
                VexedPreferences.CurrentLevel = 0;
                LCDCopy(VIRTTOREAL);
                LoadLevel(VexedPreferences.CurrentLevel);
                LCDCopy(REALTOVIRT);
                PDESKBOX_draw(thisView);
            }
            break;

    }

    PDESKBOX_handleEvent (thisView, evType, penx, peny);

}



void Prefs()
{
    PDESKBOX *FormPrefs;

    CheckBoxPieceAnim = VexedPreferences.PieceMoveAnim;
    CheckBoxGravityAnim = VexedPreferences.GravityAnim;
    CheckBoxEliminationAnim = VexedPreferences.EliminationAnim;
    CheckBoxSound = VexedPreferences.Sound;


    FormPrefs = (PDESKBOX *)CreateDeskBox( 220, 2, 25, 157, 144, MK_FAR_PTR((char*)"Preferences"),
                                           NULL_FP, NULL_FP, bafDotTitle | bafClose );

    PGROUP_insert((VOID_PTR) FormPrefs, (PVIEW *)
                  CreateBoolField( 221, 7, 43, &CheckBoxPieceAnim, 1));
    PGROUP_insert((VOID_PTR) FormPrefs, (PVIEW *)
                  CreateLabel( 222, 20, 45, 155 , 57, MK_FAR_PTR((char *)"Piece Move Animation"),
                  lbofAlignLeft|lbofDefineFont, PRPFONT11N));
    PGROUP_insert((VOID_PTR) FormPrefs, (PVIEW *)
                  CreateBoolField( 223, 7, 59, &CheckBoxGravityAnim, 1));
    PGROUP_insert((VOID_PTR) FormPrefs, (PVIEW *)
                  CreateLabel( 224, 20, 61, 155, 72, MK_FAR_PTR((char *)"Gravity Animation"),
                  lbofAlignLeft|lbofDefineFont, PRPFONT11N));
    PGROUP_insert((VOID_PTR) FormPrefs, (PVIEW *)
                  CreateBoolField( 225, 7, 75, &CheckBoxEliminationAnim, 1));
    PGROUP_insert((VOID_PTR) FormPrefs, (PVIEW *)
                  CreateLabel( 226, 20 , 77, 155 , 88, MK_FAR_PTR((char *)"Piece Elimination Animation"),
                  lbofAlignLeft|lbofDefineFont, PRPFONT11N));
    PGROUP_insert((VOID_PTR) FormPrefs, (PVIEW *)
                  CreateBoolField( 227, 7, 91, &CheckBoxSound, 1));
    PGROUP_insert((VOID_PTR) FormPrefs, (PVIEW *)
                  CreateLabel( 228, 20 , 93, 155 , 104, MK_FAR_PTR((char *)"Sound"),
                  lbofAlignLeft|lbofDefineFont, PRPFONT11N));
    PGROUP_insert((VOID_PTR) FormPrefs, (PVIEW *)
                  CreateButton( 229, 11, 118, 40, 134, MK_FAR_PTR("OK"), cmOK, bttBasic));
    PGROUP_insert((VOID_PTR) FormPrefs, (PVIEW *)
                  CreateButton( 230, 45, 118, 92, 134, MK_FAR_PTR("Cancel"), cmQuit, bttBasic));
    PGROUP_insert((VOID_PTR) FormPrefs, (PVIEW *)
                  CreateButton( 231, 112, 118, 148, 134, MK_FAR_PTR("Reset"), cmReset, bttBasic));

    BankedAssign2(FormPrefs->handleEvent, frmPrefsEventH);

    LCDCopy(REALTOVIRT);
    ExecView((PGROUP_PTR) FormPrefs);
    Destroy((VOID_PTR) FormPrefs);
    LCDCopy(VIRTTOREAL);
}


frmMainEventH (VOID_PTR thisView, unsigned int *evType, unsigned char penx, unsigned char peny)
{

    switch (*evType)
    {

        case evPenDown:
            if (( peny > 15) && (peny < 144)) /* the gameplay area */
            {
                playermove.begin.x = (int) (penx / 16);
                playermove.begin.y = (int) ((peny / 16) - 1);
                ClearEvent(evType);
                break;
            }
            if ((peny > 144) && ( peny < 160)) /* the control icons area */
            {
                if (penx > 144) /* the restart level icon */
                {
                    LoadLevel(VexedPreferences.CurrentLevel);
                    ClearEvent(evType);
                    break;
                }
                if ((penx > 128) && (penx < 144)) /* the recall icon */
                {
                    if (stored[0][0] == 0)
                        MessageBox( "Cannot recall because \nnothing was memorised", mfWarning | mfOKButton); /* AlertNothingStored */
                    else
                    {
                        int x, y;
                        for (y = 0; y <= 7; y ++)
                            for (x = 0; x <= 9; x ++)
                            current[y][x] = stored[y][x]; /* move stored => current level array */
                        DrawLevel();
                    }
                    ClearEvent(evType);
                }
                if ((penx > 112) && (penx < 128)) /* the memorise icon */
                {
                    int x, y;
                    for (y = 0; y <= 7; y ++)
                        for (x = 0; x <= 9; x ++)
                        stored[y][x] = current[y][x]; /* move current => stored level array */
                    ClearEvent(evType);
                }
                if ((penx < 16) && (VexedPreferences.CurrentLevel)) /* the first level icon */
                {
                    VexedPreferences.CurrentLevel = 0;
                    LoadLevel(VexedPreferences.CurrentLevel);
                    ClearEvent(evType);
                    break;
                }
                if ((penx < 32) && (penx > 16) && (VexedPreferences.CurrentLevel)) /* the previous level icon */
                {
                    VexedPreferences.CurrentLevel --;
                    LoadLevel(VexedPreferences.CurrentLevel);
                    ClearEvent(evType);
                    break;
                }
                if ((penx < 48) && (penx > 32)) /* the select level icon */
                {
                    SelectLevel();
                    break;
                }
                if ((penx < 64) && (penx > 48)) /* the next level icon */
                {
                    if (!(VexedPreferences.CurrentLevel + 1 > VexedPreferences.SolvedLevels))
                    {
                        VexedPreferences.CurrentLevel ++;
                        LoadLevel(VexedPreferences.CurrentLevel);
                    }
                    ClearEvent(evType);
                    break;
                }
                if ((penx < 80) && (penx > 64) && (!(VexedPreferences.CurrentLevel == VexedPreferences.SolvedLevels)))
                { /* the last solved level icon */
                    VexedPreferences.CurrentLevel = VexedPreferences.SolvedLevels;
                    LoadLevel(VexedPreferences.CurrentLevel);
                    ClearEvent(evType);
                    break;
                }
            }

            
            case evPenUp:

            if (( peny > 15) && (peny < 144)) /* penUpEvent is only an issue in the gameplay area */
            {
                playermove.end.x = (int) (penx / 16);
                playermove.end.y = (int) ((peny / 16) - 1);
                if (!((playermove.begin.x == playermove.end.x) && (playermove.begin.y == playermove.end.y)))
                {
                    if (playermove.end.x > playermove.begin.x)
                        if (PlayerMakeMove(playermove.begin.x, playermove.begin.y, Right))
                    {
                        VexedPreferences.CurrentLevel ++;
                        if (VexedPreferences.CurrentLevel > VexedPreferences.SolvedLevels)
                            VexedPreferences.SolvedLevels ++;
                        LoadLevel(VexedPreferences.CurrentLevel); /* move onto next level if current is completed */
                        ClearEvent(evType);
                        break;
                    }
                    if (playermove.end.x < playermove.begin.x)
                        if (PlayerMakeMove(playermove.begin.x, playermove.begin.y, Left))
                    {
                        VexedPreferences.CurrentLevel ++;
                        if (VexedPreferences.CurrentLevel > VexedPreferences.SolvedLevels)
                            VexedPreferences.SolvedLevels ++;
                        LoadLevel(VexedPreferences.CurrentLevel); /* move onto next level if current is completed */
                        ClearEvent(evType);
                        break;
                    }
                }
                ClearEvent(evType);
                break;
            }
        }

    if (*evType == evCommand)
        switch(TOWORD (penx,peny))
    {
        case ItemPreferences:
            Prefs();
            ClearEvent(evType);
            break;

        case ItemHowToPlay:
            HelpDialog();
            ClearEvent(evType);
            break;

        case ItemAbout:
            AboutDialog();
            ClearEvent(evType);
            break;

    }

    PDESKBOX_handleEvent (thisView, evType, penx, peny);
}

void VexedMain()
{
    PDESKBOX *FormMain;
    FormMain = (PDESKBOX *)CreateDeskBox(200, 0, 0, 159, 16, MK_FAR_PTR((char*)"Game"),
                                         MK_FAR_PTR(MainMenu), NULL_FP, bafDotTitle | bafClose );

    AssignBankNo(restart, ibank);
    PGROUP_insert((VOID_PTR) FormMain, (PVIEW *)
                  CreateBitmap(201, 144, 144, ibank, (unsigned int)&restart, PUT));
    AssignBankNo(back, ibank);
    PGROUP_insert((VOID_PTR) FormMain, (PVIEW *)
                  CreateBitmap(202, 16, 144, ibank, (unsigned int)&back, PUT));
    AssignBankNo(forward, ibank);
    PGROUP_insert((VOID_PTR) FormMain, (PVIEW *)
                  CreateBitmap(203, 48, 144, ibank, (unsigned int)&forward, PUT));
    AssignBankNo(lookup, ibank);
    PGROUP_insert((VOID_PTR) FormMain, (PVIEW *)
                  CreateBitmap(204, 32, 144, ibank, (unsigned int)&lookup, PUT));
    AssignBankNo(first, ibank);
    PGROUP_insert((VOID_PTR) FormMain, (PVIEW *)
                  CreateBitmap(205, 0, 144, ibank, (unsigned int)&first, PUT));
    AssignBankNo(last, ibank);
    PGROUP_insert((VOID_PTR) FormMain, (PVIEW *)
                  CreateBitmap(206, 64, 144, ibank, (unsigned int)&last, PUT));
    AssignBankNo(memory, ibank);
    PGROUP_insert((VOID_PTR) FormMain, (PVIEW *)
                  CreateBitmap(207, 112, 144, ibank, (unsigned int)&memory, PUT));
    AssignBankNo(recall, ibank);
    PGROUP_insert((VOID_PTR) FormMain, (PVIEW *)
                  CreateBitmap(208, 128, 144, ibank, (unsigned int)&recall, PUT));

    BankedAssign2(FormMain->handleEvent, frmMainEventH );
    ExecView((PGROUP_PTR) FormMain);
    Destroy((VOID_PTR) FormMain);
}



static void StopApplication(void)
{
    SavePreferences();
}

/* main program */

int main ()
{
    StartApplication(); /* Application start code */
    VexedMain();
    StopApplication (); /* Application stop code */
    return APPLICATION;
}


