/*-----------------------------------------------------------------*/
/* Math.C Hubi's Math-Pack                                         */
/* Author Hubert Baumgarten 101.265175@germanynet.de.              */
/* Datum 21.Feb.1999                                               */
/*-----------------------------------------------------------------*/
#include "math.h"

int math_error;   /* TRUE or FALSE */
/*-----------------------------------------------------------------*/
double exp(double x)
{
	double Nenner,Zaehler,y,yold;
	int i;

	math_error=FALSE;
	y = 1;
	Zaehler = 1;
	Nenner = 1;
	i = 0;
	yold = 1 - y;
	while (i < 200 && yold!=y)
	{
		yold = y;
		i++;
		Zaehler = Zaehler * x;
		Nenner = Nenner * i;
		y = y + Zaehler / Nenner;
	}
	return y;
}
/*---------------------------------------------------------------*/
double ln(double arg)
{
	double x,Nenner,Zaehler,y,yold,xquat,work;
	int i,k;
	math_error=FALSE;
	if (arg <= 0.0)
	{
		math_error=TRUE;
		y=0;
	}
	else
	{
		x=arg;
		k=0;
		work = (x-1)/(x+1);
		while (work > 0.5)
		{
			x = x / const_e;
			k++;
			work = (x-1)/(x+1);
		}
		while (work < 0.1)
		{
			x = x * const_e;
			k--;
			work = (x-1)/(x+1);
		}


		x = (x-1)/(x+1);
		xquat = x * x;
		y = x;
		Zaehler = x;
		Nenner = 1;
		i = 1;

		yold=1-y;
		while (i < 200 && yold!=y)
		{
			yold = y;
    			i++;
    			Zaehler = Zaehler * xquat;
    			Nenner = Nenner + 2;
    			y = y + Zaehler / Nenner;
		}
		y = y + y + k;

	}
	return y;
}
/*---------------------------------------------------------------*/
double log(double arg)
{
	double y;
	y = ln(arg);
	y = y / const_ln10;
	return y;
}
/*---------------------------------------------------------------*/
double sin(double arg)
{

	double Nenner,Zaehler,y,yold,x,xquat;
	int i;

	math_error=FALSE;
        
	if (arg > 10000 || arg <-10000)
	{
		math_error=TRUE;
		y=0;
	}
	else
	{
		
		x=arg-((int)(arg/(2*const_pi)))*(2*const_pi); /* make 0<x<2*PI, hi gerard !*/

		y = x;
		xquat=x*x;
		Zaehler = x;
		Nenner = 1;
		i = 1;
		yold=1-y;
		while (i < 400 && yold!=y)
		{
			yold = y;
    			Zaehler = Zaehler * xquat;
    			Zaehler = -Zaehler; 
    			i++;
   			Nenner = Nenner * i;
    			i++;
   			Nenner = Nenner * i;
    			y = y + Zaehler / Nenner;
		}
	}
	return y;

}
/*---------------------------------------------------------------*/
double cos(double arg)
{
	double y,x;
	x = const_pihalf - arg;
	y = sin(x);
	return y;
}
/*---------------------------------------------------------------*/
double tan(double x)
{
	double y1,y2; 
	y1 = sin(x);
	y2 = cos(x);
	y1 = y1/y2;
	return y1;
}
/*---------------------------------------------------------------*/
double arcsin(double arg)
{

	double Nenner,Zaehler1,Zaehler2,y,yold,xquat,x;
	int i;

	math_error=FALSE;
	if (arg < -1.0 || arg > 1.0)
	{
		math_error=TRUE;
		y=0;
	}
	else
	{
		if (arg > 0.5 || arg < -0.5)
		{
			x = sqrt(1 - arg * arg);
		}
		else
		{
			x = arg;
		}

		y = x;
		xquat = x * x;
		Zaehler1 = x;
		Zaehler2 = 1.0;
		Nenner = 1;
		i = 1;
		yold=1-y;
		while (i < 400 && yold!=y)
		{
			yold = y;
    			Zaehler1 = Zaehler1 * xquat;
    			Zaehler2 = Zaehler2 * i; 
    			i++;
			Nenner = Nenner * i;
   			i++;
    			y = y + Zaehler1 * Zaehler2 / (Nenner *i);
		}

		if (arg > 0.5)
		{
			y = const_pihalf - y;
		}
		if (arg < -0.5)
		{
			y = y-const_pihalf;
		}
	}
return y;

}
/*---------------------------------------------------------------*/
double arccos(double x)
{
	double y;
 
	y = arcsin(x);
	if (!math_error)
	{
		y = const_pihalf - y;
	}
	return y;
}
/*---------------------------------------------------------------*/
double arctan(double arg)
{
	double y,x;
	x=arg;
	if (arg>1.0 || arg<-1.0)
	{
		x=1/arg;
	}
	x=x/(sqrt(1.0 + x * x)); 
	y = arcsin(x);
	if (arg>1.0)
	{
		y = const_pihalf-y;
	}
	if (arg<-1.0)
	{
		y = -const_pihalf-y;
	}
	return y;
}

/*---------------------------------------------------------------*/
double dec2rad(double x)
{
	double y;
	y = x * const_pi / 180;
	return y;
}
/*---------------------------------------------------------------*/
double rad2dec(double x)
{
	double y;
	y = x * 180 / const_pi;
	return y;
}
/*---------------------------------------------------------------*/
double sin360(double arg)
{
	double x,y;
	x = dec2rad(arg);
	y = sin(x);
	return y;
}
/*---------------------------------------------------------------*/
double cos360(double arg)
{
	double x,y;
	x = dec2rad(arg);
	y = cos(x);
	return y;
}
/*---------------------------------------------------------------*/
double tan360(double arg)
{
	double x,y;
	x = dec2rad(arg);
	y = tan(x);
	return y;
}
/*---------------------------------------------------------------*/
double arcsin360(double x)
{
	double y;
	y = arcsin(x);
	y = rad2dec(y);
	return y;
}
/*---------------------------------------------------------------*/
double arccos360(double x)
{
	double y;
	y = arccos(x);
	y = rad2dec(y);
	return y;
}
/*---------------------------------------------------------------*/
double arctan360(double x)
{
	double y;
	y = arctan(x);
	y = rad2dec(y);
	return y;
}
