/* 
 * dopewars.c
 *
 * Kai Nothdurft
 * KNothdur@ifu.Rantzau.de
 *
 * Adapted from the Palm-Version which is coded by
 *
 * Matt Lee
 * mattlee@mit.edu
 *
 * Some code by Ken Shirriff (ken.shirriff@eng.sun.com)
 *
 * 2000(c) Kai Nothdurft, 1999(c) Matthew Lee
 * You may use this code as you wish, but please give mention to me in
 * derivative works.
 *
 * Thanks goes out to all of the people who made great feature suggestions and
 * pointed out bugs.  This game is great because of your contributions!
 *
 */

/* revision history
 *
 * 1.0 : first release version
 */

#include "dopewars.h"

static char OutwitMsg[]="You try to outwit me, this will cost you 1500 bucks.";
static char JustKiddingMsg[]="Just kidding, it cost you nothing but nerves.";
static char LackMoney[]="You do not have that much money.";

static Message gameMessages [GAME_MESSAGE_COUNT] = {
    {13, "The cops just did a big Weed bust!  Prices are sky-high!", 5, 4, 0, 0},
    {20, "The cops just did a big PCP bust!  Prices are sky-high!", 3, 4, 0, 0},
    {25, "The cops just did a big Heroin bust!  Prices are sky-high!", 4, 4, 0, 0},
    {13, "The cops just did a big Ludes bust!  Prices are sky-high!", 2, 4, 0, 0},
    {35, "The cops just did a big Cocaine bust!  Prices are sky-high!", 1, 4, 0, 0},
    {15, "The cops just did a big Speed bust!  Prices are sky-high!", 7, 4, 0, 0},
    {25, "Addicts are buying Heroin at outrageous prices!", 4, 8, 0, 0},
    {20, "Addicts are buying Speed at outrageous prices!", 7, 8, 0, 0},
    {20, "Addicts are buying PCP at outrageous prices!", 3, 8, 0, 0},
    {17, "Addicts are buying Mushrooms at outrageous prices!", 6, 8, 0, 0},
    {35, "Addicts are buying Cocaine at outrageous prices!", 1, 8, 0, 0},
    {17, "The market has been flooded with cheap home-made Acid!", 0, 0, 8, 0},
    {10, "A Columbian freighter dusted the Coast Guard!  Weed prices have bottomed out!", 5, 0, 4, 0},
    {11, "A gang raided a local pharmacy and are selling cheap Ludes!", 2, 0, 8, 0},
    {55, "You found some Cocaine on a dead dude in the subway!", 1, 0, 0, 3},
    {45, "You found some Acid on a dead dude in the subway!", 0, 0, 0, 6},
    {35, "You found some PCP on a dead dude in the subway!", 3, 0, 0, 4}};
static char EnterNumber[]="Enter a number";

static int updatelocation;
static int myDrugs [8];
static double myCash;
static double myDebt;
static double myBank;
static int myCoat;
static int myGuns;
static int myTotal;
static int myLocation;
static int timeLeft;
static int copCount;
static int cheatsEnabled;
static int cheatKey;

static int drawflag;

static int drugnum;
static int affordable;
static double drugPrices[8];

static char* drugnames[]=
    { "Acid",
      "Cocaine",
      "Ludes",
      "PCP",
      "Heroin",
      "Weed",
      "Mushrooms",
      "Speed"
    };

static char* LocationNames[]=
  { "Bronx",
    "Ghetto",
    "Central Park",
    "Manhattan",
    "Coney Island",
    "Brooklyn"
  };

static unsigned int ibank=0;
static MENUITEM HelpMenu[]=
  {
    {"Help", cmHelp, lstDisplay},
    {"\0", 0, 0} 
  };

static MENUITEM BuySellMenu[]=
  {
    {"Help", cmHelp, lstUnderLine},
    {"Restart game", cmRestart, lstDisplay},
    {"Show high-scores", cmHighScore, lstUnderLine},
    {"Quit", cmQuit, lstDisplay},
    {"\0", 0, 0} 
  };

static void makeDrugPrices(int leaveout)
{
    int i, j;

    drugPrices [0] = 1000 + random(3500);
    drugPrices [1] = 15000 + random(15000);
    drugPrices [2] = 10 + random(50);
    drugPrices [3] = 1000 + random(2500);
    drugPrices [4] = 5000 + random(9000);
    drugPrices [5] = 300 + random(600);
    drugPrices [6] = 600 + random(750);
    drugPrices [7] = 70 + random(180);

    for (i = 0; i < leaveout; i++)
    {
      j=random(8);
      drugPrices[j]=0;
    }
}

/*
the following function is also used from within doperare.c.
I could duplicate it or put it in the RAM-Bank. Since it is small,
i did the latter.
*/
#pragma dataseg
void myNumberField_handleEvent(VOID_PTR thisView, unsigned int *evType, unsigned char x, unsigned char y)
{
    if (*evType == evPenDown)
    {
      BackupWindow(1, 91, 158, 239, GetLCDBackBufAddr());
      PNUMBERFIELD_handleEvent(thisView, evType, x, y);
      RestoreWindow(1,91, GetLCDBackBufAddr(), PUT);
    }
    else
      PNUMBERFIELD_handleEvent(thisView, evType, x, y);
}
#pragma defaultseg

static void DoRandomStuff(void)
{
  int i;
  int addcount;

  for (i=0; i<GAME_MESSAGE_COUNT; i++)
  {
    if (!(random(gameMessages[i].freq)))
    {
      if (drugPrices[gameMessages[i].drug]==0)
        continue;
      MessageBox(gameMessages[i].msg, mfWarning);
      if (gameMessages[i].plus>0)
        drugPrices[gameMessages[i].drug]=drugPrices[gameMessages[i].drug] * gameMessages[i].plus;
      if (gameMessages[i].minus>0)
        drugPrices[gameMessages[i].drug]=drugPrices[gameMessages[i].drug] / gameMessages[i].minus;
        drugPrices[gameMessages[i].drug]=dint(&(drugPrices[gameMessages[i].drug]));
      if (gameMessages[i].add + myTotal > myCoat)
        addcount=myCoat-myTotal;
      else
        addcount = gameMessages[i].add;
      myDrugs[gameMessages[i].drug]=myDrugs[gameMessages[i].drug]+addcount;
      myTotal=myTotal+addcount;
    }
  }
}

void amountbank_draw(VOID_PTR thisView)
{
  char s[45];
  char* capital;

  PDESKBOX_draw(thisView);

  strcpy(s, "You have $");
  dtoa(myBank, s+strlen(s));
  strcpy(s+strlen(s)-1, " on bank and");
  WriteString(4, 33, s, 0);

  strcpy(s, "$");
  dtoa(myCash, s+strlen(s));
  strcpy(s+strlen(s)-1, " cash. How much would");
  WriteString(4, 47, s, 0);

  strcpy(s, "you like to ");
  capital=s+strlen(s); /* Here starts 'Draw' or 'Deposit' */
  fstrcpy(capital, ((PDESKBOX *)thisView)->title);
  *capital=*capital+32; /* 'decapitalize' ('D'->'d') it. */
  strcat(s,"?");
  WriteString(4, 61, s, 0);
}

static void VisitBank(void)
{
  unsigned char result=0,
           okay=0;
  double count;
  int d;
  PDESKBOX *dsk;
  PDESKBOX *amountbox;
  PNUMBERFIELD *fld;

  /* Create 'What to do'-Dialog */
  dsk=(PDESKBOX *)CreateDeskBox(230, 2, 120, 157, 239, MK_FAR_PTR((char *)"Bank Options"),
         MK_FAR_PTR(HelpMenu), NULL_FP, bafSmall);

  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(231,  7, 153, 155, 165, MK_FAR_PTR((char*)"What would you like to"),
                     lbofAlignCenter|lbofDefineFont, PRPFONT14N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(232,  7, 166, 155, 178, MK_FAR_PTR((char*)"do at the bank?"),
                     lbofAlignCenter|lbofDefineFont, PRPFONT14N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
             CreateButton(233, 4, 215, 49, 231, MK_FAR_PTR("Done"), cmCancel, bttBasic));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
             CreateButton(234, 57, 215, 101, 231, MK_FAR_PTR("Deposit"), cmDeposit, bttBasic));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
             CreateButton(235, 109, 215, 154, 231, MK_FAR_PTR("Draw"), cmWithdraw, bttBasic));

  /* Create 'How much'-Dialog */
  amountbox=(PDESKBOX *)CreateDeskBox(235, 1, 17, 158, 81, 
        NULL_FP, NULL_FP, NULL_FP, bafSmall | bafCheck | bafClose );
  fld=(PNUMBERFIELD *)CreateNumberField(238, 100, 61,(unsigned char *) &count, DTINTEGER,
                                        MK_FAR_PTR(EnterNumber));
  PGROUP_insert((VOID_PTR) amountbox, (PVIEW *)fld);
  BankedAssign2(amountbox->draw, amountbank_draw);
  BankedAssign2(fld->handleEvent, myNumberField_handleEvent);

  while (result!=cmCancel)
  {
    result=ExecView((PGROUP_PTR) dsk);
    LCDCopy(REALTOVIRT);

    if (result==cmWithdraw)
    {
      amountbox->title=MK_FAR_PTR("Draw");
      okay=0;
      while(!okay)
      {
        count=myBank;
        okay=ExecView((PGROUP_PTR)amountbox);
        LCDCopy(VIRTTOREAL);

        if (okay==cmCancel)
        {
          okay=1;
          count=0;
          continue;
        }
        else
          okay=0;

        if (count<0)
          continue;

        if ((myBank-count) < 0)
        {
          MessageBox("You do not have that much money in the bank.", mfWarning);
          continue;
        }
        okay = 1;
      }
      myBank=myBank-count;
      myCash=myCash+count;
    }               
    else if (result==cmDeposit)
    {
      amountbox->title=MK_FAR_PTR("Deposit");
      okay=0;
      while(!okay)
      {
        count=myCash;
        okay=ExecView((PGROUP_PTR)amountbox);
        LCDCopy(VIRTTOREAL);

        if (okay == cmCancel)
        {
          okay=1;
          count=0;
          continue;
        }
        else
          okay=0;

        if (count < 0)
          continue;
            
        if (count > myCash)
        {
          MessageBox(LackMoney, mfWarning);
          continue;
        }
        okay=1;
      }
      myBank=myBank+count;
      myCash=myCash-count;
    }               
  }
  Destroy((VOID_PTR)amountbox);
  Destroy((VOID_PTR)dsk);
}

static void DoTravel(unsigned char newLocation)
{
    int result;
    double taxes;

    myLocation=newLocation;
    if (timeLeft < 31)
    {
      taxes=myDebt*0.125;
      myDebt=myDebt+taxes;
      myDebt=dint(&myDebt);
      taxes=myBank*0.0625;;
      myBank=myBank+taxes;
      myBank=dint(&myBank);
    }
    timeLeft--;
    if (!random(7) && timeLeft && myTotal)
      FuzzEncounter();

    if (!timeLeft)
    {
      finishGame();
      if (myCash >= hscores[4].score) /* && !cheatsEnabled) */
      {
        GetHighScoreName();
        SaveStatus();
      }
      return;
    }

    if (!(random(10)))
    {
      result=MessageBox("Would you like to buy a trenchcoat with more pockets for $200?", mfYesNo);
      if (result==cmYes)
      {
        if (myCash<200)
          MessageBox(LackMoney,mfWarning);
        else
        {
          myCash=myCash-200;
          myCoat=myCoat+40;
        }
      }
    }

    if (!myGuns && !(random(10)))
    {
      result=MessageBox("Would you like to buy a gun for $400?", mfYesNo);
      if (result==cmYes)
      {
        if (myCash<400)
          MessageBox(LackMoney, mfWarning);
        else
        {
          myCash=myCash-400;
          myGuns++;
        }
      }
    }

    DoRandomStuff();

    if (myLocation==0) /* Bronx */
    {
      result=MessageBox("Would you like to visit the Loan Shark?", mfYesNo);
      if (result==cmYes)
        VisitShark();

      result=MessageBox("Would you like to visit the Bank?", mfYesNo);
      if (result==cmYes)
        VisitBank();
    }
}

void Travel_draw(VOID_PTR thisView)
{
  char i;

#define Offset 90
  
  PDESKBOX_draw(thisView);
  
  SetFontType(PRPFONT11N);

  /* Grid mitsamt Inhalt zeichnen */
  for(i=0; i<7; i++)
  {
    /* Horiz Linien zeichnen. Abstand 15 Pixel, Offset 40 Pixel. */
    DrawLine(30, i*15+Offset, 129, i*15+Offset, DRAW_B2DOT);
    if (i<6)
      WriteString(50, i*15+Offset+2, LocationNames[i], 0);
  }
  /* Vertikale Linien zeichnen */
  DrawLine(30, Offset, 30, Offset+90, DRAW_B2DOT);
  DrawLine(129, Offset, 129, Offset+90, DRAW_B2DOT);
}

void Travel_handleEvent(VOID_PTR thisView, unsigned int *evType, unsigned char x, unsigned char y)
{
  unsigned char y1;
  static char selectedLocation=0;
  
  if (x>29&& x<130 && y>=Offset && y<91+Offset)
  {
    /* Event inside grid. */
    switch (*evType)
    {
      case evPenUp:
        PenBeep();
        if (selectedLocation-1 != myLocation)
        {
          makeDrugPrices(3);
          DoTravel(selectedLocation-1);
        }
        selectedLocation=0;
        ((PDESKBOX *)thisView)->endState=cmOK;   /* End Window */
        ClearEvent(evType);
        break;

      case evPenDown:
      case evPenDownMove:
        y1 = (y-Offset-1)/15;  /* y1 = 0..6 (LineNumber) */
        if (y1 != selectedLocation-1)  /* Only if selection changed */
        {
          if (selectedLocation--)      /* deselct old selection */
            InverseLCDArea(30, selectedLocation*15+Offset+1, 129, (selectedLocation+1)*15+Offset-1);
          InverseLCDArea(30, y1*15+Offset+1, 129, (y1+1)*15+Offset-1);
        }
        selectedLocation = ++y1;       /* remember selection */
        ClearEvent(evType);
        break;
      case evCommand:
        if ((TOWORD(x,y))==cmHelp)
        {
          help(hlpTravel);
          ClearEvent(evType);
        }
        break;
    }
  }
  PDESKBOX_handleEvent(thisView, evType, x, y);
}

#undef Offset


void Travel()
{
  PDESKBOX *dsk;

  dsk = (PDESKBOX *)CreateDeskBox(220, 0, 20, 159, 239, MK_FAR_PTR((char *)"Jet"),
                          MK_FAR_PTR(HelpMenu), NULL_FP, bafDotTitle | bafClose);
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
             CreateLabel(221, 25, 50, 134, 72, MK_FAR_PTR((char *)"Where to, dude ?"),
                         lbofDefineFont, PRPFONT14B));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
             CreateButton(222, 59, 215, 99, 231, MK_FAR_PTR("Cancel"), cmCancel, bttBasic));

  BankedAssign2(dsk->draw, Travel_draw);
  BankedAssign2(dsk->handleEvent, Travel_handleEvent);

  ExecView((PGROUP_PTR) dsk);

  Destroy((VOID_PTR)dsk);
}

void NB_draw(VOID_PTR thisView)
{
  char s[45];

  PDESKBOX_draw(thisView);
  
  strcpy(s, drugnames[drugnum]);
  strcat(s, " at $");
  itoa(drugPrices[drugnum],s+strlen(s),10);
  strcat(s, " each, you");
  WriteString(4, 33, s, 0);

  strcpy(s, "can afford ");
  itoa(affordable, s+strlen(s), 10);
  strcat(s,". How many do");
  WriteString(4, 47, s, 0);
  
  strcpy(s, "you want to buy?");
  WriteString(4, 61, s, 0);
}

#pragma dataseg
unsigned char title[14];  /* Used in NegotiateBuy() and NegotiateSell() */
#pragma defaultseg

static void NegotiateBuy()
{
  PDESKBOX *frm;
  PNUMBERFIELD *fld;
  double count;
  int okay=0;
  
  strcpy(title, "Buy ");
  strcat(title, drugnames[drugnum]);

  count=myCash/drugPrices[drugnum];      /* # of drugs I can buy with my money */
  count=dint(&count);                    /* cut division-rest */
  affordable=MIN(count,myCoat-myTotal);  /* don't buy more than I can carry */
  count=affordable;                      /* set default for numberpicker */
  
  frm=(PDESKBOX *)CreateDeskBox(220, 1, 17, 158, 81, 
        MK_FAR_PTR(title), NULL_FP, NULL_FP, bafSmall | bafCheck | bafClose );
  fld=(PNUMBERFIELD *)CreateNumberField(221, 100, 59,(unsigned char *) &count, DTINTEGER,
                                        MK_FAR_PTR(EnterNumber));
  PGROUP_insert((VOID_PTR) frm, (PVIEW *)fld);

  BankedAssign2(fld->handleEvent, myNumberField_handleEvent);
  BankedAssign2(frm->draw, NB_draw);

  while (!okay)
  {
    okay=ExecView((PGROUP_PTR) frm);
    if (okay==cmOK)
    {
      if (count < 0)
      {
        MessageBox(OutwitMsg, mfWarning);
        MessageBox(JustKiddingMsg, mfWarning);
        okay=0;
        count=affordable;
        continue;
      }
      if ((count*drugPrices[drugnum]) > myCash)
      {
        MessageBox(LackMoney, mfWarning);
        okay=0;
        continue;
      }
      if ((count+myTotal) > myCoat)
      {
        MessageBox("You do not have enough room in your trenchcoat.", mfWarning);
        count=myCoat-myTotal;
        okay=0;
        continue;
      }
      myCash=myCash-(count*drugPrices[drugnum]);
      myDrugs[drugnum]=myDrugs[drugnum]+count;
      myTotal=myTotal+count;
    }
  }
  Destroy((VOID_PTR)frm);
}   

static void BuyDrugs()
{

    if (drugPrices[drugnum] == 0)
    {
        MessageBox("Nobody is selling that drug here.", mfWarning);
        return;
    }
    if (drugPrices[drugnum] > myCash)
    {
        MessageBox("You cannot afford any of that drug.", mfWarning);
        return;
    }
    if (myTotal+1 > myCoat)
    {
        MessageBox("You do not have enough room in your trenchcoat.", mfWarning);
        return;
    }
    NegotiateBuy();
}   

void NS_draw(VOID_PTR thisView)
{
  char s[45];

  PDESKBOX_draw(thisView);
  
  strcpy(s, drugnames[drugnum]);
  strcat(s, " at $");
  itoa(drugPrices[drugnum],s+strlen(s),10);
  strcat(s, " each, you");
  WriteString(4, 33, s, 0);

  strcpy(s, "can sell up to ");
  itoa(affordable, s+strlen(s), 10);
  strcat(s,". How many do");
  WriteString(4, 47, s, 0);
  
  strcpy(s, "you want to sell?");
  WriteString(4, 61, s, 0);
}

static void NegotiateSell()
{
  PDESKBOX *frm;
  PNUMBERFIELD *fld;
  double count;
  int okay=0;
  
  strcpy(title, "Sell ");
  strcat(title, drugnames[drugnum]);

  count=myDrugs[drugnum];
  affordable=count;

  frm=(PDESKBOX *)CreateDeskBox(220, 1, 17, 158, 81, 
        MK_FAR_PTR(title), NULL_FP, NULL_FP, bafSmall | bafCheck | bafClose );
  fld=(PNUMBERFIELD *)CreateNumberField(221, 100, 59,(unsigned char *) &count, DTINTEGER,
                                        MK_FAR_PTR(EnterNumber));
  PGROUP_insert((VOID_PTR) frm, (PVIEW *)fld);

  BankedAssign2(fld->handleEvent, myNumberField_handleEvent);
  BankedAssign2(frm->draw, NS_draw);
  while (okay == 0)
  {
    okay=ExecView((PGROUP_PTR) frm);
    if (okay==cmOK)
    {
      if (count < 0)
      {
        MessageBox(OutwitMsg, mfWarning);
        MessageBox(JustKiddingMsg, mfWarning);
        okay=0;
        count=affordable;
        continue;
      }
      if ((myDrugs[drugnum]-count) < 0)
      {
        MessageBox("You don't have that much of that drug to sell.", mfWarning);
        okay=0;
        continue;
      }
      myCash=myCash+(count*drugPrices[drugnum]);
      myDrugs[drugnum]=myDrugs[drugnum]-count;
      myTotal=myTotal-count;
    }
  }
  Destroy((VOID_PTR)frm);
}   


static void SellDrugs()
{
    if (myDrugs [drugnum] < 1)
    {
        MessageBox("You do not have any of that drug to sell.", mfWarning);
        return;
    }
    if (drugPrices [drugnum] == 0)
    {
        MessageBox("Nobody wants to buy that drug here.", mfWarning);
        return;
    }
    NegotiateSell();
}

void BS_draw(VOID_PTR thisView)
{
  char i;
  char s[25];

#define Offset 72
  
  PDESKBOX_draw(thisView);
  
  SetFontType(PRPFONT11N);

  /* Cash-value */
  strcpy(s,"$");
  dtoa(myCash, s+1);
  s[strlen(s)-1]=0;   /* eliminate dot */
  WriteAlignString(109, 17, s, 52, ALIGN_RIGHT, 0);
  
  /* Debt-value */
  strcpy(s,"$");
  dtoa(myDebt, s+1);
  s[strlen(s)-1]=0;   /* eliminate dot */
  WriteAlignString(109, 30, s, 52, ALIGN_RIGHT, 0);

  /* Savings-value */
  strcpy(s,"$");
  dtoa(myBank, s+1);
  s[strlen(s)-1]=0;   /* eliminate dot */
  WriteAlignString(109, 43, s, 52, ALIGN_RIGHT, 0);

  /* Show, if you have a gun - Then you can shot at the police. */
  if (myGuns)
  {
    AssignBankNo(glock, ibank);
    DrawIcon(114, 23, ibank, &glock, 0);
  }

  /* Grid mitsamt Inhalt zeichnen */
  for(i=0; i<9; i++)
  {
    /* Horiz Linien zeichnen. Abstand 15 Pixel, Offset 40 Pixel. */
    DrawLine(5, i*15+Offset, 155, i*15+Offset, DRAW_B2DOT);
    if (i<8)
    {
      itoa(myDrugs[i], s, 10);
      WriteAlignString(30, i*15+Offset+2, s, 22, ALIGN_RIGHT, 0);
      WriteString(40, i*15+Offset+2, drugnames[i], 0);
      if (drugPrices[i] > 0)
      {
        strcpy(s, "$");
        dtoa((double) drugPrices[i], s+1);
        s[strlen(s)-1]=0;
      }
      else
      {
        strcpy (s, "n/a");
      }
      WriteAlignString(150, i*15+Offset+2, s, 52, ALIGN_RIGHT, 0);
    }
  }
  /* Vertikale Linien zeichnen */
  DrawLine(5, Offset, 5, Offset+120, DRAW_B2DOT);
  DrawLine(35, Offset, 35, Offset+120, DRAW_B2DOT);
  DrawLine(100, Offset, 100, Offset+120, DRAW_B2DOT);
  DrawLine(155, Offset, 155, Offset+120, DRAW_B2DOT);

  /* Coat-value */
  itoa(myTotal, s, 10);
  strcat(s,"/");
  itoa(myCoat, s+strlen(s), 10);
  WriteAlignString(109, 56, s, 52, ALIGN_RIGHT, 0);
  
  /* Draw remaining time */
  strcpy(s, "Time remaining: ");
  itoa(timeLeft, s+strlen(s), 10);
  strcat(s, " days.");
  SetFontType(PRPFONT11B);
  WriteString(12, 126 + Offset, s, 0);
}

void BS_handleEvent(VOID_PTR thisView, unsigned int *evType, unsigned char x, unsigned char y)
{
  unsigned char y1;
  static char selectedDrug=0;
  
  if (x>4 && x<156 && y>=Offset && y<121+Offset)
  {
    /* Event inside grid. */
    switch (*evType)
    {
      case evPenUp:
        PenBeep();
        if (x>4 && x<36) /* Column with #of owned drugs = sell*/
        {
          *evType=evCommand;
          x=HIGBYTE(cmSell);
          y=LOWBYTE(cmSell);
          break;
        }
        if (x>99 && x<156) /* Column with drug-prices = buy */
        {
          *evType=evCommand;
          x=HIGBYTE(cmBuy);
          y=LOWBYTE(cmBuy);
          break;
        }
      case evPenDown:
      case evPenDownMove:
        y1 = (y-Offset-1)/15;  /* y1 = 0..8 (LineNumber) */
        if (y1 != selectedDrug-1)  /* Only if selection changed */
        {
          if (selectedDrug--)      /* deselct old selection */
            InverseLCDArea(6, selectedDrug*15+Offset+1, 154, (selectedDrug+1)*15+Offset-1);
          InverseLCDArea(6, y1*15+Offset+1, 154, (y1+1)*15+Offset-1);
        }
        selectedDrug = ++y1;       /* remember selection */
        ClearEvent(evType);
        break;
    }
  }
  if (*evType == evCommand)
    switch(TOWORD(x,y))
    {
      case cmSell:
        if (selectedDrug)
        {
          drugnum=selectedDrug-1;
          SellDrugs();
          PDESKBOX_redraw(thisView);
          InverseLCDArea(6, (selectedDrug-1)*15+Offset+1, 154, selectedDrug*15+Offset-1);
        }
        else
          MessageBox("No drug selected! Tap a drugname to select it. You can simply tap the quantity column of a drug to sell it quickly.", mfWarning);
        ClearEvent(evType);
        break;
      case cmJet:
          Travel();
          if (!timeLeft)
          {
            ((PDESKBOX *)thisView)->endState = GameOver();
            selectedDrug=0;
            return;
          }
          ((PDESKBOX *)thisView)->title=MK_FAR_PTR(LocationNames[myLocation]);
          PDESKBOX_redraw(thisView);
          if (selectedDrug)
            InverseLCDArea(6, (selectedDrug-1)*15+Offset+1, 154, selectedDrug*15+Offset-1);
        ClearEvent(evType);
        break;
      case cmBuy:
        if (selectedDrug)
        {
          drugnum=selectedDrug-1;
          BuyDrugs();
          PDESKBOX_redraw(thisView);
          InverseLCDArea(6, (selectedDrug-1)*15+Offset+1, 154, selectedDrug*15+Offset-1);
        }
        else
          MessageBox("No drug selected! Tap a drugname to select it. You can simply tap the price column of a drug to buy it quickly.", mfWarning);
        ClearEvent(evType);
        break;
      case cmHighScore:
        ClearLCDArea(2,16,158,238,0);
        SetFontType(PRPFONT14B);
        WriteString(35, 55, "Hall of Fame", 0);
        SetFontType(PRPFONT11N);
        DrawHighScores(90);
        WriteString(18, 190, "Tap anywhere to continue.", 0);
        while (!GetKey(&x,&y));
        PDESKBOX_redraw(thisView);
        ClearEvent(evType);
        break;
      case cmRestart:
        if (MessageBox("Are you sure you wan't to quit this game and start a new one?", mfYesNo) == cmYes)
        {
          initGame();
          PDESKBOX_redraw(thisView);
        }
        ClearEvent(evType);
        break;
      case cmHelp:
        help(hlpBuySell);
        ClearEvent(evType);
        break;
    }
  PDESKBOX_handleEvent(thisView, evType, x, y);
}

#undef Offset

char BuySell()
{
  PDESKBOX *dsk;
  char result;

  dsk = (PDESKBOX *)CreateDeskBox(200, 0, 0, 159, 239, MK_FAR_PTR(LocationNames[myLocation]),
                          MK_FAR_PTR(BuySellMenu), NULL_FP, bafDotTitle | bafClose);
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
             CreateLabel(201, 5, 17, 50, 29, MK_FAR_PTR((char *)"Cash"),
                         lbofDefineFont, PRPFONT11B));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
             CreateLabel(202, 5, 30, 50, 42, MK_FAR_PTR((char *)"Debt"), 
                         lbofDefineFont, PRPFONT11B));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
             CreateLabel(203, 5, 43, 50, 55, MK_FAR_PTR((char *)"Savings"), 
                         lbofDefineFont, PRPFONT11B));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
             CreateLabel(204, 5, 56, 50, 68, MK_FAR_PTR((char *)"Coat"),
                         lbofDefineFont, PRPFONT11B));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
             CreateButton(205, 9, 215, 49, 231, MK_FAR_PTR("Sell"), cmSell, bttBasic));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
             CreateButton(206, 59, 215, 99, 231, MK_FAR_PTR("Jet"), cmJet, bttBasic));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
             CreateButton(207, 109, 215, 149, 231, MK_FAR_PTR("Buy"), cmBuy, bttBasic));

  BankedAssign2(dsk->draw, BS_draw);
  BankedAssign2(dsk->handleEvent, BS_handleEvent);
  result=ExecView((PGROUP_PTR) dsk);
  Destroy((VOID_PTR)dsk);
  return result;
}

int main()
{
  LoadApplicationState();   /* Load previous saved game-status to continue old game */
  OpenDatabase();           /* Load high-score */
  while (BuySell() == cmOK) /* cmOK: User wants to play again */
    initGame();             /* Init game-data on request */
  if (!timeLeft)            /* Game Over and user don't wants to play again *now* */
    initGame();             /* Init game-data for a later game */
  SaveApplicationState();   /* Save game-status for later continuation */
  return APPLICATION;       /* Return to 'Apps', if user quit game normally */
}                           /* If user tapped e.g. calc, return-value is ignored */
