/*

  Other includes, common to all sources in project.

*/
#include <avsys.h>
#include <avdata.h>
#include <avgui.h>

/*

  Macros

*/
#define GAME_MESSAGE_COUNT  17
#define NAMELEN             20
#define SHARK_MULTIPLIER    30

#define cmHelp              0x2000
#define cmSell              0x2001
#define cmJet               0x2002
#define cmBuy               0x2003
#define cmRestart           0x2004
#define cmHighScore         0x2005
#define cmRun               0x0000
#define cmFight             0x0001
#define cmBorrow            0x0002 /* bought from cmQuit */
#define cmRepay             0x0003 /* bought from cmOK.  */
#define cmWithdraw          0x0002 /* bought from cmQuit */
#define cmDeposit           0x0003 /* bought from cmOK. Using them avoids own event-handler */

#define hlpBuySell          0x0001
#define hlpTravel           0x0002

#define MIN(n1,n2)          ((n1)<(n2)?(n1):(n2))

/*

  Type definitions

*/
typedef struct HighScoreType {
    char name [NAMELEN];
    double score;
} HighScore;

typedef struct MessageType {
    int freq;
    char *msg;
    int drug;
    int plus;
    int minus;
    int add;
} Message;

typedef struct SaveGameStruct
{
  int myDrugs [8];
  double myCash;
  double myDebt;
  double myBank;
  int myCoat;
  int myGuns;
  int myTotal;
  int myLocation;
  int timeLeft;
  int copCount;
  double drugPrices[8];
  int cheatsEnabled;
  char FillerForFutureExpansion[16];
} SaveGameType;


/*

  Variable declarations (prototypes)

*/
extern HighScore hscores[];
extern double myCash;
extern unsigned int dopeguy; /* picture of the guy in the intro */
extern unsigned int glock;   /* gun picture */
extern int myDrugs[];
extern double myDebt;
extern double myBank;
extern int myCoat;
extern int myGuns;
extern int myTotal;
extern int myLocation;
extern int timeLeft;
extern int copCount;
extern int cheatsEnabled;
extern int cheatKey;
extern MENUITEM HelpMenu[];
extern unsigned int ibank;
extern char DopeTitle[];
extern double drugPrices[];
extern char EnterNumber[];
extern char LackMoney[];

/*

  Function prototypes

*/
extern void InitHighScores(void);
extern void InsertScore(char *playername, double newscore);
extern void OpenDatabase(void);
extern void SaveStatus(void);
extern void GetHighScoreName();
extern void makeDrugPrices(int leaveout);
extern void intro(void);
extern void initGame(void);
extern void LoadApplicationState();
extern void SaveApplicationState();
extern unsigned short GameOver();
extern void finishGame(void);
extern void FuzzEncounter(void);
extern unsigned char Cops(unsigned char still);
extern void VisitShark(void);
extern void amountshark_draw(VOID_PTR thisView);
extern void DrawHighScores();
extern void help(char chapter);